/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.utilities.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class AbstractCodecJsonDataManager<T>
extends SimpleJsonResourceReloadListener {
    protected static final Gson STANDARD_GSON = new Gson();
    public Codec<T> codec;
    protected Logger logger;
    protected String folderName;
    protected Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();

    public AbstractCodecJsonDataManager(String folderName, Codec<T> codec, Logger logger) {
        this(folderName, codec, logger, STANDARD_GSON);
    }

    public AbstractCodecJsonDataManager(String folderName, Codec<T> codec, Logger logger, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
        this.logger = logger;
    }

    @Nullable
    public T getData(ResourceLocation id) {
        return this.data.get(id);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.logger.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons);
        this.logger.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.data.size());
    }

    public abstract Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> var1);
}

