/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.utilities.data;

import com.rae.creatingspace.utilities.CSNBTUtil;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class FlightDataHelper {

    public record PropellantStatusData(PropellantStatus status, HashMap<TagKey<Fluid>, Integer> massForEachPropellant, HashMap<TagKey<Fluid>, Integer> consumedMassForEachPropellant, float finalPropellantMass) {
        public static PropellantStatusData createFromPropellantMap(HashMap<TagKey<Fluid>, Integer> massForEachPropellant, HashMap<TagKey<Fluid>, Integer> consumedMassForEachPropellant, float finalPropellantMass) {
            PropellantStatus status = PropellantStatus.ENOUGH_PROPELLANT;
            if (finalPropellantMass < 0.0f) {
                status = PropellantStatus.NOT_ENOUGH_PROPELLANT;
            } else {
                for (TagKey<Fluid> fluidTag : consumedMassForEachPropellant.keySet()) {
                    Integer mass = massForEachPropellant.get(fluidTag);
                    if (mass == null) {
                        status = PropellantStatus.ONE_OR_MORE_PROPELLANT_IS_MISSING;
                        break;
                    }
                    if (mass >= consumedMassForEachPropellant.get(fluidTag)) continue;
                    status = PropellantStatus.ONE_OR_MORE_PROPELLANT_IS_MISSING;
                    break;
                }
            }
            return new PropellantStatusData(status, massForEachPropellant, consumedMassForEachPropellant, finalPropellantMass);
        }
    }

    public static enum CollisionStatus {
        NO_COLLISION(false),
        COLLISION_ON_DESCENT(false),
        COLLISION_ON_ASCENT;

        public final boolean isFailReason;

        private CollisionStatus() {
            this.isFailReason = true;
        }

        private CollisionStatus(boolean isFailReason) {
            this.isFailReason = isFailReason;
        }
    }

    public static enum PropellantStatus {
        ENOUGH_PROPELLANT(false),
        NOT_ENOUGH_PROPELLANT,
        ONE_OR_MORE_PROPELLANT_IS_MISSING;

        public final boolean isFailReason;

        private PropellantStatus() {
            this.isFailReason = true;
        }

        private PropellantStatus(boolean isFailReason) {
            this.isFailReason = isFailReason;
        }
    }

    public record RocketAssemblyData(PropellantStatusData propellantStatusData, float thrust, float weight, boolean hasFailed) {
        public static RocketAssemblyData create(HashMap<TagKey<Fluid>, Integer> massForEachPropellant, HashMap<TagKey<Fluid>, Integer> consumedMassForEachPropellant, float finalPropellantMass, float thrust, float weight) {
            PropellantStatusData data = PropellantStatusData.createFromPropellantMap(massForEachPropellant, consumedMassForEachPropellant, finalPropellantMass);
            boolean hasFailed = data.status.isFailReason;
            hasFailed = hasFailed || thrust < weight;
            return new RocketAssemblyData(data, thrust, weight, hasFailed);
        }

        public static RocketAssemblyData fromNBT(CompoundTag tag) {
            if (tag == null) {
                return null;
            }
            if (tag.m_128456_()) {
                return null;
            }
            HashMap<TagKey<Fluid>, Integer> massForEachPropellant = CSNBTUtil.fromNBTtoMapFluidTagsInteger(tag.m_128469_("massForEachPropellant"));
            HashMap<TagKey<Fluid>, Integer> consumedMassForEachPropellant = CSNBTUtil.fromNBTtoMapFluidTagsInteger(tag.m_128469_("consumedMassForEachPropellant"));
            float finalPropellantMass = tag.m_128457_("finalPropellantMass");
            float thrust = tag.m_128457_("thrust");
            float weight = tag.m_128457_("weight");
            return RocketAssemblyData.create(massForEachPropellant, consumedMassForEachPropellant, finalPropellantMass, thrust, weight);
        }

        public static CompoundTag toNBT(RocketAssemblyData data) {
            CompoundTag newTag = new CompoundTag();
            if (data != null) {
                newTag.m_128365_("massForEachPropellant", (Tag)CSNBTUtil.fromMapFluidTagsIntegerToNBT(data.propellantStatusData().massForEachPropellant));
                newTag.m_128365_("consumedMassForEachPropellant", (Tag)CSNBTUtil.fromMapFluidTagsIntegerToNBT(data.propellantStatusData().consumedMassForEachPropellant));
                newTag.m_128350_("finalPropellantMass", data.propellantStatusData().finalPropellantMass);
                newTag.m_128350_("thrust", data.thrust);
                newTag.m_128350_("weight", data.weight);
            }
            return newTag;
        }
    }
}

