/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.utilities.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.rae.creatingspace.utilities.data.AbstractCodecJsonDataManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SingleFileCodecJsonDataManager<T>
extends AbstractCodecJsonDataManager<T> {
    private final ResourceLocation location;

    public SingleFileCodecJsonDataManager(String folderName, ResourceLocation location, Codec<T> codec, Logger logger) {
        this(folderName, location, codec, logger, STANDARD_GSON);
    }

    public SingleFileCodecJsonDataManager(String folderName, ResourceLocation location, Codec<T> codec, Logger logger, Gson gson) {
        super(folderName, codec, logger, gson);
        this.location = location;
    }

    @javax.annotation.Nullable
    public T getData() {
        return (T)this.data.get(this.location);
    }

    @Override
    @Nullable
    public T getData(ResourceLocation id) {
        return this.getData();
    }

    @Override
    public Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        HashMap newMap = new HashMap();
        JsonElement element = inputs.get(this.location);
        if (element != null) {
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> newMap.put(this.location, result.getFirst())).ifRight(partial -> this.logger.error("Failed to parse data json for {} due to: {}", (Object)this.location.toString(), (Object)partial.message()));
        }
        return newMap;
    }
}

