/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.utilities.packet;

import com.rae.creatingspace.api.squedule.RocketSchedule;
import com.rae.creatingspace.server.entities.RocketContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class RocketScheduleEditPacket
extends SimplePacketBase {
    private RocketSchedule schedule;
    private int rocketId;

    public RocketScheduleEditPacket(RocketSchedule schedule, int rocketId) {
        this.schedule = schedule;
        this.rocketId = rocketId;
    }

    public RocketScheduleEditPacket(FriendlyByteBuf buffer) {
        this.schedule = RocketSchedule.fromTag(buffer.m_130260_());
        this.rocketId = buffer.readInt();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.schedule.write());
        buffer.writeInt(this.rocketId);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Entity entity = Objects.requireNonNull(context.getSender()).m_9236_().m_6815_(this.rocketId);
            if (entity instanceof RocketContraptionEntity) {
                RocketContraptionEntity contraptionEntity = (RocketContraptionEntity)entity;
                contraptionEntity.schedule.setSchedule(this.schedule, true);
                contraptionEntity.sendPacket();
            }
        });
        return true;
    }
}

