/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.content.entity.boat;

import com.dannbrown.deltaboxlib.common.content.entity.boat.BaseBoatEntity;
import com.dannbrown.deltaboxlib.common.content.entity.boat.BaseChestBoatEntity;
import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u0010J)\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0012\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J9\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ?\u0010%\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010'R\u0014\u0010\u0005\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010'R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010(R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010)\u00a8\u0006+"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/entity/boat/BaseBoatRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Lnet/minecraft/world/entity/vehicle/Boat;", "", "modId", "variant", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "context", "", "isChestBoat", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Z)V", "boat", "Lnet/minecraft/resources/ResourceLocation;", "getTextureLocation", "(Lnet/minecraft/world/entity/vehicle/Boat;)Lnet/minecraft/resources/ResourceLocation;", "()Lnet/minecraft/resources/ResourceLocation;", "Lcom/mojang/datafixers/util/Pair;", "Lnet/minecraft/client/model/ListModel;", "getModelWithLocation", "(Lnet/minecraft/world/entity/vehicle/Boat;)Lcom/mojang/datafixers/util/Pair;", "pContext", "pChestBoat", "createModelWithLocation", "(Ljava/lang/String;Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Z)Lcom/mojang/datafixers/util/Pair;", "createBoatModel", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Ljava/lang/String;Z)Lnet/minecraft/client/model/ListModel;", "", "yaw", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lnet/minecraft/client/renderer/MultiBufferSource;", "bufferSource", "", "packedLight", "", "render", "(Lnet/minecraft/world/entity/vehicle/Boat;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "Ljava/lang/String;", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "Z", "Companion", "deltaboxlib-forge"})
public final class BaseBoatRenderer
extends EntityRenderer<Boat> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String modId;
    @NotNull
    private final String variant;
    @NotNull
    private final EntityRendererProvider.Context context;
    private final boolean isChestBoat;

    public BaseBoatRenderer(@NotNull String modId, @NotNull String variant, @NotNull EntityRendererProvider.Context context, boolean isChestBoat) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.modId = modId;
        this.variant = variant;
        this.context = context;
        this.isChestBoat = isChestBoat;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Boat boat) {
        Intrinsics.checkNotNullParameter((Object)boat, (String)"boat");
        if (boat instanceof BaseBoatEntity) {
            String variant = ((BaseBoatEntity)boat).getVariant();
            return DeltaboxUtil.INSTANCE.resourceLocation(this.modId, "textures/entity/boat/" + variant + ".png");
        }
        if (boat instanceof BaseChestBoatEntity) {
            String variant = ((BaseChestBoatEntity)boat).getVariant();
            return DeltaboxUtil.INSTANCE.resourceLocation(this.modId, "textures/entity/chest_boat/" + variant + ".png");
        }
        return DeltaboxUtil.INSTANCE.resourceLocation(this.modId, this.isChestBoat ? "textures/entity/chest_boat/" + this.variant + ".png" : "textures/entity/boat/" + this.variant + ".png");
    }

    @NotNull
    public final ResourceLocation getTextureLocation() {
        return DeltaboxUtil.INSTANCE.resourceLocation(this.modId, this.isChestBoat ? "textures/entity/chest_boat/" + this.variant + ".png" : "textures/entity/boat/" + this.variant + ".png");
    }

    @Nullable
    public final Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(@NotNull Boat boat) {
        Intrinsics.checkNotNullParameter((Object)boat, (String)"boat");
        if (boat instanceof BaseBoatEntity) {
            String variant = ((BaseBoatEntity)boat).getVariant();
            return this.createModelWithLocation(variant, this.context, this.isChestBoat);
        }
        if (boat instanceof BaseChestBoatEntity) {
            String variant = ((BaseChestBoatEntity)boat).getVariant();
            return this.createModelWithLocation(variant, this.context, true);
        }
        return null;
    }

    private final Pair<ResourceLocation, ListModel<Boat>> createModelWithLocation(String variant, EntityRendererProvider.Context pContext, boolean pChestBoat) {
        ResourceLocation texture = this.getTextureLocation();
        ListModel<Boat> model = this.createBoatModel(pContext, variant, pChestBoat);
        Pair pair = Pair.of((Object)texture, model);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
        return pair;
    }

    private final ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, String variant, boolean pChestBoat) {
        ModelLayerLocation modelLayerLocation = pChestBoat ? Companion.createChestBoatModelName(this.modId, variant) : Companion.createBoatModelName(this.modId, variant);
        ModelPart modelPart = pContext.m_174023_(modelLayerLocation);
        return pChestBoat ? (ListModel)new ChestBoatModel(modelPart) : (ListModel)new BoatModel(modelPart);
    }

    public void render(@NotNull Boat boat, float yaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        float bubbleAngle;
        Intrinsics.checkNotNullParameter((Object)boat, (String)"boat");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.375f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        float damageTime = (float)boat.m_38385_() - partialTicks;
        float damage = boat.m_38384_() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (damageTime > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)damageTime) * damageTime * damage / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(bubbleAngle = boat.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(bubbleAngle * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(boat);
        if (pair == null) {
            return;
        }
        Pair<ResourceLocation, ListModel<Boat>> alt = pair;
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        ((ListModel)alt.getSecond()).m_6973_((Entity)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(((ListModel)alt.getSecond()).m_103119_((ResourceLocation)alt.getFirst()));
        ((ListModel)alt.getSecond()).m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer waterBuffer = bufferSource.m_6299_(RenderType.m_110478_());
            if (alt.getSecond() instanceof WaterPatchModel) {
                Object object = alt.getSecond();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.client.model.WaterPatchModel");
                ((WaterPatchModel)object).m_102282_().m_104301_(poseStack, waterBuffer, packedLight, OverlayTexture.f_118083_);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)boat, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\tJ'\u0010\r\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/entity/boat/BaseBoatRenderer$Companion;", "", "<init>", "()V", "", "modId", "variant", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBoatModelName", "(Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createChestBoatModelName", "path", "model", "createLocation", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/client/model/geom/ModelLayerLocation;", "deltaboxlib-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelLayerLocation createBoatModelName(@NotNull String modId, @NotNull String variant) {
            Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            return this.createLocation(modId, "boat/" + variant, "main");
        }

        @NotNull
        public final ModelLayerLocation createChestBoatModelName(@NotNull String modId, @NotNull String variant) {
            Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            return this.createLocation(modId, "chest_boat/" + variant, "main");
        }

        private final ModelLayerLocation createLocation(String modId, String path, String model) {
            return new ModelLayerLocation(DeltaboxUtil.INSTANCE.resourceLocation(modId, path), model);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

