/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.builders;

import com.dannbrown.deltaboxlib.common.registrate.AbstractDeltaboxRegistrate;
import com.dannbrown.deltaboxlib.common.registrate.builders.AbstractBuilder;
import com.dannbrown.deltaboxlib.common.registrate.builders.BlockBuilderContext;
import com.dannbrown.deltaboxlib.common.registrate.builders.ItemBuilder;
import com.dannbrown.deltaboxlib.common.registrate.datagen.RegistrateBlockLootTables;
import com.dannbrown.deltaboxlib.common.registrate.datagen.RegistrateRecipes;
import com.dannbrown.deltaboxlib.common.registrate.datagen.model.RegistrateBlockModelGenerator;
import com.dannbrown.deltaboxlib.common.registrate.datagen.model.RegistrateItemModelGenerator;
import com.dannbrown.deltaboxlib.common.registrate.registry.BlockEntry;
import com.dannbrown.deltaboxlib.common.registrate.registry.ItemEntry;
import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0010!\n\u0002\b\u0012\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\u0013\u001a \u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u0017\u001a \u0012\u0004\u0012\u00020\u0015\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0014J'\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0018j\u0002`\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010\u001f\u001a \u0012\u0004\u0012\u00020\u001d\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0014J\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0004\b \u0010!J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0006\u00a2\u0006\u0004\b%\u0010&J3\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001e\u0010(\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\"\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00010\u0018\u00a2\u0006\u0004\b)\u0010*J!\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010\u00a2\u0006\u0004\b,\u0010-J9\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002$\u0010(\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\"\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0\u0018j\u0002`.\u00a2\u0006\u0004\b/\u0010*J7\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2 \b\u0002\u0010(\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0018j\u0002`\u001a\u00a2\u0006\u0004\b0\u00101J\u0013\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b2\u00103J9\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002$\u00104\u001a \u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u0012\u00a2\u0006\u0004\b5\u00106J9\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002$\u00107\u001a \u0012\u0004\u0012\u00020\u0015\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u0016\u00a2\u0006\u0004\b8\u00106J\u001b\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00109\u001a\u00020\u0006\u00a2\u0006\u0004\b:\u0010;J'\u0010?\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010=\u001a\u00020<2\b\b\u0002\u0010>\u001a\u00020<\u00a2\u0006\u0004\b?\u0010@J#\u0010B\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u00a2\u0006\u0004\bB\u0010-J#\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u00a2\u0006\u0004\bC\u0010-J\u0013\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\bD\u00103J\u0013\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\bE\u00103J5\u0010I\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001e\u0010H\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00010G0F\"\b\u0012\u0004\u0012\u00020\u00010GH\u0007\u00a2\u0006\u0004\bI\u0010JJ5\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001e\u0010K\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000b0G0F\"\b\u0012\u0004\u0012\u00020\u000b0GH\u0007\u00a2\u0006\u0004\bL\u0010JJ5\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001e\u0010M\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000b0G0F\"\b\u0012\u0004\u0012\u00020\u000b0GH\u0007\u00a2\u0006\u0004\bN\u0010JJ=\u0010S\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010O\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010G2\u000e\u0010P\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010G2\b\b\u0002\u0010R\u001a\u00020Q\u00a2\u0006\u0004\bS\u0010TJ9\u0010U\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002$\u0010)\u001a \u0012\u0004\u0012\u00020\u001d\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u001e\u00a2\u0006\u0004\bU\u00106J\u001b\u0010W\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010W\u001a\u00020V\u00a2\u0006\u0004\bW\u0010XJ\u001b\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010Y\u001a\u00020\u0006\u00a2\u0006\u0004\bY\u0010;J'\u0010\\\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010Z\u001a\u00020Q2\b\b\u0002\u0010[\u001a\u00020Q\u00a2\u0006\u0004\b\\\u0010]J\u001d\u0010`\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010_\u001a\u00020^\u00a2\u0006\u0004\b`\u0010aJ#\u0010d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010c\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010b\u00a2\u0006\u0004\bd\u0010eJ\u00c3\u0001\u0010h\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102$\u0010f\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\"\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0\u0018j\u0002`.2\u0014\b\u0002\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010G0g2\u0014\b\u0002\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0G0g2\u0014\b\u0002\u0010N\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0G0g2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010V2\u0010\b\u0002\u0010O\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010G2\u0010\b\u0002\u0010P\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010G2\b\b\u0002\u0010R\u001a\u00020Q\u00a2\u0006\u0004\bh\u0010iJ3\u0010l\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001e\u0010k\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000j\u00a2\u0006\u0004\bl\u0010mJ\u0015\u0010o\u001a\b\u0012\u0004\u0012\u00028\u00000nH\u0002\u00a2\u0006\u0004\bo\u0010pJ\u0019\u0010s\u001a\u00020\u00112\n\u0010r\u001a\u0006\u0012\u0002\b\u00030q\u00a2\u0006\u0004\bs\u0010tJ\u001d\u0010v\u001a\b\u0012\u0004\u0012\u00028\u00000n2\b\b\u0002\u0010u\u001a\u00020Q\u00a2\u0006\u0004\bv\u0010wR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010x\u001a\u0004\by\u0010&R \u0010z\u001a\b\u0012\u0004\u0012\u00028\u00000\"8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\bz\u0010{\u001a\u0004\b|\u0010$R%\u0010}\u001a\u00020'8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0015\n\u0004\b}\u0010~\u001a\u0005\b\u007f\u0010\u0080\u0001\"\u0006\b\u0081\u0001\u0010\u0082\u0001R.\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0017\n\u0006\b\u0083\u0001\u0010\u0084\u0001\u001a\u0005\b\u0085\u0001\u0010!\"\u0006\b\u0086\u0001\u0010\u0087\u0001R'\u0010\u0088\u0001\u001a\u00020\u00068\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0016\n\u0005\b\u0088\u0001\u0010x\u001a\u0005\b\u0089\u0001\u0010&\"\u0006\b\u008a\u0001\u0010\u008b\u0001R0\u0010\u008c\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0017\n\u0006\b\u008c\u0001\u0010\u008d\u0001\u001a\u0005\b\u008e\u0001\u0010\r\"\u0006\b\u008f\u0001\u0010\u0090\u0001R.\u0010\u0091\u0001\u001a\b\u0012\u0002\b\u0003\u0018\u00010q8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0017\n\u0006\b\u0091\u0001\u0010\u0092\u0001\u001a\u0006\b\u0093\u0001\u0010\u0094\u0001\"\u0005\b\u0095\u0001\u0010tR.\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108\u0004@\u0004X\u0084.\u00a2\u0006\u0017\n\u0006\b\u0096\u0001\u0010\u0084\u0001\u001a\u0005\b\u0097\u0001\u0010!\"\u0006\b\u0098\u0001\u0010\u0087\u0001R)\u0010\u0099\u0001\u001a\u00020Q8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0018\n\u0006\b\u0099\u0001\u0010\u009a\u0001\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001\"\u0006\b\u009d\u0001\u0010\u009e\u0001R8\u0010\u00a0\u0001\u001a\u0011\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00010b0\u009f\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00a0\u0001\u0010\u00a1\u0001\u001a\u0006\b\u00a2\u0001\u0010\u00a3\u0001\"\u0006\b\u00a4\u0001\u0010\u00a5\u0001RF\u0010\u00a6\u0001\u001a \u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u00a6\u0001\u0010\u00a7\u0001\u001a\u0005\b\u00a8\u0001\u0010\u0014\"\u0006\b\u00a9\u0001\u0010\u00aa\u0001RF\u0010\u00ab\u0001\u001a \u0012\u0004\u0012\u00020\u0015\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u00ab\u0001\u0010\u00a7\u0001\u001a\u0005\b\u00ac\u0001\u0010\u0014\"\u0006\b\u00ad\u0001\u0010\u00aa\u0001RF\u0010\u00ae\u0001\u001a \u0012\u0004\u0012\u00020\u001d\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u00ae\u0001\u0010\u00a7\u0001\u001a\u0005\b\u00af\u0001\u0010\u0014\"\u0006\b\u00b0\u0001\u0010\u00aa\u0001\u00a8\u0006\u00b1\u0001"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "Lnet/minecraft/world/level/block/Block;", "T", "Lcom/dannbrown/deltaboxlib/common/registrate/builders/AbstractBuilder;", "Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "registrate", "", "blockId", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;Ljava/lang/String;)V", "Lcom/dannbrown/deltaboxlib/common/registrate/builders/ItemBuilder;", "Lnet/minecraft/world/item/Item;", "defaultItemBuilder", "()Lcom/dannbrown/deltaboxlib/common/registrate/builders/ItemBuilder;", "Lkotlin/Function2;", "Lcom/dannbrown/deltaboxlib/common/registrate/datagen/RegistrateBlockLootTables;", "Ljava/util/function/Supplier;", "", "Lcom/dannbrown/deltaboxlib/common/registrate/types/BlockLootTableFactory;", "defaultLootTableFactory", "()Lkotlin/jvm/functions/Function2;", "Lcom/dannbrown/deltaboxlib/common/registrate/datagen/model/RegistrateBlockModelGenerator;", "Lcom/dannbrown/deltaboxlib/common/registrate/types/BlockstateFactory;", "defaultBlockstateFactory", "Ljava/util/function/BiFunction;", "Lnet/minecraft/world/item/Item$Properties;", "Lcom/dannbrown/deltaboxlib/common/registrate/types/BlockItemFactory;", "defaultItemBlockFactory", "()Ljava/util/function/BiFunction;", "Lcom/dannbrown/deltaboxlib/common/registrate/datagen/RegistrateRecipes;", "Lcom/dannbrown/deltaboxlib/common/registrate/types/BlockRecipeFactory;", "defaultRecipeFactory", "getBlock", "()Ljava/util/function/Supplier;", "Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilderContext;", "getContext", "()Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilderContext;", "getName", "()Ljava/lang/String;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "_factoryFunction", "factory", "(Ljava/util/function/BiFunction;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "_referenceBlock", "copyFrom", "(Ljava/util/function/Supplier;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "Lcom/dannbrown/deltaboxlib/common/registrate/types/BlockPropertiesFactory;", "properties", "item", "(Ljava/util/function/BiFunction;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/ItemBuilder;", "noItem", "()Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "_lootFactory", "loot", "(Lkotlin/jvm/functions/Function2;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "_blockstateFactory", "blockstate", "langKey", "lang", "(Ljava/lang/String;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "", "burnChance", "spreadChance", "flammable", "(II)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "otherBlock", "strippable", "potted", "cutoutRender", "translucentRender", "", "Lnet/minecraft/tags/TagKey;", "tag", "blockTags", "([Lnet/minecraft/tags/TagKey;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "tags", "itemTags", "tabs", "tabTags", "tool", "tier", "", "correctToolForDrops", "toolAndTier", "(Lnet/minecraft/tags/TagKey;Lnet/minecraft/tags/TagKey;Z)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "recipe", "Lnet/minecraft/world/level/material/MapColor;", "color", "(Lnet/minecraft/world/level/material/MapColor;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "textureName", "hasBlockColors", "hasItemColors", "biomeColors", "(ZZ)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "", "amount", "compostable", "(F)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "Ljava/util/function/Consumer;", "callback", "onRegister", "(Ljava/util/function/Consumer;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "propsFactory", "", "fromFamily", "(Ljava/util/function/Supplier;Ljava/util/function/BiFunction;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lnet/minecraft/world/level/material/MapColor;Lnet/minecraft/tags/TagKey;Lnet/minecraft/tags/TagKey;Z)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "Ljava/util/function/Function;", "consumer", "transform", "(Ljava/util/function/Function;)Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry;", "asEntry", "()Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;", "_itemEntry", "buildItemEntry", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;)V", "doRegister", "register", "(Z)Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry;", "Ljava/lang/String;", "getBlockId", "ctx", "Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilderContext;", "getCtx", "props", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "getProps", "()Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "setProps", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "blockFactory", "Ljava/util/function/Supplier;", "getBlockFactory", "setBlockFactory", "(Ljava/util/function/Supplier;)V", "blockName", "getBlockName", "setBlockName", "(Ljava/lang/String;)V", "itemBuilder", "Lcom/dannbrown/deltaboxlib/common/registrate/builders/ItemBuilder;", "getItemBuilder", "setItemBuilder", "(Lcom/dannbrown/deltaboxlib/common/registrate/builders/ItemBuilder;)V", "itemEntry", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;", "getItemEntry", "()Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;", "setItemEntry", "blockInstance", "getBlockInstance", "setBlockInstance", "hasCustomItemBuilder", "Z", "getHasCustomItemBuilder", "()Z", "setHasCustomItemBuilder", "(Z)V", "", "registerCallbacks", "Ljava/util/List;", "getRegisterCallbacks", "()Ljava/util/List;", "setRegisterCallbacks", "(Ljava/util/List;)V", "lootTableFactory", "Lkotlin/jvm/functions/Function2;", "getLootTableFactory", "setLootTableFactory", "(Lkotlin/jvm/functions/Function2;)V", "blockstateFactory", "getBlockstateFactory", "setBlockstateFactory", "recipeFactory", "getRecipeFactory", "setRecipeFactory", "deltaboxlib-forge"})
@SourceDebugExtension(value={"SMAP\nBlockBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockBuilder.kt\ncom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,244:1\n37#2,2:245\n37#2,2:247\n37#2,2:249\n*S KotlinDebug\n*F\n+ 1 BlockBuilder.kt\ncom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder\n*L\n216#1:245,2\n217#1:247,2\n218#1:249,2\n*E\n"})
public final class BlockBuilder<T extends Block>
extends AbstractBuilder {
    @NotNull
    private final String blockId;
    @NotNull
    private final BlockBuilderContext<T> ctx;
    @NotNull
    private BlockBehaviour.Properties props;
    @NotNull
    private Supplier<T> blockFactory;
    @NotNull
    private String blockName;
    @NotNull
    private ItemBuilder<? extends Item> itemBuilder;
    @Nullable
    private ItemEntry<?> itemEntry;
    protected Supplier<T> blockInstance;
    private boolean hasCustomItemBuilder;
    @NotNull
    private List<Consumer<? super Block>> registerCallbacks;
    @NotNull
    private Function2<? super RegistrateBlockLootTables, ? super Supplier<? extends Block>, Unit> lootTableFactory;
    @NotNull
    private Function2<? super RegistrateBlockModelGenerator, ? super Supplier<? extends Block>, Unit> blockstateFactory;
    @NotNull
    private Function2<? super RegistrateRecipes, ? super Supplier<? extends Block>, Unit> recipeFactory;

    public BlockBuilder(@NotNull AbstractDeltaboxRegistrate registrate, @NotNull String blockId) {
        Intrinsics.checkNotNullParameter((Object)registrate, (String)"registrate");
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        super(registrate);
        this.blockId = blockId;
        this.ctx = new BlockBuilderContext(registrate, this);
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)Blocks.f_50069_));
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"copy(...)");
        this.props = properties;
        this.blockFactory = () -> BlockBuilder.blockFactory$lambda$0(this);
        this.blockName = DeltaboxUtil.INSTANCE.asName(this.blockId);
        this.itemBuilder = this.defaultItemBuilder();
        this.registerCallbacks = new ArrayList();
        this.lootTableFactory = this.defaultLootTableFactory();
        this.blockstateFactory = this.defaultBlockstateFactory();
        this.recipeFactory = this.defaultRecipeFactory();
    }

    @NotNull
    public final String getBlockId() {
        return this.blockId;
    }

    @NotNull
    protected final BlockBuilderContext<T> getCtx() {
        return this.ctx;
    }

    @NotNull
    protected final BlockBehaviour.Properties getProps() {
        return this.props;
    }

    protected final void setProps(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"<set-?>");
        this.props = properties;
    }

    @NotNull
    protected final Supplier<T> getBlockFactory() {
        return this.blockFactory;
    }

    protected final void setBlockFactory(@NotNull Supplier<T> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.blockFactory = supplier;
    }

    @NotNull
    protected final String getBlockName() {
        return this.blockName;
    }

    protected final void setBlockName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.blockName = string;
    }

    @NotNull
    protected final ItemBuilder<? extends Item> getItemBuilder() {
        return this.itemBuilder;
    }

    protected final void setItemBuilder(@NotNull ItemBuilder<? extends Item> itemBuilder) {
        Intrinsics.checkNotNullParameter(itemBuilder, (String)"<set-?>");
        this.itemBuilder = itemBuilder;
    }

    @Nullable
    protected final ItemEntry<?> getItemEntry() {
        return this.itemEntry;
    }

    protected final void setItemEntry(@Nullable ItemEntry<?> itemEntry) {
        this.itemEntry = itemEntry;
    }

    @NotNull
    protected final Supplier<T> getBlockInstance() {
        Supplier<T> supplier = this.blockInstance;
        if (supplier != null) {
            return supplier;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"blockInstance");
        return null;
    }

    protected final void setBlockInstance(@NotNull Supplier<T> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.blockInstance = supplier;
    }

    protected final boolean getHasCustomItemBuilder() {
        return this.hasCustomItemBuilder;
    }

    protected final void setHasCustomItemBuilder(boolean bl) {
        this.hasCustomItemBuilder = bl;
    }

    @NotNull
    public final List<Consumer<? super Block>> getRegisterCallbacks() {
        return this.registerCallbacks;
    }

    public final void setRegisterCallbacks(@NotNull List<Consumer<? super Block>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.registerCallbacks = list;
    }

    @NotNull
    public final Function2<RegistrateBlockLootTables, Supplier<? extends Block>, Unit> getLootTableFactory() {
        return this.lootTableFactory;
    }

    public final void setLootTableFactory(@NotNull Function2<? super RegistrateBlockLootTables, ? super Supplier<? extends Block>, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.lootTableFactory = function2;
    }

    @NotNull
    public final Function2<RegistrateBlockModelGenerator, Supplier<? extends Block>, Unit> getBlockstateFactory() {
        return this.blockstateFactory;
    }

    public final void setBlockstateFactory(@NotNull Function2<? super RegistrateBlockModelGenerator, ? super Supplier<? extends Block>, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.blockstateFactory = function2;
    }

    @NotNull
    public final Function2<RegistrateRecipes, Supplier<? extends Block>, Unit> getRecipeFactory() {
        return this.recipeFactory;
    }

    public final void setRecipeFactory(@NotNull Function2<? super RegistrateRecipes, ? super Supplier<? extends Block>, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.recipeFactory = function2;
    }

    private final ItemBuilder<? extends Item> defaultItemBuilder() {
        return this.getRegistrate().item(this.blockId, this).factory(arg_0 -> BlockBuilder.defaultItemBuilder$lambda$1(this, arg_0)).model((Function2<RegistrateItemModelGenerator, Supplier<Item>, Unit>)((Function2)(arg_0, arg_1) -> BlockBuilder.defaultItemBuilder$lambda$2(this, arg_0, arg_1)));
    }

    private final Function2<RegistrateBlockLootTables, Supplier<? extends Block>, Unit> defaultLootTableFactory() {
        return BlockBuilder::defaultLootTableFactory$lambda$3;
    }

    private final Function2<RegistrateBlockModelGenerator, Supplier<? extends Block>, Unit> defaultBlockstateFactory() {
        return BlockBuilder::defaultBlockstateFactory$lambda$4;
    }

    private final BiFunction<Item.Properties, Block, ? extends Item> defaultItemBlockFactory() {
        return (arg_0, arg_1) -> BlockBuilder.defaultItemBlockFactory$lambda$5(this, arg_0, arg_1);
    }

    private final Function2<RegistrateRecipes, Supplier<? extends Block>, Unit> defaultRecipeFactory() {
        return BlockBuilder::defaultRecipeFactory$lambda$6;
    }

    @NotNull
    public final Supplier<T> getBlock() {
        return this.getBlockInstance();
    }

    @NotNull
    public final BlockBuilderContext<T> getContext() {
        return this.ctx;
    }

    @NotNull
    public final String getName() {
        return this.blockName;
    }

    @NotNull
    public final BlockBuilder<T> factory(@NotNull BiFunction<BlockBuilderContext<T>, BlockBehaviour.Properties, Block> _factoryFunction) {
        Intrinsics.checkNotNullParameter(_factoryFunction, (String)"_factoryFunction");
        this.blockFactory = () -> BlockBuilder.factory$lambda$7(_factoryFunction, this);
        return this;
    }

    @NotNull
    public final BlockBuilder<T> copyFrom(@NotNull Supplier<Block> _referenceBlock) {
        Intrinsics.checkNotNullParameter(_referenceBlock, (String)"_referenceBlock");
        this.props = BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)_referenceBlock.get()));
        return this;
    }

    @NotNull
    public final BlockBuilder<T> properties(@NotNull BiFunction<BlockBuilderContext<? extends Block>, BlockBehaviour.Properties, BlockBehaviour.Properties> _factoryFunction) {
        Intrinsics.checkNotNullParameter(_factoryFunction, (String)"_factoryFunction");
        this.props = _factoryFunction.apply(this.ctx, this.props);
        return this;
    }

    @NotNull
    public final ItemBuilder<? extends Item> item(@NotNull BiFunction<Item.Properties, Block, ? extends Item> _factoryFunction) {
        Intrinsics.checkNotNullParameter(_factoryFunction, (String)"_factoryFunction");
        this.hasCustomItemBuilder = true;
        return this.itemBuilder.factory(_factoryFunction);
    }

    public static /* synthetic */ ItemBuilder item$default(BlockBuilder blockBuilder, BiFunction biFunction, int n, Object object) {
        if ((n & 1) != 0) {
            biFunction = blockBuilder.defaultItemBlockFactory();
        }
        return blockBuilder.item(biFunction);
    }

    @NotNull
    public final BlockBuilder<T> noItem() {
        this.ctx.setNoItem(true);
        this.lootTableFactory = BlockBuilder::noItem$lambda$8;
        return this;
    }

    @NotNull
    public final BlockBuilder<T> loot(@NotNull Function2<? super RegistrateBlockLootTables, ? super Supplier<? extends Block>, Unit> _lootFactory) {
        Intrinsics.checkNotNullParameter(_lootFactory, (String)"_lootFactory");
        this.lootTableFactory = _lootFactory;
        return this;
    }

    @NotNull
    public final BlockBuilder<T> blockstate(@NotNull Function2<? super RegistrateBlockModelGenerator, ? super Supplier<? extends Block>, Unit> _blockstateFactory) {
        Intrinsics.checkNotNullParameter(_blockstateFactory, (String)"_blockstateFactory");
        this.blockstateFactory = _blockstateFactory;
        return this;
    }

    @NotNull
    public final BlockBuilder<T> lang(@NotNull String langKey) {
        Intrinsics.checkNotNullParameter((Object)langKey, (String)"langKey");
        this.blockName = langKey;
        return this;
    }

    @NotNull
    public final BlockBuilder<T> flammable(int burnChance, int spreadChance) {
        this.ctx.setFlammabilityBurnChance(burnChance);
        this.ctx.setFlammabilitySpreadChance(spreadChance);
        return this;
    }

    public static /* synthetic */ BlockBuilder flammable$default(BlockBuilder blockBuilder, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 20;
        }
        if ((n3 & 2) != 0) {
            n2 = 5;
        }
        return blockBuilder.flammable(n, n2);
    }

    @NotNull
    public final BlockBuilder<T> strippable(@NotNull Supplier<? extends Block> otherBlock) {
        Intrinsics.checkNotNullParameter(otherBlock, (String)"otherBlock");
        this.ctx.setStrippableOther(otherBlock);
        return this;
    }

    @NotNull
    public final BlockBuilder<T> potted(@NotNull Supplier<? extends Block> otherBlock) {
        Intrinsics.checkNotNullParameter(otherBlock, (String)"otherBlock");
        this.ctx.setPottedOther(otherBlock);
        return this;
    }

    @NotNull
    public final BlockBuilder<T> cutoutRender() {
        this.ctx.setHasCutoutRender(true);
        return this;
    }

    @NotNull
    public final BlockBuilder<T> translucentRender() {
        this.ctx.setHasTranslucentRender(true);
        return this;
    }

    @SafeVarargs
    @NotNull
    public final BlockBuilder<T> blockTags(TagKey<Block> ... tag) {
        Intrinsics.checkNotNullParameter(tag, (String)"tag");
        for (TagKey<Block> blockTagKey : tag) {
            Supplier[] supplierArray = new Supplier[]{() -> BlockBuilder.blockTags$lambda$9(this)};
            this.getRegistrate().blockTags(blockTagKey).add(supplierArray).register();
        }
        return this;
    }

    @SafeVarargs
    @NotNull
    public final BlockBuilder<T> itemTags(TagKey<Item> ... tags) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.itemBuilder.itemTags(Arrays.copyOf(tags, tags.length));
        return this;
    }

    @SafeVarargs
    @NotNull
    public final BlockBuilder<T> tabTags(TagKey<Item> ... tabs) {
        Intrinsics.checkNotNullParameter(tabs, (String)"tabs");
        this.itemBuilder.tabTags(Arrays.copyOf(tabs, tabs.length));
        return this;
    }

    @NotNull
    public final BlockBuilder<T> toolAndTier(@Nullable TagKey<Block> tool, @Nullable TagKey<Block> tier, boolean correctToolForDrops) {
        TagKey[] tagKeyArray;
        if (tool != null) {
            tagKeyArray = new TagKey[]{tool};
            this.blockTags(tagKeyArray);
        }
        if (tier != null) {
            tagKeyArray = new TagKey[]{tier};
            this.blockTags(tagKeyArray);
        }
        if (correctToolForDrops) {
            this.props = this.props.m_60999_();
        }
        return this;
    }

    public static /* synthetic */ BlockBuilder toolAndTier$default(BlockBuilder blockBuilder, TagKey tagKey, TagKey tagKey2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return blockBuilder.toolAndTier((TagKey<Block>)tagKey, (TagKey<Block>)tagKey2, bl);
    }

    @NotNull
    public final BlockBuilder<T> recipe(@NotNull Function2<? super RegistrateRecipes, ? super Supplier<? extends Block>, Unit> factory) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.recipeFactory = factory;
        return this;
    }

    @NotNull
    public final BlockBuilder<T> color(@NotNull MapColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.ctx.setColor(color);
        return this;
    }

    @NotNull
    public final BlockBuilder<T> textureName(@NotNull String textureName) {
        Intrinsics.checkNotNullParameter((Object)textureName, (String)"textureName");
        this.ctx.setTextureName(textureName);
        return this;
    }

    @NotNull
    public final BlockBuilder<T> biomeColors(boolean hasBlockColors, boolean hasItemColors) {
        this.ctx.setHasBlockBiomeColors(hasBlockColors);
        this.ctx.setHasItemBiomeColors(hasItemColors);
        return this;
    }

    public static /* synthetic */ BlockBuilder biomeColors$default(BlockBuilder blockBuilder, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return blockBuilder.biomeColors(bl, bl2);
    }

    @NotNull
    public final BlockBuilder<T> compostable(float amount) {
        this.ctx.setCompostableAmount(amount);
        return this;
    }

    public static /* synthetic */ BlockBuilder compostable$default(BlockBuilder blockBuilder, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.2f;
        }
        return blockBuilder.compostable(f);
    }

    @NotNull
    public final BlockBuilder<T> onRegister(@NotNull Consumer<? super Block> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.registerCallbacks.add(callback);
        return this;
    }

    @NotNull
    public final BlockBuilder<T> fromFamily(@NotNull Supplier<Block> copyFrom, @NotNull BiFunction<BlockBuilderContext<? extends Block>, BlockBehaviour.Properties, BlockBehaviour.Properties> propsFactory, @NotNull List<TagKey<Block>> blockTags2, @NotNull List<TagKey<Item>> itemTags2, @NotNull List<TagKey<Item>> tabTags, @Nullable MapColor color, @Nullable TagKey<Block> tool, @Nullable TagKey<Block> tier, boolean correctToolForDrops) {
        Intrinsics.checkNotNullParameter(copyFrom, (String)"copyFrom");
        Intrinsics.checkNotNullParameter(propsFactory, (String)"propsFactory");
        Intrinsics.checkNotNullParameter(blockTags2, (String)"blockTags");
        Intrinsics.checkNotNullParameter(itemTags2, (String)"itemTags");
        Intrinsics.checkNotNullParameter(tabTags, (String)"tabTags");
        this.copyFrom(copyFrom);
        this.properties(propsFactory);
        if (color != null) {
            this.color(color);
        }
        this.toolAndTier(tool, tier, correctToolForDrops);
        Collection $this$toTypedArray$iv = blockTags2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TagKey[] tagKeyArray = thisCollection$iv.toArray(new TagKey[0]);
        this.blockTags(Arrays.copyOf(tagKeyArray, tagKeyArray.length));
        $this$toTypedArray$iv = itemTags2;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        tagKeyArray = thisCollection$iv.toArray(new TagKey[0]);
        this.itemTags(Arrays.copyOf(tagKeyArray, tagKeyArray.length));
        $this$toTypedArray$iv = tabTags;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        tagKeyArray = thisCollection$iv.toArray(new TagKey[0]);
        this.tabTags(Arrays.copyOf(tagKeyArray, tagKeyArray.length));
        return this;
    }

    public static /* synthetic */ BlockBuilder fromFamily$default(BlockBuilder blockBuilder, Supplier supplier, BiFunction biFunction, List list, List list2, List list3, MapColor mapColor, TagKey tagKey, TagKey tagKey2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            mapColor = null;
        }
        if ((n & 0x40) != 0) {
            tagKey = null;
        }
        if ((n & 0x80) != 0) {
            tagKey2 = null;
        }
        if ((n & 0x100) != 0) {
            bl = true;
        }
        return blockBuilder.fromFamily(supplier, biFunction, list, list2, list3, mapColor, (TagKey<Block>)tagKey, (TagKey<Block>)tagKey2, bl);
    }

    @NotNull
    public final BlockBuilder<T> transform(@NotNull Function<BlockBuilder<T>, BlockBuilder<T>> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BlockBuilder<T> blockBuilder = consumer.apply(this);
        Intrinsics.checkNotNullExpressionValue(blockBuilder, (String)"apply(...)");
        return blockBuilder;
    }

    private final BlockEntry<T> asEntry() {
        return new BlockEntry(this, this.itemEntry);
    }

    public final void buildItemEntry(@NotNull ItemEntry<?> _itemEntry) {
        Intrinsics.checkNotNullParameter(_itemEntry, (String)"_itemEntry");
        this.itemEntry = _itemEntry;
    }

    @NotNull
    public final BlockEntry<T> register(boolean doRegister) {
        if (!doRegister) {
            return new BlockEntry(null, null);
        }
        this.setBlockInstance(this.getRegistrate().getBlockRegistry().register(this.blockId, this.blockFactory, this));
        if (!this.hasCustomItemBuilder && !this.ctx.getNoItem()) {
            this.itemBuilder.build();
        }
        return this.asEntry();
    }

    public static /* synthetic */ BlockEntry register$default(BlockBuilder blockBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return blockBuilder.register(bl);
    }

    private static final Block blockFactory$lambda$0(BlockBuilder this$0) {
        return new Block(this$0.props);
    }

    private static final Item defaultItemBuilder$lambda$1(BlockBuilder this$0, Item.Properties props) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        return (Item)new BlockItem((Block)this$0.getBlockInstance().get(), props);
    }

    private static final Unit defaultItemBuilder$lambda$2(BlockBuilder this$0, RegistrateItemModelGenerator g, Supplier i) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Object t = this$0.getBlockInstance().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        g.blockItem((Block)t);
        return Unit.INSTANCE;
    }

    private static final Unit defaultLootTableFactory$lambda$3(RegistrateBlockLootTables lt, Supplier b) {
        Intrinsics.checkNotNullParameter((Object)((Object)lt), (String)"lt");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Object t = b.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        lt.dropItself((Block)t);
        return Unit.INSTANCE;
    }

    private static final Unit defaultBlockstateFactory$lambda$4(RegistrateBlockModelGenerator g, Supplier b) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Object t = b.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        RegistrateBlockModelGenerator.cubeAll$default(g, (Block)t, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Item defaultItemBlockFactory$lambda$5(BlockBuilder this$0, Item.Properties p, Block b) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return (Item)new BlockItem((Block)this$0.getBlockInstance().get(), p);
    }

    private static final Unit defaultRecipeFactory$lambda$6(RegistrateRecipes r, Supplier b) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Unit.INSTANCE;
    }

    private static final Block factory$lambda$7(BiFunction $_factoryFunction, BlockBuilder this$0) {
        Object r = $_factoryFunction.apply(this$0.ctx, this$0.props);
        Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type T of com.dannbrown.deltaboxlib.common.registrate.builders.BlockBuilder");
        return (Block)r;
    }

    private static final Unit noItem$lambda$8(RegistrateBlockLootTables lt, Supplier b) {
        Intrinsics.checkNotNullParameter((Object)((Object)lt), (String)"lt");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Object t = b.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        lt.noLoot((Block)t);
        return Unit.INSTANCE;
    }

    private static final Block blockTags$lambda$9(BlockBuilder this$0) {
        return (Block)this$0.getBlockInstance().get();
    }
}

