/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.network.forge;

import com.dannbrown.deltaboxlib.common.registrate.network.NetworkChannelHandler;
import com.dannbrown.deltaboxlib.common.registrate.network.NetworkDirection;
import com.dannbrown.deltaboxlib.common.registrate.network.NetworkPacket;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007JC\u0010\u0012\u001a\u00020\u0011\"\b\b\u0000\u0010\t*\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u0018\u001a\u00020\u0011\"\b\b\u0000\u0010\t*\u00020\b2\u0006\u0010\u0014\u001a\u00028\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b!\u0010 J/\u0010(\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010,\u001a\u00020\u00112\u0006\u0010+\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b,\u0010-J\u001f\u0010.\u001a\u00020\u00112\u0006\u0010+\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b.\u0010-R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00103\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00066"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/network/forge/NetworkChannelHandlerForge;", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkChannelHandler;", "", "modId", "Ljava/util/function/IntSupplier;", "version", "<init>", "(Ljava/lang/String;Ljava/util/function/IntSupplier;)V", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkPacket;", "M", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkDirection;", "direction", "Ljava/lang/Class;", "messageClass", "Lkotlin/Function1;", "Lnet/minecraft/network/FriendlyByteBuf;", "decoder", "", "register", "(Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkDirection;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "message", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "contextSupplier", "consumer", "(Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkPacket;Ljava/util/function/Supplier;)V", "Lnet/minecraft/server/level/ServerPlayer;", "serverPlayer", "networkPacket", "sendToClientPlayer", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkPacket;)V", "sendToAllClientPlayers", "(Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkPacket;)V", "sendToServer", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "", "radius", "sendToAllClientPlayersInRange", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;DLcom/dannbrown/deltaboxlib/common/registrate/network/NetworkPacket;)V", "Lnet/minecraft/world/entity/Entity;", "target", "sendToAllClientPlayersTrackingEntity", "(Lnet/minecraft/world/entity/Entity;Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkPacket;)V", "sendToAllClientPlayersTrackingEntityAndSelf", "Lnet/minecraftforge/network/simple/SimpleChannel;", "channel", "Lnet/minecraftforge/network/simple/SimpleChannel;", "", "id", "I", "Wrapper", "deltaboxlib-forge"})
public final class NetworkChannelHandlerForge
extends NetworkChannelHandler {
    @NotNull
    private final SimpleChannel channel;
    private int id;

    public NetworkChannelHandlerForge(@NotNull String modId, @NotNull IntSupplier version) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        super(modId);
        Supplier<String> ver = () -> NetworkChannelHandlerForge._init_$lambda$0(version);
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modId, "channel"), ver, arg_0 -> NetworkChannelHandlerForge._init_$lambda$1(ver, arg_0), arg_0 -> NetworkChannelHandlerForge._init_$lambda$2(ver, arg_0));
    }

    @Override
    public <M extends NetworkPacket> void register(@NotNull NetworkDirection direction, @NotNull Class<M> messageClass, @NotNull Function1<? super FriendlyByteBuf, ? extends M> decoder) {
        Optional<Object> optional;
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter(messageClass, (String)"messageClass");
        Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                Optional optional2 = Optional.empty();
                optional = optional2;
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
                break;
            }
            case 2: {
                Optional<net.minecraftforge.network.NetworkDirection> optional3 = Optional.of(net.minecraftforge.network.NetworkDirection.PLAY_TO_CLIENT);
                optional = optional3;
                Intrinsics.checkNotNullExpressionValue(optional3, (String)"of(...)");
                break;
            }
            case 3: {
                Optional<net.minecraftforge.network.NetworkDirection> optional4 = Optional.of(net.minecraftforge.network.NetworkDirection.PLAY_TO_SERVER);
                optional = optional4;
                Intrinsics.checkNotNullExpressionValue(optional4, (String)"of(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Optional<Object> dir = optional;
        int n = this.id;
        this.id = n + 1;
        this.channel.registerMessage(n, messageClass, NetworkPacket::writeToBuffer, arg_0 -> NetworkChannelHandlerForge.register$lambda$3(decoder, arg_0), this::consumer, dir);
    }

    private final <M extends NetworkPacket> void consumer(M message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get(...)");
        NetworkEvent.Context context2 = context;
        context2.enqueueWork(() -> NetworkChannelHandlerForge.consumer$lambda$4(message, context2));
        context2.setPacketHandled(true);
    }

    @Override
    public void sendToClientPlayer(@NotNull ServerPlayer serverPlayer, @NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        this.channel.send(PacketDistributor.PLAYER.with(() -> NetworkChannelHandlerForge.sendToClientPlayer$lambda$5(serverPlayer)), (Object)networkPacket);
    }

    @Override
    public void sendToAllClientPlayers(@NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)networkPacket);
    }

    @Override
    public void sendToServer(@NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        this.channel.sendToServer((Object)networkPacket);
    }

    @Override
    public void sendToAllClientPlayersInRange(@NotNull Level level, @NotNull BlockPos pos, double radius, @NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && !level.f_46443_) {
            PacketDistributor.PacketTarget distributor = PacketDistributor.NEAR.with(() -> NetworkChannelHandlerForge.sendToAllClientPlayersInRange$lambda$6(pos, radius, level));
            this.channel.send(distributor, (Object)networkPacket);
        }
    }

    @Override
    public void sendToAllClientPlayersTrackingEntity(@NotNull Entity target, @NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        if (!target.m_9236_().f_46443_) {
            this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> NetworkChannelHandlerForge.sendToAllClientPlayersTrackingEntity$lambda$7(target)), (Object)networkPacket);
        }
    }

    @Override
    public void sendToAllClientPlayersTrackingEntityAndSelf(@NotNull Entity target, @NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        if (!target.m_9236_().f_46443_) {
            this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> NetworkChannelHandlerForge.sendToAllClientPlayersTrackingEntityAndSelf$lambda$8(target)), (Object)networkPacket);
        }
    }

    private static final String _init_$lambda$0(IntSupplier $version) {
        return String.valueOf($version.getAsInt());
    }

    private static final boolean _init_$lambda$1(Supplier $ver, String it) {
        return Intrinsics.areEqual((Object)it, $ver.get());
    }

    private static final boolean _init_$lambda$2(Supplier $ver, String it) {
        return Intrinsics.areEqual((Object)it, $ver.get());
    }

    private static final NetworkPacket register$lambda$3(Function1 $tmp0, FriendlyByteBuf p0) {
        return (NetworkPacket)$tmp0.invoke((Object)p0);
    }

    private static final void consumer$lambda$4(NetworkPacket $message, NetworkEvent.Context $context) {
        $message.handle(new Wrapper($context));
    }

    private static final ServerPlayer sendToClientPlayer$lambda$5(ServerPlayer $serverPlayer) {
        return $serverPlayer;
    }

    private static final PacketDistributor.TargetPoint sendToAllClientPlayersInRange$lambda$6(BlockPos $pos, double $radius, Level $level) {
        return new PacketDistributor.TargetPoint((double)$pos.m_123341_(), (double)$pos.m_123342_(), (double)$pos.m_123343_(), $radius, $level.m_46472_());
    }

    private static final Entity sendToAllClientPlayersTrackingEntity$lambda$7(Entity $target) {
        return $target;
    }

    private static final Entity sendToAllClientPlayersTrackingEntityAndSelf$lambda$8(Entity $target) {
        return $target;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NetworkDirection.values().length];
            try {
                nArray[NetworkDirection.BOTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkDirection.PLAY_TO_CLIENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkDirection.PLAY_TO_SERVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000bR\u001a\u0010\r\u001a\u00020\f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/network/forge/NetworkChannelHandlerForge$Wrapper;", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkChannelHandler$Context;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "context", "<init>", "(Lnet/minecraftforge/network/NetworkEvent$Context;)V", "Lnet/minecraft/network/chat/Component;", "reason", "", "disconnect", "(Lnet/minecraft/network/chat/Component;)V", "Lnet/minecraftforge/network/NetworkEvent$Context;", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkDirection;", "direction", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkDirection;", "getDirection", "()Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkDirection;", "Lnet/minecraft/world/entity/player/Player;", "sender", "Lnet/minecraft/world/entity/player/Player;", "getSender", "()Lnet/minecraft/world/entity/player/Player;", "deltaboxlib-forge"})
    private static final class Wrapper
    implements NetworkChannelHandler.Context {
        @NotNull
        private final NetworkEvent.Context context;
        @NotNull
        private final NetworkDirection direction;
        @Nullable
        private final Player sender;

        public Wrapper(@NotNull NetworkEvent.Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            net.minecraftforge.network.NetworkDirection networkDirection = this.context.getDirection();
            this.direction = (networkDirection == null ? -1 : WhenMappings.$EnumSwitchMapping$0[networkDirection.ordinal()]) == 1 ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER;
            this.sender = (Player)this.context.getSender();
        }

        @Override
        @NotNull
        public NetworkDirection getDirection() {
            return this.direction;
        }

        @Override
        @Nullable
        public Player getSender() {
            return this.sender;
        }

        @Override
        public void disconnect(@NotNull Component reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.context.getNetworkManager().m_129507_(reason);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[net.minecraftforge.network.NetworkDirection.values().length];
                try {
                    nArray[net.minecraftforge.network.NetworkDirection.PLAY_TO_CLIENT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

