/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.providers.trades;

import com.dannbrown.deltaboxlib.common.registrate.AbstractDeltaboxRegistrate;
import com.dannbrown.deltaboxlib.common.registrate.providers.trades.VillagerTradeCodec;
import com.dannbrown.deltaboxlib.common.registrate.providers.trades.VillagerTradeItem;
import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017R\u001c\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/providers/trades/VillagerTradeProvider;", "Lnet/minecraft/data/DataProvider;", "Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "registrate", "Lnet/minecraft/data/PackOutput;", "packOutput", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;Lnet/minecraft/data/PackOutput;)V", "", "getName", "()Ljava/lang/String;", "Lnet/minecraft/data/CachedOutput;", "cachedOutput", "Ljava/util/concurrent/CompletableFuture;", "run", "(Lnet/minecraft/data/CachedOutput;)Ljava/util/concurrent/CompletableFuture;", "Ljava/nio/file/Path;", "path", "Lcom/dannbrown/deltaboxlib/common/registrate/providers/trades/VillagerTradeCodec;", "trade", "saveTradeData", "(Lnet/minecraft/data/CachedOutput;Ljava/nio/file/Path;Lcom/dannbrown/deltaboxlib/common/registrate/providers/trades/VillagerTradeCodec;)Ljava/util/concurrent/CompletableFuture;", "Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "Lnet/minecraft/data/PackOutput;", "Lnet/minecraft/data/PackOutput$PathProvider;", "kotlin.jvm.PlatformType", "pathProvider", "Lnet/minecraft/data/PackOutput$PathProvider;", "deltaboxlib-forge"})
@SourceDebugExtension(value={"SMAP\nVillagerTradeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VillagerTradeProvider.kt\ncom/dannbrown/deltaboxlib/common/registrate/providers/trades/VillagerTradeProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n37#2,2:47\n*S KotlinDebug\n*F\n+ 1 VillagerTradeProvider.kt\ncom/dannbrown/deltaboxlib/common/registrate/providers/trades/VillagerTradeProvider\n*L\n31#1:47,2\n*E\n"})
public final class VillagerTradeProvider
implements DataProvider {
    @NotNull
    private final AbstractDeltaboxRegistrate registrate;
    @NotNull
    private final PackOutput packOutput;
    private final PackOutput.PathProvider pathProvider;

    public VillagerTradeProvider(@NotNull AbstractDeltaboxRegistrate registrate, @NotNull PackOutput packOutput) {
        Intrinsics.checkNotNullParameter((Object)registrate, (String)"registrate");
        Intrinsics.checkNotNullParameter((Object)packOutput, (String)"packOutput");
        this.registrate = registrate;
        this.packOutput = packOutput;
        this.pathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "deltabox_villager_trades");
    }

    @NotNull
    public String m_6055_() {
        return "Villager Trades Datagen for: " + this.registrate.getModId();
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cachedOutput) {
        Intrinsics.checkNotNullParameter((Object)cachedOutput, (String)"cachedOutput");
        List futures = new ArrayList();
        for (VillagerTradeCodec trade : this.registrate.getTradesRegistry().getTrades()) {
            String tradeName = trade.getProfession().f_35600_() + "_" + trade.getLevel().toName() + "_" + DeltaboxUtil.INSTANCE.getItemId(() -> VillagerTradeProvider.run$lambda$0(trade)) + "_for_" + DeltaboxUtil.INSTANCE.getItemId(() -> VillagerTradeProvider.run$lambda$1(trade));
            Path tradePath = this.pathProvider.m_245731_(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), tradeName));
            Intrinsics.checkNotNull((Object)tradePath);
            futures.add(this.saveTradeData(cachedOutput, tradePath, trade));
        }
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"allOf(...)");
        return completableFuture;
    }

    private final CompletableFuture<?> saveTradeData(CachedOutput cachedOutput, Path path, VillagerTradeCodec trade) {
        CompletableFuture completableFuture;
        try {
            JsonObject jsonObject = ((JsonElement)VillagerTradeCodec.Companion.getCODEC().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)trade).getOrThrow(false, VillagerTradeProvider::saveTradeData$lambda$2)).getAsJsonObject();
            completableFuture = DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)((JsonElement)jsonObject), (Path)path);
        }
        catch (IOException ioException) {
            DeltaboxUtil.INSTANCE.getLOGGER().error("Couldn't save villager trade at {}", (Object)path, (Object)ioException);
            throw ioException;
        }
        return completableFuture;
    }

    private static final Item run$lambda$0(VillagerTradeCodec $trade) {
        return ((VillagerTradeItem)CollectionsKt.first($trade.getTradeCosts())).getItem().get();
    }

    private static final Item run$lambda$1(VillagerTradeCodec $trade) {
        return ((VillagerTradeItem)CollectionsKt.first($trade.getTradeSells())).getItem().get();
    }

    private static final void saveTradeData$lambda$2(String it) {
    }
}

