/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.registry;

import com.dannbrown.deltaboxlib.common.content.armorRenderer.ArmorModelProvider;
import com.dannbrown.deltaboxlib.common.content.armorRenderer.ArmorModelSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u000f\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000f\u0010\u0012J\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0015j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e`\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R3\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0015j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e`\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ArmorModelRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "armorName", "Lnet/minecraft/world/entity/EquipmentSlot;", "slot", "Ljava/util/function/Supplier;", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "layerDefinition", "Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelSupplier;", "armorModelSupplier", "Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelProvider;", "register", "(Ljava/lang/String;Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/Supplier;Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelSupplier;)Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelProvider;", "", "()V", "getProviderForArmor", "(Ljava/lang/String;Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelProvider;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getRegistry", "()Ljava/util/HashMap;", "Ljava/lang/String;", "REGISTRY", "Ljava/util/HashMap;", "getREGISTRY", "deltaboxlib-forge"})
public final class ArmorModelRegistry {
    @NotNull
    private final String modId;
    @NotNull
    private final HashMap<String, ArmorModelProvider> REGISTRY;

    public ArmorModelRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.modId = modId;
        this.REGISTRY = new HashMap();
    }

    @NotNull
    public final HashMap<String, ArmorModelProvider> getREGISTRY() {
        return this.REGISTRY;
    }

    @NotNull
    public final ArmorModelProvider register(@NotNull String armorName, @NotNull EquipmentSlot slot, @NotNull Supplier<LayerDefinition> layerDefinition, @NotNull ArmorModelSupplier armorModelSupplier) {
        Intrinsics.checkNotNullParameter((Object)armorName, (String)"armorName");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter(layerDefinition, (String)"layerDefinition");
        Intrinsics.checkNotNullParameter((Object)armorModelSupplier, (String)"armorModelSupplier");
        ArmorModelProvider provider = new ArmorModelProvider(this.modId, armorName, slot, layerDefinition, armorModelSupplier);
        ((Map)this.REGISTRY).put(armorName + "_" + slot.name(), provider);
        return provider;
    }

    public final void register() {
    }

    @Nullable
    public final ArmorModelProvider getProviderForArmor(@NotNull String armorName, @NotNull EquipmentSlot slot) {
        Intrinsics.checkNotNullParameter((Object)armorName, (String)"armorName");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        return this.REGISTRY.get(armorName + "_" + slot.name());
    }

    @NotNull
    public final HashMap<String, ArmorModelProvider> getRegistry() {
        return this.REGISTRY;
    }
}

