/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.architectury.platform.Platform;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\n3456789:;<B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J9\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00150\n2\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J9\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\n2\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J9\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00150\n2\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J9\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\n2\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0017J\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ\u001f\u0010!\u001a\u00020\u00072\u000e\u0010 \u001a\n\u0012\u0002\b\u00030\u001fR\u00020\u0000H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b#\u0010\u001dJ\r\u0010$\u001a\u00020\u001b\u00a2\u0006\u0004\b$\u0010\u001dJ\r\u0010%\u001a\u00020\u001b\u00a2\u0006\u0004\b%\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010&R\u001c\u0010)\u001a\n (*\u0004\u0018\u00010'0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R(\u0010/\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0002\b\u00030\u001fR\u00020\u00000.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00101\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u0006="}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "key", "", "defaultValue", "comment", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigSupplier;", "registerBoolean", "(Ljava/lang/String;ZLjava/lang/String;)Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigSupplier;", "", "registerInt", "(Ljava/lang/String;ILjava/lang/String;)Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigSupplier;", "", "registerFloat", "(Ljava/lang/String;FLjava/lang/String;)Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigSupplier;", "registerString", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigSupplier;", "", "registerBooleanArray", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigSupplier;", "registerIntArray", "registerFloatArray", "registerStringArray", "", "loadConfig", "()V", "saveConfig", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "property", "isArrayProperty", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;)Z", "createConfigFile", "freeze", "clear", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Ljava/io/File;", "configFile", "Ljava/io/File;", "", "properties", "Ljava/util/Map;", "frozen", "Z", "ConfigProperty", "BooleanConfigProperty", "IntConfigProperty", "FloatConfigProperty", "StringConfigProperty", "BooleanArrayConfigProperty", "IntArrayConfigProperty", "FloatArrayConfigProperty", "StringArrayConfigProperty", "ConfigSupplier", "deltaboxlib-forge"})
@SourceDebugExtension(value={"SMAP\nConfigRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigRegistry.kt\ncom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,341:1\n1#2:342\n1557#3:343\n1628#3,3:344\n216#4,2:347\n*S KotlinDebug\n*F\n+ 1 ConfigRegistry.kt\ncom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry\n*L\n102#1:343\n102#1:344,3\n136#1:347,2\n*E\n"})
public final class ConfigRegistry {
    @NotNull
    private final String modId;
    private final Gson gson;
    @NotNull
    private final File configFile;
    @NotNull
    private final Map<String, ConfigProperty<?>> properties;
    private boolean frozen;

    public ConfigRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.modId = modId;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.configFile = new File(Platform.getConfigFolder().toFile(), this.modId + ".common.conf");
        this.properties = new LinkedHashMap();
    }

    @NotNull
    public final ConfigSupplier<Boolean> registerBoolean(@NotNull String key, boolean defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.frozen) {
            return new ConfigSupplier<Boolean>(() -> ConfigRegistry.registerBoolean$lambda$0(this, key));
        }
        BooleanConfigProperty property = new BooleanConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<Boolean>(() -> ConfigRegistry.registerBoolean$lambda$1(property));
    }

    @NotNull
    public final ConfigSupplier<Integer> registerInt(@NotNull String key, int defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.frozen) {
            return new ConfigSupplier<Integer>(() -> ConfigRegistry.registerInt$lambda$2(this, key));
        }
        IntConfigProperty property = new IntConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<Integer>(() -> ConfigRegistry.registerInt$lambda$3(property));
    }

    @NotNull
    public final ConfigSupplier<Float> registerFloat(@NotNull String key, float defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.frozen) {
            return new ConfigSupplier<Float>(() -> ConfigRegistry.registerFloat$lambda$4(this, key));
        }
        FloatConfigProperty property = new FloatConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<Float>(() -> ConfigRegistry.registerFloat$lambda$5(property));
    }

    @NotNull
    public final ConfigSupplier<String> registerString(@NotNull String key, @NotNull String defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        if (this.frozen) {
            return new ConfigSupplier<String>(() -> ConfigRegistry.registerString$lambda$6(this, key));
        }
        StringConfigProperty property = new StringConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<String>(() -> ConfigRegistry.registerString$lambda$7(property));
    }

    @NotNull
    public final ConfigSupplier<List<Boolean>> registerBooleanArray(@NotNull String key, @NotNull List<Boolean> defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        if (this.frozen) {
            return new ConfigSupplier<List<Boolean>>(() -> ConfigRegistry.registerBooleanArray$lambda$8(this, key));
        }
        BooleanArrayConfigProperty property = new BooleanArrayConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<List<Boolean>>(() -> ConfigRegistry.registerBooleanArray$lambda$9(property));
    }

    @NotNull
    public final ConfigSupplier<List<Integer>> registerIntArray(@NotNull String key, @NotNull List<Integer> defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        if (this.frozen) {
            return new ConfigSupplier<List<Integer>>(() -> ConfigRegistry.registerIntArray$lambda$10(this, key));
        }
        IntArrayConfigProperty property = new IntArrayConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<List<Integer>>(() -> ConfigRegistry.registerIntArray$lambda$11(property));
    }

    @NotNull
    public final ConfigSupplier<List<Float>> registerFloatArray(@NotNull String key, @NotNull List<Float> defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        if (this.frozen) {
            return new ConfigSupplier<List<Float>>(() -> ConfigRegistry.registerFloatArray$lambda$12(this, key));
        }
        FloatArrayConfigProperty property = new FloatArrayConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<List<Float>>(() -> ConfigRegistry.registerFloatArray$lambda$13(property));
    }

    @NotNull
    public final ConfigSupplier<List<String>> registerStringArray(@NotNull String key, @NotNull List<String> defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        if (this.frozen) {
            return new ConfigSupplier<List<String>>(() -> ConfigRegistry.registerStringArray$lambda$14(this, key));
        }
        StringArrayConfigProperty property = new StringArrayConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<List<String>>(() -> ConfigRegistry.registerStringArray$lambda$15(property));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void loadConfig() {
        List list;
        Object object;
        if (!this.configFile.exists()) {
            this.createConfigFile();
        }
        try {
            object = new InputStreamReader((InputStream)new FileInputStream(this.configFile), Charsets.UTF_8);
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)object;
                boolean bl = false;
                list = TextStreamsKt.readLines((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = list;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Object lines = object;
        int i = 0;
        while (i < lines.size()) {
            String line = ((Object)StringsKt.trim((CharSequence)((String)lines.get(i)))).toString();
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || ((CharSequence)line).length() == 0) {
                ++i;
                continue;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)"=", (boolean)false, (int)2, null)) {
                ConfigProperty<?> property;
                void $this$mapTo$iv$iv;
                String[] bl = new String[]{"="};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)line, (String[])bl, (boolean)false, (int)2, (int)2, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                list = (List)destination$iv$iv;
                String key = (String)list.get(0);
                String rawValueStart = (String)list.get(1);
                String value = rawValueStart;
                if (StringsKt.startsWith$default((String)value, (String)"[", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)value, (String)"]", (boolean)false, (int)2, null)) {
                    List valueLines = new ArrayList();
                    valueLines.add(value);
                    ++i;
                    while (i < lines.size() && !StringsKt.endsWith$default((String)((Object)StringsKt.trim((CharSequence)((String)lines.get(i)))).toString(), (String)"]", (boolean)false, (int)2, null)) {
                        valueLines.add(lines.get(i));
                        ++i;
                    }
                    if (i < lines.size()) {
                        valueLines.add(((Object)StringsKt.trim((CharSequence)((String)lines.get(i)))).toString());
                    }
                    value = CollectionsKt.joinToString$default((Iterable)valueLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                }
                ConfigProperty<?> configProperty = property = this.properties.get(key);
                if (configProperty != null) {
                    configProperty.loadValue(value);
                }
            }
            ++i;
        }
        this.saveConfig();
        this.frozen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveConfig() {
        try {
            Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), Charsets.UTF_8);
            Throwable throwable = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)closeable;
                boolean bl = false;
                writer.write("# Config for " + this.modId + "\n");
                Map<String, ConfigProperty<?>> $this$forEach$iv = this.properties;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, ConfigProperty<?>>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ConfigProperty<?>> element$iv;
                    Map.Entry<String, ConfigProperty<?>> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    ConfigProperty<?> property = entry.getValue();
                    CharSequence charSequence = property.getComment();
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        writer.write("# " + property.getComment() + "\n");
                    }
                    if (this.isArrayProperty(property)) {
                        writer.write(property.getKey() + "=");
                        String json = this.gson.toJson(property.getValue());
                        writer.write(json + "\n\n");
                        continue;
                    }
                    writer.write(property.getKey() + "=" + property.toStringValue() + "\n\n");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final boolean isArrayProperty(ConfigProperty<?> property) {
        return property instanceof BooleanArrayConfigProperty || property instanceof IntArrayConfigProperty || property instanceof FloatArrayConfigProperty || property instanceof StringArrayConfigProperty;
    }

    private final void createConfigFile() {
        try {
            Files.createDirectories(Paths.get(this.configFile.getParent(), new String[0]), new FileAttribute[0]);
            this.configFile.createNewFile();
            FileWriter writer = new FileWriter(this.configFile);
            writer.write("# Config for " + this.modId + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void freeze() {
        this.frozen = true;
    }

    public final void clear() {
        this.properties.clear();
    }

    private static final boolean registerBoolean$lambda$0(ConfigRegistry this$0, String $key) {
        ConfigProperty<?> configProperty = this$0.properties.get($key);
        Intrinsics.checkNotNull(configProperty, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.common.registrate.registry.ConfigRegistry.BooleanConfigProperty");
        return ((BooleanConfigProperty)configProperty).getValue();
    }

    private static final boolean registerBoolean$lambda$1(BooleanConfigProperty $property) {
        return $property.getValue();
    }

    private static final int registerInt$lambda$2(ConfigRegistry this$0, String $key) {
        ConfigProperty<?> configProperty = this$0.properties.get($key);
        Intrinsics.checkNotNull(configProperty, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.common.registrate.registry.ConfigRegistry.IntConfigProperty");
        return ((IntConfigProperty)configProperty).getValue();
    }

    private static final int registerInt$lambda$3(IntConfigProperty $property) {
        return $property.getValue();
    }

    private static final float registerFloat$lambda$4(ConfigRegistry this$0, String $key) {
        ConfigProperty<?> configProperty = this$0.properties.get($key);
        Intrinsics.checkNotNull(configProperty, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.common.registrate.registry.ConfigRegistry.FloatConfigProperty");
        return ((FloatConfigProperty)configProperty).getValue().floatValue();
    }

    private static final float registerFloat$lambda$5(FloatConfigProperty $property) {
        return $property.getValue().floatValue();
    }

    private static final String registerString$lambda$6(ConfigRegistry this$0, String $key) {
        ConfigProperty<?> configProperty = this$0.properties.get($key);
        Intrinsics.checkNotNull(configProperty, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.common.registrate.registry.ConfigRegistry.StringConfigProperty");
        return ((StringConfigProperty)configProperty).getValue();
    }

    private static final String registerString$lambda$7(StringConfigProperty $property) {
        return $property.getValue();
    }

    private static final List registerBooleanArray$lambda$8(ConfigRegistry this$0, String $key) {
        ConfigProperty<?> configProperty = this$0.properties.get($key);
        Intrinsics.checkNotNull(configProperty, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.common.registrate.registry.ConfigRegistry.BooleanArrayConfigProperty");
        return ((BooleanArrayConfigProperty)configProperty).getValue();
    }

    private static final List registerBooleanArray$lambda$9(BooleanArrayConfigProperty $property) {
        return $property.getValue();
    }

    private static final List registerIntArray$lambda$10(ConfigRegistry this$0, String $key) {
        ConfigProperty<?> configProperty = this$0.properties.get($key);
        Intrinsics.checkNotNull(configProperty, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.common.registrate.registry.ConfigRegistry.IntArrayConfigProperty");
        return ((IntArrayConfigProperty)configProperty).getValue();
    }

    private static final List registerIntArray$lambda$11(IntArrayConfigProperty $property) {
        return $property.getValue();
    }

    private static final List registerFloatArray$lambda$12(ConfigRegistry this$0, String $key) {
        ConfigProperty<?> configProperty = this$0.properties.get($key);
        Intrinsics.checkNotNull(configProperty, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.common.registrate.registry.ConfigRegistry.FloatArrayConfigProperty");
        return ((FloatArrayConfigProperty)configProperty).getValue();
    }

    private static final List registerFloatArray$lambda$13(FloatArrayConfigProperty $property) {
        return $property.getValue();
    }

    private static final List registerStringArray$lambda$14(ConfigRegistry this$0, String $key) {
        ConfigProperty<?> configProperty = this$0.properties.get($key);
        Intrinsics.checkNotNull(configProperty, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.common.registrate.registry.ConfigRegistry.StringArrayConfigProperty");
        return ((StringArrayConfigProperty)configProperty).getValue();
    }

    private static final List registerStringArray$lambda$15(StringArrayConfigProperty $property) {
        return $property.getValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001R\u00020\u0004B'\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$BooleanArrayConfigProperty;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "", "", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "()Ljava/util/List;", "", "Ljava/util/List;", "deltaboxlib-forge"})
    public final class BooleanArrayConfigProperty
    extends ConfigProperty<List<? extends Boolean>> {
        @NotNull
        private List<Boolean> value;

        public BooleanArrayConfigProperty(@NotNull String key, @Nullable List<Boolean> defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            super(key, defaultValue, comment);
            this.value = CollectionsKt.toMutableList((Collection)defaultValue);
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                Type type2 = new TypeToken<List<? extends Boolean>>(){}.getType();
                Object object = new Gson().fromJson(value, type2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                this.value = CollectionsKt.toMutableList((Collection)((Collection)object));
            }
            catch (Exception e) {
                this.value = CollectionsKt.toMutableList((Collection)((Collection)this.getDefaultValue()));
            }
        }

        @Override
        @NotNull
        public String toStringValue() {
            String string = new Gson().toJson(this.value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        @Override
        @NotNull
        public List<Boolean> getValue() {
            return this.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B!\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$BooleanConfigProperty;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;ZLjava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Boolean;", "Z", "deltaboxlib-forge"})
    public final class BooleanConfigProperty
    extends ConfigProperty<Boolean> {
        private boolean value;

        public BooleanConfigProperty(String key, @Nullable boolean defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key, defaultValue, comment);
            this.value = defaultValue;
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = Boolean.parseBoolean(value);
        }

        @Override
        @NotNull
        public String toStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        @NotNull
        public Boolean getValue() {
            return this.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\b\u00a6\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\u0005\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0010R\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0011\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "T", "", "", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/String;", "getKey", "Ljava/lang/Object;", "getDefaultValue", "getComment", "deltaboxlib-forge"})
    public abstract class ConfigProperty<T> {
        @NotNull
        private final String key;
        private final T defaultValue;
        @Nullable
        private final String comment;

        public ConfigProperty(String key, @Nullable T defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.defaultValue = defaultValue;
            this.comment = comment;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final T getDefaultValue() {
            return this.defaultValue;
        }

        @Nullable
        public final String getComment() {
            return this.comment;
        }

        public abstract void loadValue(@NotNull String var1);

        @NotNull
        public abstract String toStringValue();

        public abstract T getValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\tR\u0018\u0010\n\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigSupplier;", "T", "", "Lkotlin/Function0;", "valueGetter", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "get", "()Ljava/lang/Object;", "Lkotlin/jvm/functions/Function0;", "value", "Ljava/lang/Object;", "deltaboxlib-forge"})
    public static final class ConfigSupplier<T> {
        @NotNull
        private final Function0<T> valueGetter;
        @Nullable
        private T value;

        public ConfigSupplier(@NotNull Function0<? extends T> valueGetter) {
            Intrinsics.checkNotNullParameter(valueGetter, (String)"valueGetter");
            this.valueGetter = valueGetter;
        }

        public final T get() {
            if (this.value == null) {
                this.value = this.valueGetter.invoke();
            }
            T t = this.value;
            Intrinsics.checkNotNull(t);
            return t;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001R\u00020\u0004B'\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$FloatArrayConfigProperty;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "", "", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "()Ljava/util/List;", "", "Ljava/util/List;", "deltaboxlib-forge"})
    public final class FloatArrayConfigProperty
    extends ConfigProperty<List<? extends Float>> {
        @NotNull
        private List<Float> value;

        public FloatArrayConfigProperty(@NotNull String key, @Nullable List<Float> defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            super(key, defaultValue, comment);
            this.value = CollectionsKt.toMutableList((Collection)defaultValue);
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                Type type2 = new TypeToken<List<? extends Float>>(){}.getType();
                Object object = new Gson().fromJson(value, type2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                this.value = CollectionsKt.toMutableList((Collection)((Collection)object));
            }
            catch (Exception e) {
                this.value = CollectionsKt.toMutableList((Collection)((Collection)this.getDefaultValue()));
            }
        }

        @Override
        @NotNull
        public String toStringValue() {
            String string = new Gson().toJson(this.value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        @Override
        @NotNull
        public List<Float> getValue() {
            return this.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B!\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$FloatConfigProperty;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;FLjava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Float;", "F", "deltaboxlib-forge"})
    public final class FloatConfigProperty
    extends ConfigProperty<Float> {
        private float value;

        public FloatConfigProperty(String key, @Nullable float defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key, Float.valueOf(defaultValue), comment);
            this.value = defaultValue;
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = Float.parseFloat(value);
        }

        @Override
        @NotNull
        public String toStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        @NotNull
        public Float getValue() {
            return Float.valueOf(this.value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001R\u00020\u0004B'\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$IntArrayConfigProperty;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "", "", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "()Ljava/util/List;", "", "Ljava/util/List;", "deltaboxlib-forge"})
    public final class IntArrayConfigProperty
    extends ConfigProperty<List<? extends Integer>> {
        @NotNull
        private List<Integer> value;

        public IntArrayConfigProperty(@NotNull String key, @Nullable List<Integer> defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            super(key, defaultValue, comment);
            this.value = CollectionsKt.toMutableList((Collection)defaultValue);
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                Type type2 = new TypeToken<List<? extends Integer>>(){}.getType();
                Object object = new Gson().fromJson(value, type2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                this.value = CollectionsKt.toMutableList((Collection)((Collection)object));
            }
            catch (Exception e) {
                this.value = CollectionsKt.toMutableList((Collection)((Collection)this.getDefaultValue()));
            }
        }

        @Override
        @NotNull
        public String toStringValue() {
            String string = new Gson().toJson(this.value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        @Override
        @NotNull
        public List<Integer> getValue() {
            return this.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B!\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$IntConfigProperty;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;ILjava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Integer;", "I", "deltaboxlib-forge"})
    public final class IntConfigProperty
    extends ConfigProperty<Integer> {
        private int value;

        public IntConfigProperty(String key, @Nullable int defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key, defaultValue, comment);
            this.value = defaultValue;
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = Integer.parseInt(value);
        }

        @Override
        @NotNull
        public String toStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        @NotNull
        public Integer getValue() {
            return this.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001R\u00020\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$StringArrayConfigProperty;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "", "", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "()Ljava/util/List;", "", "Ljava/util/List;", "deltaboxlib-forge"})
    public final class StringArrayConfigProperty
    extends ConfigProperty<List<? extends String>> {
        @NotNull
        private List<String> value;

        public StringArrayConfigProperty(@NotNull String key, @Nullable List<String> defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            super(key, defaultValue, comment);
            this.value = CollectionsKt.toMutableList((Collection)defaultValue);
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                Type type2 = new TypeToken<List<? extends String>>(){}.getType();
                Object object = new Gson().fromJson(value, type2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                this.value = CollectionsKt.toMutableList((Collection)CollectionsKt.filterNotNull((Iterable)((Iterable)object)));
            }
            catch (Exception e) {
                this.value = CollectionsKt.toMutableList((Collection)((Collection)this.getDefaultValue()));
            }
        }

        @Override
        @NotNull
        public String toStringValue() {
            String string = new Gson().toJson(this.value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        @Override
        @NotNull
        public List<String> getValue() {
            return this.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eR\u0016\u0010\t\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$StringConfigProperty;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry$ConfigProperty;", "", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;", "key", "defaultValue", "comment", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/registry/ConfigRegistry;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "getValue", "Ljava/lang/String;", "deltaboxlib-forge"})
    public final class StringConfigProperty
    extends ConfigProperty<String> {
        @NotNull
        private String value;

        public StringConfigProperty(@NotNull String key, @Nullable String defaultValue, String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            super(key, defaultValue, comment);
            this.value = defaultValue;
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @Override
        @NotNull
        public String toStringValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }
    }
}

