/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.registry;

import com.dannbrown.deltaboxlib.common.registrate.util.AbstractDimension;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0011\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0014\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u001b\u0010\u0016\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e\u00a2\u0006\u0004\b\u0016\u0010\u0012R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/DimensionRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "Lcom/dannbrown/deltaboxlib/common/registrate/util/AbstractDimension;", "dimension", "", "addDimension", "(Lcom/dannbrown/deltaboxlib/common/registrate/util/AbstractDimension;)V", "", "getDimensions", "()Ljava/util/List;", "Lnet/minecraft/data/worldgen/BootstapContext;", "Lnet/minecraft/world/level/levelgen/NoiseGeneratorSettings;", "context", "bootstrapNoise", "(Lnet/minecraft/data/worldgen/BootstapContext;)V", "Lnet/minecraft/world/level/dimension/LevelStem;", "bootstrapStem", "Lnet/minecraft/world/level/dimension/DimensionType;", "bootstrapType", "DIMENSIONS", "Ljava/util/List;", "deltaboxlib-forge"})
public final class DimensionRegistry {
    @NotNull
    private final List<AbstractDimension> DIMENSIONS;

    public DimensionRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.DIMENSIONS = new ArrayList();
    }

    public final void addDimension(@NotNull AbstractDimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.DIMENSIONS.add(dimension);
    }

    @NotNull
    public final List<AbstractDimension> getDimensions() {
        return this.DIMENSIONS;
    }

    public final void bootstrapNoise(@NotNull BootstapContext<NoiseGeneratorSettings> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        for (AbstractDimension dimension : this.DIMENSIONS) {
            dimension.bootstrapNoise(context);
        }
    }

    public final void bootstrapStem(@NotNull BootstapContext<LevelStem> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        for (AbstractDimension dimension : this.DIMENSIONS) {
            dimension.bootstrapStem(context);
        }
    }

    public final void bootstrapType(@NotNull BootstapContext<DimensionType> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        for (AbstractDimension dimension : this.DIMENSIONS) {
            dimension.bootstrapType(context);
        }
    }
}

