/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.registry;

import com.dannbrown.deltaboxlib.common.registrate.builders.ItemBuilder;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JC\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\t\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R8\u0010\u0014\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00060\u0006 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R%\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b0\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001c\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "Lnet/minecraft/world/item/Item;", "T", "id", "Ljava/util/function/Supplier;", "itemSupplier", "Lcom/dannbrown/deltaboxlib/common/registrate/builders/ItemBuilder;", "itemBuilder", "register", "(Ljava/lang/String;Ljava/util/function/Supplier;Lcom/dannbrown/deltaboxlib/common/registrate/builders/ItemBuilder;)Ljava/util/function/Supplier;", "", "build", "()V", "Ldev/architectury/registry/registries/DeferredRegister;", "kotlin.jvm.PlatformType", "items", "Ldev/architectury/registry/registries/DeferredRegister;", "", "entries", "Ljava/util/List;", "getEntries", "()Ljava/util/List;", "", "isRegistered", "Z", "()Z", "setRegistered", "(Z)V", "deltaboxlib-forge"})
public final class ItemRegistry {
    private final DeferredRegister<Item> items;
    @NotNull
    private final List<ItemBuilder<? extends Item>> entries;
    private boolean isRegistered;

    public ItemRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.items = DeferredRegister.create((String)modId, (ResourceKey)Registries.f_256913_);
        this.entries = new ArrayList();
    }

    @NotNull
    public final List<ItemBuilder<? extends Item>> getEntries() {
        return this.entries;
    }

    public final boolean isRegistered() {
        return this.isRegistered;
    }

    public final void setRegistered(boolean bl) {
        this.isRegistered = bl;
    }

    @NotNull
    public final <T extends Item> Supplier<T> register(@NotNull String id, @NotNull Supplier<T> itemSupplier, @NotNull ItemBuilder<? extends Item> itemBuilder) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(itemSupplier, (String)"itemSupplier");
        Intrinsics.checkNotNullParameter(itemBuilder, (String)"itemBuilder");
        this.entries.add(itemBuilder);
        RegistrySupplier registrySupplier = this.items.register(id, itemSupplier);
        Intrinsics.checkNotNullExpressionValue((Object)registrySupplier, (String)"register(...)");
        return (Supplier)registrySupplier;
    }

    public final void build() {
        if (this.isRegistered) {
            return;
        }
        this.isRegistered = true;
        this.items.register();
    }
}

