/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.util;

import com.dannbrown.deltaboxlib.common.registrate.util.AbstractWorldgenUtil;
import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJM\u0010\u0015\u001a\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0014\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001e\u0010\u001fJ#\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\u0004\b!\u0010\u001fJ\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\"\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/util/PlacedFeaturesUtil;", "Lcom/dannbrown/deltaboxlib/common/registrate/util/AbstractWorldgenUtil;", "<init>", "()V", "", "name", "modId", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/levelgen/placement/PlacedFeature;", "registerKey", "(Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/data/worldgen/BootstapContext;", "context", "key", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/levelgen/feature/ConfiguredFeature;", "configuration", "", "Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;", "modifiers", "", "register", "(Lnet/minecraft/data/worldgen/BootstapContext;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/Holder;Ljava/util/List;)V", "placementModifier", "modifier", "orePlacement", "(Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;)Ljava/util/List;", "", "pCount", "pHeightRange", "commonOrePlacement", "(ILnet/minecraft/world/level/levelgen/placement/PlacementModifier;)Ljava/util/List;", "pChance", "rareOrePlacement", "chance", "wildCropPlaced", "(I)Ljava/util/List;", "deltaboxlib-forge"})
public final class PlacedFeaturesUtil
extends AbstractWorldgenUtil {
    @NotNull
    public static final PlacedFeaturesUtil INSTANCE = new PlacedFeaturesUtil();

    private PlacedFeaturesUtil() {
    }

    @NotNull
    public final ResourceKey<PlacedFeature> registerKey(@NotNull String name, @NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)DeltaboxUtil.INSTANCE.resourceLocation(modId, name));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        return resourceKey;
    }

    public final void register(@NotNull BootstapContext<PlacedFeature> context, @NotNull ResourceKey<PlacedFeature> key, @NotNull Holder<ConfiguredFeature<?, ?>> configuration, @NotNull List<? extends PlacementModifier> modifiers) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        context.m_255272_(key, (Object)new PlacedFeature(configuration, modifiers));
    }

    @NotNull
    public final List<PlacementModifier> orePlacement(@NotNull PlacementModifier placementModifier, @NotNull PlacementModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)placementModifier, (String)"placementModifier");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Object[] objectArray = new PlacementModifier[]{placementModifier, InSquarePlacement.m_191715_(), modifier, BiomeFilter.m_191561_()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<PlacementModifier> commonOrePlacement(int pCount, @NotNull PlacementModifier pHeightRange) {
        Intrinsics.checkNotNullParameter((Object)pHeightRange, (String)"pHeightRange");
        CountPlacement countPlacement = CountPlacement.m_191628_((int)pCount);
        Intrinsics.checkNotNullExpressionValue((Object)countPlacement, (String)"of(...)");
        return this.orePlacement((PlacementModifier)countPlacement, pHeightRange);
    }

    @NotNull
    public final List<PlacementModifier> rareOrePlacement(int pChance, @NotNull PlacementModifier pHeightRange) {
        Intrinsics.checkNotNullParameter((Object)pHeightRange, (String)"pHeightRange");
        RarityFilter rarityFilter = RarityFilter.m_191900_((int)pChance);
        Intrinsics.checkNotNullExpressionValue((Object)rarityFilter, (String)"onAverageOnceEvery(...)");
        return this.orePlacement((PlacementModifier)rarityFilter, pHeightRange);
    }

    private final List<PlacementModifier> wildCropPlaced(int chance) {
        Object[] objectArray = new PlacementModifier[]{RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

