/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.platform.forge.registrate;

import com.dannbrown.deltaboxlib.common.content.armorRenderer.ArmorModelProvider;
import com.dannbrown.deltaboxlib.common.content.item.DeltaboxSpawnEggItem;
import com.dannbrown.deltaboxlib.common.registrate.AbstractDeltaboxRegistrate;
import com.dannbrown.deltaboxlib.common.registrate.builders.BlockBuilder;
import com.dannbrown.deltaboxlib.common.registrate.builders.BlockEntityBuilder;
import com.dannbrown.deltaboxlib.common.registrate.builders.EntityTypeBuilder;
import com.dannbrown.deltaboxlib.common.registrate.builders.ItemBuilder;
import com.dannbrown.deltaboxlib.common.registrate.helpers.StripHelper;
import com.dannbrown.deltaboxlib.common.registrate.providers.trades.VillagerTradeDeserializer;
import com.dannbrown.deltaboxlib.common.registrate.providers.trades.WandererTradeDeserializer;
import com.dannbrown.deltaboxlib.common.registrate.registry.ParticleRegistry;
import com.dannbrown.deltaboxlib.common.registrate.util.AttributesUtil;
import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.BadAttributeValueExpException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\bJ\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\bJ\u000f\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\bJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\bJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\bJ\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010%\u001a\u00020\u0006\"\b\b\u0000\u0010\"*\u00020!2\u0006\u0010\u0012\u001a\u00020\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010(\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020'\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0015\u00a2\u0006\u0004\b*\u0010\u0017J\u0015\u0010,\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010.\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/dannbrown/deltaboxlib/platform/forge/registrate/RegistrateInitForge;", "", "Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "registrate", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;)V", "", "init", "()V", "setup", "clientSetup", "registerBlockCallbacks", "registerStrippableBlocks", "registerPottedBlocks", "registerComposterBlocks", "registerDispenserBehaviors", "registerWoodTypes", "Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterRenderers;", "event", "onRegisterEntityRenderers", "(Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterRenderers;)V", "Lnet/minecraftforge/client/event/RegisterColorHandlersEvent$Item;", "onRegisterSpawnEggColors", "(Lnet/minecraftforge/client/event/RegisterColorHandlersEvent$Item;)V", "Lnet/minecraftforge/client/event/RegisterParticleProvidersEvent;", "onRegisterParticleRenders", "(Lnet/minecraftforge/client/event/RegisterParticleProvidersEvent;)V", "Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterLayerDefinitions;", "onRegisterLayerDefinitions", "(Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterLayerDefinitions;)V", "Lnet/minecraftforge/event/entity/EntityAttributeCreationEvent;", "onRegisterEntityAttributes", "(Lnet/minecraftforge/event/entity/EntityAttributeCreationEvent;)V", "Lnet/minecraft/core/particles/ParticleOptions;", "T", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ParticleRegistry$ParticleRegistration;", "registration", "handleParticleRegistration", "(Lnet/minecraftforge/client/event/RegisterParticleProvidersEvent;Lcom/dannbrown/deltaboxlib/common/registrate/registry/ParticleRegistry$ParticleRegistration;)V", "Lnet/minecraftforge/client/event/RegisterColorHandlersEvent$Block;", "onRegisterBlockBiomeColors", "(Lnet/minecraftforge/client/event/RegisterColorHandlersEvent$Block;)V", "onRegisterItemBiomeColors", "Lnet/minecraftforge/event/AddReloadListenerEvent;", "onDatapackReload", "(Lnet/minecraftforge/event/AddReloadListenerEvent;)V", "Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "getRegistrate", "()Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "deltaboxlib-forge"})
@SourceDebugExtension(value={"SMAP\nRegistrateInitForge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistrateInitForge.kt\ncom/dannbrown/deltaboxlib/platform/forge/registrate/RegistrateInitForge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,287:1\n1863#2,2:288\n1863#2,2:292\n774#2:294\n865#2,2:295\n1557#2:297\n1628#2,3:298\n774#2:303\n865#2,2:304\n1557#2:306\n1628#2,3:307\n216#3,2:290\n37#4,2:301\n37#4,2:310\n*S KotlinDebug\n*F\n+ 1 RegistrateInitForge.kt\ncom/dannbrown/deltaboxlib/platform/forge/registrate/RegistrateInitForge\n*L\n144#1:288,2\n185#1:292,2\n251#1:294\n251#1:295,2\n252#1:297\n252#1:298,3\n268#1:303\n268#1:304,2\n269#1:306\n269#1:307,3\n153#1:290,2\n263#1:301,2\n276#1:310,2\n*E\n"})
public final class RegistrateInitForge {
    @NotNull
    private final AbstractDeltaboxRegistrate registrate;

    public RegistrateInitForge(@NotNull AbstractDeltaboxRegistrate registrate) {
        Intrinsics.checkNotNullParameter((Object)registrate, (String)"registrate");
        this.registrate = registrate;
    }

    @NotNull
    public final AbstractDeltaboxRegistrate getRegistrate() {
        return this.registrate;
    }

    public final void init() {
    }

    public final void setup() {
        this.registerBlockCallbacks();
        this.registerStrippableBlocks();
        this.registerPottedBlocks();
        this.registerComposterBlocks();
        this.registerDispenserBehaviors();
    }

    public final void clientSetup() {
        this.registerWoodTypes();
    }

    public final void registerBlockCallbacks() {
        for (BlockBuilder<? extends Block> block : this.registrate.getBlockRegistry().getEntries()) {
            for (Consumer<Block> callback : block.getRegisterCallbacks()) {
                try {
                    Block block2 = block.getBlock().get();
                    Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"get(...)");
                    callback.accept(block2);
                }
                catch (Exception e) {
                    String string = "Failed to register block callback for " + block.getBlock().get().m_49954_();
                    System.out.println((Object)string);
                    e.printStackTrace();
                }
            }
        }
    }

    private final void registerStrippableBlocks() {
        for (BlockBuilder<? extends Block> block : this.registrate.getBlockRegistry().getEntries()) {
            Supplier<Block> other;
            if (block.getContext().getStrippableOther() == null) continue;
            if (!other.get().m_49966_().m_61138_((Property)BlockStateProperties.f_61365_)) {
                throw new BadAttributeValueExpException((Object)"Output stripped block should have 'axis' property!");
            }
            if (!block.getBlock().get().m_49966_().m_61138_((Property)BlockStateProperties.f_61365_)) {
                throw new BadAttributeValueExpException((Object)"Input stripped block should have 'axis' property!");
            }
            Block block2 = block.getBlock().get();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"get(...)");
            Block block3 = other.get();
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"get(...)");
            StripHelper.INSTANCE.registerStrippable(block2, block3);
        }
    }

    private final void registerPottedBlocks() {
        for (BlockBuilder<? extends Block> block : this.registrate.getBlockRegistry().getEntries()) {
            Supplier<Block> plant = block.getContext().getPottedOther();
            if (plant == null) continue;
            try {
                Block block2 = Blocks.f_50276_;
                Intrinsics.checkNotNull((Object)block2, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.FlowerPotBlock");
                FlowerPotBlock flowerPotBlock = (FlowerPotBlock)block2;
                Block block3 = plant.get();
                Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"get(...)");
                String string = DeltaboxUtil.INSTANCE.getBlockModId(block3);
                Block block4 = plant.get();
                Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"get(...)");
                flowerPotBlock.addPlant(DeltaboxUtil.INSTANCE.resourceLocation(string, DeltaboxUtil.INSTANCE.getBlockId(block4)), block.getBlock());
            }
            catch (Exception e) {
                String string = "Failed to add plant " + plant.get().m_49954_() + " to flower pot " + block.getBlock().get().m_49954_();
                System.out.println((Object)string);
            }
        }
    }

    private final void registerComposterBlocks() {
        String string;
        Float f;
        float amount;
        for (BlockBuilder<? extends Block> blockBuilder : this.registrate.getBlockRegistry().getEntries()) {
            amount = blockBuilder.getContext().getCompostableAmount();
            if (amount <= 0.0f) continue;
            try {
                f = Float.valueOf(ComposterBlock.f_51914_.put((Object)blockBuilder.getBlock().get().m_5456_(), amount));
            }
            catch (Exception e) {
                string = "Failed to add block " + blockBuilder.getBlock().get().m_49954_() + " to compostables";
                System.out.println((Object)string);
                f = Unit.INSTANCE;
            }
        }
        for (ItemBuilder itemBuilder : this.registrate.getItemRegistry().getEntries()) {
            amount = itemBuilder.getCompostableAmount();
            if (amount <= 0.0f) continue;
            try {
                f = Float.valueOf(ComposterBlock.f_51914_.put(itemBuilder.getItem().get(), amount));
            }
            catch (Exception e) {
                string = "Failed to add block " + ((Item)itemBuilder.getItem().get()).m_5524_() + " to compostables";
                System.out.println((Object)string);
                f = Unit.INSTANCE;
            }
        }
    }

    private final void registerDispenserBehaviors() {
        Object element$iv;
        Object $this$forEach$iv = DeltaboxSpawnEggItem.Companion.getMOD_EGGS();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            DeltaboxSpawnEggItem egg = (DeltaboxSpawnEggItem)((Object)element$iv);
            boolean bl = false;
            DispenseItemBehavior behavior = egg.createDispenseBehavior();
            boolean bl2 = false;
            DispenserBlock.m_52672_((ItemLike)((ItemLike)egg), (DispenseItemBehavior)behavior);
            DeltaboxSpawnEggItem.Companion.getTYPE_MAP().put(egg.getTypeSupplier().get(), egg);
        }
        $this$forEach$iv = this.registrate.getDispenserBehaviorRegistry().getRegistries();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Supplier t = (Supplier)object.getKey();
            DispenseItemBehavior u = (DispenseItemBehavior)object.getValue();
            DispenserBlock.m_52672_((ItemLike)((ItemLike)t.get()), (DispenseItemBehavior)u);
        }
    }

    private final void registerWoodTypes() {
        for (Map.Entry<String, WoodType> entry : this.registrate.getWoodTypesRegistry().getAllWoodTypes().entrySet()) {
            String key = entry.getKey();
            WoodType woodType = entry.getValue();
            Sheets.addWoodType((WoodType)woodType);
        }
    }

    public final void onRegisterEntityRenderers(@NotNull EntityRenderersEvent.RegisterRenderers event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (EntityTypeBuilder<? extends Entity> entityTypeBuilder : this.registrate.getEntityTypeRegistry().getEntries()) {
            if (entityTypeBuilder.getEntityRenderer() == null) continue;
            event.registerEntityRenderer(entityTypeBuilder.getEntity().get(), entityTypeBuilder::getRenderer);
        }
        for (BlockEntityBuilder blockEntityBuilder : this.registrate.getBlockEntityRegistry().getEntries()) {
            if (blockEntityBuilder.getBlockEntityRenderer() == null) continue;
            event.registerBlockEntityRenderer(blockEntityBuilder.getBlockEntity().get(), blockEntityBuilder::getRenderer);
        }
    }

    public final void onRegisterSpawnEggColors(@NotNull RegisterColorHandlersEvent.Item event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = DeltaboxSpawnEggItem.Companion.getMOD_EGGS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeltaboxSpawnEggItem egg = (DeltaboxSpawnEggItem)((Object)element$iv);
            boolean bl = false;
            ItemColors itemColors = event.getItemColors();
            ItemColor itemColor = (arg_0, arg_1) -> RegistrateInitForge.onRegisterSpawnEggColors$lambda$4$lambda$3(egg, arg_0, arg_1);
            ItemLike[] itemLikeArray = new ItemLike[1];
            Intrinsics.checkNotNull((Object)((Object)egg), (String)"null cannot be cast to non-null type net.minecraft.world.level.ItemLike");
            itemLikeArray[0] = egg;
            itemColors.m_92689_(itemColor, itemLikeArray);
        }
    }

    public final void onRegisterParticleRenders(@NotNull RegisterParticleProvidersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (ParticleRegistry.ParticleRegistration<? extends ParticleOptions> particle : this.registrate.getParticleRegistry().getParticles()) {
            this.handleParticleRegistration(event, particle);
        }
    }

    public final void onRegisterLayerDefinitions(@NotNull EntityRenderersEvent.RegisterLayerDefinitions event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (String entry : this.registrate.getBoatVariantRegistry().getBoatVariants()) {
            event.registerLayerDefinition(new ModelLayerLocation(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), "boat/" + entry), "main"), BoatModel::m_246613_);
            event.registerLayerDefinition(new ModelLayerLocation(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), "chest_boat/" + entry), "main"), ChestBoatModel::m_247175_);
        }
        for (Map.Entry entry : ((Map)this.registrate.getArmorModelRegistry().getRegistry()).entrySet()) {
            String name = (String)entry.getKey();
            ArmorModelProvider provider = (ArmorModelProvider)entry.getValue();
            event.registerLayerDefinition(provider.getLayerLocation(), () -> RegistrateInitForge.onRegisterLayerDefinitions$lambda$5(provider));
        }
        for (Map.Entry entry : this.registrate.getModelLayersRegistry().getModelLayers().entrySet()) {
            String path = (String)entry.getKey();
            Pair data = (Pair)entry.getValue();
            Supplier model = (Supplier)data.component1();
            Supplier modelLayer = (Supplier)data.component2();
            event.registerLayerDefinition((ModelLayerLocation)modelLayer.get(), model);
        }
    }

    public final void onRegisterEntityAttributes(@NotNull EntityAttributeCreationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (EntityTypeBuilder<? extends Entity> entityBuilder : this.registrate.getEntityTypeRegistry().getEntries()) {
            if (entityBuilder.getAttributeBuilderFactory() == null) continue;
            try {
                EntityType<? extends Entity> entityType = entityBuilder.getEntity().get();
                Intrinsics.checkNotNull(entityType, (String)"null cannot be cast to non-null type net.minecraft.world.entity.EntityType<out net.minecraft.world.entity.LivingEntity>");
                Function<AttributesUtil, AttributeSupplier.Builder> function = entityBuilder.getAttributeBuilderFactory();
                Intrinsics.checkNotNull(function);
                event.put(entityType, function.apply(AttributesUtil.INSTANCE).m_22265_());
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to register entity " + entityBuilder.getEntityId() + " attribute, it may not be a living entity"));
            }
        }
    }

    private final <T extends ParticleOptions> void handleParticleRegistration(RegisterParticleProvidersEvent event, ParticleRegistry.ParticleRegistration<T> registration) {
        event.registerSpriteSet((ParticleType)registration.getType().get(), arg_0 -> RegistrateInitForge.handleParticleRegistration$lambda$6(registration.getProvider().get(), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void onRegisterBlockBiomeColors(@NotNull RegisterColorHandlersEvent.Block event) {
        void $this$mapTo$iv$iv;
        BlockBuilder it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$filter$iv = this.registrate.getBlockRegistry().getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BlockBuilder)element$iv$iv;
            boolean bl = false;
            if (!it.getContext().getHasBlockBiomeColors()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BlockBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.getBlock().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            collection.add((Block)t);
        }
        List blocks = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = blocks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Block[] blockArray = thisCollection$iv.toArray(new Block[0]);
        event.getBlockColors().m_92589_(RegistrateInitForge::onRegisterBlockBiomeColors$lambda$9, Arrays.copyOf(blockArray, blockArray.length));
    }

    /*
     * WARNING - void declaration
     */
    public final void onRegisterItemBiomeColors(@NotNull RegisterColorHandlersEvent.Item event) {
        void $this$mapTo$iv$iv;
        BlockBuilder it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$filter$iv = this.registrate.getBlockRegistry().getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BlockBuilder)element$iv$iv;
            boolean bl = false;
            if (!it.getContext().getHasItemBiomeColors()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BlockBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.getBlock().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            collection.add((Block)t);
        }
        List blocks = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = blocks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Block[] blockArray = thisCollection$iv.toArray(new Block[0]);
        event.getItemColors().m_92689_((arg_0, arg_1) -> RegistrateInitForge.onRegisterItemBiomeColors$lambda$12(event, arg_0, arg_1), (ItemLike[])Arrays.copyOf(blockArray, blockArray.length));
    }

    public final void onDatapackReload(@NotNull AddReloadListenerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BiConsumer<ResourceLocation, PreparableReloadListener> registry = (arg_0, arg_1) -> RegistrateInitForge.onDatapackReload$lambda$13(event, arg_0, arg_1);
        registry.accept(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), "deltabox_villager_trades"), (PreparableReloadListener)new VillagerTradeDeserializer(this.registrate));
        registry.accept(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), "deltabox_wanderer_trades"), (PreparableReloadListener)new WandererTradeDeserializer(this.registrate));
    }

    private static final int onRegisterSpawnEggColors$lambda$4$lambda$3(DeltaboxSpawnEggItem $egg, ItemStack stack, int layer) {
        return $egg.m_43211_(layer);
    }

    private static final LayerDefinition onRegisterLayerDefinitions$lambda$5(ArmorModelProvider $provider) {
        return $provider.createLayer();
    }

    private static final ParticleProvider handleParticleRegistration$lambda$6(Function1 $tmp0, SpriteSet arg) {
        return (ParticleProvider)$tmp0.invoke((Object)arg);
    }

    private static final int onRegisterBlockBiomeColors$lambda$9(BlockState state, BlockAndTintGetter level, BlockPos pos, int tint) {
        return level != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.m_46113_();
    }

    private static final int onRegisterItemBiomeColors$lambda$12(RegisterColorHandlersEvent.Item $event, ItemStack stack, int tintIndex) {
        Item item = stack.m_41720_();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
        BlockState state = ((BlockItem)item).m_40614_().m_49966_();
        return $event.getBlockColors().m_92577_(state, null, null, tintIndex);
    }

    private static final void onDatapackReload$lambda$13(AddReloadListenerEvent $event, ResourceLocation id, PreparableReloadListener listener) {
        $event.addListener(listener);
    }
}

