/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.init;

import net.mcreator.demonism.entity.BloodDemonicHorseEntity;
import net.mcreator.demonism.entity.CloudOfDestructionEntity;
import net.mcreator.demonism.entity.DAEntity;
import net.mcreator.demonism.entity.FogsEntity;
import net.mcreator.demonism.entity.SAEntity;
import net.mcreator.demonism.entity.TheKingDemonEntity;
import net.mcreator.demonism.entity.TheShadowServantEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DemonismModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"demonism");
    public static final RegistryObject<EntityType<SAEntity>> SA = DemonismModEntities.register("projectile_sa", EntityType.Builder.m_20704_(SAEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(SAEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<DAEntity>> DA = DemonismModEntities.register("projectile_da", EntityType.Builder.m_20704_(DAEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(DAEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<CloudOfDestructionEntity>> CLOUD_OF_DESTRUCTION = DemonismModEntities.register("cloud_of_destruction", EntityType.Builder.m_20704_(CloudOfDestructionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(0).setUpdateInterval(3).setCustomClientFactory(CloudOfDestructionEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<TheKingDemonEntity>> THE_KING_DEMON = DemonismModEntities.register("the_king_demon", EntityType.Builder.m_20704_(TheKingDemonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TheKingDemonEntity::new).m_20719_().m_20699_(1.2f, 2.8f));
    public static final RegistryObject<EntityType<BloodDemonicHorseEntity>> BLOOD_DEMONIC_HORSE = DemonismModEntities.register("blood_demonic_horse", EntityType.Builder.m_20704_(BloodDemonicHorseEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BloodDemonicHorseEntity::new).m_20719_().m_20699_(1.2f, 1.4f));
    public static final RegistryObject<EntityType<TheShadowServantEntity>> THE_SHADOW_SERVANT = DemonismModEntities.register("the_shadow_servant", EntityType.Builder.m_20704_(TheShadowServantEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TheShadowServantEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FogsEntity>> FOGS = DemonismModEntities.register("fogs", EntityType.Builder.m_20704_(FogsEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FogsEntity::new).m_20719_().m_20699_(0.0f, 0.1f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CloudOfDestructionEntity.init();
            TheKingDemonEntity.init();
            BloodDemonicHorseEntity.init();
            TheShadowServantEntity.init();
            FogsEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CLOUD_OF_DESTRUCTION.get(), CloudOfDestructionEntity.createAttributes().m_22265_());
        event.put((EntityType)THE_KING_DEMON.get(), TheKingDemonEntity.createAttributes().m_22265_());
        event.put((EntityType)BLOOD_DEMONIC_HORSE.get(), BloodDemonicHorseEntity.createAttributes().m_22265_());
        event.put((EntityType)THE_SHADOW_SERVANT.get(), TheShadowServantEntity.createAttributes().m_22265_());
        event.put((EntityType)FOGS.get(), FogsEntity.createAttributes().m_22265_());
    }
}

