/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.network;

import java.util.function.Supplier;
import net.mcreator.demonism.DemonismMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DemonismModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        DemonismMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        DemonismMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.LevelDemon = message.data.LevelDemon;
                    variables.SoulPoint = message.data.SoulPoint;
                    variables.PointDemonSkill = message.data.PointDemonSkill;
                    variables.SkillLevel = message.data.SkillLevel;
                    variables.ModeDemon = message.data.ModeDemon;
                    variables.timer = message.data.timer;
                    variables.Demon_Blood = message.data.Demon_Blood;
                    variables.Demon_Shadow = message.data.Demon_Shadow;
                    variables.Demon_Crick = message.data.Demon_Crick;
                    variables.BloodLevel = message.data.BloodLevel;
                    variables.ShadowLevel = message.data.ShadowLevel;
                    variables.DestructionLevel = message.data.DestructionLevel;
                    variables.dop_point = message.data.dop_point;
                    variables.BDH = message.data.BDH;
                    variables.regen = message.data.regen;
                    variables.tss = message.data.tss;
                    variables.fog = message.data.fog;
                    variables.ShockWave = message.data.ShockWave;
                    variables.scroll = message.data.scroll;
                    variables.im = message.data.im;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double LevelDemon = 0.0;
        public double SoulPoint = 0.0;
        public double PointDemonSkill = 0.0;
        public double SkillLevel = 0.0;
        public double ModeDemon = 0.0;
        public double timer = 0.0;
        public boolean Demon_Blood = false;
        public boolean Demon_Shadow = false;
        public boolean Demon_Crick = false;
        public double BloodLevel = 0.0;
        public double ShadowLevel = 0.0;
        public double DestructionLevel = 0.0;
        public boolean dop_point = false;
        public boolean BDH = false;
        public boolean regen = false;
        public boolean tss = false;
        public boolean fog = false;
        public boolean ShockWave = false;
        public double scroll = 0.0;
        public boolean im = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                DemonismMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("LevelDemon", this.LevelDemon);
            nbt.m_128347_("SoulPoint", this.SoulPoint);
            nbt.m_128347_("PointDemonSkill", this.PointDemonSkill);
            nbt.m_128347_("SkillLevel", this.SkillLevel);
            nbt.m_128347_("ModeDemon", this.ModeDemon);
            nbt.m_128347_("timer", this.timer);
            nbt.m_128379_("Demon_Blood", this.Demon_Blood);
            nbt.m_128379_("Demon_Shadow", this.Demon_Shadow);
            nbt.m_128379_("Demon_Crick", this.Demon_Crick);
            nbt.m_128347_("BloodLevel", this.BloodLevel);
            nbt.m_128347_("ShadowLevel", this.ShadowLevel);
            nbt.m_128347_("DestructionLevel", this.DestructionLevel);
            nbt.m_128379_("dop_point", this.dop_point);
            nbt.m_128379_("BDH", this.BDH);
            nbt.m_128379_("regen", this.regen);
            nbt.m_128379_("tss", this.tss);
            nbt.m_128379_("fog", this.fog);
            nbt.m_128379_("ShockWave", this.ShockWave);
            nbt.m_128347_("scroll", this.scroll);
            nbt.m_128379_("im", this.im);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.LevelDemon = nbt.m_128459_("LevelDemon");
            this.SoulPoint = nbt.m_128459_("SoulPoint");
            this.PointDemonSkill = nbt.m_128459_("PointDemonSkill");
            this.SkillLevel = nbt.m_128459_("SkillLevel");
            this.ModeDemon = nbt.m_128459_("ModeDemon");
            this.timer = nbt.m_128459_("timer");
            this.Demon_Blood = nbt.m_128471_("Demon_Blood");
            this.Demon_Shadow = nbt.m_128471_("Demon_Shadow");
            this.Demon_Crick = nbt.m_128471_("Demon_Crick");
            this.BloodLevel = nbt.m_128459_("BloodLevel");
            this.ShadowLevel = nbt.m_128459_("ShadowLevel");
            this.DestructionLevel = nbt.m_128459_("DestructionLevel");
            this.dop_point = nbt.m_128471_("dop_point");
            this.BDH = nbt.m_128471_("BDH");
            this.regen = nbt.m_128471_("regen");
            this.tss = nbt.m_128471_("tss");
            this.fog = nbt.m_128471_("fog");
            this.ShockWave = nbt.m_128471_("ShockWave");
            this.scroll = nbt.m_128459_("scroll");
            this.im = nbt.m_128471_("im");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("demonism", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "demonism_mapvars";
        public boolean Demonism = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.Demonism = nbt.m_128471_("Demonism");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("Demonism", this.Demonism);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                DemonismMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "demonism_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                DemonismMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.LevelDemon = original.LevelDemon;
            clone.SoulPoint = original.SoulPoint;
            clone.PointDemonSkill = original.PointDemonSkill;
            clone.SkillLevel = original.SkillLevel;
            clone.ModeDemon = original.ModeDemon;
            clone.timer = original.timer;
            clone.Demon_Blood = original.Demon_Blood;
            clone.Demon_Shadow = original.Demon_Shadow;
            clone.Demon_Crick = original.Demon_Crick;
            clone.BloodLevel = original.BloodLevel;
            clone.ShadowLevel = original.ShadowLevel;
            clone.DestructionLevel = original.DestructionLevel;
            clone.dop_point = original.dop_point;
            clone.BDH = original.BDH;
            clone.regen = original.regen;
            clone.tss = original.tss;
            clone.fog = original.fog;
            clone.ShockWave = original.ShockWave;
            clone.scroll = original.scroll;
            clone.im = original.im;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    DemonismMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    DemonismMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                DemonismMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

