/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.demonism.DemonismMod;
import net.mcreator.demonism.procedures.ProUpBDHProcedure;
import net.mcreator.demonism.procedures.ProUpInvisibleBloodProcedure;
import net.mcreator.demonism.procedures.ProUpNRProcedure;
import net.mcreator.demonism.procedures.ProUpRageBloodProcedure;
import net.mcreator.demonism.procedures.ProUpRegenProcedure;
import net.mcreator.demonism.procedures.ProUpVampirismBloodProcedure;
import net.mcreator.demonism.world.inventory.GUISkillsDemonBloodMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUISkillsDemonBloodButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUISkillsDemonBloodButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUISkillsDemonBloodButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUISkillsDemonBloodButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUISkillsDemonBloodButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUISkillsDemonBloodButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GUISkillsDemonBloodMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProUpVampirismBloodProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ProUpRageBloodProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ProUpInvisibleBloodProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ProUpNRProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ProUpBDHProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProUpRegenProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DemonismMod.addNetworkMessage(GUISkillsDemonBloodButtonMessage.class, GUISkillsDemonBloodButtonMessage::buffer, GUISkillsDemonBloodButtonMessage::new, GUISkillsDemonBloodButtonMessage::handler);
    }
}

