/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.demonism.DemonismMod;
import net.mcreator.demonism.procedures.ProUpCDProcedure;
import net.mcreator.demonism.procedures.ProUpDAProcedure;
import net.mcreator.demonism.procedures.ProUpFireProcedure;
import net.mcreator.demonism.procedures.ProUpImProcedure;
import net.mcreator.demonism.procedures.ProUpPKMProcedure;
import net.mcreator.demonism.procedures.ProUpShokwareProcedure;
import net.mcreator.demonism.world.inventory.GUISkillsDemonCrickMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUISkillsDemonCrickButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUISkillsDemonCrickButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUISkillsDemonCrickButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUISkillsDemonCrickButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUISkillsDemonCrickButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUISkillsDemonCrickButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GUISkillsDemonCrickMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProUpDAProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ProUpCDProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ProUpFireProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ProUpPKMProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ProUpShokwareProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProUpImProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DemonismMod.addNetworkMessage(GUISkillsDemonCrickButtonMessage.class, GUISkillsDemonCrickButtonMessage::buffer, GUISkillsDemonCrickButtonMessage::new, GUISkillsDemonCrickButtonMessage::handler);
    }
}

