/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.demonism.DemonismMod;
import net.mcreator.demonism.procedures.ProOpenGUIDemonBloodProcedure;
import net.mcreator.demonism.procedures.ProOpenGUIDemonCrickProcedure;
import net.mcreator.demonism.procedures.ProOpenGUIDemonShadowProcedure;
import net.mcreator.demonism.procedures.ProUpClassDemonBloodProcedure;
import net.mcreator.demonism.procedures.ProUpClassDemonCrickProcedure;
import net.mcreator.demonism.procedures.ProUpClassDemonShadowProcedure;
import net.mcreator.demonism.procedures.ProUpSkillAtackProcedure;
import net.mcreator.demonism.procedures.ProUpSkillBlazeProcedure;
import net.mcreator.demonism.world.inventory.SkillsGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkillsGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SkillsGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SkillsGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SkillsGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SkillsGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SkillsGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SkillsGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProUpSkillBlazeProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ProUpSkillAtackProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ProUpClassDemonBloodProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ProUpClassDemonShadowProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ProUpClassDemonCrickProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProOpenGUIDemonBloodProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            ProOpenGUIDemonShadowProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            ProOpenGUIDemonCrickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DemonismMod.addNetworkMessage(SkillsGUIButtonMessage.class, SkillsGUIButtonMessage::buffer, SkillsGUIButtonMessage::new, SkillsGUIButtonMessage::handler);
    }
}

