/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.demonism.DemonismMod;
import net.mcreator.demonism.procedures.ProModeBDHProcedure;
import net.mcreator.demonism.procedures.ProModeBlazeProcedure;
import net.mcreator.demonism.procedures.ProModeCDProcedure;
import net.mcreator.demonism.procedures.ProModeDAProcedure;
import net.mcreator.demonism.procedures.ProModeFogProcedure;
import net.mcreator.demonism.procedures.ProModeInvisibleBloodProcedure;
import net.mcreator.demonism.procedures.ProModeNRProcedure;
import net.mcreator.demonism.procedures.ProModePKMProcedure;
import net.mcreator.demonism.procedures.ProModeRageProcedure;
import net.mcreator.demonism.procedures.ProModeSAProcedure;
import net.mcreator.demonism.procedures.ProModeSWProcedure;
import net.mcreator.demonism.procedures.ProModeTProcedure;
import net.mcreator.demonism.procedures.ProModeTSSProcedure;
import net.mcreator.demonism.world.inventory.SkillsModeMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkillsModeButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SkillsModeButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SkillsModeButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SkillsModeButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SkillsModeButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SkillsModeButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SkillsModeMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProModeBlazeProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ProModeRageProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ProModeInvisibleBloodProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ProModeNRProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ProModeSAProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProModeTProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ProModeDAProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            ProModeCDProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            ProModePKMProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            ProModeBDHProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            ProModeTSSProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            ProModeFogProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            ProModeSWProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DemonismMod.addNetworkMessage(SkillsModeButtonMessage.class, SkillsModeButtonMessage::buffer, SkillsModeButtonMessage::new, SkillsModeButtonMessage::handler);
    }
}

