/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.network;

import java.util.function.Supplier;
import net.mcreator.demonism.DemonismMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DemonismModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        DemonismMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Demonism = message.data.Demonism;
                    variables.xp_demon = message.data.xp_demon;
                    variables.level_demon = message.data.level_demon;
                    variables.mana_demon = message.data.mana_demon;
                    variables.point_demon = message.data.point_demon;
                    variables.demon_rage = message.data.demon_rage;
                    variables.ability = message.data.ability;
                    variables.cd_ability = message.data.cd_ability;
                    variables.demonic_blood = message.data.demonic_blood;
                    variables.demonic_blood_2_level = message.data.demonic_blood_2_level;
                    variables.ThebloodftheChaosDemon = message.data.ThebloodftheChaosDemon;
                    variables.FieryTouch = message.data.FieryTouch;
                    variables.demon_rage2 = message.data.demon_rage2;
                    variables.ReleasingPower = message.data.ReleasingPower;
                    variables.Shadow_Celitri = message.data.Shadow_Celitri;
                    variables.Nether_Shagarot = message.data.Nether_Shagarot;
                    variables.Souls_Demon = message.data.Souls_Demon;
                    variables.variants = message.data.variants;
                    variables.NV = message.data.NV;
                    variables.fog = message.data.fog;
                    variables.ShadowEnhancement = message.data.ShadowEnhancement;
                    variables.fog2 = message.data.fog2;
                    variables.teleport = message.data.teleport;
                    variables.DR_Celitri = message.data.DR_Celitri;
                    variables.SS = message.data.SS;
                    variables.ES = message.data.ES;
                    variables.SRK = message.data.SRK;
                    variables.SH = message.data.SH;
                    variables.DS = message.data.DS;
                    variables.time = message.data.time;
                    variables.EDW = message.data.EDW;
                    variables.LifeStop = message.data.LifeStop;
                    variables.Disclosure = message.data.Disclosure;
                    variables.HH = message.data.HH;
                    variables.EnhancedHealth = message.data.EnhancedHealth;
                    variables.PowerNether = message.data.PowerNether;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean Demonism = false;
        public double xp_demon = 0.0;
        public double level_demon = 0.0;
        public double mana_demon = 0.0;
        public double point_demon = 0.0;
        public boolean demon_rage = false;
        public double ability = 0.0;
        public double cd_ability = 0.0;
        public boolean demonic_blood = false;
        public boolean demonic_blood_2_level = false;
        public boolean ThebloodftheChaosDemon = false;
        public boolean FieryTouch = false;
        public boolean demon_rage2 = false;
        public boolean ReleasingPower = false;
        public boolean Shadow_Celitri = false;
        public boolean Nether_Shagarot = false;
        public boolean Souls_Demon = false;
        public boolean variants = false;
        public boolean NV = false;
        public boolean fog = false;
        public boolean ShadowEnhancement = false;
        public boolean fog2 = false;
        public boolean teleport = false;
        public boolean DR_Celitri = false;
        public boolean SS = false;
        public boolean ES = false;
        public boolean SRK = false;
        public boolean SH = false;
        public boolean DS = false;
        public boolean time = false;
        public boolean EDW = false;
        public boolean LifeStop = false;
        public boolean Disclosure = false;
        public boolean HH = false;
        public boolean EnhancedHealth = false;
        public boolean PowerNether = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                DemonismMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("Demonism", this.Demonism);
            nbt.m_128347_("xp_demon", this.xp_demon);
            nbt.m_128347_("level_demon", this.level_demon);
            nbt.m_128347_("mana_demon", this.mana_demon);
            nbt.m_128347_("point_demon", this.point_demon);
            nbt.m_128379_("demon_rage", this.demon_rage);
            nbt.m_128347_("ability", this.ability);
            nbt.m_128347_("cd_ability", this.cd_ability);
            nbt.m_128379_("demonic_blood", this.demonic_blood);
            nbt.m_128379_("demonic_blood_2_level", this.demonic_blood_2_level);
            nbt.m_128379_("ThebloodftheChaosDemon", this.ThebloodftheChaosDemon);
            nbt.m_128379_("FieryTouch", this.FieryTouch);
            nbt.m_128379_("demon_rage2", this.demon_rage2);
            nbt.m_128379_("ReleasingPower", this.ReleasingPower);
            nbt.m_128379_("Shadow_Celitri", this.Shadow_Celitri);
            nbt.m_128379_("Nether_Shagarot", this.Nether_Shagarot);
            nbt.m_128379_("Souls_Demon", this.Souls_Demon);
            nbt.m_128379_("variants", this.variants);
            nbt.m_128379_("NV", this.NV);
            nbt.m_128379_("fog", this.fog);
            nbt.m_128379_("ShadowEnhancement", this.ShadowEnhancement);
            nbt.m_128379_("fog2", this.fog2);
            nbt.m_128379_("teleport", this.teleport);
            nbt.m_128379_("DR_Celitri", this.DR_Celitri);
            nbt.m_128379_("SS", this.SS);
            nbt.m_128379_("ES", this.ES);
            nbt.m_128379_("SRK", this.SRK);
            nbt.m_128379_("SH", this.SH);
            nbt.m_128379_("DS", this.DS);
            nbt.m_128379_("time", this.time);
            nbt.m_128379_("EDW", this.EDW);
            nbt.m_128379_("LifeStop", this.LifeStop);
            nbt.m_128379_("Disclosure", this.Disclosure);
            nbt.m_128379_("HH", this.HH);
            nbt.m_128379_("EnhancedHealth", this.EnhancedHealth);
            nbt.m_128379_("PowerNether", this.PowerNether);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Demonism = nbt.m_128471_("Demonism");
            this.xp_demon = nbt.m_128459_("xp_demon");
            this.level_demon = nbt.m_128459_("level_demon");
            this.mana_demon = nbt.m_128459_("mana_demon");
            this.point_demon = nbt.m_128459_("point_demon");
            this.demon_rage = nbt.m_128471_("demon_rage");
            this.ability = nbt.m_128459_("ability");
            this.cd_ability = nbt.m_128459_("cd_ability");
            this.demonic_blood = nbt.m_128471_("demonic_blood");
            this.demonic_blood_2_level = nbt.m_128471_("demonic_blood_2_level");
            this.ThebloodftheChaosDemon = nbt.m_128471_("ThebloodftheChaosDemon");
            this.FieryTouch = nbt.m_128471_("FieryTouch");
            this.demon_rage2 = nbt.m_128471_("demon_rage2");
            this.ReleasingPower = nbt.m_128471_("ReleasingPower");
            this.Shadow_Celitri = nbt.m_128471_("Shadow_Celitri");
            this.Nether_Shagarot = nbt.m_128471_("Nether_Shagarot");
            this.Souls_Demon = nbt.m_128471_("Souls_Demon");
            this.variants = nbt.m_128471_("variants");
            this.NV = nbt.m_128471_("NV");
            this.fog = nbt.m_128471_("fog");
            this.ShadowEnhancement = nbt.m_128471_("ShadowEnhancement");
            this.fog2 = nbt.m_128471_("fog2");
            this.teleport = nbt.m_128471_("teleport");
            this.DR_Celitri = nbt.m_128471_("DR_Celitri");
            this.SS = nbt.m_128471_("SS");
            this.ES = nbt.m_128471_("ES");
            this.SRK = nbt.m_128471_("SRK");
            this.SH = nbt.m_128471_("SH");
            this.DS = nbt.m_128471_("DS");
            this.time = nbt.m_128471_("time");
            this.EDW = nbt.m_128471_("EDW");
            this.LifeStop = nbt.m_128471_("LifeStop");
            this.Disclosure = nbt.m_128471_("Disclosure");
            this.HH = nbt.m_128471_("HH");
            this.EnhancedHealth = nbt.m_128471_("EnhancedHealth");
            this.PowerNether = nbt.m_128471_("PowerNether");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("demonism", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Demonism = original.Demonism;
            clone.xp_demon = original.xp_demon;
            clone.level_demon = original.level_demon;
            clone.mana_demon = original.mana_demon;
            clone.point_demon = original.point_demon;
            clone.demon_rage = original.demon_rage;
            clone.ability = original.ability;
            clone.cd_ability = original.cd_ability;
            clone.demonic_blood = original.demonic_blood;
            clone.demonic_blood_2_level = original.demonic_blood_2_level;
            clone.ThebloodftheChaosDemon = original.ThebloodftheChaosDemon;
            clone.FieryTouch = original.FieryTouch;
            clone.demon_rage2 = original.demon_rage2;
            clone.ReleasingPower = original.ReleasingPower;
            clone.Shadow_Celitri = original.Shadow_Celitri;
            clone.Nether_Shagarot = original.Nether_Shagarot;
            clone.Souls_Demon = original.Souls_Demon;
            clone.variants = original.variants;
            clone.NV = original.NV;
            clone.fog = original.fog;
            clone.ShadowEnhancement = original.ShadowEnhancement;
            clone.fog2 = original.fog2;
            clone.teleport = original.teleport;
            clone.DR_Celitri = original.DR_Celitri;
            clone.SS = original.SS;
            clone.ES = original.ES;
            clone.SRK = original.SRK;
            clone.SH = original.SH;
            clone.DS = original.DS;
            clone.time = original.time;
            clone.EDW = original.EDW;
            clone.LifeStop = original.LifeStop;
            clone.Disclosure = original.Disclosure;
            clone.HH = original.HH;
            clone.EnhancedHealth = original.EnhancedHealth;
            clone.PowerNether = original.PowerNether;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

