/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.demonism.DemonismMod;
import net.mcreator.demonism.procedures.ProActDemRageProcedure;
import net.mcreator.demonism.procedures.ProActDisclosureProcedure;
import net.mcreator.demonism.procedures.ProActFiaryTouchProcedure;
import net.mcreator.demonism.procedures.ProActFireAuraProcedure;
import net.mcreator.demonism.procedures.ProActFogProcedure;
import net.mcreator.demonism.procedures.ProActHHProcedure;
import net.mcreator.demonism.procedures.ProActNVProcedure;
import net.mcreator.demonism.procedures.ProActSHProcedure;
import net.mcreator.demonism.procedures.ProActSRKProcedure;
import net.mcreator.demonism.procedures.ProActSSProcedure;
import net.mcreator.demonism.procedures.ProActStopLifeProcedure;
import net.mcreator.demonism.procedures.ProActTeleportProcedure;
import net.mcreator.demonism.world.inventory.GUIAbilityDemonMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUIAbilityDemonButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUIAbilityDemonButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUIAbilityDemonButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUIAbilityDemonButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUIAbilityDemonButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUIAbilityDemonButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GUIAbilityDemonMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProActDemRageProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ProActFiaryTouchProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ProActFireAuraProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ProActNVProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ProActFogProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProActTeleportProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ProActSSProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            ProActSRKProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            ProActSHProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            ProActStopLifeProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            ProActDisclosureProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            ProActHHProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DemonismMod.addNetworkMessage(GUIAbilityDemonButtonMessage.class, GUIAbilityDemonButtonMessage::buffer, GUIAbilityDemonButtonMessage::new, GUIAbilityDemonButtonMessage::handler);
    }
}

