/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonism.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.demonism.DemonismMod;
import net.mcreator.demonism.procedures.ProOpenDemonMenuProcedure;
import net.mcreator.demonism.procedures.ProOpenDemonVariantProcedure;
import net.mcreator.demonism.procedures.ProOpenGuideOneProcedure;
import net.mcreator.demonism.procedures.ProSkillsUpAuraFireProcedure;
import net.mcreator.demonism.procedures.ProSkillsUpChaosDemBloodProcedure;
import net.mcreator.demonism.procedures.ProSkillsUpDemBloodLevel2Procedure;
import net.mcreator.demonism.procedures.ProSkillsUpDemBloodProcedure;
import net.mcreator.demonism.procedures.ProSkillsUpDemRage2LeProcedure;
import net.mcreator.demonism.procedures.ProSkillsUpDemRageProcedure;
import net.mcreator.demonism.procedures.ProSkillsUpFieryTouchProcedure;
import net.mcreator.demonism.procedures.ProSkillsUpVariantProcedure;
import net.mcreator.demonism.world.inventory.GUIDemonSkillsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUIDemonSkillsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUIDemonSkillsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUIDemonSkillsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUIDemonSkillsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUIDemonSkillsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUIDemonSkillsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GUIDemonSkillsMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProOpenDemonMenuProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ProSkillsUpDemRageProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ProSkillsUpDemBloodProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ProSkillsUpFieryTouchProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ProSkillsUpDemBloodLevel2Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProSkillsUpChaosDemBloodProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ProOpenGuideOneProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            ProSkillsUpDemRage2LeProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            ProSkillsUpAuraFireProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            ProSkillsUpVariantProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            ProOpenDemonVariantProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DemonismMod.addNetworkMessage(GUIDemonSkillsButtonMessage.class, GUIDemonSkillsButtonMessage::buffer, GUIDemonSkillsButtonMessage::new, GUIDemonSkillsButtonMessage::handler);
    }
}

