/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.render;

import com.ldtteam.domumornamentum.client.render.ModRenderTypes;
import com.ldtteam.domumornamentum.util.ItemStackUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class ModelGhostRenderer {
    private static final ModelGhostRenderer INSTANCE = new ModelGhostRenderer();
    private static final BufferBuilderTransparent BUFFER = new BufferBuilderTransparent();
    private static final float[] DIRECTIONAL_BRIGHTNESS = new float[]{0.5f, 1.0f, 0.7f, 0.7f, 0.6f, 0.6f};

    public static ModelGhostRenderer getInstance() {
        return INSTANCE;
    }

    private ModelGhostRenderer() {
    }

    public void renderGhost(PoseStack poseStack, ItemStack renderStack, Vec3 targetedRenderPos, BlockHitResult blockHitResult, boolean ignoreDepth) {
        boolean renderItemMode;
        List<ModelToRender> models;
        BlockState placementState;
        poseStack.m_85836_();
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(targetedRenderPos.f_82479_ - camera.f_82479_ - 1.25E-4, targetedRenderPos.f_82480_ - camera.f_82480_ + 1.25E-4, targetedRenderPos.f_82481_ - camera.f_82481_ - 1.25E-4);
        poseStack.m_85841_(1.001f, 1.001f, 1.001f);
        Vector4f color = new Vector4f(0.0f, 0.0f, 1.0f, 0.5f);
        BUFFER.setAlphaPercentage(color.w());
        ModelData modelData = null;
        Item item = renderStack.m_41720_();
        if (item instanceof BlockItem) {
            EntityBlock entityBlock;
            BlockEntity blockEntity;
            BlockItem blockItem = (BlockItem)item;
            BlockPlaceContext context = new BlockPlaceContext((Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_), Objects.requireNonNull(ItemStackUtils.getHandWithMateriallyTexturedItemStackFromPlayer((Player)Minecraft.m_91087_().f_91074_)), renderStack, blockHitResult);
            placementState = blockItem.m_40614_().m_5573_(context);
            if (placementState == null) {
                poseStack.m_85849_();
                return;
            }
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(placementState);
            Block block = blockItem.m_40614_();
            if (block instanceof EntityBlock && (blockEntity = (entityBlock = (EntityBlock)block).m_142194_(context.m_8083_(), placementState)) != null) {
                CompoundTag beingPlacedTag = renderStack.m_41783_();
                if (beingPlacedTag == null) {
                    beingPlacedTag = new CompoundTag();
                }
                CompoundTag currentTag = blockEntity.m_187482_();
                CompoundTag currentTagCopy = currentTag.m_6426_();
                currentTag.m_128391_(beingPlacedTag);
                if (!currentTag.equals((Object)currentTagCopy)) {
                    blockEntity.m_142466_(currentTag);
                    blockEntity.m_6596_();
                }
                modelData = blockEntity.getModelData();
                modelData = model.getModelData((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, context.m_8083_(), placementState, modelData);
            }
            if (modelData == null) {
                modelData = ModelData.EMPTY;
            }
            RandomSource randomSource = RandomSource.m_216327_();
            randomSource.m_188584_(42L);
            ChunkRenderTypeSet renderTypeSet = model.getRenderTypes(placementState, randomSource, modelData);
            models = renderTypeSet.asList().stream().map(renderType -> new ModelToRender(model, (RenderType)renderType)).toList();
            renderItemMode = false;
        } else {
            placementState = null;
            BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(renderStack, null, null, 0);
            List renderPasses = model.getRenderPasses(renderStack, true);
            modelData = ModelData.EMPTY;
            models = renderPasses.stream().flatMap(pass -> pass.getRenderTypes(renderStack, true).stream().map(type -> new ModelToRender((BakedModel)pass, (RenderType)type))).toList();
            renderItemMode = true;
        }
        this.renderGhost(placementState, blockHitResult.m_82425_(), poseStack, models, modelData, color, false, renderItemMode);
        poseStack.m_85849_();
    }

    private void renderGhost(BlockState state, BlockPos pos, PoseStack poseStack, List<ModelToRender> models, ModelData modelData, Vector4f color, boolean renderColoredGhost, boolean renderItemMode) {
        RenderType renderType = renderColoredGhost ? ModRenderTypes.GHOST_BLOCK_COLORED_PREVIEW.get() : ModRenderTypes.GHOST_BLOCK_PREVIEW.get();
        BUFFER.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        if (renderColoredGhost) {
            for (ModelToRender model : models) {
                ModelGhostRenderer.renderColoredModelLists(state, model, modelData, poseStack, color);
            }
        } else {
            for (ModelToRender model : models) {
                ModelGhostRenderer.renderFullModelLists(model, modelData, state, pos, poseStack, renderItemMode);
            }
        }
        renderType.m_276775_((BufferBuilder)BUFFER, RenderSystem.getVertexSorting());
    }

    private static Vector3f[] getShadedColors(Vector4f color) {
        return (Vector3f[])Arrays.stream(Direction.values()).map(direction -> {
            float brightness = DIRECTIONAL_BRIGHTNESS[direction.m_122411_()];
            return new Vector3f(color.x() * brightness, color.y() * brightness, color.z() * brightness);
        }).toArray(Vector3f[]::new);
    }

    private static Vector3f[] getNormals(PoseStack.Pose pose) {
        return (Vector3f[])Arrays.stream(Direction.values()).map(direction -> {
            Vec3i faceNormal = direction.m_122436_();
            Vector3f normal = new Vector3f((float)faceNormal.m_123341_(), (float)faceNormal.m_123342_(), (float)faceNormal.m_123343_());
            normal.mul((Matrix3fc)pose.m_252943_());
            return normal;
        }).toArray(Vector3f[]::new);
    }

    private static void renderFullModelLists(ModelToRender pModel, ModelData modelData, BlockState state, BlockPos pos, PoseStack pPoseStack, boolean renderItemMode) {
        RandomSource randomsource = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            if (renderItemMode) {
                Minecraft.m_91087_().m_91291_().m_115162_(pPoseStack, (VertexConsumer)BUFFER, pModel.model().getQuads(state, direction, randomsource, modelData, pModel.renderType()), new ItemStack((ItemLike)state.m_60734_()), 0xF000F0, OverlayTexture.f_118083_);
                continue;
            }
            ModelGhostRenderer.renderBlockTintedQuadList(pPoseStack, pModel.model().getQuads(state, direction, randomsource, modelData, pModel.renderType()), state, pos);
        }
        randomsource.m_188584_(42L);
        if (renderItemMode) {
            Minecraft.m_91087_().m_91291_().m_115162_(pPoseStack, (VertexConsumer)BUFFER, pModel.model().getQuads(state, null, randomsource, modelData, pModel.renderType()), new ItemStack((ItemLike)state.m_60734_()), 0xF000F0, OverlayTexture.f_118083_);
        } else {
            ModelGhostRenderer.renderBlockTintedQuadList(pPoseStack, pModel.model().getQuads(state, null, randomsource, modelData, pModel.renderType()), state, pos);
        }
    }

    private static void renderBlockTintedQuadList(PoseStack pPoseStack, List<BakedQuad> pQuads, BlockState placementState, BlockPos pos) {
        PoseStack.Pose posestack$pose = pPoseStack.m_85850_();
        for (BakedQuad bakedquad : pQuads) {
            int i = -1;
            if (bakedquad.m_111304_()) {
                i = Minecraft.m_91087_().m_91298_().m_92577_(placementState, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, pos, bakedquad.m_111305_());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            BUFFER.putBulkData(posestack$pose, bakedquad, f, f1, f2, 1.0f, 0xF000F0, OverlayTexture.f_118083_, true);
        }
    }

    private static void renderColoredModelLists(BlockState state, ModelToRender model, ModelData modelData, PoseStack poseStack, Vector4f color) {
        RandomSource random = RandomSource.m_216335_((long)42L);
        Vector3f[] normals = ModelGhostRenderer.getNormals(poseStack.m_85850_());
        Vector3f[] shadedColors = ModelGhostRenderer.getShadedColors(color);
        Vector4f pos = new Vector4f();
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            ModelGhostRenderer.renderColoredQuadList(poseStack.m_85850_().m_252922_(), model.model().getQuads(state, direction, random, modelData, model.renderType()), normals, shadedColors, pos);
        }
        random.m_188584_(42L);
        ModelGhostRenderer.renderColoredQuadList(poseStack.m_85850_().m_252922_(), model.model().getQuads(state, null, random, modelData, model.renderType()), normals, shadedColors, pos);
    }

    private static void renderColoredQuadList(Matrix4f pose, List<BakedQuad> quads, Vector3f[] normals, Vector3f[] shadedColors, Vector4f pos) {
        for (BakedQuad quad : quads) {
            ModelGhostRenderer.putColoredBulkData(pose, quad, shadedColors[quad.m_111306_().ordinal()], normals[quad.m_111306_().ordinal()], pos);
        }
    }

    private static void putColoredBulkData(Matrix4f pose, BakedQuad bakedQuad, Vector3f color, Vector3f normal, Vector4f pos) {
        int[] vertices = bakedQuad.m_111303_();
        int vertexCount = vertices.length / DefaultVertexFormat.f_85811_.m_86017_();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int v = 0; v < vertexCount; ++v) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(vertices, v * 8, 8);
                pos.set(bytebuffer.getFloat(0), bytebuffer.getFloat(4), bytebuffer.getFloat(8), 1.0f);
                pos.mul((Matrix4fc)pose);
                BUFFER.m_5483_(pos.x(), pos.y(), pos.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
            }
        }
    }

    private static class BufferBuilderTransparent
    extends BufferBuilder {
        private float alphaPercentage;

        public BufferBuilderTransparent() {
            super(0x200000);
        }

        public void setAlphaPercentage(float alphaPercentage) {
            this.alphaPercentage = Mth.m_14036_((float)alphaPercentage, (float)0.0f, (float)1.0f);
        }

        @NotNull
        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            return super.m_6122_(red, green, blue, (int)((float)alpha * this.alphaPercentage));
        }

        public void m_5954_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
            super.m_5954_(x, y, z, red, green, blue, alpha * this.alphaPercentage, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }

    private record ModelToRender(BakedModel model, RenderType renderType) {
    }
}

