/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.compat.jade.provider;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ITooltip;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.ui.BoxElement;
import snownee.jade.impl.ui.FluidStackElement;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.impl.ui.ProgressArrowElement;
import snownee.jade.impl.ui.ProgressElement;
import snownee.jade.impl.ui.ProgressStyle;
import snownee.jade.impl.ui.SpacerElement;
import snownee.jade.impl.ui.TextElement;

public class JadeHelper {
    public static final IElement ITEM_PLACEHOLDER = ItemStackElement.of((ItemStack)Items.f_41852_.m_7968_());
    private static final IElement _ARROW = new ProgressArrowElement(1.0f);
    public static final IElement ARROW_PLACEHOLDER = new SpacerElement(_ARROW.getSize());

    public static float getRowHeight(List<IElement> row) {
        float rowHeight = 0.0f;
        for (IElement grid : row) {
            rowHeight = Math.max(rowHeight, grid.getCachedSize().f_82471_);
        }
        return rowHeight;
    }

    public static float[] getHeightsByRow(List<List<IElement>> grids) {
        float[] heights = new float[grids.size()];
        int i = 0;
        for (List<IElement> row : grids) {
            float rowHeight;
            heights[i] = rowHeight = JadeHelper.getRowHeight(row);
            ++i;
        }
        return heights;
    }

    public static float getTotalHeight(List<List<IElement>> grids) {
        float[] heights = JadeHelper.getHeightsByRow(grids);
        float totalHeight = 0.0f;
        for (float height : heights) {
            totalHeight += height;
        }
        return totalHeight;
    }

    public static IElement createCenteredItem(IElementHelper helper, ItemStack stack, float scale, float rowHeight) {
        Vec2 standardSize = new Vec2(rowHeight, rowHeight);
        IElement ret = helper.item(stack, scale).size(standardSize);
        ret.translate(standardSize.m_165910_(ret.getSize().m_165913_()).m_165903_(0.5f));
        return ret;
    }

    public static IElement createSpacerItem(IElementHelper helper) {
        return helper.item(Items.f_41852_.m_7968_());
    }

    public static IElement createSpacerItem() {
        return ItemStackElement.of((ItemStack)Items.f_41852_.m_7968_());
    }

    public static List<List<IElement>> createRows(int height) {
        ArrayList<List<IElement>> grids = new ArrayList<List<IElement>>();
        for (int i = 0; i < height; ++i) {
            grids.add(new ArrayList());
        }
        return grids;
    }

    public static IElement[][] layoutItems(List<IElement> itemElements, int itemCount) {
        int maxRow = (int)Math.round(Math.sqrt(itemCount));
        int maxCol = (itemCount - 1) / maxRow + 1;
        int gridsCount = maxRow * maxCol;
        IElement[][] grids = new IElement[maxRow][maxCol];
        for (int i = 0; i < gridsCount; ++i) {
            int row = i / maxCol;
            int col = i % maxCol;
            grids[row][col] = i < itemCount ? itemElements.remove(0) : ITEM_PLACEHOLDER;
        }
        return grids;
    }

    public static ElementGroup placeItems(List<List<IElement>> grids, IElement[][] items, boolean placeHolder) {
        int gridsRows = grids.size();
        int itemsRows = items.length;
        if (itemsRows == 0) {
            return new ElementGroup();
        }
        int itemsCols = items[0].length;
        if (itemsCols == 0) {
            return new ElementGroup();
        }
        float rowHeight = JadeHelper.getRowHeight(List.of(items[0]));
        return JadeHelper.placeItems(grids, items, gridsRows, itemsRows, itemsCols, rowHeight, placeHolder);
    }

    public static ElementGroup placeItems(List<List<IElement>> grids, IElement[][] items, int gridRows, int itemRows, int itemCols, float rowHeight, boolean placeHolder) {
        ElementGroup helper = new ElementGroup();
        float delta = rowHeight * (float)(gridRows - itemRows) / 2.0f;
        IElement placeholder = JadeHelper.createSpacerItem(helper);
        block0: for (int i = 0; i < gridRows; ++i) {
            List<IElement> row = grids.get(i);
            for (int j = 0; j < itemCols; ++j) {
                if (i < itemRows) {
                    row.add(helper.track(items[i][j].translate(new Vec2(0.0f, delta))));
                    continue;
                }
                if (!placeHolder) continue block0;
                row.add(helper.track(placeholder));
            }
        }
        return helper;
    }

    public static ElementGroup placeScaledItem(IElementHelper iHelper, List<List<IElement>> grids, ItemStack stack, float scale) {
        float oneGridItemRetio;
        ElementGroup helper = new ElementGroup(iHelper);
        int tileCount = grids.size();
        if (tileCount == 1) {
            grids.get(0).add(helper.item(stack, scale));
        }
        float translateEff = oneGridItemRetio = 1.0f / (float)tileCount;
        if (scale < oneGridItemRetio) {
            return helper;
        }
        ItemStack iconItem = stack.m_41777_();
        iconItem.m_41764_(1);
        float totalHeight = JadeHelper.getTotalHeight(grids);
        IElement sample = helper.item(stack);
        float baseScale = totalHeight / sample.getSize().f_82471_;
        float iconScale = baseScale * scale;
        float tileWidth = totalHeight / (float)tileCount;
        Vec2 tileSize = new Vec2(tileWidth, 0.0f);
        IElement icon = JadeHelper.createCenteredItem(helper, iconItem, iconScale, totalHeight).size(tileSize);
        IElement spacer = helper.spacer(0, 0).size(tileSize);
        IElement text = helper.item(stack, 0.01f).size(tileSize).translate(new Vec2(totalHeight, totalHeight).m_165903_((oneGridItemRetio - 1.0f + (scale - oneGridItemRetio) * translateEff) / 2.0f));
        for (int i = 0; i < tileCount; ++i) {
            List<IElement> row = grids.get(i);
            for (int j = 0; j < tileCount; ++j) {
                if (i + j == 0) {
                    row.add(icon);
                    continue;
                }
                if (i == tileCount - 1 && j == tileCount - 1) {
                    row.add(text);
                    continue;
                }
                row.add(spacer);
            }
        }
        return helper;
    }

    public static ElementGroup placeArrow(List<List<IElement>> grids) {
        return JadeHelper.placeArrowProgress(grids, 1.0f);
    }

    public static ElementGroup placeArrowProgress(List<List<IElement>> grids, float progress) {
        ElementGroup helper = new ElementGroup();
        int maxRow = grids.size();
        if (maxRow == 0) {
            return helper;
        }
        int arrowRow = (maxRow + 1) / 2 - 1;
        IElement arrow = helper.progressArrow(progress);
        if (maxRow % 2 == 0) {
            float delta = -arrow.getCachedSize().f_82471_ / 2.0f + JadeHelper.getTotalHeight(grids) / 2.0f;
            arrow.translate(new Vec2(0.0f, delta));
        }
        for (int i = 0; i < maxRow; ++i) {
            if (i == arrowRow) {
                grids.get(i).add(arrow);
                continue;
            }
            grids.get(i).add(helper.spacer(arrow.getSize()));
        }
        return helper;
    }

    public static void addGridsToTooltip(ITooltip tooltip, List<List<IElement>> grids) {
        for (List<IElement> row : grids) {
            tooltip.add(row);
        }
    }

    public static IElement translateDelta(IElement element, float x, float y) {
        return JadeHelper.translateDelta(element, new Vec2(x, y));
    }

    public static IElement translateDelta(IElement element, Vec2 delta) {
        return element.translate(element.getTranslation().m_165910_(delta));
    }

    public static class ElementGroup
    implements IElementHelper {
        private final IElementHelper helper;
        public Set<IElement> elements = new HashSet<IElement>();

        ElementGroup() {
            this(null);
        }

        ElementGroup(IElementHelper helper) {
            this.helper = helper;
        }

        public IElement track(IElement element) {
            this.elements.add(element);
            return element;
        }

        public ElementGroup translateDelta(float x, float y) {
            return this.translateDelta(new Vec2(x, y));
        }

        public ElementGroup translateDelta(Vec2 delta) {
            for (IElement element : this.elements) {
                JadeHelper.translateDelta(element, delta);
            }
            return this;
        }

        public IElement text(Component component) {
            Object ret = this.helper != null ? this.helper.text(component) : new TextElement(component);
            return this.track((IElement)ret);
        }

        public IElement spacer(int i, int i1) {
            Object ret = this.helper != null ? this.helper.spacer(i, i1) : new SpacerElement(new Vec2((float)i, (float)i1));
            return this.track((IElement)ret);
        }

        public IElement spacer(Vec2 vec) {
            SpacerElement ret = new SpacerElement(vec);
            return this.track((IElement)ret);
        }

        public IElement item(ItemStack itemStack) {
            Object ret = this.helper != null ? this.helper.item(itemStack) : ItemStackElement.of((ItemStack)itemStack);
            return this.track((IElement)ret);
        }

        public IElement item(ItemStack itemStack, float v) {
            Object ret = this.helper != null ? this.helper.item(itemStack, v) : ItemStackElement.of((ItemStack)itemStack, (float)v);
            return this.track((IElement)ret);
        }

        public IElement item(ItemStack itemStack, float v, @Nullable String s) {
            Object ret = this.helper != null ? this.helper.item(itemStack, v, s) : ItemStackElement.of((ItemStack)itemStack, (float)v, (String)s);
            return this.track((IElement)ret);
        }

        public IElement smallItem(ItemStack itemStack) {
            return null;
        }

        public IElement fluid(JadeFluidObject jadeFluidObject) {
            Object ret = this.helper != null ? this.helper.fluid(jadeFluidObject) : new FluidStackElement(jadeFluidObject);
            return this.track((IElement)ret);
        }

        public IElement progress(float v, @Nullable Component component, IProgressStyle iProgressStyle, IBoxStyle iBoxStyle, boolean b) {
            Object ret = this.helper != null ? this.helper.progress(v, component, iProgressStyle, iBoxStyle, b) : new ProgressElement(v, component, iProgressStyle, iBoxStyle, b);
            return this.track((IElement)ret);
        }

        public IBoxElement box(ITooltip iTooltip, IBoxStyle iBoxStyle) {
            Object ret = this.helper != null ? this.helper.box(iTooltip, iBoxStyle) : new BoxElement((Tooltip)iTooltip, iBoxStyle);
            return (IBoxElement)this.track((IElement)ret);
        }

        public ITooltip tooltip() {
            if (this.helper != null) {
                return this.helper.tooltip();
            }
            return null;
        }

        public IProgressStyle progressStyle() {
            if (this.helper != null) {
                return this.helper.progressStyle();
            }
            return new ProgressStyle();
        }

        public IElement progressArrow(float progress) {
            return this.track((IElement)new ProgressArrowElement(progress));
        }
    }
}

