/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.effects;

import java.awt.Color;
import lekavar.lma.drinkbeer.registries.MobEffectRegistry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class DrunkStatusEffect
extends MobEffect {
    public static final int MAX_DRUNK_AMPLIFIER = 4;
    public static final int MIN_DRUNK_AMPLIFIER = 0;
    private static final int BASE_DURATION = 1200;
    private static final boolean visible = false;
    private static final int[] drunkDurations = new int[]{3600, 3000, 2400, 1800, 1200};
    private static final int[] nauseaDurations = new int[]{160, 160, 200, 300, 600};
    private static final int[] slownessDurations = new int[]{0, 80, 160, 200, 600};
    private static final int[] harmulStatusEffectsIntervals = new int[]{200, 160, 200, 300, 20};

    public DrunkStatusEffect() {
        super(MobEffectCategory.HARMFUL, new Color(255, 222, 173, 255).getRGB());
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public static void addStatusEffect(LivingEntity user, int value) {
        if (value == 0) {
            return;
        }
        MobEffectInstance statusEffectInstance = user.m_21124_((MobEffect)MobEffectRegistry.DRUNK.get());
        int currentDrunkAmplifier = statusEffectInstance == null ? -1 : statusEffectInstance.m_19564_();
        int newDrunkAmplifier = currentDrunkAmplifier + value;
        newDrunkAmplifier = Math.min(newDrunkAmplifier, 4);
        if (currentDrunkAmplifier < 0 && newDrunkAmplifier < 0) {
            return;
        }
        if (currentDrunkAmplifier >= 0 && newDrunkAmplifier < 0) {
            user.m_21195_((MobEffect)MobEffectRegistry.DRUNK.get());
        } else if (currentDrunkAmplifier < 0) {
            user.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.DRUNK.get(), DrunkStatusEffect.getDrunkDuratioin(newDrunkAmplifier), newDrunkAmplifier));
        } else if (newDrunkAmplifier > currentDrunkAmplifier) {
            user.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.DRUNK.get(), DrunkStatusEffect.getDrunkDuratioin(newDrunkAmplifier), newDrunkAmplifier));
        } else if (newDrunkAmplifier < currentDrunkAmplifier) {
            for (int tempDrunkAmplifier = currentDrunkAmplifier - newDrunkAmplifier; tempDrunkAmplifier > 0; --tempDrunkAmplifier) {
                DrunkStatusEffect.decreaseDrunkStatusEffefct(user, currentDrunkAmplifier);
                --currentDrunkAmplifier;
            }
        }
    }

    public static void addStatusEffect(LivingEntity user) {
        DrunkStatusEffect.addStatusEffect(user, 1);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        int time = entity.m_21124_((MobEffect)MobEffectRegistry.DRUNK.get()).m_19557_();
        this.giveHarmfulStatusEffects(entity, amplifier, time);
        if (time == 1) {
            DrunkStatusEffect.decreaseDrunkStatusEffefct(entity, amplifier);
        }
    }

    private void giveHarmfulStatusEffects(LivingEntity entity, int amplifier, int time) {
        if (amplifier >= 4) {
            int duration = entity.m_21124_((MobEffect)MobEffectRegistry.DRUNK.get()).m_19557_();
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, duration, 0, false, false));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 3, false, false));
        } else if (time % harmulStatusEffectsIntervals[amplifier] == 0) {
            int nauseaDuration = nauseaDurations[amplifier];
            int slownessDuration = slownessDurations[amplifier];
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, nauseaDuration, 0, false, false));
            if (amplifier > 0) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slownessDuration, amplifier - 1, false, false));
            }
        }
    }

    private static void decreaseDrunkStatusEffefct(LivingEntity entity, int amplifier) {
        if (!entity.m_9236_().m_5776_()) {
            entity.m_21195_((MobEffect)MobEffectRegistry.DRUNK.get());
            MobEffectInstance nextDrunkStatusEffect = DrunkStatusEffect.getDecreasedDrunkStatusEffect(amplifier);
            if (nextDrunkStatusEffect != null) {
                entity.m_7292_(nextDrunkStatusEffect);
            }
        }
    }

    private static MobEffectInstance getDecreasedDrunkStatusEffect(int currentAmplifier) {
        int nextDrunkAmplifier = currentAmplifier - 1;
        if (nextDrunkAmplifier < 0) {
            return null;
        }
        return new MobEffectInstance((MobEffect)MobEffectRegistry.DRUNK.get(), DrunkStatusEffect.getDrunkDuratioin(nextDrunkAmplifier), nextDrunkAmplifier);
    }

    public static int getNextDrunkAmplifier(LivingEntity user) {
        MobEffectInstance statusEffectInstance = user.m_21124_((MobEffect)MobEffectRegistry.DRUNK.get());
        int drunkAmplifier = statusEffectInstance == null ? -1 : statusEffectInstance.m_19564_();
        return drunkAmplifier < 4 ? drunkAmplifier + 1 : drunkAmplifier;
    }

    public static int getDrunkDuratioin(int amplifier) {
        try {
            return drunkDurations[amplifier];
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Amplifier is out of range");
            return 1200;
        }
    }
}

