/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import lekavar.lma.drinkbeer.blockentities.TradeBoxBlockEntity;
import lekavar.lma.drinkbeer.managers.TradeBoxManager;
import lekavar.lma.drinkbeer.registries.BlockRegistry;
import lekavar.lma.drinkbeer.registries.MenuTypeRegistry;
import lekavar.lma.drinkbeer.registries.SoundEventRegistry;
import lekavar.lma.drinkbeer.utils.tradebox.Good;
import lekavar.lma.drinkbeer.utils.tradebox.Locations;
import lekavar.lma.drinkbeer.utils.tradebox.Residents;
import lekavar.lma.drinkbeer.utils.tradebox.TradeMission;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TradeBoxMenu
extends AbstractContainerMenu {
    private final Container tradeboxInventory;
    private final List<Slot> tradeboxSlots;
    private final List<Slot> goodSlots;
    private final ContainerData syncData;
    private Runnable inventoryChangeListener;
    public Player player;
    private BlockPos pos;

    public TradeBoxMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, data.m_130135_());
    }

    public TradeBoxMenu(int id, Inventory playerInventory, BlockPos pos) {
        this(id, (Container)((TradeBoxBlockEntity)Minecraft.m_91087_().f_91073_.m_7702_(pos)), ((TradeBoxBlockEntity)Minecraft.m_91087_().f_91073_.m_7702_((BlockPos)pos)).syncData, playerInventory, (TradeBoxBlockEntity)Minecraft.m_91087_().f_91073_.m_7702_(pos));
    }

    public TradeBoxMenu(int id, Container goodInventory, ContainerData syncData, Inventory playerInventory, TradeBoxBlockEntity tradeBoxBlockEntity) {
        super((MenuType)MenuTypeRegistry.tradeBoxContainer.get(), id);
        this.syncData = syncData;
        this.pos = tradeBoxBlockEntity.m_58899_();
        this.m_38884_(syncData);
        this.inventoryChangeListener = () -> {};
        this.player = playerInventory.f_35978_;
        this.tradeboxSlots = new ArrayList<Slot>();
        this.goodSlots = new ArrayList<Slot>();
        this.tradeboxInventory = new SimpleContainer(4){

            public void m_6596_() {
                super.m_6596_();
                TradeBoxMenu.this.m_6199_((Container)this);
                TradeBoxMenu.this.inventoryChangeListener.run();
            }
        };
        if (goodInventory.m_6643_() < 8) {
            throw new IllegalArgumentException("Container size " + goodInventory.m_6643_() + " is smaller than expected 8");
        }
        AtomicInteger num = new AtomicInteger();
        IntStream.range(0, 2).forEach(i -> IntStream.range(0, 2).forEach(j -> {
            this.tradeboxSlots.add(this.m_38897_(new InputSlot(this.tradeboxInventory, num.get(), 25 + i * 18, 26 + j * 18)));
            num.getAndIncrement();
        }));
        num.set(0);
        IntStream.range(0, 2).forEach(j -> IntStream.range(0, 4).forEach(i -> {
            this.goodSlots.add(this.m_38897_(new OutputSlot(goodInventory, num.get(), 85 + i * 18, 26 + j * 18, syncData, this)));
            num.getAndIncrement();
        }));
        this.layoutPlayerInventorySlots(8, 84, (IItemHandler)new InvWrapper((Container)playerInventory));
        if (this.isTrading() && !this.hasLegalTradeMission()) {
            this.setTradeboxTrading();
        }
        this.m_38884_(syncData);
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow, IItemHandler playerInventory) {
        this.addSlotBox(playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public int getCoolingTime() {
        return this.syncData.m_6413_(0);
    }

    public int getProcess() {
        return this.syncData.m_6413_(3);
    }

    public void setInventoryChangeListener(Runnable inventoryChangeListener) {
        this.inventoryChangeListener = inventoryChangeListener;
    }

    public void m_6199_(Container inventory) {
        this.checkTradeMission();
        this.m_38946_();
    }

    public void checkTradeMission() {
        Map<Item, Integer> neededGoodMap;
        if (!this.isTrading()) {
            return;
        }
        Map<Item, Integer> inputGoodMap = this.goodSlotListToGoodMap(this.tradeboxSlots);
        if (!TradeBoxManager.test(inputGoodMap, neededGoodMap = this.goodSlotListToGoodMap(this.getToLocationGoodSlots()))) {
            return;
        }
        this.setProcess(0);
        this.consumeInputGood(neededGoodMap);
        this.m_150411_(this.player, this.tradeboxInventory);
        int goodNum = 0;
        for (Slot slot : this.getFromLocationGoodSlots()) {
            if (!slot.m_6657_()) continue;
            this.tradeboxSlots.get(goodNum).m_5852_(slot.m_7993_());
            ++goodNum;
        }
        this.setTradeboxCooling();
    }

    public void consumeInputGood(Map<Item, Integer> targetGoodMap) {
        block0: for (Map.Entry<Item, Integer> targetGood : targetGoodMap.entrySet()) {
            int currentNum = 0;
            int requiredNum = targetGood.getValue();
            for (Slot slot : this.tradeboxSlots) {
                if (targetGood.getKey().equals(slot.m_7993_().m_41720_())) {
                    ItemStack itemStack = slot.m_7993_();
                    if (itemStack.m_41613_() >= targetGood.getValue()) {
                        currentNum = requiredNum;
                        slot.m_6201_(requiredNum);
                    } else {
                        currentNum += itemStack.m_41613_();
                        slot.m_6201_(itemStack.m_41613_());
                    }
                }
                if (currentNum != requiredNum) continue;
                continue block0;
            }
        }
    }

    public boolean isCooling() {
        return this.getProcess() == 0;
    }

    public boolean isTrading() {
        return this.getProcess() == 1;
    }

    public void setProcess(int process) {
        this.syncData.m_8050_(3, process);
    }

    public void setCoolingTime(int coolingTime) {
        this.syncData.m_8050_(0, coolingTime);
    }

    public void setLocationId(int locationId) {
        this.syncData.m_8050_(1, locationId);
    }

    public void setResidentId(int residentId) {
        this.syncData.m_8050_(2, residentId);
    }

    public int getLocationId() {
        return this.syncData.m_6413_(1);
    }

    public int getResidentId() {
        return this.syncData.m_6413_(2);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().m_5776_()) {
            this.m_150411_(player, this.tradeboxInventory);
        } else {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundEventRegistry.TRADEBOX_CLOSE.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        }
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (invSlot < this.tradeboxSlots.size() ? !this.m_38903_(originalStack, this.tradeboxSlots.size(), this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, this.tradeboxSlots.size(), false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    public void setTradeMission(TradeMission tradeMission) {
        this.setLocationId(tradeMission.getLocationId());
        this.setResidentId(tradeMission.getResidentId());
        if (!tradeMission.getGoodToLocationList().isEmpty()) {
            IntStream.range(0, tradeMission.getGoodToLocationList().size()).forEach(i -> {
                Good good = tradeMission.getGoodToLocationList().get(i);
                ItemStack goodItemStack = new ItemStack((ItemLike)good.getGoodItem(), good.getCount());
                this.goodSlots.get(i).m_5852_(goodItemStack);
            });
        }
        if (!tradeMission.getGoodFromLocationList().isEmpty()) {
            IntStream.range(0, tradeMission.getGoodFromLocationList().size()).forEach(i -> {
                Good good = tradeMission.getGoodFromLocationList().get(i);
                ItemStack goodItemStack = new ItemStack((ItemLike)good.getGoodItem(), good.getCount());
                this.goodSlots.get(4 + i).m_5852_(goodItemStack);
            });
        }
    }

    public void setTradeboxCooling() {
        this.setProcess(0);
        this.setCoolingTime(4800);
        this.setLocationId(Locations.EMPTY_LOCATION.getId());
        this.setResidentId(Residents.EMPTY_RESIDENT.getId());
        this.clearGoodInventory();
    }

    public void setTradeboxTrading() {
        TradeMission tradeMission = new TradeMission();
        try {
            Block block = this.player.m_9236_().m_8055_(this.pos).m_60734_();
            if (block.equals(BlockRegistry.TRADE_BOX.get())) {
                tradeMission = TradeMission.genRandomTradeMission();
            }
        }
        catch (Exception e) {
            tradeMission = TradeMission.genRandomTradeMission();
        }
        this.setTradeMission(tradeMission);
        this.setProcess(1);
    }

    public List<Slot> getToLocationGoodSlots() {
        return this.goodSlots.subList(0, 4);
    }

    public List<Slot> getFromLocationGoodSlots() {
        return this.goodSlots.subList(4, 8);
    }

    public boolean hasLegalTradeMission() {
        if (Math.max(this.getLocationId(), Locations.EMPTY_LOCATION.getId()) != Math.min(this.getLocationId(), Locations.size())) {
            return false;
        }
        if (Math.max(this.getResidentId(), Residents.EMPTY_RESIDENT.getId()) != Math.min(this.getResidentId(), Residents.size())) {
            return false;
        }
        if (this.getToLocationGoodSlots().stream().noneMatch(Slot::m_6657_)) {
            return false;
        }
        return this.getFromLocationGoodSlots().stream().anyMatch(Slot::m_6657_);
    }

    private void clearGoodInventory() {
        this.goodSlots.forEach(slot -> slot.m_5852_(ItemStack.f_41583_));
    }

    private Map<Item, Integer> goodSlotListToGoodMap(List<Slot> goodSlots) {
        HashMap<Item, Integer> goodMap = new HashMap<Item, Integer>();
        IntStream.range(0, 4).forEach(i -> {
            if (!((Slot)goodSlots.get(i)).m_6657_()) {
                return;
            }
            ItemStack inputTradeboxSlotsItemStack = ((Slot)goodSlots.get(i)).m_7993_();
            Item inputTradeboxSlotsItem = inputTradeboxSlotsItemStack.m_41720_();
            if (goodMap.containsKey(inputTradeboxSlotsItem)) {
                goodMap.replace(inputTradeboxSlotsItem, (Integer)goodMap.get(inputTradeboxSlotsItem) + inputTradeboxSlotsItemStack.m_41613_());
            } else {
                goodMap.put(inputTradeboxSlotsItem, inputTradeboxSlotsItemStack.m_41613_());
            }
        });
        return goodMap;
    }

    static class OutputSlot
    extends Slot {
        private final ContainerData syncData;
        private final TradeBoxMenu tradeBoxMenu;

        public OutputSlot(Container p_i1824_1_, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_, ContainerData syncData, TradeBoxMenu tradeBoxMenu) {
            super(p_i1824_1_, p_i1824_2_, p_i1824_3_, p_i1824_4_);
            this.syncData = syncData;
            this.tradeBoxMenu = tradeBoxMenu;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player playerEntity) {
            return false;
        }

        public boolean m_6659_() {
            return !this.tradeBoxMenu.isCooling();
        }
    }

    static class InputSlot
    extends Slot {
        public InputSlot(Container p_i1824_1_, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_) {
            super(p_i1824_1_, p_i1824_2_, p_i1824_3_, p_i1824_4_);
        }

        public boolean m_5857_(ItemStack p_75214_1_) {
            return true;
        }
    }
}

