/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.utils.tradebox;

import lekavar.lma.drinkbeer.utils.tradebox.Locations;
import lekavar.lma.drinkbeer.utils.tradebox.Residents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class Good {
    private Item goodItem = Items.f_41852_;
    private Locations location = Locations.EMPTY_LOCATION;
    private Residents resident = Residents.EMPTY_RESIDENT;
    private int fromOrToLocation = 1;
    private int count = 1;
    private int minCount = 1;
    private int maxCount = 1;
    private int rarity = 1;
    public static final int EMPTY_FROM_OR_TO = 0;
    public static final int FROM = 1;
    public static final int TO = 2;
    private static final int MIN_COUNT = 1;

    public Good set(Block goodBlock, @NotNull Locations location, int fromOrToLocation, Residents resident, int minCount, int maxCount, int rarity) {
        return this.set(goodBlock.m_5456_(), location, fromOrToLocation, resident, minCount, maxCount, rarity);
    }

    public Good set(Item goodItem, @NotNull Locations location, int fromOrToLocation, Residents resident, int minCount, int maxCount, int rarity) {
        return this.setGoodItem(goodItem).setTradeLocation(location, fromOrToLocation).setResident(resident).setCountRange(minCount, maxCount).setRarity(rarity);
    }

    public Good setGoodItem(Item goodItem) {
        this.goodItem = goodItem;
        return this;
    }

    public Good setGoodItem(Block goodBlock) {
        return this.setGoodItem(goodBlock.m_5456_());
    }

    public Good setTradeLocation(@NotNull Locations location, int fromOrToLocation) {
        this.location = location;
        this.fromOrToLocation = fromOrToLocation;
        return this;
    }

    public Good setResident(@NotNull Residents resident) {
        this.resident = resident;
        return this;
    }

    public Good setCountRange(int minCount, int maxCount) {
        this.minCount = Math.max(minCount, 1);
        this.maxCount = maxCount;
        return this;
    }

    public Good setRarity(int rarity) {
        this.rarity = Math.min(Math.max(rarity, 1), 4);
        return this;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public Item getGoodItem() {
        return this.goodItem;
    }

    public Locations getLocation() {
        return this.location;
    }

    public Residents getResident() {
        return this.resident;
    }

    public int getFromOrToLocation() {
        return this.fromOrToLocation;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getRarity() {
        return this.rarity;
    }

    public Good copy(Good good) {
        this.set(good.getGoodItem(), good.getLocation(), good.getFromOrToLocation(), good.getResident(), good.getMinCount(), good.getMaxCount(), good.getRarity());
        this.setCount(good.getCount());
        return this;
    }
}

