/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.IdMapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.RegistryManager;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.SynchedAnimationVariableKeys;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.PacketBufferCodec;
import yesman.epicfight.api.utils.datastruct.ClearableIdMapper;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPAnimationVariablePacket;
import yesman.epicfight.network.common.AnimationVariablePacket;
import yesman.epicfight.network.server.SPAnimationVariablePacket;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public interface SynchedAnimationVariableKey<T> {
    public static final ResourceLocation BY_ID_REGISTRY = EpicFightMod.identifier("variablekeytoid");

    public static <T> SynchedSharedAnimationVariableKey<T> shared(Function<Animator, T> defaultValueSupplier, boolean mutable, PacketBufferCodec<T> codec) {
        return new SynchedSharedAnimationVariableKey<T>(defaultValueSupplier, mutable, codec);
    }

    public static <T> SynchedIndependentAnimationVariableKey<T> independent(Function<Animator, T> defaultValueSupplier, boolean mutable, PacketBufferCodec<T> codec) {
        return new SynchedIndependentAnimationVariableKey<T>(defaultValueSupplier, mutable, codec);
    }

    public static SynchedAnimationVariableKeyCallbacks getRegistryCallback() {
        return SynchedAnimationVariableKeyCallbacks.INSTANCE;
    }

    public static IdMapper<SynchedAnimationVariableKey<?>> getIdMap() {
        return (IdMapper)SynchedAnimationVariableKeys.REGISTRY.get().getSlaveMap(BY_ID_REGISTRY, IdMapper.class);
    }

    public static <T> SynchedAnimationVariableKey<T> byId(int id) {
        return (SynchedAnimationVariableKey)SynchedAnimationVariableKey.getIdMap().m_7942_(id);
    }

    public PacketBufferCodec<T> getPacketBufferCodec();

    public boolean isSharedKey();

    default public int getId() {
        return SynchedAnimationVariableKey.getIdMap().m_7447_((Object)this);
    }

    default public void sync(LivingEntityPatch<?> entitypatch, @Nullable AssetAccessor<? extends StaticAnimation> animation, T value, AnimationVariablePacket.Action action) {
        if (entitypatch.isLogicalClient()) {
            EpicFightNetworkManager.sendToServer(new CPAnimationVariablePacket<T>(this, animation, value, action));
        } else {
            entitypatch.sendToAllPlayersTrackingMe(new SPAnimationVariablePacket<T>(entitypatch, this, animation, value, action));
        }
    }

    public static class SynchedSharedAnimationVariableKey<T>
    extends AnimationVariables.SharedAnimationVariableKey<T>
    implements SynchedAnimationVariableKey<T> {
        private final PacketBufferCodec<T> packetBufferCodec;

        protected SynchedSharedAnimationVariableKey(Function<Animator, T> defaultValueSupplier, boolean mutable, PacketBufferCodec<T> packetBufferCodec) {
            super(defaultValueSupplier, mutable);
            this.packetBufferCodec = packetBufferCodec;
        }

        @Override
        public boolean isSynched() {
            return true;
        }

        @Override
        public PacketBufferCodec<T> getPacketBufferCodec() {
            return this.packetBufferCodec;
        }
    }

    public static class SynchedIndependentAnimationVariableKey<T>
    extends AnimationVariables.IndependentAnimationVariableKey<T>
    implements SynchedAnimationVariableKey<T> {
        private final PacketBufferCodec<T> packetBufferCodec;

        protected SynchedIndependentAnimationVariableKey(Function<Animator, T> defaultValueSupplier, boolean mutable, PacketBufferCodec<T> packetBufferCodec) {
            super(defaultValueSupplier, mutable);
            this.packetBufferCodec = packetBufferCodec;
        }

        @Override
        public boolean isSharedKey() {
            return false;
        }

        @Override
        public PacketBufferCodec<T> getPacketBufferCodec() {
            return this.packetBufferCodec;
        }
    }

    public static class SynchedAnimationVariableKeyCallbacks
    implements IForgeRegistry.BakeCallback<SynchedAnimationVariableKey<?>>,
    IForgeRegistry.CreateCallback<SynchedAnimationVariableKey<?>>,
    IForgeRegistry.ClearCallback<SynchedAnimationVariableKey<?>> {
        private static final SynchedAnimationVariableKeyCallbacks INSTANCE = new SynchedAnimationVariableKeyCallbacks();

        public void onBake(IForgeRegistryInternal<SynchedAnimationVariableKey<?>> owner, RegistryManager stage) {
            ClearableIdMapper synchedanimationvariablekeybyid = (ClearableIdMapper)((Object)owner.getSlaveMap(BY_ID_REGISTRY, ClearableIdMapper.class));
            owner.forEach(arg_0 -> ((ClearableIdMapper)synchedanimationvariablekeybyid).m_122667_(arg_0));
        }

        public void onCreate(IForgeRegistryInternal<SynchedAnimationVariableKey<?>> owner, RegistryManager stage) {
            owner.setSlaveMap(BY_ID_REGISTRY, new ClearableIdMapper(owner.getKeys().size()));
        }

        public void onClear(IForgeRegistryInternal<SynchedAnimationVariableKey<?>> owner, RegistryManager stage) {
            ((ClearableIdMapper)((Object)owner.getSlaveMap(BY_ID_REGISTRY, ClearableIdMapper.class))).clear();
        }
    }
}

