/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.procedural;

import java.util.List;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.physics.ik.InverseKinematicsSimulatable;
import yesman.epicfight.api.physics.ik.InverseKinematicsSimulator;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class EnderDragonWalkAnimation
extends StaticAnimation {
    public EnderDragonWalkAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends EnderDragonWalkAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(convertTime, true, accessor, armature);
    }

    @Override
    public void putOnPlayer(AnimationPlayer animationPlayer, LivingEntityPatch<?> entitypatch) {
        super.putOnPlayer(animationPlayer, entitypatch);
        if (entitypatch instanceof InverseKinematicsSimulatable) {
            InverseKinematicsSimulatable ikSimulatable = (InverseKinematicsSimulatable)((Object)entitypatch);
            Vec3 entitypos = ikSimulatable.toEntity().m_20182_();
            OpenMatrix4f toWorld = OpenMatrix4f.mul(OpenMatrix4f.createTranslation((float)entitypos.f_82479_, (float)entitypos.f_82480_, (float)entitypos.f_82481_), ikSimulatable.getModelMatrix(1.0f), null);
            this.getProperty(AnimationProperty.StaticAnimationProperty.BAKED_IK_DEFINITION).ifPresent(ikDefinitions -> {
                for (InverseKinematicsSimulator.BakedInverseKinematicsDefinition bakedIKInfo : ikDefinitions) {
                    TransformSheet tipAnim = bakedIKInfo.terminalBoneTransform().getFirstFrame();
                    Keyframe[] keyframes = tipAnim.getKeyframes();
                    JointTransform firstposeTransform = keyframes[0].transform();
                    firstposeTransform.translation().multiply(-1.0f, 1.0f, -1.0f);
                    if (!bakedIKInfo.clipAnimation() || bakedIKInfo.touchingGround()[0]) {
                        Vec3f rayResultPosition = this.getRayCastedTipPosition(ikSimulatable, firstposeTransform.translation().add(0.0f, 2.5f, 0.0f), toWorld, 8.0f, bakedIKInfo.rayLeastHeight());
                        firstposeTransform.translation().set(rayResultPosition);
                    } else {
                        firstposeTransform.translation().set(OpenMatrix4f.transform3v(toWorld, firstposeTransform.translation(), null));
                    }
                    for (Keyframe keyframe : keyframes) {
                        keyframe.transform().translation().set(firstposeTransform.translation());
                    }
                    ikSimulatable.getIKSimulator().runUntil(bakedIKInfo.endJoint(), this, InverseKinematicsSimulator.InverseKinematicsBuilder.create(firstposeTransform.translation(), tipAnim, bakedIKInfo), () -> ((Animator)entitypatch.getAnimator()).getPlayer(this.getAccessor()).isPresent());
                }
            });
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (entitypatch instanceof InverseKinematicsSimulatable) {
            InverseKinematicsSimulatable ikSimulatable = (InverseKinematicsSimulatable)((Object)entitypatch);
            if (((Animator)entitypatch.getAnimator()).getPlayerFor(null).getAnimation().get() != this) {
                return;
            }
            Vec3 entitypos = ikSimulatable.toEntity().m_20182_();
            OpenMatrix4f toWorld = OpenMatrix4f.mul(OpenMatrix4f.createTranslation((float)entitypos.f_82479_, (float)entitypos.f_82480_, (float)entitypos.f_82481_), ikSimulatable.getModelMatrix(1.0f), null);
            for (InverseKinematicsSimulator.BakedInverseKinematicsDefinition bakedIKInfo : (List)this.getProperty(AnimationProperty.StaticAnimationProperty.BAKED_IK_DEFINITION).orElse(null)) {
                Vec3f footpos;
                if (!ikSimulatable.getIKSimulator().isRunning(bakedIKInfo.endJoint())) continue;
                InverseKinematicsSimulator.InverseKinematicsObject ikObject = (InverseKinematicsSimulator.InverseKinematicsObject)ikSimulatable.getIKSimulator().getRunningObject(bakedIKInfo.endJoint()).get();
                Vec3f clipStart = bakedIKInfo.endPosition().copy().add(0.0f, 2.5f, 0.0f).multiply(-1.0f, 1.0f, -1.0f);
                Vec3f finalTargetpos = this.getRayCastedTipPosition(ikSimulatable, clipStart, toWorld, 8.0f, bakedIKInfo.rayLeastHeight());
                if (ikObject.isOnWorking()) {
                    ikObject.newTargetPosition(finalTargetpos);
                    continue;
                }
                InverseKinematicsSimulator.InverseKinematicsObject opponentIKObject = (InverseKinematicsSimulator.InverseKinematicsObject)ikSimulatable.getIKSimulator().getRunningObject(bakedIKInfo.opponentJoint()).get();
                if (opponentIKObject == null || opponentIKObject.isOnWorking() || !((double)(footpos = ikObject.getTipPosition(1.0f)).distanceSqr(finalTargetpos) > 15.0)) continue;
                this.startPartAnimation(bakedIKInfo, ikObject, this.clipAnimation(bakedIKInfo.terminalBoneTransform(), bakedIKInfo), finalTargetpos);
            }
        }
    }
}

