/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.physics.cloth;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.client.model.CompositeMesh;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.MeshPart;
import yesman.epicfight.api.client.model.SoftBodyTranslatable;
import yesman.epicfight.api.client.model.VertexBuilder;
import yesman.epicfight.api.client.physics.AbstractSimulator;
import yesman.epicfight.api.client.physics.cloth.ClothSimulatable;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.physics.SimulationObject;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.main.EpicFightSharedConstants;

public class ClothSimulator
extends AbstractSimulator<ResourceLocation, ClothObjectBuilder, SoftBodyTranslatable, ClothSimulatable, ClothObject> {
    public static final ResourceLocation PLAYER_CLOAK = EpicFightMod.identifier("ingame_cloak");
    public static final ResourceLocation MODELPREVIEWER_CLOAK = EpicFightMod.identifier("previewer_cloak");
    private static final float SPATIAL_HASH_SPACING = 0.05f;
    private static boolean DRAW_MESH_COLLIDERS = false;
    private static boolean DRAW_NORMAL_OFFSET = true;
    private static boolean DRAW_OUTLINES = false;

    public static void drawMeshColliders(boolean flag) {
        if (!EpicFightSharedConstants.IS_DEV_ENV) {
            throw new IllegalStateException("Can't switch developer configuration in product environment.");
        }
        DRAW_MESH_COLLIDERS = flag;
    }

    public static void drawNormalOffset(boolean flag) {
        if (!EpicFightSharedConstants.IS_DEV_ENV) {
            throw new IllegalStateException("Can't switch developer configuration in product environment.");
        }
        DRAW_NORMAL_OFFSET = flag;
    }

    public static void drawOutlines(boolean flag) {
        if (!EpicFightSharedConstants.IS_DEV_ENV) {
            throw new IllegalStateException("Can't switch developer configuration in product environment.");
        }
        DRAW_OUTLINES = flag;
    }

    public static class ClothOBBCollider
    extends OBBCollider {
        private static final Vec3f WORLD_CENTER = new Vec3f();
        private static final Vec3f TO_OPPONENT = new Vec3f();
        private static final Vec3f SEP_AXIS = new Vec3f();
        private static final Vec3f TO_VERTEX = new Vec3f();
        private static final Vec3f MAX_PROJ = new Vec3f();
        private static final Vec3f TO_OPPONENT_PROJECTION = new Vec3f();
        private static final Vec3f VERTEX_PROJECTION = new Vec3f();
        private static final Vec3f PROJECTION1 = new Vec3f();
        private static final Vec3f PROJECTION2 = new Vec3f();
        private static final Vec3f PROJECTION3 = new Vec3f();
        private static final Vec3f TO_PLANE1 = new Vec3f();
        private static final Vec3f TO_PLANE2 = new Vec3f();
        private static final Vec3f TO_PLANE3 = new Vec3f();
        private final Vec3f[] destinations = new Vec3f[]{new Vec3f(), new Vec3f(), new Vec3f(), new Vec3f(), new Vec3f(), new Vec3f()};

        public ClothOBBCollider(double vertexX, double vertexY, double vertexZ, double centerX, double centerY, double centerZ) {
            super(vertexX, vertexY, vertexZ, centerX, centerY, centerZ);
        }

        public AABB getOuterAABB(float particleRadius) {
            double maxX = -1000000.0;
            double maxY = -1000000.0;
            double maxZ = -1000000.0;
            for (Vec3 rotated : this.rotatedVertices) {
                double zdistance;
                double ydistance;
                double xdistance = Math.abs(rotated.f_82479_);
                if (xdistance > maxX) {
                    maxX = xdistance;
                }
                if ((ydistance = Math.abs(rotated.f_82480_)) > maxY) {
                    maxY = ydistance;
                }
                if (!((zdistance = Math.abs(rotated.f_82481_)) > maxZ)) continue;
                maxZ = zdistance;
            }
            return new AABB(-(maxX += (double)particleRadius), -(maxY += (double)particleRadius), -(maxZ += (double)particleRadius), maxX, maxY, maxZ).m_82383_(this.worldCenter);
        }

        private boolean doesPointCollide(Vec3 point, float radius) {
            Vec3 toOpponent = point.m_82546_(this.worldCenter);
            for (Vec3 seperateAxis : this.rotatedNormals) {
                Vec3 maxProj = null;
                double maxDot = -1000000.0;
                if (seperateAxis.m_82526_(toOpponent) < 0.0) {
                    seperateAxis = seperateAxis.m_82490_(-1.0);
                }
                for (Vec3 vertexVector : this.rotatedVertices) {
                    Vec3 toVertex = seperateAxis.m_82526_(vertexVector) > 0.0 ? vertexVector : vertexVector.m_82490_(-1.0);
                    double dot = seperateAxis.m_82526_(toVertex);
                    if (!(dot > maxDot) && maxProj != null) continue;
                    maxDot = dot;
                    maxProj = toVertex;
                }
                Vec3 opponentProjection = MathUtils.projectVector(toOpponent, seperateAxis);
                Vec3 vertexProjection = MathUtils.projectVector(maxProj, seperateAxis);
                if (!(opponentProjection.m_82553_() > vertexProjection.m_82553_() + (double)radius)) continue;
                return false;
            }
            return true;
        }

        public void pushIfPointInside(Vec3f point, Vec3f root, float selfCollision, List<Vec3f> destnations, List<ClothOBBCollider> others) {
            WORLD_CENTER.set(this.worldCenter);
            Vec3f.sub(point, WORLD_CENTER, TO_OPPONENT);
            int order = 0;
            for (Vec3 vec3 : this.rotatedNormals) {
                SEP_AXIS.set(vec3);
                float maxDot = -10000.0f;
                if ((double)Vec3f.dot(SEP_AXIS, TO_OPPONENT) < 0.0) {
                    SEP_AXIS.scale(-1.0f);
                }
                for (Vec3 vertexVector : this.rotatedVertices) {
                    float dot;
                    TO_VERTEX.set(vertexVector);
                    if ((double)Vec3f.dot(SEP_AXIS, TO_VERTEX) < 0.0) {
                        TO_VERTEX.scale(-1.0f);
                    }
                    if (!((dot = Vec3f.dot(SEP_AXIS, TO_VERTEX)) > maxDot)) continue;
                    maxDot = dot;
                    MAX_PROJ.set(TO_VERTEX);
                }
                MathUtils.projectVector(TO_OPPONENT, SEP_AXIS, TO_OPPONENT_PROJECTION);
                MathUtils.projectVector(MAX_PROJ, SEP_AXIS, VERTEX_PROJECTION);
                if (TO_OPPONENT_PROJECTION.length() > VERTEX_PROJECTION.length() + selfCollision) {
                    return;
                }
                switch (order) {
                    case 0: {
                        PROJECTION1.set(TO_OPPONENT_PROJECTION);
                        Vec3f.scale(VERTEX_PROJECTION, TO_PLANE1, (VERTEX_PROJECTION.length() + selfCollision) / VERTEX_PROJECTION.length());
                        break;
                    }
                    case 1: {
                        PROJECTION2.set(TO_OPPONENT_PROJECTION);
                        Vec3f.scale(VERTEX_PROJECTION, TO_PLANE2, (VERTEX_PROJECTION.length() + selfCollision) / VERTEX_PROJECTION.length());
                        break;
                    }
                    case 2: {
                        PROJECTION3.set(TO_OPPONENT_PROJECTION);
                        Vec3f.scale(VERTEX_PROJECTION, TO_PLANE3, (VERTEX_PROJECTION.length() + selfCollision) / VERTEX_PROJECTION.length());
                    }
                }
                ++order;
            }
            this.destinations[0].set(0.0f, 0.0f, 0.0f).add(PROJECTION1).add(PROJECTION2).add(TO_PLANE3).add(this.worldCenter);
            this.destinations[1].set(0.0f, 0.0f, 0.0f).add(PROJECTION2).add(PROJECTION3).add(TO_PLANE1).add(this.worldCenter);
            this.destinations[2].set(0.0f, 0.0f, 0.0f).add(PROJECTION3).add(PROJECTION1).add(TO_PLANE2).add(this.worldCenter);
            this.destinations[3].set(0.0f, 0.0f, 0.0f).add(PROJECTION1).add(PROJECTION2).sub(TO_PLANE3).add(this.worldCenter);
            this.destinations[4].set(0.0f, 0.0f, 0.0f).add(PROJECTION2).add(PROJECTION3).sub(TO_PLANE1).add(this.worldCenter);
            this.destinations[5].set(0.0f, 0.0f, 0.0f).add(PROJECTION3).add(PROJECTION1).sub(TO_PLANE2).add(this.worldCenter);
            block7: for (Vec3f vec3f : this.destinations) {
                for (ClothOBBCollider other : others) {
                    if (other == this || !other.doesPointCollide(vec3f.toDoubleVector(), selfCollision * 0.5f)) continue;
                    vec3f.invalidate();
                    continue block7;
                }
            }
            for (Vec3f vec3f : this.destinations) {
                if (!vec3f.validateValues()) continue;
                destnations.add(vec3f);
            }
        }
    }

    public static class ClothObject
    implements SimulationObject<ClothObjectBuilder, SoftBodyTranslatable, ClothSimulatable>,
    Mesh {
        private final SoftBodyTranslatable provider;
        private final Map<String, ClothPart> parts;
        private final Map<Integer, Particle> particles;
        private final Map<Integer, ClothPart.OffsetParticle> normalOffsetParticles;
        private final List<Map<Integer, Vec3f>> particleNormals;
        private final Quaternionf rotationO = new Quaternionf();
        private final Vec3f centrifugalO = new Vec3f();
        @Nullable
        protected List<Pair<Function<ClothSimulatable, OpenMatrix4f>, ClothOBBCollider>> clothColliders;
        protected final Joint parentJoint;
        private static final Vec3f TRASNFORMED = new Vec3f();
        private static final Vector4f POSITION = new Vector4f();
        private static final Vector3f NORMAL = new Vector3f();
        private static final int SUB_STEPS = 6;
        private static final Vec3f EXTERNAL_FORCE = new Vec3f();
        private static final Vec3f OFFSET = new Vec3f();
        private static final Vec3f CENTRIFUGAL = new Vec3f();
        private static final Vec3f CIRCULAR = new Vec3f();
        private static final OpenMatrix4f[] BOUND_ANIMATION_TRANSFORM = OpenMatrix4f.allocateMatrixArray(1000);
        private static final OpenMatrix4f COLLIDER_TRANSFORM = new OpenMatrix4f();
        private static final OpenMatrix4f TO_CENTRIFUGAL = new OpenMatrix4f();
        private static final OpenMatrix4f OBJECT_TRANSFORM = new OpenMatrix4f();
        private static final OpenMatrix4f INVERTED = new OpenMatrix4f();
        private static final Quaternionf ROTATOR = new Quaternionf();
        private static final Vec3f TO_P2 = new Vec3f();
        private static final Vec3f TO_P3 = new Vec3f();
        private static final Vec3f CROSS = new Vec3f();
        private static final Vec3f SCALE = new Vec3f();
        private static final Vector3f SCALER = new Vector3f();

        public ClothObject(ClothObjectBuilder builder, SoftBodyTranslatable provider, Map<String, MeshPart> parts, float[] positions) {
            this.clothColliders = builder.clothColliders;
            this.parentJoint = builder.joint;
            this.provider = provider;
            this.particles = Maps.newHashMap();
            this.normalOffsetParticles = Maps.newHashMap();
            this.particleNormals = Lists.newArrayList();
            for (int i = 0; i < positions.length / 3; ++i) {
                this.particleNormals.add(Maps.newHashMap());
            }
            for (Map.Entry<String, MeshPart> meshPart : parts.entrySet()) {
                for (VertexBuilder vb : meshPart.getValue().getVertices()) {
                    Map<Integer, Vec3f> posNormals = this.particleNormals.get(vb.position);
                    if (posNormals.containsKey(vb.normal)) continue;
                    provider.getOriginalMesh().getVertexNormal(vb.normal, NORMAL);
                    posNormals.put(vb.normal, new Vec3f(ClothObject.NORMAL.x, ClothObject.NORMAL.y, ClothObject.NORMAL.z));
                }
            }
            ImmutableMap.Builder partBuilder = ImmutableMap.builder();
            for (Map.Entry<String, SoftBodyTranslatable.ClothSimulationInfo> entry : provider.getSoftBodySimulationInfo().entrySet()) {
                partBuilder.put((Object)entry.getKey(), (Object)new ClothPart(entry.getValue(), positions));
            }
            this.parts = partBuilder.build();
        }

        private ClothObject(ClothObject copyTarget) {
            this.provider = copyTarget.provider;
            this.parts = copyTarget.parts;
            this.particles = new HashMap<Integer, Particle>();
            this.normalOffsetParticles = new HashMap<Integer, ClothPart.OffsetParticle>();
            for (Map.Entry<Integer, Particle> entry : copyTarget.particles.entrySet()) {
                this.particles.put(entry.getKey(), entry.getValue().copy());
            }
            for (Map.Entry<Integer, Object> entry : copyTarget.normalOffsetParticles.entrySet()) {
                this.normalOffsetParticles.put(entry.getKey(), ((ClothPart.OffsetParticle)entry.getValue()).copy());
            }
            for (Map.Entry<Integer, Object> entry : copyTarget.normalOffsetParticles.entrySet()) {
                this.normalOffsetParticles.put(entry.getKey(), ((ClothPart.OffsetParticle)entry.getValue()).copy());
            }
            this.particleNormals = ImmutableList.copyOf(copyTarget.particleNormals);
            this.parentJoint = copyTarget.parentJoint;
        }

        public ClothObject captureMyself() {
            return new ClothObject(this);
        }

        public void tick(ClothSimulatable simulatableObj, Function<Float, OpenMatrix4f> colliderTransformGetter, float partialTick, @Nullable Armature armature, @Nullable OpenMatrix4f[] poses) {
            if (!Minecraft.m_91087_().m_91104_()) {
                int deltaSign;
                boolean skinned = poses != null && armature != null;
                for (int j = 0; j < armature.getJointNumber(); ++j) {
                    if (!skinned) continue;
                    BOUND_ANIMATION_TRANSFORM[j].load(poses[j]);
                    BOUND_ANIMATION_TRANSFORM[j].mulBack(armature.searchJointById(j).getToOrigin());
                    BOUND_ANIMATION_TRANSFORM[j].removeScale();
                }
                float deltaFrameTime = Minecraft.m_91087_().m_91297_();
                float subStebInvert = 0.16666667f;
                float subSteppingDeltaTime = deltaFrameTime * subStebInvert;
                float gravity = simulatableObj.getGravity() * subSteppingDeltaTime * 0.05f;
                float yRot = Mth.m_14177_((float)Mth.m_14189_((float)partialTick, (float)Mth.m_14177_((float)simulatableObj.getYRotO()), (float)Mth.m_14177_((float)simulatableObj.getYRot())));
                TO_CENTRIFUGAL.load(BOUND_ANIMATION_TRANSFORM[this.parentJoint.getId()]);
                TO_CENTRIFUGAL.mulFront(OpenMatrix4f.createRotatorDeg(-yRot + 180.0f, Vec3f.Y_AXIS));
                TO_CENTRIFUGAL.toQuaternion(ROTATOR);
                Vec3 velocity = simulatableObj.getObjectVelocity();
                float delta = MathUtils.wrapRadian(MathUtils.getAngleBetween(this.rotationO, ROTATOR));
                float speed = Math.min((float)velocity.m_82553_() * deltaFrameTime, 0.2f);
                float rotationForce = Math.abs(delta);
                this.rotationO.set((Quaternionfc)ROTATOR);
                OpenMatrix4f.transform3v(TO_CENTRIFUGAL, Vec3f.Z_AXIS, CENTRIFUGAL);
                int n = deltaSign = (double)Math.abs(delta) < 0.02 ? 0 : MathUtils.getSign(delta);
                if (deltaSign == 0) {
                    CIRCULAR.set(Vec3f.ZERO);
                } else {
                    Vec3f.sub(CENTRIFUGAL, this.centrifugalO, CIRCULAR);
                    CIRCULAR.normalize();
                }
                this.centrifugalO.set(CENTRIFUGAL);
                CENTRIFUGAL.scale(rotationForce * (1.0f + speed * 50.0f));
                CIRCULAR.scale(rotationForce * (1.0f + speed * 50.0f));
                velocity = velocity.m_82490_((double)rotationForce);
                Vec3f.add(CIRCULAR, CENTRIFUGAL, EXTERNAL_FORCE);
                EXTERNAL_FORCE.add(velocity);
                this.particleNormals.forEach(poseNormals -> poseNormals.values().forEach(vec3f -> vec3f.set(0.0f, 0.0f, 0.0f)));
                Vec3 pos = simulatableObj.getAccuratePartialLocation(partialTick);
                float yRotLerp = simulatableObj.getAccurateYRot(partialTick);
                OpenMatrix4f objectTransform = OpenMatrix4f.ofTranslation((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, OBJECT_TRANSFORM).rotateDeg(180.0f - yRotLerp, Vec3f.Y_AXIS);
                OpenMatrix4f.invert(objectTransform, INVERTED);
                for (ClothPart part : this.parts.values()) {
                    part.tick(objectTransform, EXTERNAL_FORCE, (OpenMatrix4f[])(skinned ? BOUND_ANIMATION_TRANSFORM : null));
                }
                for (int i = 0; i < 6; ++i) {
                    float substepPartialTick = partialTick - deltaFrameTime + subSteppingDeltaTime * (float)(i + 1);
                    if (this.clothColliders != null) {
                        simulatableObj.getArmature().setPose(simulatableObj.getSimulatableAnimator().getPose(Mth.m_14036_((float)substepPartialTick, (float)0.0f, (float)1.0f)));
                        OpenMatrix4f colliderTransform = colliderTransformGetter.apply(Float.valueOf(substepPartialTick));
                        for (Pair<Function<ClothSimulatable, OpenMatrix4f>, ClothOBBCollider> entry : this.clothColliders) {
                            ((ClothOBBCollider)entry.getSecond()).transform(OpenMatrix4f.mul(colliderTransform, (OpenMatrix4f)((Function)entry.getFirst()).apply(simulatableObj), COLLIDER_TRANSFORM));
                        }
                    }
                    for (ClothPart part : this.parts.values()) {
                        part.substepTick(gravity, subSteppingDeltaTime, i + 1, this.clothColliders);
                    }
                }
            }
            this.updateNormal(false);
            if (!this.normalOffsetParticles.isEmpty()) {
                for (ClothPart.OffsetParticle offsetParticle : this.normalOffsetParticles.values()) {
                    Particle rootParticle = offsetParticle.rootParticle();
                    Map<Integer, Vec3f> rootNormalMap = this.particleNormals.get(rootParticle.meshVertexId);
                    OFFSET.set(0.0f, 0.0f, 0.0f);
                    for (Integer normIdx : offsetParticle.positionNormalMembers()) {
                        OFFSET.add(rootNormalMap.get(normIdx).normalize());
                    }
                    OFFSET.scale(offsetParticle.length / OFFSET.length());
                    offsetParticle.position.set(rootParticle.position.x - ClothObject.OFFSET.x, rootParticle.position.y - ClothObject.OFFSET.y, rootParticle.position.z - ClothObject.OFFSET.z);
                }
            }
            this.updateNormal(true);
            this.captureModelPosition(INVERTED);
        }

        private void updateNormal(boolean updateOffsetParticles) {
            SoftBodyTranslatable softBodyMesh = this.provider;
            for (MeshPart modelPart : softBodyMesh.getOriginalMesh().getAllParts()) {
                for (int i = 0; i < modelPart.getVertices().size() / 3; ++i) {
                    VertexBuilder triP1 = modelPart.getVertices().get(i * 3);
                    VertexBuilder triP2 = modelPart.getVertices().get(i * 3 + 1);
                    VertexBuilder triP3 = modelPart.getVertices().get(i * 3 + 2);
                    if (!this.particles.containsKey(triP1.position) || !this.particles.containsKey(triP2.position) || !this.particles.containsKey(triP3.position) ? !updateOffsetParticles : updateOffsetParticles) continue;
                    Vec3f p1Pos = this.getParticlePosition(triP1.position);
                    Vec3f p2Pos = this.getParticlePosition(triP2.position);
                    Vec3f p3Pos = this.getParticlePosition(triP3.position);
                    Vec3f.cross(Vec3f.sub(p2Pos, p1Pos, TO_P2), Vec3f.sub(p3Pos, p1Pos, TO_P3), CROSS);
                    CROSS.normalize();
                    Map<Integer, Vec3f> triP1Normals = this.particleNormals.get(triP1.position);
                    Map<Integer, Vec3f> triP2Normals = this.particleNormals.get(triP2.position);
                    Map<Integer, Vec3f> triP3Normals = this.particleNormals.get(triP3.position);
                    triP1Normals.get(triP1.normal).add(CROSS);
                    triP2Normals.get(triP2.normal).add(CROSS);
                    triP3Normals.get(triP3.normal).add(CROSS);
                }
            }
        }

        public void scaleFromPose(PoseStack poseStack, OpenMatrix4f[] poses) {
            OpenMatrix4f poseMat = poses[this.parentJoint.getId()];
            poseMat.toScaleVector(SCALE);
            poseStack.m_252880_(poseMat.m30, poseMat.m31, poseMat.m32);
            poseStack.m_85841_(ClothObject.SCALE.x, ClothObject.SCALE.y, ClothObject.SCALE.z);
            poseStack.m_252880_(-poseMat.m30, -poseMat.m31, -poseMat.m32);
        }

        @Override
        public void draw(PoseStack poseStack, VertexConsumer bufferBuilder, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay) {
            if (DRAW_OUTLINES) {
                this.drawOutline(poseStack, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_()), Mesh.DrawingFunction.POSITION_COLOR_NORMAL, r, g, b, a);
            } else {
                this.drawParts(poseStack, bufferBuilder, drawingFunction, packedLight, r, g, b, a, overlay);
            }
            SoftBodyTranslatable softBodyTranslatable = this.provider;
            if (softBodyTranslatable instanceof CompositeMesh) {
                CompositeMesh compositeMesh = (CompositeMesh)softBodyTranslatable;
                poseStack.m_85849_();
                compositeMesh.getStaticMesh().draw(poseStack, bufferBuilder, drawingFunction, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, overlay);
                poseStack.m_85836_();
            }
        }

        @Override
        public void drawPosed(PoseStack poseStack, VertexConsumer bufferBuilder, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
            if (DRAW_OUTLINES) {
                this.drawOutline(poseStack, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_()), Mesh.DrawingFunction.POSITION_COLOR_NORMAL, r, g, b, a);
            } else {
                this.drawParts(poseStack, bufferBuilder, drawingFunction, packedLight, r, g, b, a, overlay);
            }
            if (DRAW_MESH_COLLIDERS && this.clothColliders != null) {
                for (Pair<Function<ClothSimulatable, OpenMatrix4f>, ClothOBBCollider> entry : this.clothColliders) {
                    ((ClothOBBCollider)entry.getSecond()).draw(poseStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), -1);
                }
            }
            poseStack.m_85850_().m_252922_().getScale(SCALER);
            float scaleX = ClothObject.SCALER.x;
            float scaleY = ClothObject.SCALER.y;
            float scaleZ = ClothObject.SCALER.z;
            poseStack.m_85849_();
            poseStack.m_85850_().m_252922_().getScale(SCALER);
            float xDiv = scaleX / ClothObject.SCALER.x;
            float yDiv = scaleY / ClothObject.SCALER.y;
            float zDiv = scaleZ / ClothObject.SCALER.z;
            poseStack.m_85841_(xDiv, yDiv, zDiv);
            SoftBodyTranslatable softBodyTranslatable = this.provider;
            if (softBodyTranslatable instanceof CompositeMesh) {
                CompositeMesh compositeMesh = (CompositeMesh)softBodyTranslatable;
                compositeMesh.getStaticMesh().drawPosed(poseStack, bufferBuilder, drawingFunction, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, overlay, armature, poses);
            }
            poseStack.m_85836_();
        }

        public Vec3f getParticlePosition(int idx) {
            if (this.particles.containsKey(idx)) {
                return this.particles.get((Object)Integer.valueOf((int)idx)).position;
            }
            return this.normalOffsetParticles.get((Object)Integer.valueOf((int)idx)).position;
        }

        private void captureModelPosition(OpenMatrix4f objectTranslformInv) {
            for (Particle p : this.particles.values()) {
                OpenMatrix4f.transform3v(objectTranslformInv, p.position, p.modelPosition);
            }
        }

        public void drawParts(PoseStack poseStack, VertexConsumer bufferBuilder, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay) {
            SoftBodyTranslatable softBodyMesh = this.provider;
            float[] uvs = softBodyMesh.getOriginalMesh().uvs();
            for (MeshPart meshPart : softBodyMesh.getOriginalMesh().getAllParts()) {
                if (meshPart.isHidden()) continue;
                Vector4f color = meshPart.getColor(r, g, b, a);
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
                for (int i = 0; i < meshPart.getVertices().size(); ++i) {
                    if (!DRAW_NORMAL_OFFSET && i % 3 == 0 && i + 1 != meshPart.getVertices().size() && i + 2 != meshPart.getVertices().size()) {
                        VertexBuilder v1 = meshPart.getVertices().get(i);
                        VertexBuilder v2 = meshPart.getVertices().get(i + 1);
                        VertexBuilder v3 = meshPart.getVertices().get(i + 2);
                        if (!(this.particles.containsKey(v1.position) && this.particles.containsKey(v2.position) && this.particles.containsKey(v3.position))) {
                            i += 2;
                            continue;
                        }
                    }
                    VertexBuilder vb = meshPart.getVertices().get(i);
                    Vec3f particlePosition = this.getParticlePosition(vb.position);
                    Vec3f poseNormal = this.particleNormals.get(vb.position).get(vb.normal);
                    poseNormal.normalize();
                    POSITION.set(particlePosition.x, particlePosition.y, particlePosition.z);
                    NORMAL.set(poseNormal.x, poseNormal.y, poseNormal.z);
                    POSITION.mul((Matrix4fc)matrix4f);
                    NORMAL.mul((Matrix3fc)matrix3f);
                    drawingFunction.draw(bufferBuilder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), packedLight, color.x, color.y, color.z, color.w, uvs[vb.uv * 2], uvs[vb.uv * 2 + 1], overlay);
                }
            }
        }

        public void drawOutline(PoseStack poseStack, VertexConsumer builder, Mesh.DrawingFunction drawingFunction, float r, float g, float b, float a) {
            SoftBodyTranslatable softBodyMesh = this.provider;
            for (MeshPart meshPart : softBodyMesh.getOriginalMesh().getAllParts()) {
                if (meshPart.isHidden()) continue;
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
                for (int i = 0; i < meshPart.getVertices().size() / 3; ++i) {
                    VertexBuilder v1 = meshPart.getVertices().get(i * 3);
                    VertexBuilder v2 = meshPart.getVertices().get(i * 3 + 1);
                    VertexBuilder v3 = meshPart.getVertices().get(i * 3 + 2);
                    if (!DRAW_NORMAL_OFFSET && (!this.particles.containsKey(v1.position) || !this.particles.containsKey(v2.position) || !this.particles.containsKey(v3.position))) continue;
                    Vec3f pos1 = this.getParticlePosition(v1.position);
                    Vec3f pos2 = this.getParticlePosition(v2.position);
                    Vec3f pos3 = this.getParticlePosition(v3.position);
                    POSITION.set(pos1.x, pos1.y, pos1.z);
                    NORMAL.set(pos2.x - pos1.x, pos2.x - pos1.x, pos2.x - pos1.x);
                    POSITION.mul((Matrix4fc)matrix4f);
                    NORMAL.mul((Matrix3fc)matrix3f);
                    drawingFunction.draw(builder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), -1, r, g, b, a, 0.0f, 0.0f, 0);
                    POSITION.set(pos2.x, pos2.y, pos2.z);
                    POSITION.mul((Matrix4fc)matrix4f);
                    drawingFunction.draw(builder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), -1, r, g, b, a, 0.0f, 0.0f, 0);
                    POSITION.set(pos2.x, pos2.y, pos2.z);
                    NORMAL.set(pos3.x - pos2.x, pos3.x - pos2.x, pos3.x - pos2.x);
                    POSITION.mul((Matrix4fc)matrix4f);
                    NORMAL.mul((Matrix3fc)matrix3f);
                    drawingFunction.draw(builder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), -1, r, g, b, a, 0.0f, 0.0f, 0);
                    POSITION.set(pos3.x, pos3.y, pos3.z);
                    POSITION.mul((Matrix4fc)matrix4f);
                    drawingFunction.draw(builder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), -1, r, g, b, a, 0.0f, 0.0f, 0);
                    POSITION.set(pos3.x, pos3.y, pos3.z);
                    NORMAL.set(pos1.x - pos3.x, pos1.x - pos3.x, pos1.x - pos3.x);
                    POSITION.mul((Matrix4fc)matrix4f);
                    NORMAL.mul((Matrix3fc)matrix3f);
                    drawingFunction.draw(builder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), -1, r, g, b, a, 0.0f, 0.0f, 0);
                    POSITION.set(pos1.x, pos1.y, pos1.z);
                    POSITION.mul((Matrix4fc)matrix4f);
                    drawingFunction.draw(builder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), -1, r, g, b, a, 0.0f, 0.0f, 0);
                }
            }
        }

        public void drawNormals(PoseStack poseStack, VertexConsumer builder, Mesh.DrawingFunction drawingFunction, float r, float g, float b, float a) {
            if (!this.normalOffsetParticles.isEmpty()) {
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
                for (ClothPart.OffsetParticle offsetParticle : this.normalOffsetParticles.values()) {
                    Particle rootParticle = offsetParticle.rootParticle();
                    Map<Integer, Vec3f> rootNormalMap = this.particleNormals.get(rootParticle.meshVertexId);
                    if (rootNormalMap.size() < 2) continue;
                    OFFSET.set(0.0f, 0.0f, 0.0f);
                    for (Integer normIdx : offsetParticle.positionNormalMembers()) {
                        OFFSET.add(rootNormalMap.get(normIdx).normalize());
                    }
                    OFFSET.scale(offsetParticle.length / OFFSET.length());
                    Vec3f rootpos = this.getParticlePosition(rootParticle.meshVertexId);
                    POSITION.set(rootpos.x, rootpos.y, rootpos.z);
                    NORMAL.set(-ClothObject.OFFSET.x, -ClothObject.OFFSET.x, -ClothObject.OFFSET.x);
                    POSITION.mul((Matrix4fc)matrix4f);
                    NORMAL.mul((Matrix3fc)matrix3f);
                    drawingFunction.draw(builder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), -1, r, g, b, a, 0.0f, 0.0f, 0);
                    POSITION.set(rootpos.x - ClothObject.OFFSET.x, rootpos.y - ClothObject.OFFSET.y, rootpos.z - ClothObject.OFFSET.z);
                    POSITION.mul((Matrix4fc)matrix4f);
                    drawingFunction.draw(builder, ClothObject.POSITION.x, ClothObject.POSITION.y, ClothObject.POSITION.z, NORMAL.x(), NORMAL.y(), NORMAL.z(), -1, r, g, b, a, 0.0f, 0.0f, 0);
                }
            }
        }

        @Override
        public void initialize() {
        }

        public class ClothPart {
            final List<Particle> particleList = Lists.newArrayList();
            final List<ConstraintList> constraints;
            final Multimap<Integer, Particle> spatialHash;
            final float selfCollision;
            final float particleMass;
            final int hashTableSize;
            private static final Vec3f AVERAGE = new Vec3f();
            private static final Vec3f VEC3F = new Vec3f();
            private static final Vector4f POSITION = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            private static final Vec3f DIFF = new Vec3f();
            private static final Vec3f PARTIAL_VELOCITY = new Vec3f();

            ClothPart(SoftBodyTranslatable.ClothSimulationInfo clothInfo, float[] positions) {
                ImmutableList.Builder constraintsBuilder = ImmutableList.builder();
                this.selfCollision = clothInfo.selfCollision();
                this.particleMass = clothInfo.particleMass();
                for (int i = 0; i < clothInfo.particles().length / 2; ++i) {
                    int positionIndex = clothInfo.particles()[i * 2];
                    int weightIndex = clothInfo.particles()[i * 2 + 1];
                    float influence = clothInfo.weights()[weightIndex];
                    float rootDistance = clothInfo.rootDistance()[i];
                    float x = positions[positionIndex * 3];
                    float y = positions[positionIndex * 3 + 1];
                    float z = positions[positionIndex * 3 + 2];
                    Particle particle = new Particle(new Vec3f(x, y, z), influence, rootDistance, positionIndex);
                    ClothObject.this.particles.put(positionIndex, particle);
                    this.particleList.add(particle);
                }
                this.hashTableSize = this.particleList.size() * 2;
                this.spatialHash = HashMultimap.create((int)this.hashTableSize, (int)2);
                int idx = 0;
                for (int[] constraints : clothInfo.constraints()) {
                    float compliance = clothInfo.compliances()[idx];
                    ConstraintType constraintType = clothInfo.constraintTypes()[idx];
                    ++idx;
                    switch (constraintType) {
                        case STRETCHING: {
                            int idx2;
                            int idx1;
                            int i;
                            ArrayList<Constraint> constraintList = new ArrayList<Constraint>(constraints.length / 2);
                            for (i = 0; i < constraints.length / 2; ++i) {
                                idx1 = constraints[i * 2];
                                idx2 = constraints[i * 2 + 1];
                                constraintList.add(new StretchingConstraint(ClothObject.this.particles.get(idx1), ClothObject.this.particles.get(idx2)));
                            }
                            constraintsBuilder.add((Object)new ConstraintList(compliance, constraintType, constraintList));
                            break;
                        }
                        case SHAPING: {
                            int idx2;
                            int idx1;
                            int i;
                            ArrayList<Constraint> constraintList = new ArrayList(constraints.length / 2);
                            for (i = 0; i < constraints.length / 2; ++i) {
                                idx1 = constraints[i * 2];
                                idx2 = constraints[i * 2 + 1];
                                constraintList.add(new ShapingConstraint(ClothObject.this.particles.get(idx1), ClothObject.this.particles.get(idx2)));
                            }
                            constraintsBuilder.add((Object)new ConstraintList(compliance, constraintType, constraintList));
                            break;
                        }
                        case BENDING: {
                            int idx4;
                            int idx3;
                            int idx2;
                            int idx1;
                            int i;
                            ArrayList<Constraint> constraintList = new ArrayList(constraints.length / 4);
                            for (i = 0; i < constraints.length / 4; ++i) {
                                idx1 = constraints[i * 4];
                                idx2 = constraints[i * 4 + 1];
                                idx3 = constraints[i * 4 + 2];
                                idx4 = constraints[i * 4 + 3];
                                constraintList.add(new BendingConstraint(ClothObject.this.particles.get(idx1), ClothObject.this.particles.get(idx2), ClothObject.this.particles.get(idx3), ClothObject.this.particles.get(idx4)));
                            }
                            constraintsBuilder.add((Object)new ConstraintList(compliance, constraintType, constraintList));
                            break;
                        }
                        case VOLUME: {
                            int idx4;
                            int idx3;
                            int idx2;
                            int idx1;
                            int i;
                            ArrayList<Constraint> constraintList = new ArrayList(constraints.length / 4);
                            for (i = 0; i < constraints.length / 4; ++i) {
                                idx1 = constraints[i * 4];
                                idx2 = constraints[i * 4 + 1];
                                idx3 = constraints[i * 4 + 2];
                                idx4 = constraints[i * 4 + 3];
                                constraintList.add(new VolumeConstraint(ClothObject.this.particles.get(idx1), ClothObject.this.particles.get(idx2), ClothObject.this.particles.get(idx3), ClothObject.this.particles.get(idx4)));
                            }
                            constraintsBuilder.add((Object)new ConstraintList(compliance, constraintType, constraintList));
                        }
                    }
                }
                this.constraints = constraintsBuilder.build();
                if (clothInfo.normalOffsetMapping() != null) {
                    for (int i = 0; i < clothInfo.normalOffsetMapping().length / 2; ++i) {
                        int rootParticle = clothInfo.normalOffsetMapping()[i * 2];
                        int offsetParticleIdx = clothInfo.normalOffsetMapping()[i * 2 + 1];
                        Vec3f offsetDirection = new Vec3f(positions[offsetParticleIdx * 3] - positions[rootParticle * 3], positions[offsetParticleIdx * 3 + 1] - positions[rootParticle * 3 + 1], positions[offsetParticleIdx * 3 + 2] - positions[rootParticle * 3 + 2]);
                        ArrayList positionNormalMembers = Lists.newArrayList();
                        ArrayList inverseNormals = Lists.newArrayList();
                        OffsetParticle offsetParticle = new OffsetParticle(offsetParticleIdx, offsetDirection.length(), ClothObject.this.particles.get(rootParticle), new Vec3f(), positionNormalMembers, inverseNormals);
                        offsetDirection.normalize();
                        Map<Integer, Vec3f> rootNormalMap = ClothObject.this.particleNormals.get(rootParticle);
                        ArrayList<Vec3f> rootNormals = new ArrayList<Vec3f>(rootNormalMap.values());
                        ArrayList<Set<Integer>> normalSubsets = new ArrayList<Set<Integer>>(MathUtils.getSubset(IntStream.rangeClosed(0, rootNormals.size() - 1).boxed().toList()));
                        int candidate = -1;
                        int loopIdx = 0;
                        float maxDot = -10000.0f;
                        for (Set set : normalSubsets) {
                            Set<Vec3f> rootNormal = set.stream().map(normIdx -> (Vec3f)rootNormals.get((int)normIdx)).collect(Collectors.toSet());
                            Vec3f.average(rootNormal, AVERAGE);
                            AVERAGE.scale(-1.0f);
                            AVERAGE.normalize();
                            float dot = Vec3f.dot(offsetDirection, AVERAGE);
                            if (maxDot < dot) {
                                maxDot = dot;
                                candidate = loopIdx;
                            }
                            ++loopIdx;
                        }
                        ((Set)normalSubsets.get(candidate)).forEach(orderIdx -> {
                            int iterCount = 0;
                            for (Map.Entry entry : rootNormalMap.entrySet()) {
                                if (orderIdx == iterCount) {
                                    positionNormalMembers.add((Integer)entry.getKey());
                                    break;
                                }
                                ++iterCount;
                            }
                        });
                        ClothObject.this.normalOffsetParticles.put(offsetParticleIdx, offsetParticle);
                        block14: for (Vec3f vec3f : ClothObject.this.particleNormals.get(offsetParticleIdx).values()) {
                            int leastDotIdx = MathUtils.getLeastAngleVectorIdx(vec3f, rootNormals.toArray(new Vec3f[0]));
                            int iterCount = 0;
                            for (Map.Entry<Integer, Vec3f> entry : rootNormalMap.entrySet()) {
                                if (leastDotIdx == iterCount) {
                                    inverseNormals.add(entry.getKey());
                                    continue block14;
                                }
                                ++iterCount;
                            }
                        }
                    }
                }
            }

            public void buildSpatialHash() {
                this.spatialHash.clear();
                for (Particle p : this.particleList) {
                    int hash = this.getHash(p.position.x, p.position.y, p.position.z);
                    this.spatialHash.put((Object)hash, (Object)p);
                }
            }

            public void tick(OpenMatrix4f objectTransform, Vec3f externalForce, OpenMatrix4f[] poses) {
                for (Particle p : this.particleList) {
                    p.velocity.scale(0.92f);
                    p.velocity.add(externalForce.x * p.rootDistance * p.influence * this.particleMass, externalForce.y * p.rootDistance * p.influence * this.particleMass, externalForce.z * p.rootDistance * p.influence * this.particleMass);
                    if (p.collided) {
                        VEC3F.set(p.modelPosition);
                        OpenMatrix4f.transform3v(objectTransform, VEC3F, TRASNFORMED);
                        p.position.set(TRASNFORMED);
                        continue;
                    }
                    float influenceInv = 1.0f - p.influence;
                    if (!(influenceInv > 0.0f)) continue;
                    ClothObject.this.provider.getOriginalMesh().getVertexPosition(p.meshVertexId, POSITION, poses);
                    VEC3F.set(ClothPart.POSITION.x, ClothPart.POSITION.y, ClothPart.POSITION.z);
                    OpenMatrix4f.transform3v(objectTransform, VEC3F, TRASNFORMED);
                    Vec3f.interpolate(p.position, TRASNFORMED, influenceInv, TRASNFORMED);
                    p.position.set(TRASNFORMED);
                }
            }

            public void substepTick(float substepGravity, float substepDeltaTime, int stepCount, List<Pair<Function<ClothSimulatable, OpenMatrix4f>, ClothOBBCollider>> clothColliders) {
                for (Particle p : this.particleList) {
                    p.position.y -= substepGravity * this.particleMass * p.influence;
                    p.position.add(Vec3f.scale(p.velocity, PARTIAL_VELOCITY, 0.16666667f));
                }
                for (ConstraintList constraintsBundle : this.constraints) {
                    float alpha = constraintsBundle.compliance() / (substepDeltaTime * substepDeltaTime);
                    for (Constraint constraint : constraintsBundle.constraints()) {
                        constraint.solve(alpha, stepCount);
                    }
                }
                if (stepCount == 1) {
                    this.buildSpatialHash();
                }
                for (Particle p1 : this.particleList) {
                    int hash = this.getHash(p1.position.x, p1.position.y, p1.position.z);
                    for (Particle particle : this.spatialHash.get((Object)hash)) {
                        float influenceSum;
                        if (p1 == particle || (influenceSum = p1.influence + particle.influence) == 0.0f) continue;
                        Vec3f.sub(p1.position, particle.position, VEC3F);
                        float f = VEC3F.length();
                        if (!(f < this.selfCollision)) continue;
                        float scale = (this.selfCollision - f) / this.selfCollision;
                        float p1Move = p1.influence / influenceSum;
                        float p2Move = particle.influence / influenceSum;
                        VEC3F.scale(scale);
                        p1.position.add(ClothPart.VEC3F.x * p1Move, ClothPart.VEC3F.y * p1Move, ClothPart.VEC3F.z * p1Move);
                        particle.position.sub(ClothPart.VEC3F.x * p2Move, ClothPart.VEC3F.y * p2Move, ClothPart.VEC3F.z * p2Move);
                    }
                }
                if (clothColliders != null) {
                    for (ConstraintList constraintList : this.constraints) {
                        if (constraintList.constraintType() != ConstraintType.SHAPING) continue;
                        List<? extends Constraint> constraints = constraintList.constraints();
                        ArrayList colliders = Lists.newArrayList();
                        ArrayList arrayList = Lists.newArrayList();
                        for (ShapingConstraint shapingConstraint : constraints) {
                            if (shapingConstraint.p1.influence == 0.0f && shapingConstraint.p2.influence == 0.0f) continue;
                            for (Pair<Function<ClothSimulatable, OpenMatrix4f>, ClothOBBCollider> entry : clothColliders) {
                                ClothOBBCollider clothCollider = (ClothOBBCollider)entry.getSecond();
                                if (!clothCollider.getOuterAABB(this.selfCollision * 0.5f).m_82393_((double)shapingConstraint.p2.position.x, (double)shapingConstraint.p2.position.y, (double)shapingConstraint.p2.position.z) || clothCollider.doesPointCollide(shapingConstraint.p1.position.toDoubleVector(), this.selfCollision * 0.5f)) continue;
                                colliders.add((ClothOBBCollider)entry.getSecond());
                            }
                            for (ClothOBBCollider collider : colliders) {
                                collider.pushIfPointInside(shapingConstraint.p2.position, shapingConstraint.p1.position, this.selfCollision * 0.5f, arrayList, colliders);
                            }
                            int i = Vec3f.getNearest(shapingConstraint.p2.position, arrayList);
                            boolean bl = shapingConstraint.p2.collided = i != -1;
                            if (i != -1) {
                                Vec3f nearest = (Vec3f)arrayList.get(i);
                                Vec3f.sub(nearest, shapingConstraint.p2.position, DIFF);
                                shapingConstraint.p2.position.set(nearest);
                            }
                            colliders.clear();
                            arrayList.clear();
                        }
                    }
                }
            }

            private int getHash(double x, double y, double z) {
                int xi = (int)Math.floor(x / (double)0.05f);
                int yi = (int)Math.floor(y / (double)0.05f);
                int zi = (int)Math.floor(z / (double)0.05f);
                int hash = xi * 92837111 ^ yi * 689287499 ^ zi * 283923481;
                return Math.abs(hash) % this.hashTableSize;
            }

            public static enum ConstraintType {
                STRETCHING,
                SHAPING,
                BENDING,
                VOLUME;

            }

            class StretchingConstraint
            extends Constraint {
                final Particle p1;
                final Particle p2;
                final float restLength;
                static final Vec3f GRADIENT = new Vec3f();

                StretchingConstraint(Particle p1, Particle p2) {
                    this.p1 = p1;
                    this.p2 = p2;
                    this.restLength = p1.position.distance(p2.position);
                }

                @Override
                void solve(float alpha, int stepcount) {
                    float p1Influence = this.p1.influence;
                    float p2Influence = this.p2.influence;
                    float influenceSum = p1Influence + p2Influence;
                    if ((double)influenceSum < 1.0E-8) {
                        return;
                    }
                    Vec3f.sub(this.p2.position, this.p1.position, GRADIENT);
                    float currentLength = GRADIENT.length();
                    if ((double)currentLength < 1.0E-8) {
                        return;
                    }
                    GRADIENT.scale(1.0f / currentLength);
                    float constraint = currentLength - this.restLength;
                    float force = constraint / (influenceSum + alpha);
                    float p1Move = force * p1Influence;
                    float p2Move = -force * p2Influence;
                    this.p1.position.add(StretchingConstraint.GRADIENT.x * p1Move, StretchingConstraint.GRADIENT.y * p1Move, StretchingConstraint.GRADIENT.z * p1Move);
                    this.p2.position.add(StretchingConstraint.GRADIENT.x * p2Move, StretchingConstraint.GRADIENT.y * p2Move, StretchingConstraint.GRADIENT.z * p2Move);
                }
            }

            public record ConstraintList(float compliance, ConstraintType constraintType, List<? extends Constraint> constraints) {
            }

            class ShapingConstraint
            extends Constraint {
                final Particle p1;
                final Particle p2;
                final float restLength;
                static final Vec3f TOWARD = new Vec3f();

                ShapingConstraint(Particle p1, Particle p2) {
                    this.p1 = p1;
                    this.p2 = p2;
                    this.restLength = p1.position.distance(p2.position);
                }

                @Override
                void solve(float alpha, int stepcount) {
                    float p2Influence;
                    float p1Influence = stepcount == 6 && !this.p1.collided ? 0.0f : this.p1.influence;
                    float influenceSum = p1Influence + (p2Influence = this.p2.influence);
                    if ((double)influenceSum < 1.0E-5) {
                        return;
                    }
                    Vec3f.sub(this.p2.position, this.p1.position, TOWARD);
                    float distanceLength = TOWARD.length();
                    if (distanceLength == 0.0f) {
                        return;
                    }
                    TOWARD.scale(1.0f / distanceLength);
                    float distanceGap = distanceLength - this.restLength;
                    float force = distanceGap / (influenceSum + alpha);
                    float p1Move = force * p1Influence;
                    float p2Move = -force * p2Influence;
                    this.p1.position.add(ShapingConstraint.TOWARD.x * p1Move, ShapingConstraint.TOWARD.y * p1Move, ShapingConstraint.TOWARD.z * p1Move);
                    this.p2.position.add(ShapingConstraint.TOWARD.x * p2Move, ShapingConstraint.TOWARD.y * p2Move, ShapingConstraint.TOWARD.z * p2Move);
                }
            }

            class BendingConstraint
            extends Constraint {
                final Particle p1;
                final Particle p2;
                final Particle p3;
                final Particle p4;
                final float restAngle;
                final float oppositeDistance;
                static final Vec3f[] GRADIENTS = new Vec3f[]{new Vec3f(), new Vec3f(), new Vec3f(), new Vec3f()};
                static final Vec3f NORMAL_SUM = new Vec3f();
                static float STIFFNESS = 1.0f;
                static final Vec3f P2P1 = new Vec3f();
                static final Vec3f P3P1 = new Vec3f();
                static final Vec3f P4P2 = new Vec3f();
                static final Vec3f P4P3 = new Vec3f();
                static final Vec3f EDGE = new Vec3f();
                static final Vec3f EDGE_NORM = new Vec3f();
                static final Vec3f CROSS1 = new Vec3f();
                static final Vec3f CROSS2 = new Vec3f();
                static final Vec3f CROSS3 = new Vec3f();

                BendingConstraint(Particle p1, Particle p2, Particle p3, Particle p4) {
                    this.p1 = p1;
                    this.p2 = p2;
                    this.p3 = p3;
                    this.p4 = p4;
                    this.restAngle = this.getDihedralAngle();
                    this.oppositeDistance = Vec3f.sub(this.p1.position, this.p4.position, null).lengthSqr();
                }

                @Override
                void solve(float alpha, int stepcount) {
                    float influenceSum = this.p1.influence + this.p2.influence + this.p3.influence + this.p4.influence;
                    if ((double)influenceSum < 1.0E-8) {
                        return;
                    }
                    float currentAngle = this.getDihedralAngle();
                    float constraint = this.restAngle - currentAngle;
                    while ((double)constraint > Math.PI) {
                        constraint = (float)((double)constraint - Math.PI * 2);
                    }
                    while ((double)constraint < -Math.PI) {
                        constraint = (float)((double)constraint + Math.PI * 2);
                    }
                    constraint = this.oppositeDistance * constraint;
                    float edgeLength = EDGE.length();
                    CROSS1.scale(edgeLength);
                    CROSS2.scale(edgeLength);
                    GRADIENTS[0].set(CROSS1);
                    GRADIENTS[3].set(CROSS2);
                    Vec3f.add(CROSS1, CROSS2, NORMAL_SUM);
                    NORMAL_SUM.scale(-0.5f);
                    GRADIENTS[1].set(NORMAL_SUM);
                    GRADIENTS[2].set(NORMAL_SUM);
                    float weight = this.p1.influence * GRADIENTS[0].lengthSqr() + this.p2.influence * GRADIENTS[1].lengthSqr() + this.p3.influence * GRADIENTS[2].lengthSqr() + this.p4.influence * GRADIENTS[3].lengthSqr();
                    if ((double)weight < 1.0E-8) {
                        return;
                    }
                    float force = -constraint * STIFFNESS / (influenceSum + alpha);
                    GRADIENTS[0].scale(force * this.p1.influence);
                    GRADIENTS[1].scale(force * this.p2.influence);
                    GRADIENTS[2].scale(force * this.p3.influence);
                    GRADIENTS[3].scale(force * this.p4.influence);
                    Vec3f.add(this.p1.position, GRADIENTS[0], this.p1.position);
                    Vec3f.add(this.p2.position, GRADIENTS[1], this.p2.position);
                    Vec3f.add(this.p3.position, GRADIENTS[2], this.p3.position);
                    Vec3f.add(this.p4.position, GRADIENTS[3], this.p4.position);
                }

                public float getDihedralAngle() {
                    Vec3f.sub(this.p1.position, this.p2.position, P2P1);
                    Vec3f.sub(this.p1.position, this.p3.position, P3P1);
                    Vec3f.sub(this.p4.position, this.p2.position, P4P2);
                    Vec3f.sub(this.p4.position, this.p3.position, P4P3);
                    Vec3f.sub(this.p3.position, this.p2.position, EDGE);
                    Vec3f.cross(P2P1, P3P1, CROSS1);
                    Vec3f.cross(P4P3, P4P2, CROSS2);
                    CROSS1.normalize();
                    CROSS2.normalize();
                    Vec3f.normalize(EDGE, EDGE_NORM);
                    float cos = Vec3f.dot(CROSS1, CROSS2);
                    float sin = Vec3f.dot(Vec3f.cross(CROSS1, CROSS2, CROSS3), EDGE_NORM);
                    return (float)Math.atan2(sin, cos);
                }
            }

            class VolumeConstraint
            extends Constraint {
                final Particle[] particles;
                final float restVolume;
                static final float SUBDIVISION = 0.16666667f;
                static final int[][] VOLUME_ORDER = new int[][]{{1, 3, 2}, {0, 2, 3}, {0, 3, 1}, {0, 1, 2}};
                static final Vec3f[] SHRINK_DIRECTIONS = new Vec3f[]{new Vec3f(), new Vec3f(), new Vec3f(), new Vec3f()};
                static final Vec3f P1_TO_P2 = new Vec3f();
                static final Vec3f P1_TO_P3 = new Vec3f();
                static final Vec3f P1_TO_P4 = new Vec3f();
                static final Vec3f TET_CROSS = new Vec3f();

                VolumeConstraint(Particle p1, Particle p2, Particle p3, Particle p4) {
                    this.particles = new Particle[4];
                    this.particles[0] = p1;
                    this.particles[1] = p2;
                    this.particles[2] = p3;
                    this.particles[3] = p4;
                    this.restVolume = this.getTetrahedralVolume();
                }

                @Override
                void solve(float alpha, int stepcount) {
                    float weight = 0.0f;
                    for (int i = 0; i < 4; ++i) {
                        Particle p1 = this.particles[VOLUME_ORDER[i][0]];
                        Particle p2 = this.particles[VOLUME_ORDER[i][1]];
                        Particle p3 = this.particles[VOLUME_ORDER[i][2]];
                        Vec3f.sub(p2.position, p1.position, P1_TO_P2);
                        Vec3f.sub(p3.position, p1.position, P1_TO_P3);
                        Vec3f.cross(P1_TO_P2, P1_TO_P3, SHRINK_DIRECTIONS[i]);
                        SHRINK_DIRECTIONS[i].scale(0.16666667f);
                        weight += this.particles[i].influence * SHRINK_DIRECTIONS[i].lengthSqr();
                    }
                    if ((double)weight < 1.0E-8) {
                        return;
                    }
                    float constraint = this.restVolume - this.getTetrahedralVolume();
                    float force = constraint / (weight + alpha);
                    for (int i = 0; i < 4; ++i) {
                        SHRINK_DIRECTIONS[i].scale(force * this.particles[i].influence);
                        Vec3f.add(this.particles[i].position, SHRINK_DIRECTIONS[i], this.particles[i].position);
                    }
                }

                float getTetrahedralVolume() {
                    Vec3f.sub(this.particles[1].position, this.particles[0].position, P1_TO_P2);
                    Vec3f.sub(this.particles[2].position, this.particles[0].position, P1_TO_P3);
                    Vec3f.sub(this.particles[3].position, this.particles[0].position, P1_TO_P4);
                    Vec3f.cross(P1_TO_P2, P1_TO_P3, TET_CROSS);
                    return Vec3f.dot(TET_CROSS, P1_TO_P4) / 6.0f;
                }
            }

            public record OffsetParticle(int offsetVertexId, float length, Particle rootParticle, Vec3f position, List<Integer> positionNormalMembers, List<Integer> inverseNormal) {
                public OffsetParticle copy() {
                    return new OffsetParticle(this.offsetVertexId, this.length, this.rootParticle, this.position.copy(), this.positionNormalMembers, this.inverseNormal);
                }
            }

            abstract class Constraint {
                Constraint() {
                }

                abstract void solve(float var1, int var2);
            }
        }

        class Particle {
            final Vec3f position;
            final Vec3f modelPosition;
            final Vec3f velocity = new Vec3f();
            final float influence;
            final float rootDistance;
            final int meshVertexId;
            boolean collided;

            Particle(Vec3f position, float influence, float rootDistance, int meshVertexId) {
                this.position = position;
                this.modelPosition = position.copy();
                this.influence = influence;
                this.rootDistance = rootDistance;
                this.meshVertexId = meshVertexId;
                this.collided = false;
            }

            Particle copy() {
                return new Particle(this.position.copy(), this.influence, this.rootDistance, this.meshVertexId);
            }
        }
    }

    public static class ClothObjectBuilder
    extends SimulationObject.SimulationObjectBuilder {
        List<Pair<Function<ClothSimulatable, OpenMatrix4f>, ClothOBBCollider>> clothColliders = Lists.newArrayList();
        Joint joint;

        public ClothObjectBuilder addEntry(Function<ClothSimulatable, OpenMatrix4f> obbTransformer, ClothOBBCollider clothOBBCollider) {
            this.clothColliders.add((Pair<Function<ClothSimulatable, OpenMatrix4f>, ClothOBBCollider>)Pair.of(obbTransformer, (Object)clothOBBCollider));
            return this;
        }

        public ClothObjectBuilder putAll(List<Pair<Function<ClothSimulatable, OpenMatrix4f>, ClothOBBCollider>> clothOBBColliders) {
            this.clothColliders.addAll(clothOBBColliders);
            return this;
        }

        public ClothObjectBuilder parentJoint(Joint joint) {
            this.joint = joint;
            return this;
        }

        public static ClothObjectBuilder create() {
            return new ClothObjectBuilder();
        }
    }
}

