/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.input;

import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.client.input.DiscreteActionHandler;
import yesman.epicfight.api.client.input.action.InputAction;
import yesman.epicfight.api.client.input.controller.ControllerBinding;
import yesman.epicfight.api.client.input.controller.EpicFightControllerModProvider;
import yesman.epicfight.api.client.input.controller.IEpicFightControllerMod;

@ApiStatus.Internal
public final class DiscreteInputActionTrigger {
    private DiscreteInputActionTrigger() {
    }

    @Nullable
    private static IEpicFightControllerMod getControllerModApi() {
        return EpicFightControllerModProvider.get();
    }

    public static void triggerOnPress(@NotNull InputAction action, @NotNull DiscreteActionHandler handler) {
        IEpicFightControllerMod controllerMod = DiscreteInputActionTrigger.getControllerModApi();
        KeyMapping keyMapping = action.keyMapping();
        if (controllerMod == null) {
            DiscreteInputActionTrigger.handleKeyboardAndMouse(keyMapping, handler);
            return;
        }
        switch (controllerMod.getInputMode()) {
            case MIXED: {
                action.controllerBinding().ifPresentOrElse(controllerBinding -> {
                    boolean handled = DiscreteInputActionTrigger.handleController(controllerBinding, handler);
                    if (!handled) {
                        DiscreteInputActionTrigger.handleKeyboardAndMouse(keyMapping, handler);
                    }
                }, () -> DiscreteInputActionTrigger.handleKeyboardAndMouse(keyMapping, handler));
                break;
            }
            case CONTROLLER: {
                action.controllerBinding().ifPresentOrElse(controllerBinding -> DiscreteInputActionTrigger.handleController(controllerBinding, handler), () -> DiscreteInputActionTrigger.handleKeyboardAndMouse(keyMapping, handler));
                break;
            }
            case KEYBOARD_MOUSE: {
                DiscreteInputActionTrigger.handleKeyboardAndMouse(keyMapping, handler);
            }
        }
    }

    private static void handleKeyboardAndMouse(@NotNull KeyMapping keyMapping, @NotNull DiscreteActionHandler handler) {
        while (keyMapping.m_90859_()) {
            handler.onAction(DiscreteInputActionTrigger.createContext(false));
        }
    }

    private static boolean handleController(@NotNull ControllerBinding controllerBinding, @NotNull DiscreteActionHandler handler) {
        if (controllerBinding.isDigitalJustPressed()) {
            handler.onAction(DiscreteInputActionTrigger.createContext(true));
            return true;
        }
        return false;
    }

    @NotNull
    private static DiscreteActionHandler.Context createContext(boolean triggeredByController) {
        return new DiscreteActionHandler.Context(triggeredByController);
    }
}

