/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Vector4f;
import yesman.epicfight.api.client.forgeevent.PrepareModelEvent;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.StaticMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.LayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.LayerUtil;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.client.renderer.patched.layer.RenderOriginalModelLayer;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.mixin.client.MixinLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class PatchedLivingEntityRenderer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends EntityModel<E>, R extends LivingEntityRenderer<E, M>, AM extends SkinnedMesh>
extends PatchedEntityRenderer<E, T, R, AM>
implements LayerRenderer<E, T, M> {
    protected final Map<Class<?>, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>>> patchedLayers = Maps.newHashMap();
    protected final List<PatchedLayer<E, T, M, ? extends RenderLayer<E, M>>> customLayers = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchedLivingEntityRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        ResourceLocation type = EntityType.m_20613_(entityType);
        FileToIdConverter filetoidconverter = FileToIdConverter.m_246568_((String)("animated_layers/" + type.m_135815_()));
        ArrayList layers = Lists.newArrayList();
        for (Map.Entry entry : filetoidconverter.m_247457_(context.m_174026_()).entrySet()) {
            BufferedReader reader = null;
            try {
                reader = ((Resource)entry.getValue()).m_215508_();
                JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)new GsonBuilder().create(), (Reader)reader, JsonElement.class);
                layers.add(Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)jsonelement));
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                EpicFightMod.LOGGER.error("Failed to parse layer file {} for {}", entry.getKey(), (Object)type);
                jsonparseexception.printStackTrace();
            }
            finally {
                try {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        LayerUtil.addLayer(this, entityType, layers);
    }

    public PatchedLivingEntityRenderer<E, T, M, R, AM> initLayerLast(EntityRendererProvider.Context context, EntityType<?> entityType) {
        List vanillaLayers = null;
        if (entityType == EntityType.f_20532_) {
            var5_4 = context.m_174022_().f_114363_.get("default");
            if (var5_4 instanceof LivingEntityRenderer) {
                livingentityrenderer = (LivingEntityRenderer)var5_4;
                vanillaLayers = livingentityrenderer.f_115291_;
            }
        } else {
            var5_4 = context.m_174022_().f_114362_.get(entityType);
            if (var5_4 instanceof LivingEntityRenderer) {
                livingentityrenderer = (LivingEntityRenderer)var5_4;
                vanillaLayers = livingentityrenderer.f_115291_;
            }
        }
        if (vanillaLayers != null) {
            for (RenderLayer layer : vanillaLayers) {
                Class<?> layerClass = layer.getClass();
                if (layerClass.isAnonymousClass()) {
                    layerClass = layer.getClass().getSuperclass();
                }
                if (this.patchedLayers.containsKey(layerClass)) continue;
                this.addPatchedLayer(layerClass, new RenderOriginalModelLayer("Root", new Vec3f(0.0f, this.getDefaultLayerHeightCorrection(), 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
            }
        }
        return this;
    }

    @Override
    public void render(E entity, T entitypatch, R renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        super.render(entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.m_91087_();
        MixinLivingEntityRenderer livingEntityRendererAccessor = (MixinLivingEntityRenderer)renderer;
        boolean isVisible = livingEntityRendererAccessor.invokeIsBodyVisible((LivingEntity)entity);
        boolean isVisibleToPlayer = !isVisible && !entity.m_20177_((Player)mc.f_91074_);
        boolean isGlowing = mc.m_91314_(entity);
        RenderType renderType = livingEntityRendererAccessor.invokeGetRenderType((LivingEntity)entity, isVisible, isVisibleToPlayer, isGlowing);
        Armature armature = ((LivingEntityPatch)entitypatch).getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        this.prepareVanillaModel(entity, (M)renderer.m_7200_(), (LivingEntityRenderer<E, M>)renderer, partialTicks);
        this.setArmaturePose(entitypatch, armature, partialTicks);
        if (renderType != null) {
            SkinnedMesh mesh = (SkinnedMesh)this.getMeshProvider(entitypatch).get();
            this.prepareModel(mesh, entity, entitypatch, renderer);
            PrepareModelEvent prepareModelEvent = new PrepareModelEvent(this, mesh, (LivingEntityPatch<?>)entitypatch, buffer, poseStack, packedLight, partialTicks);
            if (!MinecraftForge.EVENT_BUS.post((Event)prepareModelEvent)) {
                Vector4f color = new Vector4f(1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f);
                ((LivingEntityPatch)entitypatch).getEntityDecorations().modifyColor(color, partialTicks);
                int blockLight = (packedLight & 0xF0) >> 4;
                int skyLight = (packedLight & 0xF00000) >> 20;
                Vec2i lightUv = new Vec2i(blockLight, skyLight);
                ((LivingEntityPatch)entitypatch).getEntityDecorations().modifyLight(lightUv, partialTicks);
                int modifiedLight = LightTexture.m_109885_((int)lightUv.x, (int)lightUv.y);
                mesh.draw(poseStack, buffer, renderType, modifiedLight, color.x(), color.y(), color.z(), color.w(), this.getOverlayCoord(entity, entitypatch, partialTicks), armature, armature.getPoseMatrices());
                ((LivingEntityPatch)entitypatch).getEntityDecorations().listDecorationOverlays().forEach(decorationOverlay -> {
                    if (!decorationOverlay.shouldRemove() && decorationOverlay.shouldRender()) {
                        Vector4f overlayColor = decorationOverlay.color(partialTicks);
                        mesh.draw(poseStack, buffer, decorationOverlay.getRenderType(), modifiedLight, overlayColor.x(), overlayColor.y(), overlayColor.z(), overlayColor.w(), OverlayTexture.f_118083_, armature, armature.getPoseMatrices());
                    }
                });
            }
        }
        if (!entity.m_5833_()) {
            this.renderLayer((LivingEntityRenderer<E, M>)renderer, entitypatch, entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.m_91087_().m_91290_().m_114377_()) {
            ((LivingEntityPatch)entitypatch).getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.m_85849_();
    }

    protected void prepareVanillaModel(E entity, M model, LivingEntityRenderer<E, M> renderer, float partialTicks) {
        Entity entity2;
        boolean shouldSit;
        ((EntityModel)model).f_102609_ = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        ((EntityModel)model).f_102610_ = entity.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entity).f_20886_, (float)((LivingEntity)entity).f_20885_);
        float f2 = f1 - f;
        if (shouldSit && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entity).f_19860_, (float)entity.m_146909_());
        if (LivingEntityRenderer.m_194453_(entity)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        float f7 = ((MixinLivingEntityRenderer)renderer).invokeGetBob((LivingEntity)entity, partialTicks);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            f8 = ((LivingEntity)entity).f_267362_.m_267711_(partialTicks);
            f5 = ((LivingEntity)entity).f_267362_.m_267756_() - ((LivingEntity)entity).f_267362_.m_267731_() * (1.0f - partialTicks);
            if (entity.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        model.m_6839_(entity, f5, f8, partialTicks);
        model.m_6973_(entity, f5, f8, f7, f2, f6);
    }

    protected void prepareModel(AM mesh, E entity, T entitypatch, R renderer) {
        ((StaticMesh)mesh).initialize();
    }

    protected void renderLayer(LivingEntityRenderer<E, M> renderer, T entitypatch, E entity, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        float f = MathUtils.lerpBetween(((LivingEntity)entity).f_20884_, ((LivingEntity)entity).f_20883_, partialTicks);
        float f1 = MathUtils.lerpBetween(((LivingEntity)entity).f_20886_, ((LivingEntity)entity).f_20885_, partialTicks);
        float f2 = f1 - f;
        float f7 = entity.m_5686_(partialTicks);
        float bob = ((MixinLivingEntityRenderer)renderer).invokeGetBob((LivingEntity)entity, partialTicks);
        for (RenderLayer renderLayer : renderer.f_115291_) {
            Class<?> layerClass = renderLayer.getClass();
            if (layerClass.isAnonymousClass()) {
                layerClass = layerClass.getSuperclass();
            }
            if (!this.patchedLayers.containsKey(layerClass)) continue;
            this.patchedLayers.get(layerClass).renderLayer(entity, entitypatch, (RenderLayer<T, M>)renderLayer, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
        for (PatchedLayer patchedLayer : this.customLayers) {
            patchedLayer.renderLayer(entity, entitypatch, null, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
    }

    protected int getOverlayCoord(E entity, T entitypatch, float partialTicks) {
        int initU = 0;
        int initV = OverlayTexture.m_118096_((((LivingEntity)entity).f_20916_ > 0 || ((LivingEntity)entity).f_20919_ > 0 ? 1 : 0) != 0);
        Vec2i coord = new Vec2i(initU, initV);
        ((LivingEntityPatch)entitypatch).getEntityDecorations().modifyOverlay(coord, partialTicks);
        return OverlayTexture.m_118093_((int)coord.x, (int)coord.y);
    }

    @Override
    public void mulPoseStack(PoseStack poseStack, Armature armature, E entity, T entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        if (entity.m_6047_()) {
            poseStack.m_85837_(0.0, 0.15, 0.0);
        }
    }

    @Override
    public void addPatchedLayer(Class<?> originalLayerClass, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>> patchedLayer) {
        this.patchedLayers.putIfAbsent(originalLayerClass, patchedLayer);
    }

    public void addPatchedLayerAlways(Class<?> originalLayerClass, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>> patchedLayer) {
        this.patchedLayers.put(originalLayerClass, patchedLayer);
    }

    @Override
    public void addCustomLayer(PatchedLayer<E, T, M, ? extends RenderLayer<E, M>> patchedLayer) {
        this.customLayers.add(patchedLayer);
    }

    protected float getDefaultLayerHeightCorrection() {
        return 1.15f;
    }
}

