/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.mover;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.MovementDirection;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillCastEvent;

public class PhantomAscentSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac120002");
    private final List<AnimationManager.AnimationAccessor<? extends StaticAnimation>> animations = new ArrayList<AnimationManager.AnimationAccessor<? extends StaticAnimation>>(2);
    private int extraJumps;
    private double jumpPower;

    public PhantomAscentSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
        this.animations.add(Animations.BIPED_PHANTOM_ASCENT_FORWARD);
        this.animations.add(Animations.BIPED_PHANTOM_ASCENT_BACKWARD);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.extraJumps = parameters.m_128451_("extra_jumps");
        this.consumption = 0.2f;
        this.jumpPower = parameters.m_128459_("jump_power");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20202_() != null || !((LocalPlayerPatch)event.getPlayerPatch()).isEpicFightMode() || ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_150110_().f_35935_ || ((LocalPlayerPatch)event.getPlayerPatch()).isHoldingAny() || ((LocalPlayerPatch)event.getPlayerPatch()).getEntityState().inaction()) {
                return;
            }
            boolean jumpPressed = PhantomAscentSkill.isJumpActionPressed();
            boolean jumpPressedPrev = (Boolean)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get());
            if (jumpPressed && !jumpPressedPrev) {
                if (container.getStack() < 1) {
                    return;
                }
                int jumpCounter = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.JUMP_COUNT.get());
                if (jumpCounter > 0 || ((LocalPlayerPatch)event.getPlayerPatch()).currentLivingMotion == LivingMotions.FALL) {
                    if (jumpCounter < this.extraJumps + 1) {
                        SkillCastEvent skillexecuteevent = new SkillCastEvent(container.getExecutor(), container, null);
                        container.getExecutor().getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CAST_EVENT, skillexecuteevent);
                        if (skillexecuteevent.isCanceled()) {
                            return;
                        }
                        container.setResource(0.0f);
                        if (jumpCounter == 0 && ((LocalPlayerPatch)event.getPlayerPatch()).currentLivingMotion == LivingMotions.FALL) {
                            container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), 2);
                        } else {
                            container.getDataManager().setDataF((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), v -> v + 1);
                        }
                        container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), true);
                        float f = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)container.getExecutor().getOriginal()))), (float)0.0f, (float)1.0f);
                        event.sneakingTick(false, f);
                        MovementDirection movementDirection = MovementDirection.fromInputState(event.getInputState());
                        int forward = movementDirection.forward();
                        int backward = movementDirection.backward();
                        int left = movementDirection.left();
                        int right = movementDirection.right();
                        int vertic = movementDirection.vertical();
                        int horizon = movementDirection.horizontal();
                        int degree = -(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon);
                        int scale = forward == 0 && backward == 0 && left == 0 && right == 0 ? 0 : (vertic < 0 ? -1 : 1);
                        float launchingYRot = EpicFightCameraAPI.getInstance().getForwardYRot() + (float)degree;
                        Vec3 horizontalLaunchingDirection = MathUtils.getVectorForRotation(0.0f, launchingYRot).m_82490_(0.15 * (double)scale);
                        Vec3 currentDelta = ((Player)container.getExecutor().getOriginal()).m_20184_();
                        Vec3 newDelta = currentDelta.m_82549_(horizontalLaunchingDirection);
                        ((Player)container.getExecutor().getOriginal()).m_20334_(newDelta.f_82479_, this.jumpPower + (double)((Player)container.getExecutor().getOriginal()).m_285755_(), currentDelta.f_82481_);
                        ((LocalPlayerPatch)event.getPlayerPatch()).setModelYRot(EpicFightCameraAPI.getInstance().getForwardYRot() + (float)degree, true);
                        ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationInClientSide((AssetAccessor<? extends StaticAnimation>)this.animations.get(vertic < 0 ? 1 : 0), 0.0f);
                        ClientEngine.getInstance().controlEngine.releaseAllServedKeys();
                    }
                } else {
                    container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), 1);
                }
            }
            container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get(), jumpPressed);
        });
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            if (event.getDamageSource().m_269533_(DamageTypeTags.f_268549_) && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get())).booleanValue()) {
                float damage = event.getDamage();
                if (damage < 2.5f) {
                    event.attachValueModifier(ValueModifier.setter(0.0f));
                }
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), false);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> {
            container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), 0);
            if (((EntityPatch)event.getPlayerPatch()).isLogicalClient()) {
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get(), false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
    }

    @Override
    public boolean canExecute(SkillContainer container) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(this.extraJumps);
        return list;
    }

    private static boolean isJumpActionPressed() {
        return InputManager.isActionActive(MinecraftInputAction.JUMP);
    }
}

