/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.goal;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AnimatedAttackGoal<T extends MobPatch<?>>
extends Goal {
    protected final T mobpatch;
    protected final CombatBehaviors<T> combatBehaviors;

    public AnimatedAttackGoal(T mobpatch, CombatBehaviors<T> combatBehaviors) {
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
    }

    public boolean m_8036_() {
        return this.checkTargetValid();
    }

    public void m_8037_() {
        CombatBehaviors.Behavior<T> result;
        if (((MobPatch)this.mobpatch).getTarget() == null) {
            return;
        }
        EntityState state = ((LivingEntityPatch)this.mobpatch).getEntityState();
        this.combatBehaviors.tick();
        if (this.combatBehaviors.hasActivatedMove()) {
            CombatBehaviors.Behavior<T> result2;
            if (state.canBasicAttack() && (result2 = this.combatBehaviors.tryProceed()) != null) {
                result2.execute(this.mobpatch);
            }
        } else if (!state.inaction() && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
            result.execute(this.mobpatch);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkTargetValid() {
        LivingEntity livingentity = ((MobPatch)this.mobpatch).getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!(livingentity instanceof Player)) return true;
        Player player = (Player)livingentity;
        if (livingentity.m_5833_()) return false;
        if (player.m_7500_()) return false;
        return true;
    }
}

