/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.eventlistener;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.MainFrameAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.AbstractPlayerEvent;

public class ComboCounterHandleEvent
extends AbstractPlayerEvent<ServerPlayerPatch> {
    private final Causal causal;
    private final AnimationManager.AnimationAccessor<? extends StaticAnimation> animation;
    private final int prevValue;
    private int nextValue;

    public ComboCounterHandleEvent(Causal causal, ServerPlayerPatch playerpatch, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, int prevValue, int nextValue) {
        super(playerpatch, true);
        this.causal = causal;
        this.animation = animation;
        this.prevValue = prevValue;
        this.nextValue = nextValue;
    }

    public Causal getCausal() {
        return this.causal;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getAnimation() {
        return this.animation;
    }

    public int getPrevValue() {
        return this.prevValue;
    }

    public int getNextValue() {
        return this.nextValue;
    }

    public void setNextValue(int nextValue) {
        this.nextValue = nextValue;
    }

    public static enum Causal {
        ANOTHER_ACTION_ANIMATION,
        TIME_EXPIRED;

    }

    @FunctionalInterface
    public static interface ComboCounterHandler {
        public static final ComboCounterHandler DEFAULT_COMBO_HANDLER = (itemCapability, causal, entitypatch, nextAnimation, comboCounter) -> {
            if (causal == Causal.TIME_EXPIRED) {
                return 0;
            }
            List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> comboAnimations = itemCapability.getAutoAttackMotion(entitypatch);
            if (comboAnimations == null) {
                return 0;
            }
            HashSet attackMotionSet = Sets.newHashSet(comboAnimations);
            if (!attackMotionSet.contains(nextAnimation)) {
                return 0;
            }
            int comboSize = comboAnimations.size();
            if (nextAnimation.equals(comboAnimations.get(comboSize - 1)) || nextAnimation.equals(comboAnimations.get(comboSize - 2))) {
                return 0;
            }
            return comboCounter;
        };

        public int handleComboCounter(CapabilityItem var1, Causal var2, PlayerPatch<?> var3, @Nullable AnimationManager.AnimationAccessor<? extends MainFrameAnimation> var4, int var5);
    }
}

