/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.mojang.datafixers.util.Pair;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ServerAnimator
extends Animator {
    public final AnimationPlayer animationPlayer;
    protected DynamicAnimation nextPlaying;
    private final LinkAnimation linkAnimation;
    public boolean pause = false;

    public static Animator getAnimator(LivingEntityPatch<?> entitypatch) {
        return new ServerAnimator(entitypatch);
    }

    public ServerAnimator(LivingEntityPatch<?> entitypatch) {
        this.entitypatch = entitypatch;
        this.linkAnimation = new LinkAnimation();
        this.animationPlayer = new AnimationPlayer();
    }

    @Override
    public void playAnimation(StaticAnimation nextAnimation, float modifyTime) {
        this.pause = false;
        Pose lastPose = this.animationPlayer.getAnimation().getPoseByTime(this.entitypatch, 0.0f, 0.0f);
        this.animationPlayer.getAnimation().end(this.entitypatch, nextAnimation, this.animationPlayer.isEnd());
        nextAnimation.begin(this.entitypatch);
        if (!nextAnimation.isMetaAnimation()) {
            nextAnimation.setLinkAnimation(this.animationPlayer.getAnimation(), lastPose, true, modifyTime, this.entitypatch, this.linkAnimation);
            this.linkAnimation.putOnPlayer(this.animationPlayer, this.entitypatch);
            this.entitypatch.updateEntityState();
            this.nextPlaying = nextAnimation;
        }
    }

    @Override
    public void playAnimationInstantly(StaticAnimation nextAnimation) {
        this.pause = false;
        this.animationPlayer.getAnimation().end(this.entitypatch, nextAnimation, this.animationPlayer.isEnd());
        nextAnimation.begin(this.entitypatch);
        nextAnimation.putOnPlayer(this.animationPlayer, this.entitypatch);
        this.entitypatch.updateEntityState();
    }

    @Override
    public void reserveAnimation(StaticAnimation nextAnimation) {
        this.pause = false;
        this.nextPlaying = nextAnimation;
    }

    @Override
    public void tick() {
        if (this.pause) {
            this.entitypatch.updateEntityState();
            return;
        }
        this.animationPlayer.tick(this.entitypatch);
        this.entitypatch.updateEntityState();
        if (this.animationPlayer.isEnd()) {
            DynamicAnimation nextAnimation = this.nextPlaying == null ? Animations.DUMMY_ANIMATION : this.nextPlaying;
            this.animationPlayer.getAnimation().end(this.entitypatch, nextAnimation, true);
            if (this.nextPlaying == null) {
                Animations.DUMMY_ANIMATION.putOnPlayer(this.animationPlayer, this.entitypatch);
                this.pause = true;
            } else {
                if (!this.animationPlayer.getAnimation().isLinkAnimation() && !this.nextPlaying.isLinkAnimation()) {
                    this.nextPlaying.begin(this.entitypatch);
                }
                this.nextPlaying.putOnPlayer(this.animationPlayer, this.entitypatch);
                this.nextPlaying = null;
            }
        } else {
            this.animationPlayer.getAnimation().tick(this.entitypatch);
        }
    }

    @Override
    public Pose getPose(float partialTicks) {
        return this.animationPlayer.getCurrentPose(this.entitypatch, partialTicks);
    }

    @Override
    public AnimationPlayer getPlayerFor(DynamicAnimation playingAnimation) {
        return this.animationPlayer;
    }

    @Override
    public <T> Pair<AnimationPlayer, T> findFor(Class<T> animationType) {
        return animationType.isAssignableFrom(this.animationPlayer.getAnimation().getClass()) ? Pair.of((Object)this.animationPlayer, (Object)this.animationPlayer.getAnimation()) : null;
    }

    @Override
    public EntityState getEntityState() {
        return this.animationPlayer.getAnimation().getState(this.entitypatch, this.animationPlayer.getElapsedTime());
    }
}

