/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.Map;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.utils.datastruct.TypeFlexibleHashMap;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class LinkAnimation
extends DynamicAnimation {
    private final AnimationClip animationClip = new AnimationClip();
    protected DynamicAnimation fromAnimation;
    protected StaticAnimation toAnimation;
    protected float nextStartTime;

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        this.toAnimation.linkTick(entitypatch, this);
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        if (!isEnd) {
            this.toAnimation.end(entitypatch, nextAnimation, isEnd);
        } else if (this.nextStartTime > 0.0f) {
            ((Animator)entitypatch.getAnimator()).getPlayerFor(this).setElapsedTime(this.nextStartTime);
            ((Animator)entitypatch.getAnimator()).getPlayerFor(this).markToDoNotReset();
        }
    }

    @Override
    public TypeFlexibleHashMap<EntityState.StateFactor<?>> getStatesMap(LivingEntityPatch<?> entitypatch, float time) {
        TypeFlexibleHashMap<EntityState.StateFactor<?>> map = this.toAnimation.getStatesMap(entitypatch, Math.max(time - this.getTotalTime(), 0.0f));
        for (Map.Entry entry : map.entrySet()) {
            Object val = this.toAnimation.getModifiedLinkState((EntityState.StateFactor)entry.getKey(), entry.getValue(), entitypatch, time);
            map.put((EntityState.StateFactor)entry.getKey(), val);
        }
        return map;
    }

    @Override
    public EntityState getState(LivingEntityPatch<?> entitypatch, float time) {
        EntityState state = this.toAnimation.getState(entitypatch, Math.max(time - this.getTotalTime(), 0.0f));
        TypeFlexibleHashMap<EntityState.StateFactor<?>> map = state.getStateMap();
        for (Map.Entry entry : map.entrySet()) {
            Object val = this.toAnimation.getModifiedLinkState((EntityState.StateFactor)entry.getKey(), entry.getValue(), entitypatch, time);
            map.put((EntityState.StateFactor)entry.getKey(), val);
        }
        return state;
    }

    @Override
    public <T> T getState(EntityState.StateFactor<T> stateFactor, LivingEntityPatch<?> entitypatch, float time) {
        T state = this.toAnimation.getState(stateFactor, entitypatch, Math.max(time - this.getTotalTime(), 0.0f));
        return (T)this.toAnimation.getModifiedLinkState(stateFactor, state, entitypatch, time);
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose nextStartingPose = this.toAnimation.getPoseByTime(entitypatch, this.nextStartTime, 1.0f);
        for (Map.Entry<String, JointTransform> entry : nextStartingPose.getJointTransformData().entrySet()) {
            if (!this.animationClip.hasJointTransform(entry.getKey())) continue;
            Keyframe[] keyframe = this.animationClip.getJointTransform(entry.getKey()).getKeyframes();
            JointTransform jt = keyframe[keyframe.length - 1].transform();
            JointTransform newJt = nextStartingPose.getJointTransformData().get(entry.getKey());
            newJt.translation().set(jt.translation());
            jt.copyFrom(newJt);
        }
        return super.getPoseByTime(entitypatch, time, partialTicks);
    }

    @Override
    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        if (this.toAnimation instanceof ActionAnimation) {
            JointTransform jt = pose.getOrDefaultTransform("Root");
            Vec3f jointPosition = jt.translation();
            OpenMatrix4f toRootTransformApplied = entitypatch.getArmature().searchJointByName("Root").getLocalTrasnform().removeTranslation();
            OpenMatrix4f toOrigin = OpenMatrix4f.invert(toRootTransformApplied, null);
            Vec3f worldPosition = OpenMatrix4f.transform3v(toRootTransformApplied, jointPosition, null);
            worldPosition.x = 0.0f;
            worldPosition.y = this.toAnimation.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false && worldPosition.y > 0.0f ? 0.0f : worldPosition.y;
            worldPosition.z = 0.0f;
            OpenMatrix4f.transform3v(toOrigin, worldPosition, worldPosition);
            jointPosition.x = worldPosition.x;
            jointPosition.y = worldPosition.y;
            jointPosition.z = worldPosition.z;
        }
    }

    @Override
    public float getPlaySpeed(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        return this.toAnimation.getPlaySpeed(entitypatch, animation);
    }

    public void setConnectedAnimations(DynamicAnimation from, StaticAnimation to) {
        this.fromAnimation = from.getRealAnimation();
        this.toAnimation = to;
    }

    public DynamicAnimation getNextAnimation() {
        return this.toAnimation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<JointMaskEntry> getJointMaskEntry(LivingEntityPatch<?> entitypatch, boolean useCurrentMotion) {
        return useCurrentMotion ? this.toAnimation.getJointMaskEntry(entitypatch, true) : this.fromAnimation.getJointMaskEntry(entitypatch, false);
    }

    @Override
    public boolean isMainFrameAnimation() {
        return this.toAnimation.isMainFrameAnimation();
    }

    @Override
    public boolean isReboundAnimation() {
        return this.toAnimation.isReboundAnimation();
    }

    @Override
    public boolean doesHeadRotFollowEntityHead() {
        return this.fromAnimation.doesHeadRotFollowEntityHead() && this.toAnimation.doesHeadRotFollowEntityHead();
    }

    @Override
    public DynamicAnimation getRealAnimation() {
        return this.toAnimation;
    }

    public DynamicAnimation getFromAnimation() {
        return this.fromAnimation;
    }

    public void copyTo(LinkAnimation dest) {
        dest.setConnectedAnimations(this.fromAnimation, this.toAnimation);
        dest.setTotalTime(this.getTotalTime());
        Map<String, TransformSheet> trnasforms = dest.getTransfroms();
        trnasforms.clear();
        trnasforms.putAll(this.getTransfroms());
    }

    public float getNextStartTime() {
        return this.nextStartTime;
    }

    public void setNextStartTime(float nextStartTime) {
        this.nextStartTime = nextStartTime;
    }

    public void resetNextStartTime() {
        this.nextStartTime = 0.0f;
    }

    @Override
    public boolean isLinkAnimation() {
        return true;
    }

    public String toString() {
        return "From " + this.fromAnimation + " to " + this.toAnimation;
    }

    @Override
    public AnimationClip getAnimationClip() {
        return this.animationClip;
    }
}

