/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.StateSpectrum;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.client.model.ItemSkin;
import yesman.epicfight.api.client.model.ItemSkins;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.api.utils.datastruct.TypeFlexibleHashMap;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.AnimationBeginEvent;
import yesman.epicfight.world.entity.eventlistener.AnimationEndEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class StaticAnimation
extends DynamicAnimation
implements AnimationProvider<StaticAnimation> {
    protected final Map<AnimationProperty<?>, Object> properties = Maps.newHashMap();
    protected final StateSpectrum.Blueprint stateSpectrumBlueprint = new StateSpectrum.Blueprint();
    protected final Armature armature;
    protected final int animationId;
    protected final ResourceLocation registryName;
    protected final StateSpectrum stateSpectrum = new StateSpectrum();
    protected ResourceLocation resourceLocation;
    private final String filehash;

    public StaticAnimation() {
        super(0.0f, true);
        this.resourceLocation = null;
        this.registryName = null;
        this.armature = null;
        this.animationId = -1;
        this.filehash = "";
    }

    public StaticAnimation(boolean repeatPlay, String path, Armature armature) {
        this(0.15f, repeatPlay, path, armature);
    }

    public StaticAnimation(float convertTime, boolean isRepeat, String path, Armature armature) {
        super(convertTime, isRepeat);
        String fileHash;
        int colon = path.indexOf(58);
        String modid = colon == -1 ? AnimationManager.getInstance().workingModId() : path.substring(0, colon);
        String folderPath = colon == -1 ? path : path.substring(colon + 1);
        this.resourceLocation = new ResourceLocation(modid, "animmodels/animations/" + folderPath + ".json");
        this.registryName = new ResourceLocation(modid, folderPath);
        this.armature = armature;
        this.animationId = AnimationManager.getInstance().registerAnimation(this);
        try {
            JsonModelLoader jsonfile = new JsonModelLoader(AnimationManager.getAnimationResourceManager(), this.resourceLocation);
            fileHash = jsonfile.getFileHash();
        }
        catch (NoSuchElementException e) {
            fileHash = "";
        }
        this.filehash = fileHash;
    }

    public StaticAnimation(float convertTime, boolean repeatPlay, String path, Armature armature, boolean noRegister) {
        super(convertTime, repeatPlay);
        int colon = path.indexOf(58);
        String modid = colon == -1 ? AnimationManager.getInstance().workingModId() : path.substring(0, colon);
        String folderPath = colon == -1 ? path : path.substring(colon + 1);
        this.resourceLocation = new ResourceLocation(modid, "animmodels/animations/" + folderPath + ".json");
        this.registryName = new ResourceLocation(modid, folderPath);
        this.armature = armature;
        if (noRegister) {
            this.animationId = -1;
            this.filehash = "";
        } else {
            String fileHash;
            this.animationId = AnimationManager.getInstance().registerAnimation(this);
            try {
                JsonModelLoader jsonfile = new JsonModelLoader(AnimationManager.getAnimationResourceManager(), this.resourceLocation);
                fileHash = jsonfile.getFileHash();
            }
            catch (NoSuchElementException e) {
                fileHash = "";
            }
            this.filehash = fileHash;
        }
    }

    public StaticAnimation(ResourceLocation baseAnimPath, float convertTime, boolean repeatPlay, String registryName, Armature armature, boolean multilayer) {
        super(convertTime, repeatPlay);
        this.resourceLocation = baseAnimPath;
        this.registryName = new ResourceLocation(registryName);
        this.armature = armature;
        this.animationId = -1;
        this.filehash = "";
    }

    public static void loadClip(ResourceManager resourceManager, StaticAnimation animation) throws Exception {
        JsonModelLoader modelLoader = new JsonModelLoader(resourceManager, animation.resourceLocation);
        AnimationManager.getInstance().loadAnimationClip(animation, modelLoader::loadClipForAnimation);
    }

    public static void loadAllJointsClip(ResourceManager resourceManager, StaticAnimation animation) throws Exception {
        JsonModelLoader modelLoader = new JsonModelLoader(resourceManager, animation.resourceLocation);
        AnimationManager.getInstance().loadAnimationClip(animation, modelLoader::loadAllJointsClipForAnimation);
    }

    public void loadAnimation(ResourceManager resourceManager) {
        try {
            StaticAnimation.loadClip(resourceManager, this);
        }
        catch (Exception e) {
            AnimationManager.getInstance().onFailed(this);
            EpicFightMod.LOGGER.warn("Failed to load animation: " + this.resourceLocation);
            e.printStackTrace();
        }
    }

    public void postInit() {
        this.stateSpectrum.readFrom(this.stateSpectrumBlueprint);
    }

    public void setLinkAnimation(DynamicAnimation fromAnimation, Pose startPose, boolean isOnSameLayer, float convertTimeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        if (!entitypatch.isLogicalClient()) {
            startPose = Animations.DUMMY_ANIMATION.getPoseByTime(entitypatch, 0.0f, 1.0f);
        }
        dest.resetNextStartTime();
        float playTime = this.getPlaySpeed(entitypatch, dest);
        AnimationProperty.PlaybackSpeedModifier playSpeedModifier = this.getRealAnimation().getProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER).orElse(null);
        if (playSpeedModifier != null) {
            playTime = playSpeedModifier.modify(dest, entitypatch, playTime, 0.0f, playTime);
        }
        playTime = Math.abs(playTime);
        float linkTime = convertTimeModifier > 0.0f ? convertTimeModifier + this.convertTime : this.convertTime;
        float totalTime = (playTime *= 0.05f) * (float)((int)Math.ceil(linkTime / playTime));
        float nextStartTime = Math.max(0.0f, -convertTimeModifier);
        dest.setNextStartTime(nextStartTime += totalTime - linkTime);
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime);
        dest.setConnectedAnimations(fromAnimation, this);
        Map<String, JointTransform> data1 = startPose.getJointTransformData();
        Map<String, JointTransform> data2 = this.getPoseByTime(entitypatch, nextStartTime, 0.0f).getJointTransformData();
        HashSet<String> joint1 = new HashSet<String>(isOnSameLayer ? data1.keySet() : Set.of());
        HashSet<String> joint2 = new HashSet<String>(data2.keySet());
        if (entitypatch.isLogicalClient()) {
            JointMaskEntry entry = fromAnimation.getJointMaskEntry(entitypatch, false).orElse(null);
            JointMaskEntry entry2 = this.getJointMaskEntry(entitypatch, true).orElse(null);
            if (entry != null) {
                joint1.removeIf(jointName -> entry.isMasked(fromAnimation.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER) == Layer.LayerType.BASE_LAYER ? entitypatch.getClientAnimator().currentMotion() : entitypatch.getClientAnimator().currentCompositeMotion(), (String)jointName));
            }
            if (entry2 != null) {
                joint2.removeIf(jointName -> entry2.isMasked(this.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER) == Layer.LayerType.BASE_LAYER ? entitypatch.getCurrentLivingMotion() : entitypatch.currentCompositeMotion, (String)jointName));
            }
        }
        joint1.addAll(joint2);
        if (linkTime != totalTime) {
            Map<String, JointTransform> firstPose = this.getPoseByTime(entitypatch, 0.0f, 0.0f).getJointTransformData();
            for (String jointName2 : joint1) {
                Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.get(jointName2)), new Keyframe(linkTime, firstPose.get(jointName2)), new Keyframe(totalTime, data2.get(jointName2))};
                TransformSheet sheet = new TransformSheet(keyframes);
                dest.getAnimationClip().addJointTransform(jointName2, sheet);
            }
        } else {
            for (String jointName3 : joint1) {
                Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.get(jointName3)), new Keyframe(totalTime, data2.get(jointName3))};
                TransformSheet sheet = new TransformSheet(keyframes);
                dest.getAnimationClip().addJointTransform(jointName3, sheet);
            }
        }
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        this.getAnimationClip();
        this.getProperty(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS).ifPresent(events -> {
            for (AnimationEvent event : events) {
                event.executeIfRightSide(entitypatch, this);
            }
        });
        if (entitypatch.isLogicalClient()) {
            this.getProperty(ClientAnimationProperties.TRAIL_EFFECT).ifPresent(trailInfos -> {
                int idx = 0;
                for (TrailInfo trailInfo : trailInfos) {
                    ItemStack stack;
                    ItemSkin itemSkin;
                    double eid = Double.longBitsToDouble(((LivingEntity)entitypatch.getOriginal()).m_19879_());
                    double animid = Double.longBitsToDouble(this.animationId);
                    double jointId = Double.longBitsToDouble(this.armature.searchJointByName(trailInfo.joint).getId());
                    double index = Double.longBitsToDouble(idx++);
                    if (trailInfo.hand != null && (itemSkin = ItemSkins.getItemSkin((stack = ((LivingEntity)entitypatch.getOriginal()).m_21120_(trailInfo.hand)).m_41720_())) != null && itemSkin.trailInfo() != null) {
                        trailInfo = itemSkin.trailInfo().overwrite(trailInfo);
                    }
                    if (!trailInfo.playable()) continue;
                    ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)trailInfo.particle, eid, 0.0, animid, jointId, index, 0.0);
                }
            });
        }
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, new AnimationBeginEvent(playerpatch, this));
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ANIMATION_END_EVENT, new AnimationEndEvent(playerpatch, this, isEnd));
        }
        this.getProperty(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS).ifPresent(events -> {
            for (AnimationEvent event : events) {
                event.executeIfRightSide(entitypatch, this);
            }
        });
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        this.getProperty(AnimationProperty.StaticAnimationProperty.EVENTS).ifPresent(events -> {
            for (AnimationEvent event : events) {
                event.executeIfRightSide(entitypatch, this);
            }
        });
        this.getProperty(AnimationProperty.StaticAnimationProperty.TIME_STAMPED_EVENTS).ifPresent(events -> {
            AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this);
            if (player != null) {
                float prevElapsed = player.getPrevElapsedTime();
                float elapsed = player.getElapsedTime();
                for (AnimationEvent.TimeStampedEvent event : events) {
                    event.executeIfRightSide(entitypatch, this, prevElapsed, elapsed);
                }
            }
        });
        this.getProperty(AnimationProperty.StaticAnimationProperty.TIME_PERIOD_EVENTS).ifPresent(events -> {
            AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this);
            if (player != null) {
                float prevElapsed = player.getPrevElapsedTime();
                float elapsed = player.getElapsedTime();
                for (AnimationEvent.TimePeriodEvent event : events) {
                    event.executeIfRightSide(entitypatch, this, prevElapsed, elapsed);
                }
            }
        });
    }

    @Override
    public EntityState getState(LivingEntityPatch<?> entitypatch, float time) {
        return new EntityState(this.getStatesMap(entitypatch, time));
    }

    @Override
    public TypeFlexibleHashMap<EntityState.StateFactor<?>> getStatesMap(LivingEntityPatch<?> entitypatch, float time) {
        return this.stateSpectrum.getStateMap(entitypatch, time);
    }

    @Override
    public <T> T getState(EntityState.StateFactor<T> stateFactor, LivingEntityPatch<?> entitypatch, float time) {
        return this.stateSpectrum.getSingleState(stateFactor, entitypatch, time);
    }

    @Override
    public Optional<JointMaskEntry> getJointMaskEntry(LivingEntityPatch<?> entitypatch, boolean useCurrentMotion) {
        return this.getProperty(ClientAnimationProperties.JOINT_MASK);
    }

    @Override
    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        entitypatch.poseTick(animation, pose, time, partialTicks);
        this.getProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER).ifPresent(poseModifier -> poseModifier.modify(animation, pose, entitypatch, time, partialTicks));
    }

    @Override
    public boolean isStaticAnimation() {
        return true;
    }

    @Override
    public boolean doesHeadRotFollowEntityHead() {
        return this.getProperty(AnimationProperty.StaticAnimationProperty.FIXED_HEAD_ROTATION).orElse(false) == false;
    }

    @Override
    public int getId() {
        return this.animationId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StaticAnimation) {
            StaticAnimation staticAnimation = (StaticAnimation)obj;
            return this.getId() == staticAnimation.getId();
        }
        return super.equals(obj);
    }

    public boolean idBetween(StaticAnimation a1, StaticAnimation a2) {
        return a1.getId() <= this.getId() && a2.getId() >= this.getId();
    }

    public boolean in(StaticAnimation[] animations) {
        for (StaticAnimation animation : animations) {
            if (!this.equals(animation)) continue;
            return true;
        }
        return false;
    }

    public boolean in(AnimationProvider[] animationProviders) {
        for (AnimationProvider animationProvider : animationProviders) {
            if (!this.equals(animationProvider.get())) continue;
            return true;
        }
        return false;
    }

    public StaticAnimation setResourceLocation(String path) {
        int colon = path.indexOf(58);
        String modid = colon == -1 ? AnimationManager.getInstance().workingModId() : path.substring(0, colon);
        String folderPath = colon == -1 ? path : path.substring(colon + 1);
        this.resourceLocation = new ResourceLocation(modid, "animmodels/animations/" + folderPath + ".json");
        return this;
    }

    public ResourceLocation getLocation() {
        return this.resourceLocation;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Armature getArmature() {
        return this.armature;
    }

    public String getFileHash() {
        return this.filehash;
    }

    @Override
    public float getPlaySpeed(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        return 1.0f;
    }

    @Override
    public TransformSheet getCoord() {
        return this.getProperty(AnimationProperty.ActionAnimationProperty.COORD).orElse(super.getCoord());
    }

    public String toString() {
        String classPath = this.getClass().toString();
        return classPath.substring(classPath.lastIndexOf(".") + 1) + " " + this.getLocation();
    }

    @Deprecated
    public StaticAnimation addPropertyUnsafe(AnimationProperty<?> propertyType, Object value) {
        this.properties.put(propertyType, value);
        return this;
    }

    public <V> StaticAnimation addProperty(AnimationProperty.StaticAnimationProperty<V> propertyType, V value) {
        this.properties.put(propertyType, value);
        return this;
    }

    public StaticAnimation addEvents(AnimationProperty.StaticAnimationProperty<?> key, AnimationEvent ... events) {
        this.properties.put(key, events);
        return this;
    }

    public <V extends AnimationEvent> StaticAnimation addEvents(AnimationEvent.TimeStampedEvent ... events) {
        this.properties.put(AnimationProperty.StaticAnimationProperty.TIME_STAMPED_EVENTS, events);
        return this;
    }

    public <V extends AnimationEvent> StaticAnimation addEvents(AnimationEvent.TimePeriodEvent ... events) {
        this.properties.put(AnimationProperty.StaticAnimationProperty.TIME_PERIOD_EVENTS, events);
        return this;
    }

    @Override
    public <V> Optional<V> getProperty(AnimationProperty<V> propertyType) {
        return Optional.ofNullable(this.properties.get(propertyType));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.getProperty(ClientAnimationProperties.PRIORITY).orElse(Layer.Priority.LOWEST);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Layer.LayerType getLayerType() {
        return this.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER);
    }

    public StaticAnimation newTimePair(float start, float end) {
        this.stateSpectrumBlueprint.newTimePair(start, end);
        return this;
    }

    public StaticAnimation newConditionalTimePair(Function<LivingEntityPatch<?>, Integer> condition, float start, float end) {
        this.stateSpectrumBlueprint.newConditionalTimePair(condition, start, end);
        return this;
    }

    public <T> StaticAnimation addState(EntityState.StateFactor<T> factor, T val) {
        this.stateSpectrumBlueprint.addState(factor, val);
        return this;
    }

    public <T> StaticAnimation removeState(EntityState.StateFactor<T> factor) {
        this.stateSpectrumBlueprint.removeState(factor);
        return this;
    }

    public <T> StaticAnimation addConditionalState(int metadata, EntityState.StateFactor<T> factor, T val) {
        this.stateSpectrumBlueprint.addConditionalState(metadata, factor, val);
        return this;
    }

    public <T> StaticAnimation addStateRemoveOld(EntityState.StateFactor<T> factor, T val) {
        this.stateSpectrumBlueprint.addStateRemoveOld(factor, val);
        return this;
    }

    public <T> StaticAnimation addStateIfNotExist(EntityState.StateFactor<T> factor, T val) {
        this.stateSpectrumBlueprint.addStateIfNotExist(factor, val);
        return this;
    }

    public Object getModifiedLinkState(EntityState.StateFactor<?> factor, Object val, LivingEntityPatch<?> entitypatch, float elapsedTime) {
        return val;
    }

    @Override
    public AnimationClip getAnimationClip() {
        return AnimationManager.getInstance().getStaticAnimationClip(this);
    }

    public List<StaticAnimation> getClipHolders() {
        return List.of(this);
    }

    @Override
    public StaticAnimation get() {
        return AnimationManager.getInstance().refreshAnimation(this);
    }
}

