/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.datapack;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.AirSlashAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.BasicAttackAnimation;
import yesman.epicfight.api.animation.types.DashAttackAnimation;
import yesman.epicfight.api.animation.types.HitAnimation;
import yesman.epicfight.api.animation.types.KnockdownAnimation;
import yesman.epicfight.api.animation.types.LongHitAnimation;
import yesman.epicfight.api.animation.types.MovementAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.datapack.ClipHoldingAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeAirSlashAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeAttackAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeBasicAttackAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeDashAttackAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeHitAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeKnockdownAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeLongHitAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeMovementAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeStaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimationDataReader;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class FakeAnimation
extends StaticAnimation {
    private AnimationType animationType;
    private AnimationClip animationClip;
    private Map<String, Object> constructorParams = Maps.newLinkedHashMap();
    private JsonArray rawAnimation;
    private JsonObject properties = new JsonObject();
    private static final Map<AnimationType, Map<String, Class<?>>> PARAMETERS = Maps.newHashMap();
    private static final Map<AnimationType, Class<? extends ClipHoldingAnimation>> FAKE_ANIMATIONS = Maps.newHashMap();

    public FakeAnimation(String path, Armature armature, AnimationClip clip, JsonArray rawAnimation) {
        super(new ResourceLocation(""), 0.0f, false, "", armature, true);
        this.animationClip = clip;
        this.rawAnimation = rawAnimation;
        this.constructorParams.put("path", path);
        this.constructorParams.put("armature", armature);
    }

    public <T> T getParameter(String key) {
        return (T)this.constructorParams.get(key);
    }

    public void setParameter(String key, Object value) {
        if (!this.constructorParams.containsKey(key)) {
            throw new IllegalStateException("No key " + key);
        }
        this.constructorParams.put(key, value);
    }

    public AnimationType getAnimationClass() {
        return this.animationType;
    }

    public JsonObject getPropertiesJson() {
        return this.properties;
    }

    public void setAnimationClass(AnimationType animationClass) {
        String prevPath = (String)this.getParameter("path");
        this.constructorParams.clear();
        PARAMETERS.get((Object)animationClass).keySet().forEach(k -> this.constructorParams.put((String)k, null));
        this.setParameter("armature", this.getArmature());
        this.setParameter("path", prevPath);
        if (AttackAnimation.class.isAssignableFrom(animationClass.getAnimationClass())) {
            this.setParameter("phases", new ListTag());
        }
        this.animationType = animationClass;
    }

    @Override
    public float getConvertTime() {
        Object convTime = this.getParameter("convertTime");
        return convTime == null ? 0.0f : ((Float)convTime).floatValue();
    }

    @Override
    public AnimationClip getAnimationClip() {
        return this.animationClip;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation((String)this.constructorParams.get("path"));
    }

    @Override
    public void putOnPlayer(AnimationPlayer animationPlayer, LivingEntityPatch<?> entitypatch) {
        animationPlayer.setPlayAnimation(this);
        animationPlayer.tick(entitypatch);
    }

    public JsonArray getRawAnimationJson() {
        return this.rawAnimation;
    }

    public String getInvocationCommand() throws Exception {
        if (this.animationType == null) {
            throw new IllegalStateException("Animation type is not defined.");
        }
        switch (this.animationType) {
            case STATIC: 
            case MOVEMENT: {
                return String.format("(%s#F,%b#Z,%s#java.lang.String,%s#" + Armature.class.getTypeName() + ")#%s", this.constructorParams.get("convertTime"), this.constructorParams.get("isRepeat"), this.constructorParams.get("path"), this.constructorParams.get("armature"), this.animationType.animCls.getTypeName());
            }
            case SHORT_HIT: 
            case LONG_HIT: 
            case KNOCK_DOWN: {
                return String.format("(%s#F,%s#java.lang.String,%s#" + Armature.class.getTypeName() + ")#%s", this.constructorParams.get("convertTime"), this.constructorParams.get("path"), this.constructorParams.get("armature"), this.animationType.animCls.getTypeName());
            }
            case ATTACK: 
            case BASIC_ATTACK: 
            case DASH_ATTACK: 
            case AIR_SLASH: {
                ListTag phasesTag = (ListTag)this.getParameter("phases");
                StringBuilder sb = new StringBuilder("[");
                float start = 0.0f;
                for (int i = 0; i < phasesTag.size(); ++i) {
                    Object colliderInvokeCommand;
                    float end;
                    CompoundTag phaseCompound = phasesTag.m_128728_(i);
                    float antic = phaseCompound.m_128457_("antic");
                    float preDelay = phaseCompound.m_128457_("preDelay");
                    float contact = phaseCompound.m_128457_("contact");
                    float recovery = phaseCompound.m_128457_("recovery");
                    if (i < phasesTag.size() - 1) {
                        CompoundTag nextTag = phasesTag.m_128728_(i + 1);
                        end = nextTag.m_128457_("antic");
                    } else {
                        end = recovery;
                    }
                    String hand = phaseCompound.m_128461_("hand");
                    String joint = phaseCompound.m_128461_("joint");
                    if (phaseCompound.m_128441_("collider")) {
                        CompoundTag colliderTag = phaseCompound.m_128469_("collider");
                        int colliderCount = colliderTag.m_128451_("number");
                        ListTag center = colliderTag.m_128437_("center", 6);
                        ListTag size = colliderTag.m_128437_("size", 6);
                        colliderInvokeCommand = colliderCount == 1 ? String.format("(%s#D,%s#D,%s#D,%s#D,%s#D,%s#D)#%s", size.get(0), size.get(1), size.get(2), center.get(0), center.get(1), center.get(2), OBBCollider.class.getTypeName()) : String.format("(%d#I,%s#D,%s#D,%s#D,%s#D,%s#D,%s#D)#%s", colliderCount, size.get(0), size.get(1), size.get(2), center.get(0), center.get(1), center.get(2), MultiOBBCollider.class.getTypeName());
                    } else {
                        colliderInvokeCommand = "null#" + Collider.class.getTypeName();
                    }
                    sb.append(String.format("(%s#F,%s#F,%s#F,%s#F,%s#F,%s#F,%s#net.minecraft.world.InteractionHand,%s#" + Joint.class.getTypeName() + ",%s)", Float.valueOf(start), Float.valueOf(antic), Float.valueOf(preDelay), Float.valueOf(contact), Float.valueOf(recovery), Float.valueOf(end), hand, joint, colliderInvokeCommand));
                    if (i >= phasesTag.size() - 1) continue;
                    sb.append(",");
                    start = end;
                }
                sb.append("]#" + AttackAnimation.Phase.class.getTypeName());
                return String.format("(%s#F,%s#java.lang.String,%s#" + Armature.class.getTypeName() + ",%s)#%s", this.constructorParams.get("convertTime"), this.constructorParams.get("path"), this.constructorParams.get("armature"), sb.toString(), this.animationType.animCls.getTypeName());
            }
        }
        throw new IllegalStateException("Invalid animation type: " + this.animationType);
    }

    public FakeAnimation deepCopy() {
        FakeAnimation fakeAnimation = new FakeAnimation((String)this.getParameter("path"), this.armature, this.animationClip, this.rawAnimation);
        fakeAnimation.animationType = this.animationType;
        fakeAnimation.constructorParams.clear();
        fakeAnimation.constructorParams.putAll(this.constructorParams);
        fakeAnimation.rawAnimation = this.rawAnimation;
        fakeAnimation.properties = this.properties;
        return fakeAnimation;
    }

    public ClipHoldingAnimation createAnimation() throws Throwable {
        try {
            if (this.animationType == null) {
                throw new IllegalStateException("Animation type is not defined.");
            }
            Map<String, Class<?>> map = PARAMETERS.get((Object)this.animationType);
            Class[] paramClasses = map.values().toArray(new Class[0]);
            Object[] params = this.constructorParams.values().toArray();
            Constructor<? extends ClipHoldingAnimation> constructor = FakeAnimation.switchType(this.animationType).getConstructor(paramClasses);
            ClipHoldingAnimation animation = constructor.newInstance(params);
            animation.setAnimationClip(this.animationClip);
            animation.setCreator(this);
            ClientAnimationDataReader clientDataReader = ClientAnimationDataReader.DESERIALIZER.deserialize((JsonElement)this.properties, null, null);
            clientDataReader.applyClientData(animation.cast());
            return animation;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<String, Object>> iter = this.constructorParams.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                sb.append(String.format(iter.hasNext() ? "%s(%s:%s), " : "%s(%s:%s)", entry.getKey(), entry.getValue(), entry.getValue() == null ? null : entry.getValue().getClass().getSimpleName()));
            }
            throw new IllegalArgumentException(String.format("Invalid arguments for %s: %s", ParseUtil.snakeToSpacedCamel(this.animationType.toString()), sb.toString()));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw e.getTargetException();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Class<? extends ClipHoldingAnimation> switchType(AnimationType cls) {
        return FAKE_ANIMATIONS.get((Object)cls);
    }

    public static Class<? extends ClipHoldingAnimation> switchType(Class<? extends StaticAnimation> cls) {
        for (AnimationType animType : AnimationType.values()) {
            if (animType.animCls != cls) continue;
            return FAKE_ANIMATIONS.get((Object)animType);
        }
        return FakeStaticAnimation.class;
    }

    static {
        LinkedHashMap staticAnimationParameters = Maps.newLinkedHashMap();
        staticAnimationParameters.put("convertTime", Float.TYPE);
        staticAnimationParameters.put("isRepeat", Boolean.TYPE);
        staticAnimationParameters.put("path", String.class);
        staticAnimationParameters.put("armature", Armature.class);
        LinkedHashMap hitAnimationParameters = Maps.newLinkedHashMap();
        hitAnimationParameters.put("convertTime", Float.TYPE);
        hitAnimationParameters.put("path", String.class);
        hitAnimationParameters.put("armature", Armature.class);
        LinkedHashMap attackAnimationParameters = Maps.newLinkedHashMap();
        attackAnimationParameters.put("convertTime", Float.TYPE);
        attackAnimationParameters.put("path", String.class);
        attackAnimationParameters.put("armature", Armature.class);
        attackAnimationParameters.put("phases", ListTag.class);
        PARAMETERS.put(AnimationType.STATIC, staticAnimationParameters);
        PARAMETERS.put(AnimationType.MOVEMENT, staticAnimationParameters);
        PARAMETERS.put(AnimationType.ATTACK, attackAnimationParameters);
        PARAMETERS.put(AnimationType.BASIC_ATTACK, attackAnimationParameters);
        PARAMETERS.put(AnimationType.DASH_ATTACK, attackAnimationParameters);
        PARAMETERS.put(AnimationType.AIR_SLASH, attackAnimationParameters);
        PARAMETERS.put(AnimationType.SHORT_HIT, hitAnimationParameters);
        PARAMETERS.put(AnimationType.LONG_HIT, hitAnimationParameters);
        PARAMETERS.put(AnimationType.KNOCK_DOWN, hitAnimationParameters);
        FAKE_ANIMATIONS.put(AnimationType.STATIC, FakeStaticAnimation.class);
        FAKE_ANIMATIONS.put(AnimationType.MOVEMENT, FakeMovementAnimation.class);
        FAKE_ANIMATIONS.put(AnimationType.ATTACK, FakeAttackAnimation.class);
        FAKE_ANIMATIONS.put(AnimationType.BASIC_ATTACK, FakeBasicAttackAnimation.class);
        FAKE_ANIMATIONS.put(AnimationType.DASH_ATTACK, FakeDashAttackAnimation.class);
        FAKE_ANIMATIONS.put(AnimationType.AIR_SLASH, FakeAirSlashAnimation.class);
        FAKE_ANIMATIONS.put(AnimationType.SHORT_HIT, FakeHitAnimation.class);
        FAKE_ANIMATIONS.put(AnimationType.LONG_HIT, FakeLongHitAnimation.class);
        FAKE_ANIMATIONS.put(AnimationType.KNOCK_DOWN, FakeKnockdownAnimation.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum AnimationType {
        STATIC(StaticAnimation.class),
        MOVEMENT(MovementAnimation.class),
        ATTACK(AttackAnimation.class),
        BASIC_ATTACK(BasicAttackAnimation.class),
        DASH_ATTACK(DashAttackAnimation.class),
        AIR_SLASH(AirSlashAnimation.class),
        SHORT_HIT(HitAnimation.class),
        LONG_HIT(LongHitAnimation.class),
        KNOCK_DOWN(KnockdownAnimation.class);

        final Class<? extends StaticAnimation> animCls;

        private AnimationType(Class<? extends StaticAnimation> animCls) {
            this.animCls = animCls;
        }

        public Class<? extends StaticAnimation> getAnimationClass() {
            return this.animCls;
        }

        public String toString() {
            return ParseUtil.snakeToSpacedCamel(this.name() + "_ANIMATION");
        }
    }
}

