/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import yesman.epicfight.api.client.model.AnimatedVertexBuilder;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.MeshPartDefinition;
import yesman.epicfight.api.client.model.ModelPart;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.EpicFightVertexFormatElement;
import yesman.epicfight.client.renderer.shader.AnimationShaderInstance;
import yesman.epicfight.main.EpicFightMod;

@OnlyIn(value=Dist.CLIENT)
public class AnimatedMesh
extends Mesh<AnimatedModelPart, AnimatedVertexBuilder> {
    protected final float[] weights;
    private final int maxJointCount;
    private int arrayObjectId;
    private VertexBuffer<Float> positionsBuffer = new VertexBuffer<Float>(5126, 3, false, ByteBuffer::putFloat);
    private VertexBuffer<Float> uvsBuffer = new VertexBuffer<Float>(5126, 2, false, ByteBuffer::putFloat);
    private VertexBuffer<Byte> normalsBuffer = new VertexBuffer<Byte>(5120, 3, true, ByteBuffer::put);
    private VertexBuffer<Short> jointsBuffer = new VertexBuffer<Short>(5122, 3, false, ByteBuffer::putShort);
    private VertexBuffer<Float> weightsBuffer = new VertexBuffer<Float>(5126, 3, false, ByteBuffer::putFloat);

    public AnimatedMesh(@Nullable Map<String, float[]> arrayMap, @Nullable Map<MeshPartDefinition, List<AnimatedVertexBuilder>> partBuilders, @Nullable AnimatedMesh parent, Mesh.RenderProperties properties) {
        super(arrayMap, partBuilders, parent, properties);
        this.weights = parent == null ? arrayMap.get("weights") : parent.weights;
        int maxJointId = 0;
        for (Map.Entry entry : this.parts.entrySet()) {
            for (AnimatedVertexBuilder vi : ((AnimatedModelPart)entry.getValue()).getVertices()) {
                if (maxJointId < vi.joint.x) {
                    maxJointId = vi.joint.x;
                }
                if (maxJointId < vi.joint.y) {
                    maxJointId = vi.joint.y;
                }
                if (maxJointId >= vi.joint.z) continue;
                maxJointId = vi.joint.z;
            }
        }
        this.maxJointCount = maxJointId;
        this.arrayObjectId = GlStateManager._glGenVertexArrays();
        ArrayList positionList = Lists.newArrayList();
        ArrayList uvList = Lists.newArrayList();
        ArrayList normalList = Lists.newArrayList();
        ArrayList jointList = Lists.newArrayList();
        ArrayList weightList = Lists.newArrayList();
        HashMap vertexBuilderMap = Maps.newHashMap();
        int currentBoundVao = GlStateManager._getInteger((int)34229);
        int currentBoundVbo = GlStateManager._getInteger((int)34966);
        GlStateManager._glBindVertexArray((int)this.arrayObjectId);
        for (AnimatedModelPart part : this.parts.values()) {
            part.createVbo(vertexBuilderMap, this.positions, this.uvs, this.normals, this.weights, positionList, uvList, normalList, jointList, weightList);
        }
        this.positionsBuffer.bindVertexData(positionList);
        this.uvsBuffer.bindVertexData(uvList);
        this.normalsBuffer.bindVertexData(normalList);
        this.jointsBuffer.bindVertexData(jointList);
        this.weightsBuffer.bindVertexData(weightList);
        GlStateManager._glBindVertexArray((int)currentBoundVao);
        GlStateManager._glBindBuffer((int)34962, (int)currentBoundVbo);
    }

    public void pointPositionsBuffer(int attrIndex) {
        this.positionsBuffer.vertexAttribPointer(attrIndex);
    }

    public void uvPositionsBuffer(int attrIndex) {
        this.uvsBuffer.vertexAttribPointer(attrIndex);
    }

    public void normalPositionsBuffer(int attrIndex) {
        this.normalsBuffer.vertexAttribPointer(attrIndex);
    }

    public void jointPositionsBuffer(int attrIndex) {
        this.jointsBuffer.vertexAttribPointer(attrIndex);
    }

    public void weightPositionsBuffer(int attrIndex) {
        this.weightsBuffer.vertexAttribPointer(attrIndex);
    }

    public void destroy() {
        this.positionsBuffer.destroy();
        this.uvsBuffer.destroy();
        this.normalsBuffer.destroy();
        this.jointsBuffer.destroy();
        this.weightsBuffer.destroy();
        this.parts.values().forEach(part -> RenderSystem.glDeleteBuffers((int)part.indexBufferId));
        RenderSystem.glDeleteVertexArrays((int)this.arrayObjectId);
        this.arrayObjectId = -1;
    }

    @Override
    protected Map<String, AnimatedModelPart> createModelPart(Map<MeshPartDefinition, List<AnimatedVertexBuilder>> partBuilders) {
        HashMap parts = Maps.newHashMap();
        partBuilders.forEach((partDefinition, vertexBuilder) -> parts.put(partDefinition.partName(), new AnimatedModelPart((List<AnimatedVertexBuilder>)vertexBuilder, partDefinition.getModelPartAnimationProvider())));
        return parts;
    }

    @Override
    protected AnimatedModelPart getOrLogException(Map<String, AnimatedModelPart> parts, String name) {
        if (!parts.containsKey(name)) {
            EpicFightMod.LOGGER.debug("Cannot find the mesh part named " + name + " in " + this.getClass().getCanonicalName());
            return null;
        }
        return parts.get(name);
    }

    @Override
    public void draw(PoseStack poseStack, VertexConsumer vertexConsumer, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay) {
        for (AnimatedModelPart part : this.parts.values()) {
            part.draw(poseStack, vertexConsumer, drawingFunction, packedLight, r, g, b, a, overlay);
        }
    }

    public void draw(PoseStack poseStack, MultiBufferSource multiBufferSource, RenderType renderType, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
        if (((Boolean)EpicFightMod.CLIENT_CONFIGS.useAnimationShader.getValue()).booleanValue()) {
            renderType.m_110185_();
            AnimationShaderInstance animationShader = EpicFightRenderTypes.getAnimationShader(renderType);
            this.drawWithShader(poseStack, animationShader, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, overlay, armature, poses);
            renderType.m_110188_();
        } else {
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(EpicFightRenderTypes.getTriangulated(renderType));
            this.drawToBuffer(poseStack, vertexConsumer, Mesh.DrawingFunction.ENTITY_TEXTURED, packedLight, r, g, b, a, overlay, armature, poses);
        }
    }

    public void drawToBuffer(PoseStack poseStack, VertexConsumer builder, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        OpenMatrix4f[] posesNoTranslation = new OpenMatrix4f[poses.length];
        for (int i = 0; i < poses.length; ++i) {
            posesNoTranslation[i] = armature != null ? OpenMatrix4f.mul(poses[i], armature.searchJointById(i).getToOrigin(), null).removeTranslation() : poses[i].removeTranslation();
        }
        for (ModelPart part : this.parts.values()) {
            if (part.isHidden()) continue;
            for (AnimatedVertexBuilder vi : part.getVertices()) {
                int pos = vi.position * 3;
                int norm = vi.normal * 3;
                int uv = vi.uv * 2;
                Vec4f position = new Vec4f(this.positions[pos], this.positions[pos + 1], this.positions[pos + 2], 1.0f);
                Vec4f normal = new Vec4f(this.normals[norm], this.normals[norm + 1], this.normals[norm + 2], 1.0f);
                Vec4f totalPos = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
                Vec4f totalNorm = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
                for (int i = 0; i < vi.count; ++i) {
                    int jointIndex = vi.getJointId(i);
                    int weightIndex = vi.getWeightIndex(i);
                    float weight = this.weights[weightIndex];
                    if (armature != null) {
                        Vec4f.add(OpenMatrix4f.transform(OpenMatrix4f.mul(poses[jointIndex], armature.searchJointById(jointIndex).getToOrigin(), null), position, null).scale(weight), totalPos, totalPos);
                    } else {
                        Vec4f.add(OpenMatrix4f.transform(poses[jointIndex], position, null).scale(weight), totalPos, totalPos);
                    }
                    Vec4f.add(OpenMatrix4f.transform(posesNoTranslation[jointIndex], normal, null).scale(weight), totalNorm, totalNorm);
                }
                Vector4f posVec = new Vector4f(totalPos.x, totalPos.y, totalPos.z, 1.0f);
                Vector3f normVec = new Vector3f(totalNorm.x, totalNorm.y, totalNorm.z);
                posVec.mul((Matrix4fc)matrix4f);
                normVec.mul((Matrix3fc)matrix3f);
                drawingFunction.draw(builder, posVec.x, posVec.y, posVec.z, normVec.x, normVec.y, normVec.z, packedLight, r, g, b, a, this.uvs[uv], this.uvs[uv + 1], overlay);
            }
        }
    }

    public void drawWithShader(PoseStack poseStack, ShaderInstance shader, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
        AnimationShaderInstance animationShader = EpicFightRenderTypes.getAnimationShader(shader);
        this.drawWithShader(poseStack, animationShader, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, armature, poses);
    }

    public void drawWithShader(PoseStack poseStack, AnimationShaderInstance animationShaderInstance, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
        int i;
        if (this.arrayObjectId < 0) {
            throw new IllegalStateException("Mesh destroyed");
        }
        if (animationShaderInstance == null) {
            return;
        }
        for (i = 0; i < 12; ++i) {
            int j = RenderSystem.getShaderTexture((int)i);
            animationShaderInstance._setSampler("Sampler" + i, j);
        }
        if (animationShaderInstance.getModelViewMatrixUniform() != null) {
            animationShaderInstance.getModelViewMatrixUniform().m_5679_(poseStack.m_85850_().m_252922_());
        }
        if (animationShaderInstance.getProjectionMatrixUniform() != null) {
            animationShaderInstance.getProjectionMatrixUniform().m_5679_(RenderSystem.getProjectionMatrix());
        }
        if (animationShaderInstance.getNormalMatrixUniform() != null) {
            animationShaderInstance.getNormalMatrixUniform().m_200759_(poseStack.m_85850_().m_252943_());
        }
        if (animationShaderInstance.getInverseViewRotationMatrixUniform() != null) {
            animationShaderInstance.getInverseViewRotationMatrixUniform().m_200759_(RenderSystem.getInverseViewRotationMatrix());
        }
        if (animationShaderInstance.getColorModulatorUniform() != null) {
            animationShaderInstance.getColorModulatorUniform().m_5941_(RenderSystem.getShaderColor());
        }
        if (animationShaderInstance.getGlintAlphaUniform() != null) {
            animationShaderInstance.getGlintAlphaUniform().m_5985_(RenderSystem.getShaderGlintAlpha());
        }
        if (animationShaderInstance.getFogStartUniform() != null) {
            animationShaderInstance.getFogStartUniform().m_5985_(RenderSystem.getShaderFogStart());
        }
        if (animationShaderInstance.getFogEndUniform() != null) {
            animationShaderInstance.getFogEndUniform().m_5985_(RenderSystem.getShaderFogEnd());
        }
        if (animationShaderInstance.getFogColorUniform() != null) {
            animationShaderInstance.getFogColorUniform().m_5941_(RenderSystem.getShaderFogColor());
        }
        if (animationShaderInstance.getFogShapeUniform() != null) {
            animationShaderInstance.getFogShapeUniform().m_142617_(RenderSystem.getShaderFogShape().m_202324_());
        }
        if (animationShaderInstance.getTextureMatrixUniform() != null) {
            animationShaderInstance.getTextureMatrixUniform().m_5679_(RenderSystem.getTextureMatrix());
        }
        if (animationShaderInstance.getGameTimeUniform() != null) {
            animationShaderInstance.getGameTimeUniform().m_5985_(RenderSystem.getShaderGameTime());
        }
        if (animationShaderInstance.getScreenSizeUniform() != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            animationShaderInstance.getScreenSizeUniform().m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        if (animationShaderInstance.getColorUniform() != null) {
            animationShaderInstance.getColorUniform().m_5805_(r, g, b, a);
        }
        if (animationShaderInstance.getOverlayUniform() != null) {
            animationShaderInstance.getOverlayUniform().m_142326_(overlay & 0xFFFF, overlay >> 16 & 0xFFFF);
        }
        if (animationShaderInstance.getLightUniform() != null) {
            animationShaderInstance.getLightUniform().m_142326_(packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        }
        for (i = 0; i < poses.length; ++i) {
            if (animationShaderInstance.getPoses(i) == null) continue;
            animationShaderInstance.getPoses(i).m_5679_(OpenMatrix4f.exportToMojangMatrix(armature == null ? poses[i] : OpenMatrix4f.mul(poses[i], armature.searchJointById(i).getToOrigin(), null)));
        }
        animationShaderInstance.setupShaderLights();
        int currentBoundVao = GlStateManager._getInteger((int)34229);
        int currentBoundVbo = GlStateManager._getInteger((int)34966);
        GlStateManager._glBindVertexArray((int)this.arrayObjectId);
        EpicFightVertexFormatElement.bindDrawing(this);
        animationShaderInstance._getVertexFormat().m_166912_();
        animationShaderInstance._apply();
        for (AnimatedModelPart part : this.parts.values()) {
            part.drawWithShader();
        }
        animationShaderInstance._clear();
        animationShaderInstance._getVertexFormat().m_86024_();
        EpicFightVertexFormatElement.unbindDrawing();
        GlStateManager._glBindVertexArray((int)currentBoundVao);
        GlStateManager._glBindBuffer((int)34962, (int)currentBoundVbo);
    }

    public int getMaxJointCount() {
        return this.maxJointCount;
    }

    public JsonObject toJsonObject() {
        int k;
        int i;
        JsonObject root = new JsonObject();
        JsonObject vertices = new JsonObject();
        float[] positions = (float[])this.positions.clone();
        float[] normals = (float[])this.normals.clone();
        OpenMatrix4f correctRevert = OpenMatrix4f.invert(JsonModelLoader.BLENDER_TO_MINECRAFT_COORD, null);
        for (i = 0; i < positions.length / 3; ++i) {
            k = i * 3;
            Vec4f posVector = new Vec4f(positions[k], positions[k + 1], positions[k + 2], 1.0f);
            posVector.transform(correctRevert);
            positions[k] = posVector.x;
            positions[k + 1] = posVector.y;
            positions[k + 2] = posVector.z;
        }
        for (i = 0; i < normals.length / 3; ++i) {
            k = i * 3;
            Vec4f normVector = new Vec4f(normals[k], normals[k + 1], normals[k + 2], 1.0f);
            normVector.transform(correctRevert);
            normals[k] = normVector.x;
            normals[k + 1] = normVector.y;
            normals[k + 2] = normVector.z;
        }
        int[] indices = new int[this.vertexCount * 3];
        int[] vcounts = new int[positions.length / 3];
        IntArrayList vIndexList = new IntArrayList();
        Int2ObjectOpenHashMap positionMap = new Int2ObjectOpenHashMap();
        int i2 = 0;
        for (AnimatedModelPart part : this.parts.values()) {
            for (AnimatedVertexBuilder vertexIndicator : part.getVertices()) {
                indices[i2 * 3] = vertexIndicator.position;
                indices[i2 * 3 + 1] = vertexIndicator.uv;
                indices[i2 * 3 + 2] = vertexIndicator.normal;
                vcounts[vertexIndicator.position] = vertexIndicator.count;
                positionMap.put(vertexIndicator.position, (Object)vertexIndicator);
                ++i2;
            }
        }
        block9: for (i2 = 0; i2 < vcounts.length; ++i2) {
            AnimatedVertexBuilder vi = (AnimatedVertexBuilder)positionMap.get(i2);
            switch (vcounts[i2]) {
                case 1: {
                    vIndexList.add(vi.joint.x);
                    vIndexList.add(vi.weight.x);
                    continue block9;
                }
                case 2: {
                    vIndexList.add(vi.joint.x);
                    vIndexList.add(vi.weight.x);
                    vIndexList.add(vi.joint.y);
                    vIndexList.add(vi.weight.y);
                    continue block9;
                }
                case 3: {
                    vIndexList.add(vi.joint.x);
                    vIndexList.add(vi.weight.x);
                    vIndexList.add(vi.joint.y);
                    vIndexList.add(vi.weight.y);
                    vIndexList.add(vi.joint.z);
                    vIndexList.add(vi.weight.z);
                }
            }
        }
        int[] vIndices = vIndexList.toIntArray();
        vertices.add("positions", (JsonElement)ParseUtil.arrayToJsonObject(positions, 3));
        vertices.add("uvs", (JsonElement)ParseUtil.arrayToJsonObject(this.uvs, 2));
        vertices.add("normals", (JsonElement)ParseUtil.arrayToJsonObject(normals, 3));
        if (!this.parts.isEmpty()) {
            JsonObject parts = new JsonObject();
            for (Map.Entry partEntry : this.parts.entrySet()) {
                IntArrayList indicesArray = new IntArrayList();
                for (AnimatedVertexBuilder vertexIndicator : ((AnimatedModelPart)partEntry.getValue()).getVertices()) {
                    indicesArray.add(vertexIndicator.position);
                    indicesArray.add(vertexIndicator.uv);
                    indicesArray.add(vertexIndicator.normal);
                }
                parts.add((String)partEntry.getKey(), (JsonElement)ParseUtil.arrayToJsonObject(indicesArray.toIntArray(), 3));
            }
            vertices.add("parts", (JsonElement)parts);
        } else {
            vertices.add("indices", (JsonElement)ParseUtil.arrayToJsonObject(indices, 3));
        }
        vertices.add("vcounts", (JsonElement)ParseUtil.arrayToJsonObject(vcounts, 1));
        vertices.add("weights", (JsonElement)ParseUtil.arrayToJsonObject(this.weights, 1));
        vertices.add("vindices", (JsonElement)ParseUtil.arrayToJsonObject(vIndices, 1));
        root.add("vertices", (JsonElement)vertices);
        if (this.renderProperties != null) {
            JsonObject renderProperties = new JsonObject();
            renderProperties.addProperty("texture_path", this.renderProperties.getCustomTexturePath());
            renderProperties.addProperty("transparent", Boolean.valueOf(this.renderProperties.isTransparent()));
            root.add("render_properties", (JsonElement)renderProperties);
        }
        return root;
    }

    @OnlyIn(value=Dist.CLIENT)
    private class VertexBuffer<T extends Number> {
        private int vertexBufferIds = GlStateManager._glGenBuffers();
        private final int glType;
        private final int size;
        private final boolean normalize;
        private final BiConsumer<ByteBuffer, T> bufferUploader;

        public VertexBuffer(int glType, int size, boolean normalize, BiConsumer<ByteBuffer, T> bufferUploader) {
            this.glType = glType;
            this.size = size;
            this.normalize = normalize;
            this.bufferUploader = bufferUploader;
        }

        public void bindVertexData(List<T> data) {
            if (this.vertexBufferIds < 0) {
                throw new RuntimeException("vertex buffer is already destroyed");
            }
            ByteBuffer buf = ByteBuffer.allocateDirect(data.size() * 4).order(ByteOrder.nativeOrder());
            for (Number f : data) {
                this.bufferUploader.accept(buf, (ByteBuffer)((Object)f));
            }
            buf.flip();
            GlStateManager._glBindBuffer((int)34962, (int)this.vertexBufferIds);
            GlStateManager._glBufferData((int)34962, (ByteBuffer)buf, (int)35044);
            GlStateManager._glBindBuffer((int)34962, (int)0);
        }

        public void vertexAttribPointer(int attrIndex) {
            if (this.vertexBufferIds < 0) {
                throw new RuntimeException("vertex buffer is already destroyed");
            }
            GlStateManager._glBindBuffer((int)34962, (int)this.vertexBufferIds);
            switch (this.glType) {
                case 5126: 
                case 5130: {
                    GlStateManager._vertexAttribPointer((int)attrIndex, (int)this.size, (int)this.glType, (boolean)this.normalize, (int)0, (long)0L);
                    break;
                }
                case 5120: 
                case 5122: 
                case 5124: {
                    if (this.normalize) {
                        GlStateManager._vertexAttribPointer((int)attrIndex, (int)this.size, (int)this.glType, (boolean)true, (int)0, (long)0L);
                        break;
                    }
                    GlStateManager._vertexAttribIPointer((int)attrIndex, (int)this.size, (int)this.glType, (int)0, (long)0L);
                }
            }
        }

        public void destroy() {
            RenderSystem.glDeleteBuffers((int)this.vertexBufferIds);
            this.vertexBufferIds = -1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class AnimatedModelPart
    extends ModelPart<AnimatedVertexBuilder> {
        private int indexBufferId;

        public AnimatedModelPart(@Nullable List<AnimatedVertexBuilder> animatedMeshPartList, Supplier<OpenMatrix4f> vanillaPartTracer) {
            super(animatedMeshPartList, vanillaPartTracer);
        }

        private void createVbo(Map<AnimatedVertexBuilder, Integer> vertexBuilderMap, float[] positions, float[] uvs, float[] normals, float[] weights, List<Float> position, List<Float> uv, List<Byte> normal, List<Short> joint, List<Float> weight) {
            ByteBuffer indicesBuffer = ByteBuffer.allocateDirect(this.getVertices().size() * 4).order(ByteOrder.nativeOrder());
            for (AnimatedVertexBuilder vb : this.getVertices()) {
                if (vertexBuilderMap.containsKey(vb)) {
                    indicesBuffer.putInt(vertexBuilderMap.get(vb));
                    continue;
                }
                int next = vertexBuilderMap.size();
                indicesBuffer.putInt(next);
                vertexBuilderMap.put(vb, next);
                position.add(Float.valueOf(positions[vb.position * 3]));
                position.add(Float.valueOf(positions[vb.position * 3 + 1]));
                position.add(Float.valueOf(positions[vb.position * 3 + 2]));
                uv.add(Float.valueOf(uvs[vb.uv * 2]));
                uv.add(Float.valueOf(uvs[vb.uv * 2 + 1]));
                normal.add(AnimatedModelPart.normalIntValue(normals[vb.normal * 3]));
                normal.add(AnimatedModelPart.normalIntValue(normals[vb.normal * 3 + 1]));
                normal.add(AnimatedModelPart.normalIntValue(normals[vb.normal * 3 + 2]));
                joint.add((short)vb.joint.x);
                joint.add((short)vb.joint.y);
                joint.add((short)vb.joint.z);
                weight.add(Float.valueOf(vb.weight.x > -1 ? weights[vb.weight.x] : 0.0f));
                weight.add(Float.valueOf(vb.weight.y > -1 ? weights[vb.weight.y] : 0.0f));
                weight.add(Float.valueOf(vb.weight.z > -1 ? weights[vb.weight.z] : 0.0f));
            }
            indicesBuffer.flip();
            this.indexBufferId = GlStateManager._glGenBuffers();
            GlStateManager._glBindBuffer((int)34963, (int)this.indexBufferId);
            GlStateManager._glBufferData((int)34963, (ByteBuffer)indicesBuffer, (int)35044);
            GlStateManager._glBindBuffer((int)34963, (int)0);
        }

        @Override
        public void draw(PoseStack poseStack, VertexConsumer builder, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay) {
            if (this.isHidden()) {
                return;
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
            for (AnimatedVertexBuilder vi : this.getVertices()) {
                int pos = vi.position * 3;
                int norm = vi.normal * 3;
                int uv = vi.uv * 2;
                Vector4f posVec = matrix4f.transform(new Vector4f(AnimatedMesh.this.positions[pos], AnimatedMesh.this.positions[pos + 1], AnimatedMesh.this.positions[pos + 2], 1.0f));
                Vector3f normVec = matrix3f.transform(new Vector3f(AnimatedMesh.this.normals[norm], AnimatedMesh.this.normals[norm + 1], AnimatedMesh.this.normals[norm + 2]));
                drawingFunction.draw(builder, posVec.x(), posVec.y(), posVec.z(), normVec.x(), normVec.y(), normVec.z(), packedLight, r, g, b, a, AnimatedMesh.this.uvs[uv], AnimatedMesh.this.uvs[uv + 1], overlay);
            }
        }

        public void drawWithShader() {
            if (this.isHidden()) {
                return;
            }
            GlStateManager._glBindBuffer((int)34963, (int)this.indexBufferId);
            RenderSystem.drawElements((int)VertexFormat.Mode.TRIANGLES.f_166946_, (int)this.getVertices().size(), (int)VertexFormat.IndexType.INT.f_166923_);
            GlStateManager._glBindBuffer((int)34963, (int)0);
        }

        static byte normalIntValue(float f) {
            return (byte)((int)(Mth.m_14036_((float)f, (float)-1.0f, (float)1.0f) * 127.0f) & 0xFF);
        }
    }
}

