/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent;
import yesman.epicfight.api.client.forgeevent.RenderEnderDragonEvent;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.ItemSkin;
import yesman.epicfight.api.client.model.ItemSkins;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.gui.VersionNotifier;
import yesman.epicfight.client.gui.screen.config.UISetupScreen;
import yesman.epicfight.client.gui.screen.overlay.OverlayManager;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.AimHelperRenderer;
import yesman.epicfight.client.renderer.FirstPersonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCreeperRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCustomEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCustomHumanoidEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PDrownedRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEnderDragonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEndermanRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHoglinRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHumanoidRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIllagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIronGolemRenderer;
import yesman.epicfight.client.renderer.patched.entity.PPlayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PRavagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PSpiderRenderer;
import yesman.epicfight.client.renderer.patched.entity.PStrayRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVexRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVindicatorRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitchRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherSkeletonMinionRenderer;
import yesman.epicfight.client.renderer.patched.entity.PZombieVillagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PresetRenderer;
import yesman.epicfight.client.renderer.patched.entity.WitherGhostCloneRenderer;
import yesman.epicfight.client.renderer.patched.item.RenderBow;
import yesman.epicfight.client.renderer.patched.item.RenderCrossbow;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.client.renderer.patched.item.RenderKatana;
import yesman.epicfight.client.renderer.patched.item.RenderMap;
import yesman.epicfight.client.renderer.patched.item.RenderShield;
import yesman.epicfight.client.renderer.patched.item.RenderTrident;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.item.BowCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.CrossbowCapability;
import yesman.epicfight.world.capabilities.item.MapCapability;
import yesman.epicfight.world.capabilities.item.ShieldCapability;
import yesman.epicfight.world.capabilities.item.TridentCapability;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.gamerule.EpicFightGamerules;
import yesman.epicfight.world.item.EpicFightItems;

@OnlyIn(value=Dist.CLIENT)
public class RenderEngine {
    private static final Vec3f AIMING_CORRECTION = new Vec3f(-1.5f, 0.0f, 1.25f);
    public final BattleModeGui battleModeUI = new BattleModeGui(Minecraft.m_91087_());
    public final VersionNotifier versionNotifier = new VersionNotifier(Minecraft.m_91087_());
    public final Minecraft minecraft;
    private final BiMap<EntityType<?>, Function<EntityType<?>, PatchedEntityRenderer>> entityRendererProvider;
    private final Map<EntityType<?>, PatchedEntityRenderer> entityRendererCache;
    private final Map<Item, RenderItemBase> itemRendererMapByInstance;
    private final Map<Class<?>, RenderItemBase> itemRendererMapByClass;
    private final Set<Component> sentMessages;
    private final OverlayManager overlayManager;
    private AimHelperRenderer aimHelper;
    private FirstPersonRenderer firstPersonRenderer;
    private PHumanoidRenderer<?, ?, ?, ?, ?> basicHumanoidRenderer;
    private boolean zoomingIn;
    private int modelInitTimer;
    private final int maxZoomCount = 20;
    private int zoomOutStandbyTicks = 0;
    private int zoomCount = 0;

    public RenderEngine() {
        Events.renderEngine = this;
        RenderItemBase.renderEngine = this;
        EntityIndicator.init();
        this.minecraft = Minecraft.m_91087_();
        this.entityRendererProvider = HashBiMap.create();
        this.entityRendererCache = Maps.newHashMap();
        this.itemRendererMapByInstance = Maps.newHashMap();
        this.itemRendererMapByClass = Maps.newHashMap();
        this.sentMessages = Sets.newHashSet();
        this.overlayManager = new OverlayManager();
    }

    public void bootstrap(EntityRendererProvider.Context context) {
        this.entityRendererProvider.clear();
        this.entityRendererProvider.put((Object)EntityType.f_20558_, entityType -> new PCreeperRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20566_, entityType -> new PEndermanRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20501_, entityType -> new PHumanoidRenderer(() -> Meshes.BIPED_OLD_TEX, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20530_, entityType -> new PZombieVillagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20531_, entityType -> new PHumanoidRenderer(() -> Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20458_, entityType -> new PHumanoidRenderer(() -> Meshes.BIPED_OLD_TEX, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20524_, entityType -> new PHumanoidRenderer(() -> Meshes.SKELETON, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20497_, entityType -> new PHumanoidRenderer(() -> Meshes.SKELETON, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20481_, entityType -> new PStrayRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20532_, entityType -> new PPlayerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20479_, entityType -> new PSpiderRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20554_, entityType -> new PSpiderRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20460_, entityType -> new PIronGolemRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20493_, entityType -> new PVindicatorRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20568_, entityType -> new PIllagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20495_, entityType -> new PWitchRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20562_, entityType -> new PDrownedRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20513_, entityType -> new PIllagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20518_, entityType -> new PRavagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20491_, entityType -> new PVexRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20511_, entityType -> new PHumanoidRenderer(() -> Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20512_, entityType -> new PHumanoidRenderer(() -> Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20456_, entityType -> new PHoglinRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20500_, entityType -> new PHoglinRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20565_, entityType -> new PEnderDragonRenderer());
        this.entityRendererProvider.put((Object)EntityType.f_20496_, entityType -> new PWitherRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)((EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get()), entityType -> new PWitherSkeletonMinionRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)((EntityType)EpicFightEntities.WITHER_GHOST_CLONE.get()), entityType -> new WitherGhostCloneRenderer());
        this.firstPersonRenderer = new FirstPersonRenderer(context, EntityType.f_20532_);
        this.basicHumanoidRenderer = new PHumanoidRenderer(() -> Meshes.BIPED, context, EntityType.f_20532_);
        this.aimHelper = new AimHelperRenderer();
        RenderItemBase baseRenderer = new RenderItemBase();
        RenderBow bowRenderer = new RenderBow();
        RenderCrossbow crossbowRenderer = new RenderCrossbow();
        RenderTrident tridentRenderer = new RenderTrident();
        RenderMap mapRenderer = new RenderMap();
        RenderShield shieldRenderer = new RenderShield();
        this.itemRendererMapByInstance.clear();
        this.itemRendererMapByClass.clear();
        this.itemRendererMapByInstance.put(Items.f_41852_, baseRenderer);
        this.itemRendererMapByInstance.put(Items.f_42411_, bowRenderer);
        this.itemRendererMapByInstance.put(Items.f_42740_, shieldRenderer);
        this.itemRendererMapByInstance.put(Items.f_42717_, crossbowRenderer);
        this.itemRendererMapByInstance.put(Items.f_42713_, tridentRenderer);
        this.itemRendererMapByInstance.put(Items.f_42573_, mapRenderer);
        this.itemRendererMapByInstance.put((Item)EpicFightItems.UCHIGATANA.get(), new RenderKatana());
        this.itemRendererMapByClass.put(BowItem.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowItem.class, crossbowRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, baseRenderer);
        this.itemRendererMapByClass.put(TridentItem.class, tridentRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, shieldRenderer);
        this.itemRendererMapByClass.put(BowCapability.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowCapability.class, crossbowRenderer);
        this.itemRendererMapByClass.put(TridentCapability.class, tridentRenderer);
        this.itemRendererMapByClass.put(MapCapability.class, mapRenderer);
        this.itemRendererMapByClass.put(ShieldCapability.class, shieldRenderer);
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.Add((Map<EntityType<?>, Function<EntityType<?>, PatchedEntityRenderer>>)this.entityRendererProvider, this.itemRendererMapByInstance, context));
        this.resetRenderers();
    }

    public void resetRenderers() {
        this.sentMessages.clear();
        this.entityRendererCache.clear();
        for (Map.Entry entry : this.entityRendererProvider.entrySet()) {
            this.entityRendererCache.put((EntityType)entry.getKey(), (PatchedEntityRenderer)((Function)entry.getValue()).apply((EntityType)entry.getKey()));
        }
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.Modify(this.entityRendererCache));
    }

    public void registerCustomEntityRenderer(EntityType<?> entityType, String rendererName, CompoundTag compound) {
        if (StringUtil.m_14408_((String)rendererName)) {
            return;
        }
        EntityRenderDispatcher erd = this.minecraft.m_91290_();
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(erd, this.minecraft.m_91291_(), this.minecraft.m_91289_(), erd.m_234586_(), this.minecraft.m_91098_(), this.minecraft.m_167973_(), this.minecraft.f_91062_);
        if ("player".equals(rendererName)) {
            this.entityRendererCache.put(entityType, this.basicHumanoidRenderer);
        } else if ("epicfight:custom".equals(rendererName)) {
            if (compound.m_128471_("humanoid")) {
                this.entityRendererCache.put(entityType, new PCustomHumanoidEntityRenderer<HumanoidMesh>(() -> Meshes.getOrCreateAnimatedMesh(this.minecraft.m_91098_(), new ResourceLocation(compound.m_128461_("model")), HumanoidMesh::new), context, entityType));
            } else {
                this.entityRendererCache.put(entityType, new PCustomEntityRenderer(() -> Meshes.getOrCreateAnimatedMesh(this.minecraft.m_91098_(), new ResourceLocation(compound.m_128461_("model")), AnimatedMesh::new), context));
            }
        } else {
            EntityType presetEntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(rendererName));
            if (this.entityRendererProvider.containsKey((Object)presetEntityType)) {
                PatchedEntityRenderer renderer = (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)presetEntityType)).apply(entityType);
                if (!(this.minecraft.m_91290_().f_114362_.get(entityType) instanceof LivingEntityRenderer) && renderer instanceof PatchedLivingEntityRenderer) {
                    PatchedLivingEntityRenderer patchedLivingEntityRenderer = (PatchedLivingEntityRenderer)renderer;
                    this.entityRendererCache.put(entityType, new PresetRenderer(context, entityType, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)((LivingEntityRenderer)context.m_174022_().f_114362_.get(presetEntityType)), patchedLivingEntityRenderer.getDefaultMesh()));
                } else {
                    this.entityRendererCache.put(entityType, (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)presetEntityType)).apply(entityType));
                }
            } else {
                throw new IllegalArgumentException("Datapack Mob Patch Crash: Invalid Renderer type " + rendererName);
            }
        }
    }

    public RenderItemBase getItemRenderer(ItemStack itemstack) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(itemstack.m_41720_());
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(itemstack.m_41720_().getClass());
            if (renderItem == null) {
                CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(itemstack);
                renderItem = this.findMatchingRendererByClass(itemCap.getClass());
            }
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.f_41852_);
            }
            this.itemRendererMapByInstance.put(itemstack.m_41720_(), renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.get(clazz);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void renderEntityArmatureModel(LivingEntity livingEntity, LivingEntityPatch<?> entitypatch, EntityRenderer<? extends Entity> renderer, MultiBufferSource buffer, PoseStack matStack, int packedLight, float partialTicks) {
        this.getEntityRenderer((Entity)livingEntity).render(livingEntity, entitypatch, renderer, buffer, matStack, packedLight, partialTicks);
    }

    public PatchedEntityRenderer getEntityRenderer(Entity entity) {
        return this.getEntityRenderer(entity.m_6095_());
    }

    public PatchedEntityRenderer getEntityRenderer(EntityType entityType) {
        return this.entityRendererCache.get(entityType);
    }

    public boolean hasRendererFor(Entity entity) {
        return this.entityRendererCache.computeIfAbsent(entity.m_6095_(), key -> this.entityRendererProvider.containsKey(key) ? (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)entity.m_6095_())).apply(entity.m_6095_()) : null) != null;
    }

    public Set<ResourceLocation> getRendererEntries() {
        Set<ResourceLocation> availableRendererEntities = this.entityRendererProvider.keySet().stream().map(entityType -> EntityType.m_20613_((EntityType)entityType)).collect(Collectors.toSet());
        availableRendererEntities.add(new ResourceLocation("epicfight", "custom"));
        return availableRendererEntities;
    }

    public void zoomIn() {
        if (!this.zoomingIn) {
            this.zoomingIn = true;
            this.zoomCount = this.zoomCount == 0 ? 1 : this.zoomCount;
        }
    }

    public void zoomOut(int zoomOutTicks) {
        if (this.zoomingIn) {
            this.zoomingIn = false;
            this.zoomOutStandbyTicks = zoomOutTicks;
        }
    }

    public void setModelInitializerTimer(int tick) {
        this.modelInitTimer = tick;
    }

    public void addMessage(Component message) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(message);
    }

    public void addMessageIfAbsent(Component message) {
        if (!this.sentMessages.contains(message)) {
            this.sentMessages.add(message);
            this.addMessage(message);
        }
    }

    private void setRangedWeaponThirdPerson(ViewportEvent.ComputeCameraAngles event, CameraType pov, double partialTicks) {
        if (ClientEngine.getInstance().getPlayerPatch() == null) {
            return;
        }
        Camera camera = event.getCamera();
        Entity entity = this.minecraft.m_91288_();
        Vec3 vector = camera.m_90583_();
        double totalX = vector.m_7096_();
        double totalY = vector.m_7098_();
        double totalZ = vector.m_7094_();
        if (pov == CameraType.THIRD_PERSON_BACK) {
            double d3;
            double posX = vector.m_7096_();
            double posY = vector.m_7098_();
            double posZ = vector.m_7094_();
            double entityPosX = entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * partialTicks;
            double entityPosY = entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * partialTicks + (double)entity.m_20192_();
            double entityPosZ = entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * partialTicks;
            float intpol = pov == CameraType.THIRD_PERSON_BACK ? (float)this.zoomCount / 20.0f : 0.0f;
            Vec3f interpolatedCorrection = new Vec3f(RenderEngine.AIMING_CORRECTION.x * intpol, RenderEngine.AIMING_CORRECTION.y * intpol, RenderEngine.AIMING_CORRECTION.z * intpol);
            OpenMatrix4f rotationMatrix = ClientEngine.getInstance().getPlayerPatch().getMatrix((float)partialTicks);
            Vec3f rotateVec = OpenMatrix4f.transform3v(rotationMatrix, interpolatedCorrection, null);
            double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
            double d00 = posX + (double)rotateVec.x;
            double d11 = posY - (double)rotateVec.y;
            double d22 = posZ + (double)rotateVec.z;
            for (int i = 0; i < 8; ++i) {
                double d7;
                BlockHitResult raytraceresult;
                float f = (i & 1) * 2 - 1;
                float f1 = (i >> 1 & 1) * 2 - 1;
                float f2 = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = this.minecraft.f_91073_.m_45547_(new ClipContext(new Vec3(entityPosX + (double)(f *= 0.1f), entityPosY + (double)(f1 *= 0.1f), entityPosZ + (double)(f2 *= 0.1f)), new Vec3(d00 + (double)f + (double)f2, d11 + (double)f1, d22 + (double)f2), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity))) == null || !((d7 = raytraceresult.m_82450_().m_82554_(new Vec3(entityPosX, entityPosY, entityPosZ))) < smallest)) continue;
                smallest = d7;
            }
            float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
            totalX += (double)(rotateVec.x * dist);
            totalY -= (double)(rotateVec.y * dist);
            totalZ += (double)(rotateVec.z * dist);
        }
        camera.m_90584_(totalX, totalY, totalZ);
    }

    public void correctCamera(ViewportEvent.ComputeCameraAngles event, float partialTicks) {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        Camera camera = event.getCamera();
        CameraType cameraType = this.minecraft.f_91066_.m_92176_();
        if (localPlayerPatch != null && localPlayerPatch.getTarget() != null && localPlayerPatch.isTargetLockedOn()) {
            float xRot = localPlayerPatch.getLerpedLockOnX(event.getPartialTick());
            float yRot = localPlayerPatch.getLerpedLockOnY(event.getPartialTick());
            if (cameraType.m_90613_()) {
                yRot += 180.0f;
                xRot *= -1.0f;
            }
            camera.m_90572_(yRot, xRot);
            event.setPitch(xRot);
            event.setYaw(yRot);
            if (!cameraType.m_90612_()) {
                Entity cameraEntity = this.minecraft.f_91075_;
                camera.m_90584_(Mth.m_14139_((double)partialTicks, (double)cameraEntity.f_19854_, (double)cameraEntity.m_20185_()), Mth.m_14139_((double)partialTicks, (double)cameraEntity.f_19855_, (double)cameraEntity.m_20186_()) + (double)Mth.m_14179_((float)partialTicks, (float)camera.f_90563_, (float)camera.f_90562_), Mth.m_14139_((double)partialTicks, (double)cameraEntity.f_19856_, (double)cameraEntity.m_20189_()));
                camera.m_90568_(-camera.m_90566_(4.0), 0.0, 0.0);
            }
        }
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public FirstPersonRenderer getFirstPersonRenderer() {
        return this.firstPersonRenderer;
    }

    public void upSlideSkillUI() {
        this.battleModeUI.slideUp();
    }

    public void downSlideSkillUI() {
        this.battleModeUI.slideDown();
    }

    public boolean shouldRenderVanillaModel() {
        return ClientEngine.getInstance().isVanillaModelDebuggingMode() || this.modelInitTimer > 0;
    }

    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static RenderEngine renderEngine;

        @SubscribeEvent
        public static void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
            LivingEntityPatch entitypatch;
            LivingEntity livingentity = event.getEntity();
            if (livingentity.m_9236_() == null) {
                return;
            }
            if (renderEngine.hasRendererFor((Entity)livingentity)) {
                entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
                float originalYRot = 0.0f;
                if ((event.getPartialTick() == 0.0f || event.getPartialTick() == 1.0f) && entitypatch instanceof LocalPlayerPatch) {
                    LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)entitypatch;
                    if (entitypatch.overrideRender()) {
                        originalYRot = localPlayerPatch.getModelYRot();
                        localPlayerPatch.setModelYRotInGui(livingentity.m_146908_());
                        event.getPoseStack().m_85837_(0.0, 0.1, 0.0);
                        boolean usingShader = (Boolean)EpicFightMod.CLIENT_CONFIGS.useAnimationShader.getValue();
                        if (usingShader) {
                            EpicFightMod.CLIENT_CONFIGS.useAnimationShader.setValue(false);
                        }
                        renderEngine.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                        if (usingShader) {
                            EpicFightMod.CLIENT_CONFIGS.useAnimationShader.setValue(true);
                        }
                        localPlayerPatch.disableModelYRotInGui(originalYRot);
                        event.setCanceled(true);
                    }
                    return;
                }
                if (entitypatch != null && entitypatch.overrideRender()) {
                    renderEngine.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                    if (renderEngine.shouldRenderVanillaModel()) {
                        event.getPoseStack().m_252880_(1.0f, 0.0f, 0.0f);
                        --Events.renderEngine.modelInitTimer;
                    } else {
                        event.setCanceled(true);
                    }
                }
            }
            if (ClientEngine.getInstance().getPlayerPatch() != null && !Events.renderEngine.minecraft.f_91066_.f_92062_ && !livingentity.m_9236_().m_46469_().m_46207_(EpicFightGamerules.DISABLE_ENTITY_UI)) {
                entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
                for (EntityIndicator entityIndicator : EntityIndicator.ENTITY_INDICATOR_RENDERERS) {
                    if (!entityIndicator.shouldDraw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch())) continue;
                    entityIndicator.drawIndicator(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick());
                }
            }
        }

        @SubscribeEvent
        public static void itemTooltip(ItemTooltipEvent event) {
            if (event.getEntity() != null && event.getEntity().m_9236_().f_46443_ && ((Boolean)EpicFightMod.CLIENT_CONFIGS.showEpicFightAttributes.getValue()).booleanValue()) {
                CapabilityItem cap = EpicFightCapabilities.getItemStackCapabilityOr(event.getItemStack(), null);
                LocalPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class);
                if (cap != null && playerpatch != null) {
                    if (ControllEngine.isKeyDown(EpicFightKeyMappings.WEAPON_INNATE_SKILL_TOOLTIP)) {
                        Skill weaponInnateSkill = cap.getInnateSkill(playerpatch, event.getItemStack());
                        if (weaponInnateSkill != null) {
                            event.getToolTip().clear();
                            List<Component> skilltooltip = weaponInnateSkill.getTooltipOnItem(event.getItemStack(), cap, playerpatch);
                            for (Component s : skilltooltip) {
                                event.getToolTip().add(s);
                            }
                        }
                    } else {
                        List tooltip = event.getToolTip();
                        cap.modifyItemTooltip(event.getItemStack(), event.getToolTip(), playerpatch);
                        for (int i = 0; i < tooltip.size(); ++i) {
                            MutableComponent mutableComponent$2;
                            ComponentContents componentContents;
                            Object object;
                            TranslatableContents translatableContent;
                            MutableComponent mutableComponent;
                            ComponentContents componentContents2;
                            Component sibling;
                            Component textComp = (Component)tooltip.get(i);
                            if (textComp.m_7360_().isEmpty() || !((sibling = (Component)textComp.m_7360_().get(0)) instanceof MutableComponent) || !((componentContents2 = (mutableComponent = (MutableComponent)sibling).m_214077_()) instanceof TranslatableContents) || (translatableContent = (TranslatableContents)componentContents2).m_237523_().length <= 1 || !((object = translatableContent.m_237523_()[1]) instanceof MutableComponent) || !((componentContents = (mutableComponent$2 = (MutableComponent)object).m_214077_()) instanceof TranslatableContents)) continue;
                            TranslatableContents translatableContent$2 = (TranslatableContents)componentContents;
                            if (translatableContent$2.m_237508_().equals(Attributes.f_22283_.m_22087_())) {
                                float weaponSpeed = (float)playerpatch.getWeaponAttribute(Attributes.f_22283_, event.getItemStack());
                                tooltip.remove(i);
                                tooltip.add(i, Component.m_237113_((String)String.format(" %.2f ", Float.valueOf(playerpatch.getModifiedAttackSpeed(cap, weaponSpeed)))).m_7220_((Component)Component.m_237115_((String)Attributes.f_22283_.m_22087_())));
                                continue;
                            }
                            if (!translatableContent$2.m_237508_().equals(Attributes.f_22281_.m_22087_())) continue;
                            float weaponDamage = (float)playerpatch.getWeaponAttribute(Attributes.f_22281_, event.getItemStack());
                            float damageBonus = EnchantmentHelper.m_44833_((ItemStack)event.getItemStack(), (MobType)MobType.f_21640_);
                            String damageFormat = ItemStack.f_41584_.format(playerpatch.getModifiedBaseDamage(weaponDamage) + damageBonus);
                            tooltip.remove(i);
                            tooltip.add(i, Component.m_237113_((String)String.format(" %s ", damageFormat)).m_7220_((Component)Component.m_237115_((String)Attributes.f_22281_.m_22087_())).m_130940_(ChatFormatting.DARK_GREEN));
                        }
                        Skill weaponInnateSkill = cap.getInnateSkill(playerpatch, event.getItemStack());
                        if (weaponInnateSkill != null) {
                            event.getToolTip().add(Component.m_237110_((String)"inventory.epicfight.guide_innate_tooltip", (Object[])new Object[]{EpicFightKeyMappings.WEAPON_INNATE_SKILL_TOOLTIP.getKey().m_84875_()}).m_130940_(ChatFormatting.DARK_GRAY));
                        }
                    }
                }
            }
        }

        @SubscribeEvent
        public static void cameraSetupEvent(ViewportEvent.ComputeCameraAngles event) {
            if (Events.renderEngine.zoomCount > 0 && ((Boolean)EpicFightMod.CLIENT_CONFIGS.aimingCorrection.getValue()).booleanValue()) {
                renderEngine.setRangedWeaponThirdPerson(event, Events.renderEngine.minecraft.f_91066_.m_92176_(), event.getPartialTick());
                if (Events.renderEngine.zoomOutStandbyTicks > 0) {
                    --Events.renderEngine.zoomOutStandbyTicks;
                } else {
                    Events.renderEngine.zoomCount = Events.renderEngine.zoomingIn ? Events.renderEngine.zoomCount + 1 : Events.renderEngine.zoomCount - 1;
                }
                Events.renderEngine.zoomCount = Math.min(Events.renderEngine.maxZoomCount, Events.renderEngine.zoomCount);
            }
            renderEngine.correctCamera(event, (float)event.getPartialTick());
        }

        @SubscribeEvent
        public static void fogEvent(ViewportEvent.RenderFog event) {
        }

        @SubscribeEvent
        public static void renderGui(RenderGuiEvent.Pre event) {
            Window window = Minecraft.m_91087_().m_91268_();
            LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
            if (playerpatch != null) {
                for (SkillContainer skillContainer : playerpatch.getSkillCapability().skillContainers) {
                    if (skillContainer.getSkill() == null) continue;
                    skillContainer.getSkill().onScreen(playerpatch, window.m_85445_(), window.m_85446_());
                }
                Events.renderEngine.overlayManager.renderTick(window.m_85445_(), window.m_85446_());
                if (Minecraft.m_91404_() && !(Minecraft.m_91087_().f_91080_ instanceof UISetupScreen)) {
                    Events.renderEngine.battleModeUI.renderGui(playerpatch, event.getGuiGraphics(), event.getPartialTick());
                }
            }
        }

        @SubscribeEvent
        public static void renderGameOverlayPost(CustomizeGuiOverlayEvent.BossEventProgress event) {
            if (event.getBossEvent().m_18861_().getString().equals("Ender Dragon") && EnderDragonPatch.INSTANCE_CLIENT != null) {
                EnderDragonPatch dragonpatch = EnderDragonPatch.INSTANCE_CLIENT;
                float stunShield = dragonpatch.getStunShield();
                GuiGraphics guiGraphics = event.getGuiGraphics();
                if (stunShield > 0.0f) {
                    float progression = stunShield / dragonpatch.getMaxStunShield();
                    int x = event.getX();
                    int y = event.getY();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.m_280411_(BossHealthOverlay.f_93697_, x, y + 6, 183, 2, 0.0f, 45.0f, 182, 6, 255, 255);
                    guiGraphics.m_280411_(BossHealthOverlay.f_93697_, x + (int)(183.0f * progression), y + 6, (int)(183.0f * (1.0f - progression)), 2, 0.0f, 39.0f, 182, 6, 255, 255);
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void renderHand(RenderHandEvent event) {
            boolean isBattleMode;
            LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
            if (playerpatch != null && ((isBattleMode = playerpatch.isBattleMode()) || !((Boolean)EpicFightMod.CLIENT_CONFIGS.filterAnimation.getValue()).booleanValue()) && ((Boolean)EpicFightMod.CLIENT_CONFIGS.firstPersonModel.getValue()).booleanValue()) {
                boolean useEpicFightModel;
                ItemSkin mainhandItemSkin = ItemSkins.getItemSkin(((LocalPlayer)playerpatch.getOriginal()).m_21205_().m_41720_());
                ItemSkin offhandItemSkin = ItemSkins.getItemSkin(((LocalPlayer)playerpatch.getOriginal()).m_21206_().m_41720_());
                boolean bl = useEpicFightModel = !(mainhandItemSkin != null && mainhandItemSkin.forceVanillaFirstPerson() || offhandItemSkin != null && offhandItemSkin.forceVanillaFirstPerson());
                if (useEpicFightModel) {
                    if (event.getHand() == InteractionHand.MAIN_HAND) {
                        Events.renderEngine.firstPersonRenderer.render((LocalPlayer)playerpatch.getOriginal(), playerpatch, (LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>>)((LivingEntityRenderer)Events.renderEngine.minecraft.m_91290_().m_114382_((Entity)((LocalPlayer)playerpatch.getOriginal()))), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                    }
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void renderWorldLast(RenderLevelStageEvent event) {
            if (((Boolean)EpicFightMod.CLIENT_CONFIGS.aimingCorrection.getValue()).booleanValue() && Events.renderEngine.zoomCount > 0 && Events.renderEngine.minecraft.f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK && event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                Events.renderEngine.aimHelper.doRender(event.getPoseStack(), event.getPartialTick());
            }
        }

        @SubscribeEvent
        public static void renderEnderDragonEvent(RenderEnderDragonEvent event) {
            EnderDragonPatch entitypatch;
            EnderDragon livingentity = event.getEntity();
            if (renderEngine.hasRendererFor((Entity)livingentity) && (entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, EnderDragonPatch.class)) != null) {
                event.setCanceled(true);
                renderEngine.getEntityRenderer((Entity)livingentity).render(livingentity, entitypatch, event.getRenderer(), event.getBuffers(), event.getPoseStack(), event.getLight(), event.getPartialRenderTick());
            }
        }
    }
}

