/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.datapack.ClipHoldingAnimation;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.client.gui.datapack.screen.ImportAnimationsScreen;
import yesman.epicfight.client.gui.datapack.widgets.ModelPreviewer;

@OnlyIn(value=Dist.CLIENT)
public class SelectAnimationScreen
extends Screen {
    private final Screen parentScreen;
    private final AnimationList animationList;
    private final ModelPreviewer modelPreviewer;
    private final Consumer<StaticAnimation> selectCallback;
    private final Consumer<StaticAnimation> cancelCallback;
    private final Predicate<StaticAnimation> filter;
    private final EditBox searchBox;

    public SelectAnimationScreen(Screen parentScreen, Consumer<StaticAnimation> selectCallback, Consumer<StaticAnimation> cancelCallback, Predicate<StaticAnimation> filter, Armature armature, MeshProvider<AnimatedMesh> mesh) {
        super((Component)Component.m_237115_((String)"gui.epicfight.select.animations"));
        this.modelPreviewer = new ModelPreviewer(10, 20, 36, 60, null, null, armature, mesh);
        this.animationList = new AnimationList(parentScreen.getMinecraft(), this.f_96543_, this.f_96544_, 36, this.f_96544_ - 16, 21);
        this.animationList.m_93496_(false);
        this.parentScreen = parentScreen;
        this.selectCallback = selectCallback;
        this.cancelCallback = cancelCallback;
        this.filter = filter;
        this.searchBox = new EditBox(parentScreen.getMinecraft().f_91062_, this.f_96543_ / 2, 12, this.f_96543_ / 2 - 12, 16, (Component)Component.m_237113_((String)"datapack_edit.keyword"));
        this.searchBox.m_94151_(this.animationList::refreshAniamtionList);
        this.animationList.refreshAniamtionList(null);
        if (armature != null) {
            this.searchBox.m_94144_(armature.toString().substring(armature.toString().indexOf("/") + 1));
            this.searchBox.m_94192_(0);
        }
    }

    public void refreshAnimationList() {
        this.animationList.refreshAniamtionList(this.searchBox.m_94155_());
    }

    protected void m_7856_() {
        int split = this.f_96543_ / 2 - 80;
        this.modelPreviewer._setWidth(split - 10);
        this.modelPreviewer._setHeight(this.f_96544_ - 68);
        this.modelPreviewer.resize(null);
        this.animationList.m_93437_(this.f_96543_ - split, this.f_96544_, 36, this.f_96544_ - 32);
        this.animationList.m_93507_(split);
        this.searchBox.m_252865_(this.f_96543_ / 2);
        this.searchBox.m_253211_(12);
        this.searchBox.m_93674_(this.f_96543_ / 2 - 12);
        this.searchBox.setHeight(16);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"datapack_edit.import_animation"), button -> Minecraft.m_91087_().m_91152_((Screen)new ImportAnimationsScreen(this, this.modelPreviewer.getArmature(), this.modelPreviewer.getMesh()))).m_252794_(10, 10).m_253046_(100, 21).m_253136_());
        this.m_142416_(this.modelPreviewer);
        this.m_142416_((GuiEventListener)this.animationList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_286989_, button -> {
            if (this.animationList.m_93511_() != null) {
                this.selectCallback.accept(((AnimationList.AnimationEntry)this.animationList.m_93511_()).animation);
            }
            this.m_7379_();
        }).m_252794_(this.f_96543_ / 2 - 162, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            this.cancelCallback.accept(null);
            this.m_7379_();
        }).m_252794_(this.f_96543_ / 2 + 2, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
        this.modelPreviewer.onDestroy();
    }

    public void m_86600_() {
        this.modelPreviewer._tick();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.modelPreviewer.m_7979_(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    class AnimationList
    extends ObjectSelectionList<AnimationEntry> {
        public AnimationList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
        }

        public void setSelected(@Nullable AnimationEntry selEntry) {
            super.m_6987_((AbstractSelectionList.Entry)selEntry);
            SelectAnimationScreen.this.modelPreviewer.clearAnimations();
            SelectAnimationScreen.this.modelPreviewer.addAnimationToPlay(selEntry.animation);
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        public void refreshAniamtionList(String keyward) {
            this.m_93410_(0.0);
            this.m_6702_().clear();
            AnimationManager.getInstance().getAnimations(SelectAnimationScreen.this.filter).values().stream().filter(animation -> StringUtil.m_14408_((String)keyward) ? true : animation.getRegistryName().toString().contains(keyward)).map(x$0 -> new AnimationEntry((StaticAnimation)x$0)).sorted((a1, a2) -> Integer.compare(a1.animation.getId(), a2.animation.getId())).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
            DatapackEditScreen.getCurrentScreen().getUserAniamtions().values().stream().map(packEntry -> ((ClipHoldingAnimation)packEntry.getValue()).cast()).filter(SelectAnimationScreen.this.filter).map(x$0 -> new AnimationEntry((StaticAnimation)x$0)).sorted((a1, a2) -> a1.animation.getRegistryName().compareTo(a2.animation.getRegistryName())).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        @OnlyIn(value=Dist.CLIENT)
        class AnimationEntry
        extends ObjectSelectionList.Entry<AnimationEntry> {
            private final StaticAnimation animation;

            public AnimationEntry(StaticAnimation animation) {
                this.animation = animation;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.m_280056_(((SelectAnimationScreen)SelectAnimationScreen.this).f_96541_.f_91062_, this.animation.getRegistryName().toString(), left + 5, top + 5, 0xFFFFFF, false);
            }

            public Component m_142172_() {
                return Component.m_237115_((String)"narrator.select");
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (AnimationList.this.m_93511_() == this) {
                        SelectAnimationScreen.this.selectCallback.accept(this.animation);
                        SelectAnimationScreen.this.f_96541_.m_91152_(SelectAnimationScreen.this.parentScreen);
                        return true;
                    }
                    AnimationList.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }
}

