/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.widgets;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.LayerOffAnimation;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.CubicBezierCurve;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.datapack.widgets.CheckBox;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.particle.TrailParticle;
import yesman.epicfight.client.renderer.EpicFightShaders;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;

@OnlyIn(value=Dist.CLIENT)
public class ModelPreviewer
extends AbstractWidget
implements ResizableComponent {
    private NoEntityAnimator animator;
    private final ModelRenderTarget modelRenderTarget;
    private final List<StaticAnimation> animationsToPlay = Lists.newArrayList();
    private final List<CustomTrailParticle> trailParticles = Lists.newArrayList();
    private final CheckBox showColliderCheckbox;
    private final CheckBox showItemCheckbox;
    private final CheckBox showTrailCheckbox;
    private double zoom;
    private float xRot;
    private float yRot;
    private float xMove;
    private float yMove;
    private int index;
    private float attackTimeBegin;
    private float attackTimeEnd;
    private MeshProvider<AnimatedMesh> mesh;
    private Joint colliderJoint;
    private Collider collider;
    private List<TrailInfo> trailInfoList;
    private Item item;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private final ResizableComponent.HorizontalSizing horizontalSizingOption;
    private final ResizableComponent.VerticalSizing verticalSizingOption;

    public ModelPreviewer(int x1, int x2, int y1, int y2, ResizableComponent.HorizontalSizing horizontal, ResizableComponent.VerticalSizing vertical, Armature armature, MeshProvider<AnimatedMesh> mesh) {
        super(x1, y1, x2, y2, (Component)Component.m_237113_((String)""));
        this.showColliderCheckbox = new CheckBox(Minecraft.m_91087_().f_91062_, 0, 60, 0, 10, null, null, true, (Component)Component.m_237115_((String)"datapack_edit.model_player.collider"), null);
        this.showItemCheckbox = new CheckBox(Minecraft.m_91087_().f_91062_, 0, 40, 0, 10, null, null, true, (Component)Component.m_237115_((String)"datapack_edit.model_player.item"), null);
        this.showTrailCheckbox = new CheckBox(Minecraft.m_91087_().f_91062_, 0, 40, 0, 10, null, null, true, (Component)Component.m_237115_((String)"datapack_edit.model_player.trail"), null);
        this.zoom = -3.0;
        this.xRot = 0.0f;
        this.yRot = 180.0f;
        this.xMove = 0.0f;
        this.yMove = 0.0f;
        this.trailInfoList = Lists.newArrayList();
        if (armature != null) {
            FakeEntityPatch patch = new FakeEntityPatch(armature);
            this.animator = new NoEntityAnimator(patch);
            patch.setAnimator();
        }
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.horizontalSizingOption = horizontal;
        this.verticalSizingOption = vertical;
        this.mesh = mesh;
        this.modelRenderTarget = new ModelRenderTarget();
        this.resize(Minecraft.m_91087_().f_91080_.m_264198_());
        this.modelRenderTarget.m_83931_(0.1552f, 0.1552f, 0.1552f, 1.0f);
        this.modelRenderTarget.m_83954_(Minecraft.f_91002_);
    }

    public void setArmature(Armature armature) {
        FakeEntityPatch patch = new FakeEntityPatch(armature);
        this.animator = new NoEntityAnimator(patch);
        patch.setAnimator();
    }

    public void setMesh(MeshProvider<AnimatedMesh> mesh) {
        this.mesh = mesh;
    }

    public Armature getArmature() {
        return this.animator.getEntityPatch().getArmature();
    }

    public MeshProvider<AnimatedMesh> getMesh() {
        return this.mesh;
    }

    public NoEntityAnimator getAnimator() {
        return this.animator;
    }

    public void setCollider(Collider collider) {
        this.collider = collider;
    }

    public void setCollider(Collider collider, Joint joint) {
        this.collider = collider;
        this.colliderJoint = joint;
    }

    public void setColliderJoint(Joint joint) {
        this.colliderJoint = joint;
    }

    public void setTrailInfo(TrailInfo ... trailInfos) {
        this.trailInfoList.clear();
        for (TrailInfo trailInfo : trailInfos) {
            this.trailInfoList.add(trailInfo);
        }
    }

    public void setItemToRender(Item item) {
        this.item = item;
    }

    public void setAttackTimeBegin(float attackTimeBegin) {
        this.attackTimeBegin = attackTimeBegin;
    }

    public void setAttackTimeEnd(float attackTimeEnd) {
        this.attackTimeEnd = attackTimeEnd;
    }

    public void addAnimationToPlay(StaticAnimation animation) {
        if (this.index == -1) {
            this.index = 0;
        }
        this.animationsToPlay.add(animation);
        this.animator.playAnimation(animation, 0.0f);
    }

    public void removeAnimationPlayingAnimation(StaticAnimation animation) {
        this.animationsToPlay.remove(animation);
    }

    public void clearAnimations() {
        this.index = -1;
        this.animationsToPlay.clear();
        this.animator.playAnimation(Animations.DUMMY_ANIMATION, 0.0f);
        this.animator.getAllLayers().forEach(layer -> layer.off(this.animator.getEntityPatch()));
        this.animator.playAnimation(Animations.OFF_ANIMATION_HIGHEST, 0.0f);
        this.animator.playAnimation(Animations.OFF_ANIMATION_MIDDLE, 0.0f);
        this.animator.playAnimation(Animations.OFF_ANIMATION_LOWEST, 0.0f);
    }

    public void restartAnimations() {
        this.index = 0;
        if (this.animationsToPlay.size() == 0) {
            this.index = -1;
            return;
        }
        this.animator.playAnimation(this.animationsToPlay.get(0), 0.0f);
    }

    @Override
    public void _tick() {
        if (this.animator != null) {
            this.animator.tick();
        }
        this.trailParticles.forEach(trail -> trail.m_5989_());
        this.trailParticles.removeIf(trail -> !trail.m_107276_());
    }

    public boolean m_6375_(double x, double y, int button) {
        boolean flag;
        if (this.f_93623_ && this.f_93624_ && this.m_7972_(button) && (flag = this.m_93680_(x, y))) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            if (this.item != null && this.showItemCheckbox.m_6375_(x, y, button)) {
                return true;
            }
            if (!this.trailInfoList.isEmpty() && this.showTrailCheckbox.m_6375_(x, y, button)) {
                return true;
            }
            if (this.collider != null && this.showColliderCheckbox.m_6375_(x, y, button)) {
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (button == 0) {
                this.xRot = (float)Mth.m_14008_((double)((double)this.xRot + dy * 2.5), (double)-180.0, (double)180.0);
                this.yRot = (float)((double)this.yRot + dx * 2.5);
            } else if (button == 2) {
                this.xMove = (float)((double)this.xMove + (double)((float)dx * 0.015f) * -this.zoom);
                this.yMove = (float)((double)this.yMove + (double)(-((float)dy) * 0.015f) * -this.zoom);
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double x, double y, double amount) {
        this.zoom = Mth.m_14008_((double)(this.zoom + amount * 0.5), (double)-20.0, (double)-0.5);
        return true;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean scissorApplied;
        Minecraft minecraft = Minecraft.m_91087_();
        partialTicks = minecraft.m_91296_();
        minecraft.m_91385_().m_83970_();
        ScreenRectangle screenrectangle = null;
        boolean bl = scissorApplied = guiGraphics.f_279587_.f_279656_.size() > 0;
        if (scissorApplied) {
            screenrectangle = (ScreenRectangle)guiGraphics.f_279587_.f_279656_.peekLast();
            guiGraphics.m_280618_();
        }
        this.modelRenderTarget.m_83954_(true);
        this.modelRenderTarget.m_83947_(true);
        if (this.animator != null) {
            Pose pose = this.animator.getPose(partialTicks);
            OpenMatrix4f[] poseMatrices = this.getArmature().getPoseAsTransformMatrix(pose, false);
            guiGraphics.m_280168_().m_85836_();
            ShaderInstance prevShader = RenderSystem.getShader();
            Matrix4f oldProjection = RenderSystem.getProjectionMatrix();
            Matrix4f perspective = new Matrix4f().setPerspective(70.0f, (float)this.f_93618_ / (float)this.f_93619_, 0.05f, 100.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)perspective, (VertexSorting)VertexSorting.f_276450_);
            RenderSystem.getModelViewStack().m_85836_();
            RenderSystem.getModelViewStack().m_166856_();
            RenderSystem.applyModelViewMatrix();
            guiGraphics.m_280168_().m_85837_((double)this.xMove, (double)this.yMove - 1.0, this.zoom);
            guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(this.xRot));
            guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(this.yRot));
            this.mesh.get().initialize();
            RenderSystem.setShader(EpicFightShaders::getPositionColorNormalShader);
            Tesselator tesselator = RenderSystem.renderThreadTesselator();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_166851_);
            this.mesh.get().drawToBuffer(guiGraphics.m_280168_(), (VertexConsumer)bufferbuilder, Mesh.DrawingFunction.ENTITY_SOLID, -1, 0.9411f, 0.9411f, 0.9411f, 1.0f, -1, this.getArmature(), poseMatrices);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            if (this.item != null && this.showItemCheckbox._getValue().booleanValue()) {
                MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                ItemStack itemstack = new ItemStack((ItemLike)this.item);
                OpenMatrix4f correction = new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS);
                OpenMatrix4f handTransform = correction.mulFront(this.getArmature().getBindedTransformFor(pose, this.getArmature().searchJointByName("Tool_R")));
                OpenMatrix4f transposed = handTransform.transpose(null);
                guiGraphics.m_280168_().m_85836_();
                MathUtils.translateStack(guiGraphics.m_280168_(), handTransform);
                MathUtils.rotateStack(guiGraphics.m_280168_(), transposed);
                MathUtils.scaleStack(guiGraphics.m_280168_(), transposed);
                BakedModel model = itemRenderer.m_115103_().m_109394_(this.item);
                BakedModel overridedModel = model.m_7343_().m_173464_(model, itemstack, null, null, 0);
                DynamicTexture light = Minecraft.m_91087_().f_91063_.m_109154_().f_109870_;
                light.m_117991_().m_84988_(0, 0, -1);
                light.m_117985_();
                itemRenderer.m_115143_(itemstack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0, OverlayTexture.f_118083_, overridedModel);
                bufferSource.m_109911_();
                guiGraphics.m_280168_().m_85849_();
            }
            if (!this.trailParticles.isEmpty() && this.showTrailCheckbox._getValue().booleanValue()) {
                RenderSystem.setShader(GameRenderer::m_172829_);
                DynamicTexture light = Minecraft.m_91087_().f_91063_.m_109154_().f_109870_;
                light.m_117991_().m_84988_(0, 0, -1);
                light.m_117985_();
                for (CustomTrailParticle trail : this.trailParticles) {
                    ParticleRenderType particleRendertype = trail.m_7556_();
                    particleRendertype.m_6505_(bufferbuilder, Minecraft.m_91087_().f_90987_);
                    trail.m_5744_((VertexConsumer)bufferbuilder, null, partialTicks);
                    particleRendertype.m_6294_(tesselator);
                }
            }
            if (this.collider != null && this.showColliderCheckbox._getValue().booleanValue()) {
                boolean red;
                RenderType renderType = this.collider.getRenderType();
                bufferbuilder.m_166779_(renderType.m_173186_(), renderType.f_110389_);
                RenderSystem.setShader(GameRenderer::m_172757_);
                AnimationPlayer player = this.animator.getPlayerFor(null);
                float elapsedTime = player.getPrevElapsedTime() + (player.getElapsedTime() - player.getPrevElapsedTime()) * partialTicks;
                boolean bl2 = red = elapsedTime >= this.attackTimeBegin && elapsedTime <= this.attackTimeEnd;
                if (this.colliderJoint != null) {
                    Pose prevPose = this.animator.getPose(0.0f);
                    Pose currentPose = this.animator.getPose(1.0f);
                    this.collider.drawInternal(guiGraphics.m_280168_(), (VertexConsumer)bufferbuilder, this.getArmature(), this.colliderJoint, prevPose, currentPose, partialTicks, red ? -65536 : -1);
                } else {
                    DynamicAnimation animation = player.getAnimation();
                    if (animation instanceof AttackAnimation) {
                        AttackAnimation attackanimation = (AttackAnimation)animation;
                        AttackAnimation.Phase phase = attackanimation.getPhaseByTime(elapsedTime);
                        for (AttackAnimation.JointColliderPair pair : phase.getColliders()) {
                            Pose prevPose = animation.getRawPose(player.getPrevElapsedTime());
                            Pose currentPose = animation.getRawPose(player.getElapsedTime());
                            this.collider.drawInternal(guiGraphics.m_280168_(), (VertexConsumer)bufferbuilder, this.getArmature(), (Joint)pair.getFirst(), prevPose, currentPose, partialTicks, -1);
                        }
                    }
                }
                RenderSystem.lineWidth((float)3.0f);
                RenderSystem.disableCull();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                RenderSystem.lineWidth((float)1.0f);
                RenderSystem.enableCull();
            }
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.setProjectionMatrix((Matrix4f)oldProjection, (VertexSorting)VertexSorting.f_276633_);
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShader(() -> prevShader);
        } else if (this.getMesh() != null) {
            guiGraphics.m_280168_().m_85836_();
            ShaderInstance prevShader = RenderSystem.getShader();
            Matrix4f oldProjection = RenderSystem.getProjectionMatrix();
            RenderSystem.setShader(EpicFightShaders::getPositionColorNormalShader);
            Matrix4f perspective = new Matrix4f().setPerspective(70.0f, (float)this.f_93618_ / (float)this.f_93619_, 0.05f, 100.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)perspective, (VertexSorting)VertexSorting.f_276450_);
            RenderSystem.getModelViewStack().m_85836_();
            RenderSystem.getModelViewStack().m_166856_();
            RenderSystem.applyModelViewMatrix();
            guiGraphics.m_280168_().m_85837_((double)this.xMove, (double)this.yMove - 1.0, this.zoom);
            guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(this.xRot));
            guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(this.yRot));
            this.mesh.get().initialize();
            Tesselator tesselator = RenderSystem.renderThreadTesselator();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_166851_);
            this.mesh.get().draw(guiGraphics.m_280168_(), (VertexConsumer)bufferbuilder, Mesh.DrawingFunction.ENTITY_SOLID, -1, 0.9411f, 0.9411f, 0.9411f, 1.0f, OverlayTexture.f_118083_);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.setProjectionMatrix((Matrix4f)oldProjection, (VertexSorting)VertexSorting.f_276633_);
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShader(() -> prevShader);
        }
        this.modelRenderTarget.m_83970_();
        minecraft.m_91385_().m_83947_(true);
        if (scissorApplied) {
            guiGraphics.m_280588_(screenrectangle.m_274563_(), screenrectangle.m_274449_(), screenrectangle.m_274445_(), screenrectangle.m_274349_());
        }
        this.modelRenderTarget.blitToScreen(guiGraphics);
        if (this.animator != null) {
            int top = this._getY() + 6;
            int right = this._getX() + this._getWidth() - 2;
            if (!this.trailInfoList.isEmpty()) {
                this.showTrailCheckbox._setX(right -= this.showTrailCheckbox._getWidth());
                this.showTrailCheckbox._setY(top);
                this.showTrailCheckbox._renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            }
            if (this.item != null) {
                this.showItemCheckbox._setX(right -= this.showItemCheckbox._getWidth());
                this.showItemCheckbox._setY(top);
                this.showItemCheckbox._renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            }
            if (this.collider != null) {
                this.showColliderCheckbox._setX(right -= this.showColliderCheckbox._getWidth());
                this.showColliderCheckbox._setY(top);
                this.showColliderCheckbox._renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            }
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementInput) {
        narrationElementInput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    @Override
    public void resize(ScreenRectangle screenRectangle) {
        if (this.getHorizontalSizingOption() != null) {
            this.getHorizontalSizingOption().resizeFunction.resize(this, screenRectangle, this.getX1(), this.getX2());
        }
        if (this.getVerticalSizingOption() != null) {
            this.getVerticalSizingOption().resizeFunction.resize(this, screenRectangle, this.getY1(), this.getY2());
        }
        double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
        this.modelRenderTarget.m_83941_(this._getWidth() * (int)guiScale, this._getHeight() * (int)guiScale, true);
    }

    public void onDestroy() {
        this.modelRenderTarget.m_83930_();
    }

    @Override
    public void setX1(int x1) {
        this.x1 = x1;
    }

    @Override
    public void setX2(int x2) {
        this.x2 = x2;
    }

    @Override
    public void setY1(int y1) {
        this.y1 = y1;
    }

    @Override
    public void setY2(int y2) {
        this.y2 = y2;
    }

    @Override
    public int getX1() {
        return this.x1;
    }

    @Override
    public int getX2() {
        return this.x2;
    }

    @Override
    public int getY1() {
        return this.y1;
    }

    @Override
    public int getY2() {
        return this.y2;
    }

    @Override
    public ResizableComponent.HorizontalSizing getHorizontalSizingOption() {
        return this.horizontalSizingOption;
    }

    @Override
    public ResizableComponent.VerticalSizing getVerticalSizingOption() {
        return this.verticalSizingOption;
    }

    @Override
    public void _setActive(boolean active) {
    }

    @Override
    public int _getX() {
        return this.m_252754_();
    }

    @Override
    public int _getY() {
        return this.m_252907_();
    }

    @Override
    public int _getWidth() {
        return this.m_5711_();
    }

    @Override
    public int _getHeight() {
        return this.m_93694_();
    }

    @Override
    public void _setX(int x) {
        this.m_252865_(x);
    }

    @Override
    public void _setY(int y) {
        this.m_253211_(y);
    }

    @Override
    public void _setWidth(int width) {
        this.m_93674_(width);
    }

    @Override
    public void _setHeight(int height) {
        this.setHeight(height);
    }

    @Override
    public Component _getMessage() {
        return this.m_6035_();
    }

    @Override
    public void _renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class FakeEntityPatch
    extends LivingEntityPatch<LivingEntity> {
        public FakeEntityPatch(Armature armature) {
            this.armature = armature.deepCopy();
        }

        public void setAnimator() {
            this.animator = ModelPreviewer.this.animator;
        }

        @Override
        public void initAnimator(Animator clientAnimator) {
        }

        @Override
        public void updateMotion(boolean considerInaction) {
        }

        @Override
        public StaticAnimation getHitAnimation(StunType stunType) {
            return null;
        }

        @Override
        public boolean isLogicalClient() {
            return true;
        }

        @Override
        public void cancelAnyAction() {
        }

        @Override
        public float getAttackDirectionPitch() {
            return 0.0f;
        }

        @Override
        public OpenMatrix4f getModelMatrix(float partialTicks) {
            return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTicks, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void poseTick(DynamicAnimation animation, Pose pose, float time, float partialTicks) {
        }

        @Override
        public void updateEntityState() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class NoEntityAnimator
    extends ClientAnimator {
        public NoEntityAnimator(FakeEntityPatch entitypatch) {
            super(entitypatch, NoEntityBaseLayer::new);
        }

        @Override
        public void tick() {
            this.baseLayer.update(this.entitypatch);
            if (this.baseLayer.animationPlayer.isEnd() && this.baseLayer.getNextAnimation() == null) {
                StaticAnimation toPlay = ModelPreviewer.this.index > -1 && ModelPreviewer.this.index < ModelPreviewer.this.animationsToPlay.size() ? ModelPreviewer.this.animationsToPlay.get(ModelPreviewer.this.index) : Animations.DUMMY_ANIMATION;
                this.baseLayer.playAnimation(toPlay, this.entitypatch, 0.0f);
                if (!ModelPreviewer.this.trailInfoList.isEmpty()) {
                    for (TrailInfo trailInfo : ModelPreviewer.this.trailInfoList) {
                        if (trailInfo.playable()) {
                            CustomTrailParticle trail = new CustomTrailParticle(ModelPreviewer.this.getArmature().searchJointByName(trailInfo.joint), toPlay, trailInfo);
                            ModelPreviewer.this.trailParticles.add(trail);
                            continue;
                        }
                        toPlay.getProperty(ClientAnimationProperties.TRAIL_EFFECT).ifPresent(trailInfos -> {
                            for (TrailInfo info : trailInfos) {
                                TrailInfo combinedTrailInfo;
                                if (info.hand != InteractionHand.MAIN_HAND || !(combinedTrailInfo = trailInfo.overwrite(info)).playable()) continue;
                                CustomTrailParticle trail = new CustomTrailParticle(ModelPreviewer.this.getArmature().searchJointByName(combinedTrailInfo.joint), toPlay, combinedTrailInfo);
                                ModelPreviewer.this.trailParticles.add(trail);
                            }
                        });
                    }
                }
                ModelPreviewer.this.index = (ModelPreviewer.this.index + 1) % ModelPreviewer.this.animationsToPlay.size();
            }
        }

        public LivingEntityPatch<?> getEntityPatch() {
            return this.entitypatch;
        }

        @OnlyIn(value=Dist.CLIENT)
        static class NoEntityBaseLayer
        extends Layer.BaseLayer {
            public NoEntityBaseLayer() {
                super(NoEntityAnimationPlayer::new);
                this.compositeLayers.clear();
                this.compositeLayers.computeIfAbsent(Layer.Priority.LOWEST, NoEntityLayer::new);
                this.compositeLayers.computeIfAbsent(Layer.Priority.MIDDLE, NoEntityLayer::new);
                this.compositeLayers.computeIfAbsent(Layer.Priority.HIGHEST, NoEntityLayer::new);
            }

            @Override
            public void playAnimation(StaticAnimation nextAnimation, LivingEntityPatch<?> entitypatch, float convertTimeModifier) {
                Layer.Priority priority;
                this.baseLayerPriority = priority = nextAnimation.getPriority();
                this.offCompositeLayerLowerThan(entitypatch, nextAnimation);
                Pose lastPose = ((Animator)entitypatch.getAnimator()).getPose(1.0f);
                this.resume();
                if (!nextAnimation.isMetaAnimation()) {
                    this.setLinkAnimation(nextAnimation, entitypatch, lastPose, convertTimeModifier);
                    this.linkAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                    entitypatch.updateEntityState();
                    this.nextAnimation = nextAnimation;
                }
            }

            @Override
            public void playAnimationInstant(DynamicAnimation nextAnimation, LivingEntityPatch<?> entitypatch) {
                this.resume();
                nextAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                this.nextAnimation = null;
            }

            @Override
            protected void playLivingAnimation(StaticAnimation nextAnimation, LivingEntityPatch<?> entitypatch) {
                this.resume();
                if (!nextAnimation.isMetaAnimation()) {
                    this.concurrentLinkAnimation.acceptFrom(this.animationPlayer.getAnimation().getRealAnimation(), nextAnimation, this.animationPlayer.getElapsedTime());
                    this.concurrentLinkAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                    this.nextAnimation = nextAnimation;
                }
            }

            @Override
            public void update(LivingEntityPatch<?> entitypatch) {
                if (this.paused) {
                    this.animationPlayer.setElapsedTime(this.animationPlayer.getElapsedTime());
                } else {
                    this.animationPlayer.tick(entitypatch);
                }
                if (!this.paused && this.animationPlayer.isEnd()) {
                    if (this.nextAnimation != null) {
                        this.nextAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                        this.nextAnimation = null;
                    } else if (this.animationPlayer.getAnimation() instanceof LayerOffAnimation) {
                        this.animationPlayer.getAnimation().end(entitypatch, Animations.DUMMY_ANIMATION, true);
                    } else {
                        this.off(entitypatch);
                    }
                }
                for (Layer layer : this.compositeLayers.values()) {
                    layer.update(entitypatch);
                }
            }

            @Override
            protected void setLinkAnimation(StaticAnimation nextAnimation, LivingEntityPatch<?> entitypatch, Pose lastPose, float convertTimeModifier) {
                DynamicAnimation fromAnimation;
                Pose currentPose = this.animationPlayer.getAnimation().getRawPose(this.animationPlayer.getElapsedTime());
                Pose nextAnimationPose = nextAnimation.getRawPose(0.0f);
                float totalTime = nextAnimation.getConvertTime();
                DynamicAnimation dynamicAnimation = fromAnimation = this.animationPlayer.isEmpty() ? entitypatch.getClientAnimator().baseLayer.animationPlayer.getAnimation() : this.animationPlayer.getAnimation();
                if (fromAnimation instanceof LinkAnimation) {
                    LinkAnimation linkAnimation = (LinkAnimation)fromAnimation;
                    fromAnimation = linkAnimation.getFromAnimation();
                }
                this.linkAnimation.getTransfroms().clear();
                this.linkAnimation.setTotalTime(totalTime);
                this.linkAnimation.setConnectedAnimations(fromAnimation, nextAnimation);
                Map<String, JointTransform> data1 = currentPose.getJointTransformData();
                Map<String, JointTransform> data2 = nextAnimationPose.getJointTransformData();
                for (String jointName : data1.keySet()) {
                    if (!data1.containsKey(jointName) || !data2.containsKey(jointName)) continue;
                    Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.get(jointName)), new Keyframe(totalTime, data2.get(jointName))};
                    TransformSheet sheet = new TransformSheet(keyframes);
                    this.linkAnimation.getAnimationClip().addJointTransform(jointName, sheet);
                }
                this.animationPlayer.setPlayAnimation(this.linkAnimation);
            }

            @Override
            public void offCompositeLayerLowerThan(LivingEntityPatch<?> entitypatch, StaticAnimation nextAnimation) {
                for (Layer.Priority p : nextAnimation.getPriority().lowerEquals()) {
                    if (p == Layer.Priority.LOWEST && !nextAnimation.isMainFrameAnimation()) continue;
                    ((Layer)this.compositeLayers.get((Object)p)).off(entitypatch);
                }
            }

            @Override
            public Layer getLayer(Layer.Priority priority) {
                return (Layer)this.compositeLayers.get((Object)priority);
            }

            @Override
            public void off(LivingEntityPatch<?> entitypatch) {
            }

            @Override
            protected boolean isDisabled() {
                return false;
            }

            @Override
            protected boolean isBaseLayer() {
                return true;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        static class NoEntityLayer
        extends Layer {
            public NoEntityLayer(Layer.Priority priority) {
                super(priority, NoEntityAnimationPlayer::new);
            }

            @Override
            public void playAnimation(StaticAnimation nextAnimation, LivingEntityPatch<?> entitypatch, float convertTimeModifier) {
                Pose lastPose = ((Animator)entitypatch.getAnimator()).getPose(1.0f);
                this.resume();
                if (!nextAnimation.isMetaAnimation()) {
                    this.setLinkAnimation(nextAnimation, entitypatch, lastPose, convertTimeModifier);
                    this.linkAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                    this.nextAnimation = nextAnimation;
                }
            }

            @Override
            public void playAnimationInstant(DynamicAnimation nextAnimation, LivingEntityPatch<?> entitypatch) {
                this.resume();
                nextAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                this.nextAnimation = null;
            }

            @Override
            protected void setLinkAnimation(StaticAnimation nextAnimation, LivingEntityPatch<?> entitypatch, Pose lastPose, float convertTimeModifier) {
                DynamicAnimation fromAnimation;
                Pose currentPose = this.animationPlayer.getAnimation().getRawPose(this.animationPlayer.getElapsedTime());
                Pose nextAnimationPose = nextAnimation.getRawPose(0.0f);
                float totalTime = nextAnimation.getConvertTime();
                DynamicAnimation dynamicAnimation = fromAnimation = this.animationPlayer.isEmpty() ? entitypatch.getClientAnimator().baseLayer.animationPlayer.getAnimation() : this.animationPlayer.getAnimation();
                if (fromAnimation instanceof LinkAnimation) {
                    LinkAnimation linkAnimation = (LinkAnimation)fromAnimation;
                    fromAnimation = linkAnimation.getFromAnimation();
                }
                this.linkAnimation.getTransfroms().clear();
                this.linkAnimation.setTotalTime(totalTime);
                this.linkAnimation.setConnectedAnimations(fromAnimation, nextAnimation);
                Map<String, JointTransform> data1 = currentPose.getJointTransformData();
                Map<String, JointTransform> data2 = nextAnimationPose.getJointTransformData();
                for (String jointName : data1.keySet()) {
                    if (!data1.containsKey(jointName) || !data2.containsKey(jointName)) continue;
                    Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.get(jointName)), new Keyframe(totalTime, data2.get(jointName))};
                    TransformSheet sheet = new TransformSheet(keyframes);
                    this.linkAnimation.getAnimationClip().addJointTransform(jointName, sheet);
                }
                this.animationPlayer.setPlayAnimation(this.linkAnimation);
            }

            @Override
            public void update(LivingEntityPatch<?> entitypatch) {
                if (this.paused) {
                    this.animationPlayer.setElapsedTime(this.animationPlayer.getElapsedTime());
                } else {
                    this.animationPlayer.tick(entitypatch);
                }
                if (!this.paused && this.animationPlayer.isEnd()) {
                    if (this.nextAnimation != null) {
                        this.nextAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                        this.nextAnimation = null;
                    } else if (this.animationPlayer.getAnimation() instanceof LayerOffAnimation) {
                        this.animationPlayer.getAnimation().end(entitypatch, Animations.DUMMY_ANIMATION, true);
                    } else {
                        this.off(entitypatch);
                    }
                }
            }

            public Pose getEnabledPose(LivingEntityPatch<?> entitypatch, float partialTick) {
                DynamicAnimation animation = this.animationPlayer.getAnimation();
                Pose pose = animation.getRawPose(this.animationPlayer.getPrevElapsedTime() + (this.animationPlayer.getElapsedTime() - this.animationPlayer.getPrevElapsedTime()) * partialTick);
                pose.removeJointIf((Predicate<? super Map.Entry<String, JointTransform>>)((Predicate)entry -> !animation.hasTransformFor((String)entry.getKey())));
                return pose;
            }

            @Override
            public void off(LivingEntityPatch<?> entitypatch) {
                if (!this.isDisabled() && !(this.animationPlayer.getAnimation() instanceof LayerOffAnimation)) {
                    float convertTime = entitypatch.getClientAnimator().baseLayer.animationPlayer.getAnimation().getConvertTime();
                    NoEntityLayer.setLayerOffAnimation(this.animationPlayer.getAnimation(), this.getEnabledPose(entitypatch, 1.0f), this.layerOffAnimation, convertTime);
                    this.playAnimationInstant(this.layerOffAnimation, entitypatch);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        static class NoEntityAnimationPlayer
        extends AnimationPlayer {
            NoEntityAnimationPlayer() {
            }

            @Override
            public void tick(LivingEntityPatch<?> entitypatch) {
                this.prevElapsedTime = this.elapsedTime;
                this.elapsedTime += 0.05f * (this.isReversed() && this.getAnimation().canBePlayedReverse() ? -1.0f : 1.0f);
                if (this.elapsedTime >= this.play.getTotalTime()) {
                    if (this.play.isRepeat()) {
                        this.prevElapsedTime = 0.0f;
                        this.elapsedTime %= this.play.getTotalTime();
                    } else {
                        this.elapsedTime = this.play.getTotalTime();
                        this.isEnd = true;
                    }
                } else if (this.elapsedTime < 0.0f) {
                    if (this.play.isRepeat()) {
                        this.prevElapsedTime = this.play.getTotalTime();
                        this.elapsedTime = this.play.getTotalTime() + this.elapsedTime;
                    } else {
                        this.elapsedTime = 0.0f;
                        this.isEnd = true;
                    }
                }
            }

            @Override
            public void begin(DynamicAnimation animation, LivingEntityPatch<?> entitypatch) {
            }

            @Override
            public Pose getCurrentPose(LivingEntityPatch<?> entitypatch, float partialTicks) {
                return this.play.getRawPose(this.prevElapsedTime + (this.elapsedTime - this.prevElapsedTime) * partialTicks);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ModelRenderTarget
    extends RenderTarget {
        public ModelRenderTarget() {
            super(true);
            RenderSystem.assertOnRenderThreadOrInit();
            Window window = Minecraft.m_91087_().m_91268_();
            this.m_83941_(window.m_85441_(), window.m_85442_(), false);
        }

        private void blitToScreen(GuiGraphics guiGraphics) {
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderTexture((int)0, (int)this.f_83923_);
            float left = ModelPreviewer.this._getX();
            float top = ModelPreviewer.this._getY();
            float right = left + (float)ModelPreviewer.this._getWidth();
            float bottom = top + (float)ModelPreviewer.this._getHeight();
            float u = (float)this.f_83917_ / (float)this.f_83915_;
            float v = (float)this.f_83918_ / (float)this.f_83916_;
            guiGraphics.m_280168_().m_85836_();
            Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_252986_(matrix4f, left, bottom, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, right, bottom, 0.0f).m_7421_(u, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, right, top, 0.0f).m_7421_(u, v).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, left, top, 0.0f).m_7421_(0.0f, v).m_6122_(255, 255, 255, 255).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            guiGraphics.m_280168_().m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class CustomTrailParticle
    extends TrailParticle {
        protected CustomTrailParticle(Joint joint, StaticAnimation animation, TrailInfo trailInfo) {
            super(ModelPreviewer.this.getArmature(), ModelPreviewer.this.animator.getEntityPatch(), joint, animation, trailInfo);
        }

        @Override
        public void m_5989_() {
            boolean visibleTrail;
            List<Object> finalEndPositions;
            List<Object> finalStartPositions;
            boolean needCorrection;
            AnimationPlayer animPlayer = ModelPreviewer.this.animator.getPlayerFor(null);
            this.visibleTrailEdges.removeIf(v -> !v.isAlive());
            if (this.animationEnd) {
                if (this.f_107225_-- == 0) {
                    this.m_107274_();
                }
            } else if (this.animation != animPlayer.getAnimation().getRealAnimation() || animPlayer.getElapsedTime() > this.trailInfo.endTime) {
                this.animationEnd = true;
                this.f_107225_ = this.trailInfo.trailLifetime;
            }
            if (this.trailInfo.fadeTime > 0.0f && this.trailInfo.endTime < animPlayer.getElapsedTime()) {
                return;
            }
            boolean isTrailInvisible = animPlayer.getAnimation().isLinkAnimation() || animPlayer.getElapsedTime() <= this.trailInfo.startTime;
            boolean isFirstTrail = this.visibleTrailEdges.isEmpty();
            boolean bl = needCorrection = !isTrailInvisible && isFirstTrail;
            if (needCorrection) {
                float startCorrection = Math.max((this.trailInfo.startTime - animPlayer.getPrevElapsedTime()) / (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()), 0.0f);
                this.startEdgeCorrection = (float)(this.trailInfo.interpolateCount * 2) * startCorrection;
            }
            TrailInfo trailInfo = this.trailInfo;
            Pose prevPose = ((Animator)this.entitypatch.getAnimator()).getPose(0.0f);
            Pose middlePose = ((Animator)this.entitypatch.getAnimator()).getPose(0.5f);
            Pose currentPose = ((Animator)this.entitypatch.getAnimator()).getPose(1.0f);
            OpenMatrix4f prevJointTf = ModelPreviewer.this.getArmature().getBindedTransformFor(prevPose, this.joint);
            OpenMatrix4f middleJointTf = ModelPreviewer.this.getArmature().getBindedTransformFor(middlePose, this.joint);
            OpenMatrix4f currentJointTf = ModelPreviewer.this.getArmature().getBindedTransformFor(currentPose, this.joint);
            Vec3 prevStartPos = OpenMatrix4f.transform(prevJointTf, trailInfo.start);
            Vec3 prevEndPos = OpenMatrix4f.transform(prevJointTf, trailInfo.end);
            Vec3 middleStartPos = OpenMatrix4f.transform(middleJointTf, trailInfo.start);
            Vec3 middleEndPos = OpenMatrix4f.transform(middleJointTf, trailInfo.end);
            Vec3 currentStartPos = OpenMatrix4f.transform(currentJointTf, trailInfo.start);
            Vec3 currentEndPos = OpenMatrix4f.transform(currentJointTf, trailInfo.end);
            if (isTrailInvisible) {
                finalStartPositions = Lists.newArrayList();
                finalEndPositions = Lists.newArrayList();
                finalStartPositions.add(prevStartPos);
                finalStartPositions.add(middleStartPos);
                finalEndPositions.add(prevEndPos);
                finalEndPositions.add(middleEndPos);
                this.invisibleTrailEdges.clear();
                visibleTrail = false;
            } else {
                TrailParticle.TrailEdge edge2;
                TrailParticle.TrailEdge edge1;
                ArrayList startPosList = Lists.newArrayList();
                ArrayList endPosList = Lists.newArrayList();
                if (isFirstTrail) {
                    int lastIdx = this.invisibleTrailEdges.size() - 1;
                    edge1 = (TrailParticle.TrailEdge)this.invisibleTrailEdges.get(lastIdx);
                    edge2 = new TrailParticle.TrailEdge(prevStartPos, prevEndPos, -1);
                } else {
                    edge1 = (TrailParticle.TrailEdge)this.visibleTrailEdges.get(this.visibleTrailEdges.size() - (this.trailInfo.interpolateCount / 2 + 1));
                    edge2 = (TrailParticle.TrailEdge)this.visibleTrailEdges.get(this.visibleTrailEdges.size() - 1);
                    ++edge2.lifetime;
                }
                startPosList.add(edge1.start);
                endPosList.add(edge1.end);
                startPosList.add(edge2.start);
                endPosList.add(edge2.end);
                startPosList.add(middleStartPos);
                endPosList.add(middleEndPos);
                startPosList.add(currentStartPos);
                endPosList.add(currentEndPos);
                finalStartPositions = CubicBezierCurve.getBezierInterpolatedPoints(startPosList, 1, 3, this.trailInfo.interpolateCount);
                finalEndPositions = CubicBezierCurve.getBezierInterpolatedPoints(endPosList, 1, 3, this.trailInfo.interpolateCount);
                if (!isFirstTrail) {
                    finalStartPositions.remove(0);
                    finalEndPositions.remove(0);
                }
                visibleTrail = true;
            }
            this.makeTrailEdges((List<Vec3>)finalStartPositions, (List<Vec3>)finalEndPositions, visibleTrail ? this.visibleTrailEdges : this.invisibleTrailEdges);
        }

        @Override
        public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
            if (this.visibleTrailEdges.isEmpty()) {
                return;
            }
            TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
            AbstractTexture abstracttexture = texturemanager.m_118506_(this.trailInfo.texturePath);
            RenderSystem.bindTexture((int)abstracttexture.m_117963_());
            RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
            RenderSystem.setShaderTexture((int)0, (int)abstracttexture.m_117963_());
            PoseStack poseStack = new PoseStack();
            this.setupPoseStack(poseStack, camera, partialTick);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            int edges = this.visibleTrailEdges.size() - 1;
            boolean startFade = ((TrailParticle.TrailEdge)this.visibleTrailEdges.get((int)0)).lifetime == 1;
            boolean endFade = ((TrailParticle.TrailEdge)this.visibleTrailEdges.get((int)edges)).lifetime == this.trailInfo.trailLifetime;
            float startEdge = (startFade ? (float)(this.trailInfo.interpolateCount * 2) * partialTick : 0.0f) + this.startEdgeCorrection;
            float endEdge = endFade ? Math.min((float)edges - (float)(this.trailInfo.interpolateCount * 2) * (1.0f - partialTick), (float)(edges - 1)) : (float)(edges - 1);
            float interval = 1.0f / (endEdge - startEdge);
            float fading = 1.0f;
            if (this.animationEnd) {
                fading = TrailInfo.isValidTime(this.trailInfo.fadeTime) ? (float)this.f_107225_ / (float)this.trailInfo.trailLifetime : Mth.m_14036_((float)(((float)this.f_107225_ + (1.0f - partialTick)) / (float)this.trailInfo.trailLifetime), (float)0.0f, (float)1.0f);
            }
            float partialStartEdge = interval * (startEdge % 1.0f);
            float from = -partialStartEdge;
            float to = -partialStartEdge + interval;
            for (int i = (int)startEdge; i < (int)endEdge + 1; ++i) {
                TrailParticle.TrailEdge e1 = (TrailParticle.TrailEdge)this.visibleTrailEdges.get(i);
                TrailParticle.TrailEdge e2 = (TrailParticle.TrailEdge)this.visibleTrailEdges.get(i + 1);
                Vector4f pos1 = new Vector4f((float)e1.start.f_82479_, (float)e1.start.f_82480_, (float)e1.start.f_82481_, 1.0f);
                Vector4f pos2 = new Vector4f((float)e1.end.f_82479_, (float)e1.end.f_82480_, (float)e1.end.f_82481_, 1.0f);
                Vector4f pos3 = new Vector4f((float)e2.end.f_82479_, (float)e2.end.f_82480_, (float)e2.end.f_82481_, 1.0f);
                Vector4f pos4 = new Vector4f((float)e2.start.f_82479_, (float)e2.start.f_82480_, (float)e2.start.f_82481_, 1.0f);
                pos1.mul((Matrix4fc)matrix4f);
                pos2.mul((Matrix4fc)matrix4f);
                pos3.mul((Matrix4fc)matrix4f);
                pos4.mul((Matrix4fc)matrix4f);
                float alphaFrom = Mth.m_14036_((float)from, (float)0.0f, (float)1.0f);
                float alphaTo = Mth.m_14036_((float)to, (float)0.0f, (float)1.0f);
                vertexConsumer.m_5483_((double)pos1.x(), (double)pos1.y(), (double)pos1.z()).m_7421_(from, 1.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaFrom * fading).m_85969_(0).m_5752_();
                vertexConsumer.m_5483_((double)pos2.x(), (double)pos2.y(), (double)pos2.z()).m_7421_(from, 0.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaFrom * fading).m_85969_(0).m_5752_();
                vertexConsumer.m_5483_((double)pos3.x(), (double)pos3.y(), (double)pos3.z()).m_7421_(to, 0.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaTo * fading).m_85969_(0).m_5752_();
                vertexConsumer.m_5483_((double)pos4.x(), (double)pos4.y(), (double)pos4.z()).m_7421_(to, 1.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaTo * fading).m_85969_(0).m_5752_();
                from += interval;
                to += interval;
            }
        }

        @Override
        protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
            float x = ModelPreviewer.this.xMove;
            float y = ModelPreviewer.this.yMove;
            float z = (float)ModelPreviewer.this.zoom;
            float xRot = ModelPreviewer.this.xRot;
            float yRot = ModelPreviewer.this.yRot;
            poseStack.m_85837_((double)x, (double)y - 1.0, (double)z);
            poseStack.m_252781_(QuaternionUtils.XP.rotationDegrees(xRot));
            poseStack.m_252781_(QuaternionUtils.YP.rotationDegrees(yRot));
        }
    }
}

