/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.EmptyLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedItemInHandLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.client.renderer.patched.layer.WearableItemLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.mixin.MixinLivingEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class FirstPersonRenderer
extends PatchedLivingEntityRenderer<LocalPlayer, LocalPlayerPatch, PlayerModel<LocalPlayer>, LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>>, HumanoidMesh> {
    public FirstPersonRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
        this.addPatchedLayer(ElytraLayer.class, new EmptyLayer());
        this.addPatchedLayer(PlayerItemInHandLayer.class, new PatchedItemInHandLayer());
        this.addPatchedLayer(HumanoidArmorLayer.class, new WearableItemLayer(() -> Meshes.BIPED, true, context.m_266367_()));
        this.addPatchedLayer(CustomHeadLayer.class, new EmptyLayer());
        this.addPatchedLayer(ArrowLayer.class, new EmptyLayer());
        this.addPatchedLayer(BeeStingerLayer.class, new EmptyLayer());
        this.addPatchedLayer(SpinAttackEffectLayer.class, new EmptyLayer());
        this.addPatchedLayer(CapeLayer.class, new EmptyLayer());
    }

    @Override
    public void render(LocalPlayer entity, LocalPlayerPatch entitypatch, LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Pose pose = ((Animator)entitypatch.getAnimator()).getPose(partialTicks);
        OpenMatrix4f[] poses = entitypatch.getArmature().getPoseAsTransformMatrix(pose, false);
        poseStack.m_85836_();
        Matrix4f lastPose = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        poseStack.m_166856_();
        float correction = 0.0f;
        if (entity.m_6067_()) {
            correction = 0.25f;
        } else if (entity.m_21255_()) {
            correction = 100.0f;
        }
        poseStack.m_252880_(0.0f, -entity.m_20192_() - 0.05f, correction);
        poseStack.m_252931_(lastPose);
        HumanoidMesh mesh = this.getMeshProvider(entitypatch).get();
        this.prepareModel(mesh, entity, entitypatch, renderer);
        if (!((LocalPlayer)entitypatch.getOriginal()).m_20145_()) {
            for (AnimatedMesh.AnimatedModelPart p : mesh.getAllParts()) {
                p.setHidden(true);
            }
            mesh.leftArm.setHidden(false);
            mesh.rightArm.setHidden(false);
            mesh.leftSleeve.setHidden(false);
            mesh.rightSleeve.setHidden(false);
            RenderType renderType = RenderType.m_110458_((ResourceLocation)entity.m_108560_());
            mesh.draw(poseStack, buffer, renderType, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), poses);
        }
        if (!entity.m_5833_()) {
            this.renderLayer(renderer, entitypatch, entity, poses, buffer, poseStack, packedLight, partialTicks);
        }
        poseStack.m_85849_();
    }

    @Override
    protected void renderLayer(LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>> renderer, LocalPlayerPatch entitypatch, LocalPlayer entity, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Iterator iter = renderer.f_115291_.iterator();
        float f = MathUtils.lerpBetween(entity.f_20884_, entity.f_20883_, partialTicks);
        float f1 = MathUtils.lerpBetween(entity.f_20886_, entity.f_20885_, partialTicks);
        float f2 = f1 - f;
        float f7 = entity.m_5686_(partialTicks);
        float bob = ((MixinLivingEntityRenderer)renderer).invokeGetBob((LivingEntity)entity, partialTicks);
        while (iter.hasNext()) {
            RenderLayer layer = (RenderLayer)iter.next();
            Class<?> rendererClass = layer.getClass();
            if (rendererClass.isAnonymousClass()) {
                rendererClass = rendererClass.getSuperclass();
            }
            if (!this.patchedLayers.containsKey(rendererClass)) continue;
            ((PatchedLayer)this.patchedLayers.get(rendererClass)).renderLayer(entity, entitypatch, layer, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
    }

    @Override
    public MeshProvider<HumanoidMesh> getMeshProvider(LocalPlayerPatch entitypatch) {
        return ((LocalPlayer)entitypatch.getOriginal()).m_108564_().equals("slim") ? () -> Meshes.ALEX : () -> Meshes.BIPED;
    }

    @Override
    public MeshProvider<HumanoidMesh> getDefaultMesh() {
        return () -> Meshes.BIPED;
    }

    @Override
    protected void prepareModel(HumanoidMesh mesh, LocalPlayer entity, LocalPlayerPatch entitypatch, LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>> renderer) {
        mesh.initialize();
        mesh.head.setHidden(true);
        mesh.hat.setHidden(true);
    }
}

