/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.IronGolemCrackinessLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.mesh.IronGolemMesh;
import yesman.epicfight.client.renderer.patched.layer.ModelRenderLayer;
import yesman.epicfight.world.capabilities.entitypatch.mob.IronGolemPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedGolemCrackLayer
extends ModelRenderLayer<IronGolem, IronGolemPatch, IronGolemModel<IronGolem>, IronGolemCrackinessLayer, IronGolemMesh> {
    private static final Map<IronGolem.Crackiness, ResourceLocation> CRACK_MAP = ImmutableMap.of((Object)IronGolem.Crackiness.LOW, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_low.png"), (Object)IronGolem.Crackiness.MEDIUM, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_medium.png"), (Object)IronGolem.Crackiness.HIGH, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_high.png"));

    public PatchedGolemCrackLayer(MeshProvider<IronGolemMesh> mesh) {
        super(mesh);
    }

    @Override
    protected void renderLayer(IronGolemPatch entitypatch, IronGolem golementity, IronGolemCrackinessLayer vanillaLayer, PoseStack postStack, MultiBufferSource buffer, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
        IronGolem.Crackiness crack = golementity.m_28873_();
        if (crack != IronGolem.Crackiness.NONE) {
            ((IronGolemMesh)this.mesh.get()).draw(postStack, buffer, RenderType.m_110458_((ResourceLocation)CRACK_MAP.get(crack)), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), poses);
        }
    }
}

