/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangePlayerMode;
import yesman.epicfight.network.client.CPModifyEntityModelYRot;
import yesman.epicfight.network.client.CPPlayAnimation;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@OnlyIn(value=Dist.CLIENT)
public class LocalPlayerPatch
extends AbstractClientPlayerPatch<LocalPlayer> {
    private static final UUID ACTION_EVENT_UUID = UUID.fromString("d1a1e102-1621-11ed-861d-0242ac120002");
    private Minecraft minecraft;
    private LivingEntity rayTarget;
    private boolean targetLockedOn;
    private float prevStamina;
    private int prevChargingAmount;
    private float lockOnXRot;
    private float lockOnXRotO;
    private float lockOnYRot;
    private float lockOnYRotO;

    @Override
    public void onConstructed(LocalPlayer entity) {
        super.onConstructed(entity);
        this.minecraft = Minecraft.m_91087_();
    }

    @Override
    public void onJoinWorld(LocalPlayer entityIn, EntityJoinLevelEvent event) {
        super.onJoinWorld(entityIn, event);
        this.eventListeners.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_CLIENT, ACTION_EVENT_UUID, playerEvent -> ClientEngine.getInstance().controllEngine.unlockHotkeys());
    }

    public void onRespawnLocalPlayer(ClientPlayerNetworkEvent.Clone event) {
        this.onJoinWorld(event.getNewPlayer(), new EntityJoinLevelEvent((Entity)event.getNewPlayer(), event.getNewPlayer().m_9236_()));
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        this.prevStamina = this.getStamina();
        this.prevChargingAmount = this.isChargingSkill() ? this.getChargingSkill().getChargingAmount(this) : 0;
        super.tick(event);
    }

    @Override
    public void clientTick(LivingEvent.LivingTickEvent event) {
        Entity hit;
        this.prevStamina = this.getStamina();
        super.clientTick(event);
        HitResult cameraHitResult = this.minecraft.f_91077_;
        if (cameraHitResult != null && cameraHitResult.m_6662_() == HitResult.Type.ENTITY && (hit = ((EntityHitResult)cameraHitResult).m_82443_()) != this.rayTarget && hit != this.original) {
            if (hit instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)hit;
                if (!(hit instanceof ArmorStand) && !this.targetLockedOn) {
                    this.rayTarget = livingentity;
                }
            } else if (hit instanceof PartEntity) {
                PartEntity partEntity = (PartEntity)hit;
                Entity parent = partEntity.getParent();
                if (parent instanceof LivingEntity) {
                    LivingEntity parentLivingEntity = (LivingEntity)parent;
                    if (!this.targetLockedOn) {
                        this.rayTarget = parentLivingEntity;
                    }
                }
            } else {
                this.rayTarget = null;
            }
            if (this.rayTarget != null) {
                EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(this.getTarget().m_19879_()));
            }
        }
        if (this.rayTarget != null) {
            if (this.targetLockedOn) {
                Vec3 playerPosition = ((LocalPlayer)this.original).m_146892_();
                Vec3 targetPosition = this.rayTarget.m_146892_();
                Vec3 toTarget = targetPosition.m_82546_(playerPosition);
                float yaw = (float)MathUtils.getYRotOfVector(toTarget);
                float pitch = (float)MathUtils.getXRotOfVector(toTarget);
                CameraType cameraType = this.minecraft.f_91066_.m_92176_();
                this.lockOnXRotO = this.lockOnXRot;
                this.lockOnYRotO = this.lockOnYRot;
                float lockOnXRotDst = pitch + (cameraType.m_90612_() ? 0.0f : 30.0f);
                lockOnXRotDst = Mth.m_14036_((float)lockOnXRotDst, (float)0.0f, (float)60.0f);
                if (cameraType.m_90613_()) {
                    lockOnXRotDst = -lockOnXRotDst;
                }
                float lockOnYRotDst = yaw + (cameraType.m_90613_() ? 180.0f : 0.0f);
                float xDiff = Mth.m_14177_((float)(lockOnXRotDst - this.lockOnXRotO));
                float yDiff = Mth.m_14177_((float)(lockOnYRotDst - this.lockOnYRotO));
                float xLerp = Mth.m_14036_((float)(xDiff * 0.4f), (float)-30.0f, (float)30.0f);
                float yLerp = Mth.m_14036_((float)(yDiff * 0.4f), (float)-30.0f, (float)30.0f);
                this.lockOnXRot = this.lockOnXRotO + xLerp;
                this.lockOnYRot = this.lockOnYRotO + yLerp;
                if (!this.getEntityState().turningLocked() || this.getEntityState().lockonRotate()) {
                    ((LocalPlayer)this.original).m_146926_(lockOnXRotDst);
                    ((LocalPlayer)this.original).m_146922_(lockOnYRotDst);
                }
            } else {
                this.lockOnXRot = ((LocalPlayer)this.original).m_146909_();
                this.lockOnYRot = ((LocalPlayer)this.original).m_146908_();
                this.lockOnXRotO = this.lockOnXRot;
                this.lockOnYRotO = this.lockOnYRot;
            }
            if (!this.rayTarget.m_6084_() || ((LocalPlayer)this.getOriginal()).m_20280_((Entity)this.rayTarget) > 400.0 || this.getAngleTo((Entity)this.rayTarget) > 100.0 && !this.targetLockedOn) {
                this.rayTarget = null;
                EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(-1));
            }
        } else {
            this.lockOnXRot = ((LocalPlayer)this.original).m_146909_();
            this.lockOnYRot = ((LocalPlayer)this.original).m_146908_();
            this.targetLockedOn = false;
        }
        CapabilityItem itemCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        switch (itemCap.getZoomInType()) {
            case ALWAYS: {
                ClientEngine.getInstance().renderEngine.zoomIn();
                break;
            }
            case USE_TICK: {
                if (((LocalPlayer)this.original).m_21212_() > 0) {
                    ClientEngine.getInstance().renderEngine.zoomIn();
                    break;
                }
                ClientEngine.getInstance().renderEngine.zoomOut(40);
                break;
            }
            case AIMING: {
                if (this.getClientAnimator().isAiming()) {
                    ClientEngine.getInstance().renderEngine.zoomIn();
                    break;
                }
                ClientEngine.getInstance().renderEngine.zoomOut(40);
                break;
            }
            case CUSTOM: {
                break;
            }
            default: {
                ClientEngine.getInstance().renderEngine.zoomOut(0);
            }
        }
    }

    public void playAnimationClientPreemptive(StaticAnimation animation, float convertTimeModifier) {
        this.animator.playAnimation(animation, convertTimeModifier);
        EpicFightNetworkManager.sendToServer(new CPPlayAnimation(animation.getId(), convertTimeModifier, false, false));
    }

    @Override
    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, LivingEntityPatch.AnimationPacketProvider packetProvider) {
        EpicFightNetworkManager.sendToServer(new CPPlayAnimation(animation.getId(), convertTimeModifier, false, true));
    }

    @Override
    public boolean overrideRender() {
        if (((LocalPlayer)this.original).m_7306_((Entity)this.minecraft.f_91074_) && this.minecraft.f_91066_.m_92176_().m_90612_() && !((Boolean)EpicFightMod.CLIENT_CONFIGS.firstPersonModel.getValue()).booleanValue()) {
            return false;
        }
        return super.overrideRender();
    }

    @Override
    public void updateHeldItem(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        super.updateHeldItem(mainHandCap, offHandCap);
        if (EpicFightMod.CLIENT_CONFIGS.battleAutoSwitchItems.contains(((LocalPlayer)this.original).m_21205_().m_41720_())) {
            this.toBattleMode(true);
        } else if (EpicFightMod.CLIENT_CONFIGS.miningAutoSwitchItems.contains(((LocalPlayer)this.original).m_21205_().m_41720_())) {
            this.toMiningMode(true);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        AttackResult result = super.tryHurt(damageSource, amount);
        if (((Boolean)EpicFightMod.CLIENT_CONFIGS.autoPreparation.getValue()).booleanValue() && result.resultType == AttackResult.ResultType.SUCCESS && !this.isBattleMode()) {
            this.toBattleMode(true);
        }
        return result;
    }

    @Override
    public LivingEntity getTarget() {
        return this.rayTarget;
    }

    @Override
    public void toMiningMode(boolean synchronize) {
        if (this.playerMode != PlayerPatch.PlayerMode.MINING) {
            ClientEngine.getInstance().renderEngine.downSlideSkillUI();
            if (((Boolean)EpicFightMod.CLIENT_CONFIGS.cameraAutoSwitch.getValue()).booleanValue()) {
                this.minecraft.f_91066_.m_92157_(CameraType.FIRST_PERSON);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.MINING));
            }
        }
        super.toMiningMode(synchronize);
    }

    @Override
    public void toBattleMode(boolean synchronize) {
        if (this.playerMode != PlayerPatch.PlayerMode.BATTLE) {
            ClientEngine.getInstance().renderEngine.upSlideSkillUI();
            if (((Boolean)EpicFightMod.CLIENT_CONFIGS.cameraAutoSwitch.getValue()).booleanValue()) {
                this.minecraft.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.BATTLE));
            }
        }
        super.toBattleMode(synchronize);
    }

    @Override
    public boolean isFirstPerson() {
        return this.minecraft.f_91066_.m_92176_() == CameraType.FIRST_PERSON;
    }

    @Override
    public boolean shouldBlockMoving() {
        return ControllEngine.isKeyDown(this.minecraft.f_91066_.f_92087_);
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        if (!this.isLogicalClient()) {
            return false;
        }
        return actionAnimation.shouldPlayerMove(this);
    }

    public float getPrevStamina() {
        return this.prevStamina;
    }

    public int getPrevChargingAmount() {
        return this.prevChargingAmount;
    }

    public float getLerpedLockOnX(double partial) {
        return Mth.m_14189_((float)((float)partial), (float)this.lockOnXRotO, (float)this.lockOnXRot);
    }

    public float getLerpedLockOnY(double partial) {
        return Mth.m_14189_((float)((float)partial), (float)this.lockOnYRotO, (float)this.lockOnYRot);
    }

    public boolean isTargetLockedOn() {
        return this.targetLockedOn;
    }

    public void setLockOn(boolean targetLockedOn) {
        this.targetLockedOn = targetLockedOn;
    }

    public void toggleLockOn() {
        this.targetLockedOn = !this.targetLockedOn;
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        super.onDeath(event);
        ((LocalPlayer)this.original).m_146926_(this.lockOnXRot);
        ((LocalPlayer)this.original).m_146922_(this.lockOnYRot);
    }

    @Override
    public void setModelYRot(float amount, boolean sendPacket) {
        super.setModelYRot(amount, sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToServer(new CPModifyEntityModelYRot(amount));
        }
    }

    public float getModelYRot() {
        return this.modelYRot;
    }

    public void setModelYRotInGui(float rotDeg) {
        this.useModelYRot = true;
        this.modelYRot = rotDeg;
    }

    public void disableModelYRotInGui(float originalDeg) {
        this.useModelYRot = false;
        this.modelYRot = originalDeg;
    }

    @Override
    public void disableModelYRot(boolean sendPacket) {
        super.disableModelYRot(sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToServer(new CPModifyEntityModelYRot());
        }
    }

    @Override
    public void correctRotation() {
        if (!this.useModelYRot) {
            this.modelYRot = ((LocalPlayer)this.getOriginal()).m_146908_();
        }
        if (this.targetLockedOn) {
            if (this.rayTarget != null && !this.rayTarget.m_213877_()) {
                Vec3 playerPosition = ((LocalPlayer)this.original).m_20182_();
                Vec3 targetPosition = this.rayTarget.m_20182_();
                Vec3 toTarget = targetPosition.m_82546_(playerPosition);
                float yaw = (float)MathUtils.getYRotOfVector(toTarget);
                float pitch = (float)MathUtils.getXRotOfVector(toTarget);
                ((LocalPlayer)this.original).m_146922_(yaw);
                ((LocalPlayer)this.original).m_146926_(pitch);
            } else {
                ((LocalPlayer)this.original).m_146922_(this.lockOnYRot);
                ((LocalPlayer)this.original).m_146926_(this.lockOnXRot);
            }
        }
    }

    @Override
    public void openSkillBook(ItemStack itemstack, InteractionHand hand) {
        if (itemstack.m_41782_() && itemstack.m_41783_().m_128441_("skill")) {
            Minecraft.m_91087_().m_91152_((Screen)new SkillBookScreen((Player)this.original, itemstack, hand));
        }
    }
}

