/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.entity;

import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.ComboBox;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HealthPoint
extends Condition.EntityPatchCondition {
    private float health;
    private Comparator comparator;

    public HealthPoint() {
        this.health = 0.0f;
    }

    public HealthPoint(float health, Comparator comparator) {
        this.health = health;
        this.comparator = comparator;
    }

    public HealthPoint read(CompoundTag tag) {
        if (!tag.m_128441_("comparator")) {
            throw new IllegalArgumentException("HealthPoint condition error: comparator not specified!");
        }
        if (!tag.m_128441_("health")) {
            throw new IllegalArgumentException("HealthPoint condition error: health not specified!");
        }
        String sComparator = tag.m_128461_("comparator").toUpperCase(Locale.ROOT);
        try {
            this.comparator = Comparator.valueOf(sComparator);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("HealthPoint condition error: invalid comparator " + sComparator);
        }
        this.health = tag.m_128457_("health");
        return this;
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("comparator", this.comparator.toString().toLowerCase(Locale.ROOT));
        tag.m_128350_("health", this.health);
        return tag;
    }

    @Override
    public boolean predicate(LivingEntityPatch<?> target) {
        switch (this.comparator) {
            case LESS_ABSOLUTE: {
                return this.health > ((LivingEntity)target.getOriginal()).m_21223_();
            }
            case GREATER_ABSOLUTE: {
                return this.health < ((LivingEntity)target.getOriginal()).m_21223_();
            }
            case LESS_RATIO: {
                return this.health > ((LivingEntity)target.getOriginal()).m_21223_() / ((LivingEntity)target.getOriginal()).m_21233_();
            }
            case GREATER_RATIO: {
                return this.health < ((LivingEntity)target.getOriginal()).m_21223_() / ((LivingEntity)target.getOriginal()).m_21233_();
            }
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        ResizableEditBox editbox = new ResizableEditBox(screen.getMinecraft().f_91062_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"health"), null, null);
        ComboBox<Comparator> comboBox = new ComboBox<Comparator>(screen, screen.getMinecraft().f_91062_, 0, 0, 0, 0, null, null, 4, (Component)Component.m_237113_((String)"comparator"), List.of(Comparator.values()), ParseUtil::snakeToSpacedCamel, null);
        editbox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
        return List.of(Condition.ParameterEditor.of(value -> FloatTag.m_128566_((float)Float.parseFloat(value.toString())), tag -> ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(tag, Tag::m_7916_)), (AbstractWidget)editbox), Condition.ParameterEditor.of(value -> StringTag.m_129297_((String)value.toString().toLowerCase(Locale.ROOT)), tag -> ParseUtil.enumValueOfOrNull(Comparator.class, ParseUtil.nullOrToString(tag, Tag::m_7916_)), comboBox));
    }

    public static enum Comparator {
        GREATER_ABSOLUTE,
        LESS_ABSOLUTE,
        GREATER_RATIO,
        LESS_RATIO;

    }
}

