/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPPlayAnimation;
import yesman.epicfight.network.server.SPPotion;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EndermanPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.DealtDamageEvent;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.ProjectileHitEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

@Mod.EventBusSubscriber(modid="epicfight")
public class EntityEvents {
    protected static Method getDamageAfterMagicAbsorb = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_6515_", (Class[])new Class[]{DamageSource.class, Float.TYPE});

    @SubscribeEvent
    public static void spawnEvent(EntityJoinLevelEvent event) {
        EntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(event.getEntity(), EntityPatch.class);
        if (entitypatch != null && !entitypatch.isInitialized()) {
            entitypatch.onJoinWorld(event.getEntity(), event);
        }
    }

    @SubscribeEvent
    public static void updateEvent(LivingEvent.LivingTickEvent event) {
        EntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), EntityPatch.class);
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            entitypatch.tick(event);
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null) {
            entitypatch.onDeath(event);
        }
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        HurtableEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), HurtableEntityPatch.class);
        if (entitypatch != null && entitypatch.shouldCancelKnockback()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        StaticAnimation fallAnimation;
        LivingEntityPatch entitypatch;
        EpicFightDamageSource epicFightDamageSource = null;
        Entity trueSource = event.getSource().m_7639_();
        if (trueSource != null) {
            LivingEntityPatch attackerEntityPatch = EpicFightCapabilities.getEntityPatch(trueSource, LivingEntityPatch.class);
            float baseDamage = event.getAmount();
            DamageSource damageSource = event.getSource();
            if (damageSource instanceof EpicFightDamageSource) {
                EpicFightDamageSource instance;
                epicFightDamageSource = instance = (EpicFightDamageSource)damageSource;
            } else if (event.getSource().m_269014_() && event.getSource().m_7640_() != null) {
                ProjectilePatch projectileCap = EpicFightCapabilities.getEntityPatch(event.getSource().m_7640_(), ProjectilePatch.class);
                if (projectileCap != null) {
                    epicFightDamageSource = projectileCap.getEpicFightDamageSource(event.getSource());
                }
            } else if (attackerEntityPatch != null) {
                epicFightDamageSource = attackerEntityPatch.getEpicFightDamageSource();
                baseDamage = attackerEntityPatch.getModifiedBaseDamage(baseDamage);
            }
            if (epicFightDamageSource != null && !epicFightDamageSource.m_269533_(EpicFightDamageType.PARTIAL_DAMAGE)) {
                LivingEntity hitEntity = event.getEntity();
                if (attackerEntityPatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch playerpatch = (ServerPlayerPatch)attackerEntityPatch;
                    DealtDamageEvent.Hurt dealDamageHurt = new DealtDamageEvent.Hurt(playerpatch, hitEntity, epicFightDamageSource, event);
                    playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_HURT, dealDamageHurt);
                }
                float totalDamage = epicFightDamageSource.getDamageModifier().getTotalValue(baseDamage);
                if (trueSource instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)trueSource;
                    if (epicFightDamageSource.getExtraDamages() != null) {
                        for (ExtraDamageInstance extraDamage : epicFightDamageSource.getExtraDamages()) {
                            totalDamage += extraDamage.get(livingEntity, epicFightDamageSource.getHurtItem(), hitEntity, baseDamage);
                        }
                    }
                }
                HurtableEntityPatch hitHurtableEntityPatch = EpicFightCapabilities.getEntityPatch((Entity)hitEntity, HurtableEntityPatch.class);
                LivingEntityPatch hitLivingEntityPatch = EpicFightCapabilities.getEntityPatch((Entity)hitEntity, LivingEntityPatch.class);
                ServerPlayerPatch hitPlayerPatch = EpicFightCapabilities.getEntityPatch((Entity)hitEntity, ServerPlayerPatch.class);
                if (hitPlayerPatch != null) {
                    HurtEvent.Post hurtEvent = new HurtEvent.Post(hitPlayerPatch, epicFightDamageSource, totalDamage);
                    hitPlayerPatch.getEventListener().triggerEvents(PlayerEventListener.EventType.HURT_EVENT_POST, hurtEvent);
                    totalDamage = hurtEvent.getAmount();
                }
                event.setAmount(totalDamage);
                if (epicFightDamageSource.m_269533_(EpicFightDamageType.EXECUTION)) {
                    int executionResistance;
                    float amount = event.getAmount();
                    event.setAmount(2.1474836E9f);
                    if (hitLivingEntityPatch != null && (executionResistance = hitLivingEntityPatch.getExecutionResistance()) > 0) {
                        hitLivingEntityPatch.setExecutionResistance(executionResistance - 1);
                        event.setAmount(amount);
                    }
                }
                if (event.getAmount() > 0.0f && hitHurtableEntityPatch != null) {
                    StunType stunType = epicFightDamageSource.getStunType();
                    float stunTime = 0.0f;
                    float knockBackAmount = 0.0f;
                    float stunShield = hitHurtableEntityPatch.getStunShield();
                    if (stunShield > epicFightDamageSource.getImpact() && (stunType == StunType.SHORT || stunType == StunType.LONG)) {
                        stunType = StunType.NONE;
                    }
                    hitHurtableEntityPatch.setStunShield(stunShield - epicFightDamageSource.getImpact());
                    switch (stunType) {
                        case SHORT: {
                            stunType = StunType.NONE;
                            if (hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) || hitHurtableEntityPatch.getStunShield() != 0.0f) break;
                            float totalStunTime = (0.25f + epicFightDamageSource.getImpact() * 0.1f) * (1.0f - hitHurtableEntityPatch.getStunReduction());
                            if (totalStunTime >= 0.075f) {
                                stunTime = totalStunTime - 0.1f;
                                boolean isLongStun = totalStunTime >= 0.83f;
                                stunTime = isLongStun ? 0.83f : stunTime;
                                stunType = isLongStun ? StunType.LONG : StunType.SHORT;
                                knockBackAmount = Math.min(isLongStun ? epicFightDamageSource.getImpact() * 0.05f : totalStunTime, 2.0f);
                            }
                            stunTime = (float)((double)stunTime * (1.0 - hitEntity.m_21133_(Attributes.f_22278_)));
                            break;
                        }
                        case LONG: {
                            stunType = hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? StunType.NONE : StunType.LONG;
                            knockBackAmount = Math.min(epicFightDamageSource.getImpact() * 0.05f, 5.0f);
                            stunTime = 0.83f;
                            break;
                        }
                        case HOLD: {
                            stunType = StunType.SHORT;
                            stunTime = epicFightDamageSource.getImpact() * 0.25f;
                            break;
                        }
                        case KNOCKDOWN: {
                            stunType = hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? StunType.NONE : StunType.KNOCKDOWN;
                            knockBackAmount = Math.min(epicFightDamageSource.getImpact() * 0.05f, 5.0f);
                            stunTime = 2.0f;
                            break;
                        }
                        case NEUTRALIZE: {
                            stunType = StunType.NEUTRALIZE;
                            hitHurtableEntityPatch.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
                            ((HitParticleType)((Object)EpicFightParticles.AIR_BURST.get())).spawnParticleWithArgument((ServerLevel)hitEntity.m_9236_(), (Entity)hitEntity, event.getSource().m_7640_());
                            knockBackAmount = 0.0f;
                            stunTime = 2.0f;
                        }
                    }
                    Vec3 sourcePosition = epicFightDamageSource.getInitialPosition();
                    hitHurtableEntityPatch.setStunReductionOnHit(stunType);
                    boolean stunApplied = hitHurtableEntityPatch.applyStun(stunType, stunTime);
                    if (sourcePosition != null) {
                        if (!(hitEntity instanceof Player) && stunApplied) {
                            hitEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, sourcePosition);
                        }
                        if (knockBackAmount > 0.0f) {
                            hitHurtableEntityPatch.knockBackEntity(sourcePosition, knockBackAmount *= 40.0f / hitHurtableEntityPatch.getWeight());
                        }
                    }
                }
            }
        } else if (event.getSource().m_276093_(DamageTypes.f_268671_) && event.getAmount() > 1.0f && event.getEntity().m_9236_().m_46469_().m_46207_(EpicFightGamerules.HAS_FALL_ANIMATION) && (entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class)) != null && !entitypatch.getEntityState().inaction() && (fallAnimation = ((Animator)entitypatch.getAnimator()).getLivingAnimation(LivingMotions.LANDING_RECOVERY, entitypatch.getHitAnimation(StunType.FALL))) != null) {
            entitypatch.playAnimationSynchronized(fallAnimation, 0.0f);
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null) {
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch(attacker, ServerPlayerPatch.class);
            EpicFightDamageSource epicFightDamageSource = null;
            DamageSource damageSource = event.getSource();
            if (damageSource instanceof EpicFightDamageSource) {
                EpicFightDamageSource instance;
                epicFightDamageSource = instance = (EpicFightDamageSource)damageSource;
            } else if (event.getSource().m_269014_() && event.getSource().m_7640_() != null) {
                ProjectilePatch projectileCap = EpicFightCapabilities.getEntityPatch(event.getSource().m_7640_(), ProjectilePatch.class);
                if (projectileCap != null) {
                    epicFightDamageSource = projectileCap.getEpicFightDamageSource(event.getSource());
                }
            } else if (playerpatch != null) {
                epicFightDamageSource = playerpatch.getEpicFightDamageSource();
            }
            if (playerpatch != null && epicFightDamageSource != null) {
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, new DealtDamageEvent.Damage(playerpatch, event.getEntity(), epicFightDamageSource, event));
            }
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        EpicFightDamageSource damageSource = null;
        if (event.getEntity().m_21223_() > 0.0f) {
            AttackResult result;
            EpicFightDamageSource efDamageSource;
            LivingEntityPatch attackerPatch = EpicFightCapabilities.getEntityPatch(event.getSource().m_7639_(), LivingEntityPatch.class);
            DamageSource damageSource2 = event.getSource();
            if (damageSource2 instanceof EpicFightDamageSource) {
                damageSource = efDamageSource = (EpicFightDamageSource)damageSource2;
            } else if (event.getSource().m_269014_() && event.getSource().m_7640_() != null) {
                ProjectilePatch projectilepatch = EpicFightCapabilities.getEntityPatch(event.getSource().m_7640_(), ProjectilePatch.class);
                if (projectilepatch != null) {
                    damageSource = projectilepatch.getEpicFightDamageSource(event.getSource());
                }
            } else if (attackerPatch != null && attackerPatch.getEpicFightDamageSource() != null) {
                damageSource = attackerPatch.getEpicFightDamageSource();
            }
            if (damageSource == null) {
                damageSource = event.getSource();
            }
            if (damageSource instanceof EpicFightDamageSource) {
                efDamageSource = damageSource;
                Entity entity = event.getSource().m_7639_();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity;
                    if (!efDamageSource.m_269533_(EpicFightDamageType.PARTIAL_DAMAGE)) {
                        ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverplayer, ServerPlayerPatch.class);
                        DealtDamageEvent.Attack dealDamageAttack = new DealtDamageEvent.Attack(playerpatch, event.getEntity(), efDamageSource, event);
                        playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, dealDamageAttack);
                        if (dealDamageAttack.isCanceled()) {
                            event.setCanceled(true);
                            return;
                        }
                    }
                }
            }
            AttackResult attackResult = result = entitypatch != null ? entitypatch.tryHurt(damageSource, event.getAmount()) : AttackResult.success(event.getAmount());
            if (attackerPatch != null) {
                attackerPatch.setLastAttackResult(result);
            }
            if (!result.resultType.dealtDamage()) {
                event.setCanceled(true);
            } else if (event.getAmount() != result.damage) {
                EpicFightDamageSource epicfightDamageSource;
                EpicFightDamageSource deflictedDamage = damageSource instanceof EpicFightDamageSource ? (epicfightDamageSource = damageSource) : EpicFightDamageSources.copy(damageSource);
                deflictedDamage.addRuntimeTag(EpicFightDamageType.PARTIAL_DAMAGE);
                event.setCanceled(true);
                event.getEntity().m_6469_((DamageSource)deflictedDamage, result.damage);
            }
        }
    }

    @SubscribeEvent
    public static void shieldEvent(ShieldBlockEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null) {
            entitypatch.playAnimationSynchronized(Animations.BIPED_HIT_SHIELD, 0.0f);
        }
    }

    @SubscribeEvent
    public static void dropEvent(LivingDropsEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null && entitypatch.onDrop(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void projectileImpactEvent(ProjectileImpactEvent event) {
        EntityHitResult rayresult;
        ProjectilePatch projectilepatch = EpicFightCapabilities.getEntityPatch(event.getEntity(), ProjectilePatch.class);
        if (!event.getProjectile().m_9236_().m_5776_() && projectilepatch != null && projectilepatch.onProjectileImpact(event)) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            return;
        }
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && (rayresult = (EntityHitResult)hitResult).m_82443_() != null) {
            ServerPlayerPatch playerpatch;
            boolean canceled2;
            if (rayresult.m_82443_() instanceof ServerPlayer && (canceled2 = (playerpatch = EpicFightCapabilities.getEntityPatch(rayresult.m_82443_(), ServerPlayerPatch.class)).getEventListener().triggerEvents(PlayerEventListener.EventType.PROJECTILE_HIT_EVENT, new ProjectileHitEvent(playerpatch, event)))) {
                event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            }
            if (event.getProjectile().m_19749_() != null) {
                Entity canceled2;
                if (rayresult.m_82443_().equals((Object)event.getProjectile().m_19749_().m_20202_())) {
                    event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                }
                if ((canceled2 = rayresult.m_82443_()) instanceof PartEntity) {
                    PartEntity partEntity = (PartEntity)canceled2;
                    Entity parent = partEntity.getParent();
                    if (event.getProjectile().m_19749_().m_7306_(parent)) {
                        event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void itemAttributeModifierEvent(ItemAttributeModifierEvent event) {
        CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(event.getItemStack());
        if (!itemCap.isEmpty()) {
            Multimap<Attribute, AttributeModifier> multimap = itemCap.getAttributeModifiers(event.getSlotType(), null);
            for (Attribute key : multimap.keys()) {
                for (AttributeModifier modifier : multimap.get((Object)key)) {
                    event.addModifier(key, modifier);
                }
            }
        }
    }

    @SubscribeEvent
    public static void equipChangeEvent(LivingEquipmentChangeEvent event) {
        HurtableEntityPatch hurtableEntitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), HurtableEntityPatch.class);
        if (hurtableEntitypatch != null) {
            hurtableEntitypatch.setDefaultStunReduction(event.getSlot(), event.getFrom(), event.getTo());
        }
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        CapabilityItem fromCap = EpicFightCapabilities.getItemStackCapability(event.getFrom());
        CapabilityItem toCap = EpicFightCapabilities.getItemStackCapability(event.getTo());
        if (event.getSlot() != EquipmentSlot.OFFHAND) {
            if (fromCap != null) {
                event.getEntity().m_21204_().m_22161_(fromCap.getAttributeModifiers(event.getSlot(), entitypatch, true));
            }
            if (toCap != null) {
                event.getEntity().m_21204_().m_22178_(toCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
        }
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            if (event.getSlot().m_20743_() == EquipmentSlot.Type.HAND) {
                InteractionHand hand = event.getSlot() == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                entitypatch.updateHeldItem(fromCap, toCap, event.getFrom(), event.getTo(), hand);
            } else if (event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
                entitypatch.updateArmor(fromCap, toCap, event.getSlot());
            }
        }
    }

    @SubscribeEvent
    public static void sizingEvent(EntityEvent.Size event) {
        if (event.getEntity() instanceof EnderDragon) {
            event.setNewSize(EntityDimensions.m_20395_((float)5.0f, (float)3.0f));
        }
    }

    @SubscribeEvent
    public static void effectAddEvent(MobEffectEvent.Added event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.ACTIVATE, event.getEntity().m_19879_()));
        }
    }

    @SubscribeEvent
    public static void effectRemoveEvent(MobEffectEvent.Remove event) {
        if (!event.getEntity().m_9236_().m_5776_() && event.getEffectInstance() != null) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.REMOVE, event.getEntity().m_19879_()));
        }
    }

    @SubscribeEvent
    public static void effectExpiryEvent(MobEffectEvent.Expired event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.REMOVE, event.getEntity().m_19879_()));
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        EntityPatch mountEntity = EpicFightCapabilities.getEntityPatch(event.getEntityMounting(), EntityPatch.class);
        if (!event.getLevel().m_5776_() && mountEntity instanceof HumanoidMobPatch && mountEntity.getOriginal() != null && event.getEntityBeingMounted() instanceof Mob) {
            ((HumanoidMobPatch)mountEntity).onMount(event.isMounting(), event.getEntityBeingMounted());
        }
    }

    @SubscribeEvent
    public static void tpEvent(EntityTeleportEvent.EnderEntity event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof EnderMan) {
            EnderMan enderman = (EnderMan)livingEntity;
            EndermanPatch endermanpatch = EpicFightCapabilities.getEntityPatch(event.getEntity(), EndermanPatch.class);
            if (endermanpatch != null) {
                if (endermanpatch.getEntityState().inaction()) {
                    for (Entity collideEntity : enderman.m_9236_().m_45976_(Entity.class, enderman.m_20191_().m_82377_(0.2, 0.2, 0.2))) {
                        if (!(collideEntity instanceof Projectile)) continue;
                        return;
                    }
                    event.setCanceled(true);
                } else if (endermanpatch.isRaging()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null && entitypatch.isLogicalClient() && !entitypatch.getEntityState().inaction() && !event.getEntity().m_20069_()) {
            StaticAnimation jumpAnimation = entitypatch.getClientAnimator().getJumpAnimation();
            ((Animator)entitypatch.getAnimator()).playAnimation(jumpAnimation, 0.0f);
            EpicFightNetworkManager.sendToServer(new CPPlayAnimation(jumpAnimation.getId(), 0.0f, true, false));
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null) {
            entitypatch.onFall(event);
        }
    }

    @SubscribeEvent
    public static void playerFallEvent(PlayerFlyableFallEvent event) {
        PlayerPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), PlayerPatch.class);
        if (entitypatch != null) {
            entitypatch.onFall(new LivingFallEvent((LivingEntity)event.getEntity(), event.getDistance(), event.getMultiplier()));
        }
    }
}

