/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CPExecuteSkill {
    private final int skillSlot;
    private final WorkType workType;
    private final FriendlyByteBuf buffer;

    public CPExecuteSkill() {
        this(0);
    }

    public CPExecuteSkill(int slotIndex) {
        this(slotIndex, WorkType.ACTIVATE);
    }

    public CPExecuteSkill(int slotIndex, WorkType active) {
        this.skillSlot = slotIndex;
        this.workType = active;
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
    }

    public CPExecuteSkill(int slotIndex, WorkType active, FriendlyByteBuf pb) {
        this.skillSlot = slotIndex;
        this.workType = active;
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
        if (pb != null) {
            this.buffer.writeBytes((ByteBuf)pb);
        }
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    public static CPExecuteSkill fromBytes(FriendlyByteBuf buf) {
        CPExecuteSkill msg = new CPExecuteSkill(buf.readInt(), (WorkType)buf.m_130066_(WorkType.class));
        while (buf.isReadable()) {
            msg.buffer.writeByte((int)buf.readByte());
        }
        return msg;
    }

    public static void toBytes(CPExecuteSkill msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.skillSlot);
        buf.m_130068_((Enum)msg.workType);
        while (msg.buffer.isReadable()) {
            buf.writeByte((int)msg.buffer.readByte());
        }
    }

    public static void handle(CPExecuteSkill msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class);
            SkillContainer skillContainer = playerpatch.getSkill(msg.skillSlot);
            switch (msg.workType) {
                case ACTIVATE: {
                    skillContainer.requestExecute(playerpatch, msg.getBuffer());
                    break;
                }
                case CANCEL: {
                    skillContainer.requestCancel(playerpatch, msg.getBuffer());
                    break;
                }
                case CHARGING_START: {
                    skillContainer.requestCharging(playerpatch, msg.getBuffer());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum WorkType {
        ACTIVATE,
        CANCEL,
        CHARGING_START;

    }
}

